/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.security.core.dsig.InclusiveNamespacesType;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBSignatureFactory;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBStructure;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.dsig.ExcC14NParameterSpec;
import com.sun.xml.ws.security.opt.impl.dsig.SignedMessageHeader;
import com.sun.xml.ws.security.opt.impl.dsig.SignedMessagePart;
import com.sun.xml.ws.security.opt.impl.message.SOAPBody;
import com.sun.xml.ws.security.opt.impl.message.SecuredMessage;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.Parameter;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;

public class SignatureElementFactory {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");

    public XMLSignature constructSignature(SignedInfo signInfo, KeyInfo keyInfo, String id) {
        return this.getSignatureFactory().newXMLSignature(signInfo, keyInfo, null, id, null);
    }

    public XMLSignature constructSignature(SignedInfo signInfo, KeyInfo keyInfo) {
        return this.getSignatureFactory().newXMLSignature(signInfo, keyInfo);
    }

    public SignedInfo constructSignedInfo(JAXBFilterProcessingContext fpContext) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        if (PolicyTypeUtil.signaturePolicy(fpContext.getSecurityPolicy())) {
            return this.generateSignedInfo(fpContext);
        }
        return null;
    }

    private SignedInfo generateSignedInfo(JAXBFilterProcessingContext fpContext) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        ArrayList targetList;
        SignaturePolicy signaturePolicy = (SignaturePolicy)fpContext.getSecurityPolicy();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
        MLSPolicy keyBinding = signaturePolicy.getKeyBinding();
        XMLSignatureFactory signatureFactory = this.getSignatureFactory();
        String canonicalAlgo = featureBinding.getCanonicalizationAlgorithm();
        ArrayList cloneList = targetList = featureBinding.getTargetBindings();
        if (signaturePolicy.getKeyBinding() instanceof AuthenticationTokenPolicy.SAMLAssertionBinding) {
            cloneList = (ArrayList)targetList.clone();
            for (SignatureTarget o : cloneList) {
                if (!o.getValue().startsWith("#SAML")) continue;
                String id = ((AuthenticationTokenPolicy.SAMLAssertionBinding)signaturePolicy.getKeyBinding()).getAssertionId();
                o.setValue("#" + id);
            }
        }
        String keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        if (PolicyTypeUtil.UsernameTokenBinding(keyBinding)) {
            AuthenticationTokenPolicy.UsernameTokenBinding untBinding = (AuthenticationTokenPolicy.UsernameTokenBinding)keyBinding;
            keyAlgo = !"".equals(untBinding.getKeyAlgorithm()) ? untBinding.getKeyAlgorithm() : "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
            if (!"".equals(certificateBinding.getKeyAlgorithm())) {
                keyAlgo = certificateBinding.getKeyAlgorithm();
            }
        } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
            if (!"".equals(samlBinding.getKeyAlgorithm())) {
                keyAlgo = samlBinding.getKeyAlgorithm();
            }
        } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
            SymmetricKeyBinding symmetricKeybinding = (SymmetricKeyBinding)keyBinding;
            keyAlgo = !"".equals(symmetricKeybinding.getKeyAlgorithm()) ? symmetricKeybinding.getKeyAlgorithm() : "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) {
            keyAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else if (PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) {
            keyAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
            DerivedTokenKeyBinding dtkBinding = (DerivedTokenKeyBinding)keyBinding;
            if (fpContext.getTrustContext() != null && fpContext.getTrustContext().getProofKey() == null && PolicyTypeUtil.issuedTokenKeyBinding(dtkBinding.getOriginalKeyBinding())) {
                keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
        } else if (PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) {
            if (fpContext.getTrustContext() != null) {
                keyAlgo = fpContext.getTrustContext().getSignWith();
            }
            if (keyAlgo == null) {
                keyAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
            }
            if (fpContext.getTrustContext() != null && fpContext.getTrustContext().getProofKey() == null && fpContext.getTrustContext().getSignWith() == null) {
                keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
        } else if (PolicyTypeUtil.keyValueTokenBinding(keyBinding)) {
            keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1703_UNSUPPORTED_KEYBINDING_SIGNATUREPOLICY(keyBinding));
            throw new XWSSecurityException("Unsupported KeyBinding for SignaturePolicy");
        }
        ExcC14NParameterSpec spec = null;
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(canonicalAlgo)) {
            if (!fpContext.getDisableIncPrefix()) {
                ArrayList<String> inc = new ArrayList<String>();
                inc.add("wsse");
                inc.add("S");
                spec = new ExcC14NParameterSpec(inc);
            }
            ((NamespaceContextEx)fpContext.getNamespaceContext()).addExc14NS();
        }
        CanonicalizationMethod canonicalMethod = signatureFactory.newCanonicalizationMethod(canonicalAlgo, spec);
        if (!fpContext.getDisableIncPrefix()) {
            List contentList = this.setInclusiveNamespaces(spec);
            ((com.sun.xml.ws.security.opt.crypto.dsig.CanonicalizationMethod)canonicalMethod).setContent(contentList);
        }
        SignatureMethod signatureMethod = signatureFactory.newSignatureMethod(keyAlgo, null);
        SignedInfo signedInfo = signatureFactory.newSignedInfo(canonicalMethod, signatureMethod, this.generateReferenceList(cloneList, signatureFactory, fpContext, false), null);
        return signedInfo;
    }

    private XMLSignatureFactory getSignatureFactory() {
        try {
            return JAXBSignatureFactory.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List generateReferenceList(List targetList, XMLSignatureFactory signatureFactory, JAXBFilterProcessingContext fpContext, boolean verify) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        iterator = targetList.listIterator();
        references = new ArrayList<Reference>();
        if (SignatureElementFactory.logger.isLoggable(Level.FINEST)) {
            SignatureElementFactory.logger.log(Level.FINEST, LogStringsMessages.WSS_1751_NUMBER_TARGETS_SIGNATURE(targetList.size()));
        }
        while (iterator.hasNext()) {
            signatureTarget = (SignatureTarget)iterator.next();
            digestAlgo = signatureTarget.getDigestAlgorithm();
            if (SignatureElementFactory.logger.isLoggable(Level.FINEST)) {
                SignatureElementFactory.logger.log(Level.FINEST, LogStringsMessages.WSS_1752_SIGNATURE_TARGET_VALUE(signatureTarget.getValue()));
                SignatureElementFactory.logger.log(Level.FINEST, LogStringsMessages.WSS_1753_TARGET_DIGEST_ALGORITHM(digestAlgo));
            }
            digestMethod = null;
            try {
                digestMethod = signatureFactory.newDigestMethod(digestAlgo, null);
            }
            catch (Exception ex) {
                SignatureElementFactory.logger.log(Level.SEVERE, "WSS1301.invalid.digest.algo", digestAlgo);
                throw new XWSSecurityException(ex.getMessage());
            }
            exclTransformToBeAdded = false;
            transforms = signatureTarget.getTransforms();
            transformIterator = transforms.listIterator();
            transformList = new ArrayList<Transform>(2);
            while (transformIterator.hasNext()) {
                transformInfo = (SignatureTarget.Transform)transformIterator.next();
                transformAlgo = transformInfo.getTransform();
                transform = null;
                if (SignatureElementFactory.logger.isLoggable(Level.FINEST)) {
                    SignatureElementFactory.logger.log(Level.FINEST, "Transform Algorithm is " + transformAlgo);
                }
                if (transformAlgo == "http://www.w3.org/TR/1999/REC-xpath-19991116" || transformAlgo.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                    throw new UnsupportedOperationException("XPATH not supported");
                }
                if (transformAlgo == "http://www.w3.org/2002/06/xmldsig-filter2" || transformAlgo.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                    throw new UnsupportedOperationException("XPATH not supported");
                }
                if (transformAlgo == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform" || transformAlgo.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
                    transformParams = (Parameter)transformInfo.getAlgorithmParameters();
                    algo = null;
                    if (transformParams.getParamName().equals("CanonicalizationMethod")) {
                        algo = transformParams.getParamValue();
                    }
                    if (algo == null) {
                        throw new XWSSecurityException("STR Transform must have acanonicalization method specified");
                    }
                    if (SignatureElementFactory.logger.isLoggable(Level.FINEST)) {
                        SignatureElementFactory.logger.log(Level.FINEST, "CanonicalizationMethod is " + algo);
                    }
                    spec = null;
                    try {
                        tp = new ObjectFactory().createTransformationParametersType();
                        cm = new com.sun.xml.ws.security.opt.crypto.dsig.CanonicalizationMethod();
                        cm.setAlgorithm(algo);
                        tp.getAny().add(cm);
                        tpElement = new ObjectFactory().createTransformationParameters(tp);
                        transformSpec = new JAXBStructure(tpElement);
                        transform = signatureFactory.newTransform(transformAlgo, transformSpec);
                        if (signatureTarget.getType() != "uri") ** GOTO lbl62
                        targetURI = signatureTarget.getValue();
                        ((com.sun.xml.ws.security.opt.crypto.dsig.Transform)transform).setReferenceId(targetURI);
                    }
                    catch (Exception ex) {
                        SignatureElementFactory.logger.log(Level.SEVERE, "WSS1300.dsig.transform_param.error", ex);
                        throw new XWSSecurityException(ex.getMessage());
                    }
                } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(transformAlgo)) {
                    exclTransformToBeAdded = true;
                } else {
                    transform = signatureFactory.newTransform(transformAlgo, (TransformParameterSpec)null);
                }
lbl62:
                // 4 sources

                if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(transformAlgo)) continue;
                transformList.add(transform);
            }
            targetURI = "";
            signatureType = signatureTarget.getType();
            secMessage = fpContext.getSecuredMessage();
            if (signatureType.equals("qname")) {
                expr = null;
                targets = new ArrayList<SignedMessagePart>();
                targetValue = signatureTarget.getValue();
                optimized = false;
                if (fpContext.getConfigType() == 1 || fpContext.getConfigType() == 2) {
                    optimized = true;
                }
                if (targetValue.equals("{http://schemas.xmlsoap.org/soap/envelope/}Body")) {
                    body = secMessage.getBody();
                    if (body instanceof SignedMessagePart) {
                        targets.add((SignedMessagePart)body);
                    } else if (body instanceof SecurityElement) {
                        smp = new SignedMessagePart((SecurityElement)body);
                        targets.add(smp);
                    } else {
                        contentOnly = signatureTarget.getContentOnly();
                        soapBody = (SOAPBody)body;
                        if (!contentOnly) {
                            if (soapBody.getId() == null || "".equals(soapBody.getId())) {
                                soapBody.setId(fpContext.generateID());
                            }
                            smp = new SignedMessagePart(soapBody, contentOnly);
                            secMessage.replaceBody(smp);
                            targets.add(smp);
                        } else {
                            id = null;
                            if (soapBody.getBodyContentId() == null || "".equals(soapBody.getBodyContentId())) {
                                id = fpContext.generateID();
                                soapBody.setBodyContentId(id);
                            }
                            smp = new SignedMessagePart(soapBody, contentOnly);
                            newBody = new SOAPBody(smp, fpContext.getSOAPVersion());
                            newBody.setId(soapBody.getId());
                            secMessage.replaceBody(newBody);
                            targets.add(smp);
                        }
                    }
                } else {
                    name = null;
                    if (targetValue.endsWith("}")) {
                        nsURI = targetValue.substring(1, targetValue.length() - 1);
                        name = new QName(nsURI, "");
                    } else {
                        name = QName.valueOf(targetValue);
                    }
                    headers = null;
                    if (name.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") || name.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                        if (!"".equals(name.getLocalPart())) {
                            headers = secMessage.getHeaders(name.getLocalPart(), null);
                        } else {
                            headers = secMessage.getHeaders("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                            if (!headers.hasNext()) {
                                headers = secMessage.getHeaders("http://www.w3.org/2005/08/addressing");
                            }
                        }
                    } else {
                        headers = "".equals(name.getLocalPart()) == false ? secMessage.getHeaders(name.getLocalPart(), name.getNamespaceURI()) : secMessage.getHeaders(name.getNamespaceURI());
                    }
                    while (headers.hasNext()) {
                        next = headers.next();
                        if (next instanceof SignedMessageHeader) {
                            targets.add((SignedMessageHeader)next);
                            continue;
                        }
                        if (next instanceof SecurityHeaderElement) {
                            she = (SecurityHeaderElement)next;
                            smh = new SignedMessageHeader(she);
                            secMessage.replaceHeader(she, smh);
                            targets.add(smh);
                            continue;
                        }
                        if (!(next instanceof Header)) continue;
                        header = (Header)next;
                        smh = this.toSignedMessageHeader(header, fpContext);
                        secMessage.replaceHeader(header, smh);
                        targets.add(smh);
                    }
                    sh = fpContext.getSecurityHeader();
                    headers = sh.getHeaders(name.getLocalPart(), name.getNamespaceURI());
                    while (headers.hasNext()) {
                        she = (SecurityHeaderElement)headers.next();
                        if (she instanceof SignedMessageHeader) {
                            targets.add((SignedMessageHeader)she);
                            continue;
                        }
                        if (she.getId() == null) {
                            she.setId(fpContext.generateID());
                        }
                        smh = new SignedMessageHeader(she);
                        targets.add(smh);
                    }
                }
                if (targets.size() <= 0) {
                    if (!signatureTarget.getEnforce()) continue;
                    throw new XWSSecurityException("SignatureTarget with URI " + signatureTarget.getValue() + " is not in the message");
                }
                if (SignatureElementFactory.logger.isLoggable(Level.FINEST)) {
                    SignatureElementFactory.logger.log(Level.FINEST, "Number of nodes " + targets.size());
                    SignatureElementFactory.logger.log(Level.FINEST, "+++++++++++++++END+++++++++++++++");
                }
                elementCache = null;
                if (fpContext != null) {
                    elementCache = fpContext.getElementCache();
                }
                for (i = 0; i < targets.size(); ++i) {
                    targetRef = (SignedMessagePart)targets.get(i);
                    clonedTransformList = (ArrayList)transformList.clone();
                    if (exclTransformToBeAdded) {
                        transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                        ((NamespaceContextEx)fpContext.getNamespaceContext()).addExc14NS();
                        spec = null;
                        if (!fpContext.getDisableIncPrefix()) {
                            list = new ArrayList<String>();
                            list.add("S");
                            spec = new ExcC14NParameterSpec(list);
                        }
                        transform = signatureFactory.newTransform(transformAlgo, spec);
                        clonedTransformList.add(transform);
                    }
                    if ((id = targetRef.getId()) == null || id.equals("")) {
                        id = fpContext.generateID();
                        if (!verify) {
                            targetRef.setId(id);
                        } else {
                            elementCache.put(id, targetRef);
                        }
                    }
                    if (SignatureElementFactory.logger.isLoggable(Level.FINEST)) {
                        SignatureElementFactory.logger.log(Level.FINEST, "SignedInfo val id " + id);
                    }
                    targetURI = "#" + id;
                    reference = null;
                    reference = signatureFactory.newReference(targetURI, digestMethod, clonedTransformList, null, null);
                    references.add(reference);
                }
                continue;
            }
            if (signatureType == "uri") {
                targetURI = signatureTarget.getValue();
                if (targetURI == null) {
                    targetURI = "";
                }
                if ((policyName = signatureTarget.getPolicyQName()) != null && policyName == MessageConstants.SCT_NAME) {
                    _uri = targetURI;
                    if (targetURI.length() > 0 && targetURI.charAt(0) == '#') {
                        _uri = targetURI.substring(1);
                    }
                    ictx = fpContext.getIssuedTokenContext(_uri);
                    sct1 = (SecurityContextToken)ictx.getSecurityToken();
                    targetURI = sct1.getWsuId();
                }
                if ("cid:*".equals(targetURI)) {
                    as = secMessage.getAttachments();
                    if (as != null && as.isEmpty()) {
                        SignatureElementFactory.logger.log(Level.WARNING, "No attachment part present in the message to be secured");
                        continue;
                    }
                    for (Attachment attachment : as) {
                        cid = "cid:" + attachment.getContentId();
                        reference = signatureFactory.newReference(cid, digestMethod, transformList, null, null);
                        references.add(reference);
                    }
                    continue;
                }
                if (exclTransformToBeAdded) {
                    _uri = targetURI;
                    if (targetURI.length() > 0 && targetURI.charAt(0) == '#') {
                        _uri = targetURI.substring(1);
                    }
                    if ((reqdPart = this.getPartFromId(fpContext, _uri)) != null) {
                        transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                        spec = null;
                        if (!fpContext.getDisableIncPrefix()) {
                            list = new ArrayList<String>();
                            list.add("wsu");
                            list.add("wsse");
                            list.add("S");
                            spec = new ExcC14NParameterSpec(list);
                        }
                        transform = signatureFactory.newTransform(transformAlgo, spec);
                        transformList.add(transform);
                    }
                }
                if (targetURI.equals("ALL_MESSAGE_HEADERS")) {
                    headers = secMessage.getHeaders();
                    for (i = 0; i < headers.size(); ++i) {
                        header = headers.get(i);
                        tmpUri = null;
                        if (header instanceof SignedMessageHeader) {
                            tmpUri = "#" + ((SignedMessageHeader)header).getId();
                        } else if (header instanceof SecurityHeaderElement) {
                            she = (SecurityHeaderElement)header;
                            smh = new SignedMessageHeader(she);
                            id = smh.getId();
                            if (id == null) {
                                id = fpContext.generateID();
                                smh.setId(id);
                            }
                            secMessage.replaceHeader(she, smh);
                            tmpUri = "#" + id;
                        } else if (header instanceof Header) {
                            jwHeader = (Header)header;
                            tmpUri = fpContext.generateID();
                            smh = this.createSignedMessageHeader(jwHeader, tmpUri, fpContext);
                            secMessage.replaceHeader(jwHeader, smh);
                            if (!tmpUri.startsWith("#")) {
                                tmpUri = "#" + tmpUri;
                            }
                        }
                        if (tmpUri == null) continue;
                        reference = signatureFactory.newReference(tmpUri, digestMethod, transformList, null, null);
                        references.add(reference);
                    }
                    continue;
                }
            }
            reference = null;
            reference = signatureFactory.newReference(targetURI, digestMethod, transformList, null, null);
            references.add(reference);
        }
        if (references.isEmpty()) {
            SignatureElementFactory.logger.log(Level.WARNING, "No Signed Parts found in the Message");
        }
        return references;
    }

    private List setInclusiveNamespaces(ExcC14NParameterSpec spec) {
        com.sun.xml.security.core.dsig.ObjectFactory objFac = new com.sun.xml.security.core.dsig.ObjectFactory();
        InclusiveNamespacesType incList = objFac.createInclusiveNamespaces();
        List prefixList = spec.getPrefixList();
        for (int j = 0; j < prefixList.size(); ++j) {
            String prefix = (String)prefixList.get(j);
            incList.addToPrefixList(prefix);
        }
        JAXBElement<InclusiveNamespacesType> je = objFac.createInclusiveNamespaces(incList);
        ArrayList<JAXBElement<InclusiveNamespacesType>> contentList = new ArrayList<JAXBElement<InclusiveNamespacesType>>();
        contentList.add(je);
        return contentList;
    }

    private SignedMessageHeader toSignedMessageHeader(Header header, JAXBFilterProcessingContext context) {
        return this.createSignedMessageHeader(header, context.generateID(), context);
    }

    private SignedMessageHeader createSignedMessageHeader(Header header, String string2, JAXBFilterProcessingContext context) {
        return new SignedMessageHeader(header, string2, context);
    }

    private Object getPartFromId(JAXBFilterProcessingContext fpContext, String id) throws XWSSecurityException {
        SecurityElement se;
        SecuredMessage secMessage = fpContext.getSecuredMessage();
        Object reqdHeader = secMessage.getHeader(id);
        if (reqdHeader != null) {
            return reqdHeader;
        }
        SecurityHeader secHeader = fpContext.getSecurityHeader();
        SecurityHeaderElement she = secHeader.getChildElement(id);
        if (she != null) {
            return she;
        }
        Object body = secMessage.getBody();
        if (body instanceof SOAPBody) {
            SOAPBody soapBody = (SOAPBody)body;
            if (id.equals(soapBody.getId())) {
                return soapBody;
            }
        } else if (body instanceof SecurityElement && id.equals((se = (SecurityElement)body).getId())) {
            return se;
        }
        return null;
    }
}

