/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.IMQBlockingQueue;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.HandOffQueue;
import java.io.IOException;
import java.util.Hashtable;

public class IMQEmbeddedConnection
extends IMQIPConnection
implements DirectBrokerConnection {
    IMQBlockingQueue inputQueue = new IMQBlockingQueue();
    IMQBlockingQueue outputQueue = new IMQBlockingQueue();
    String localsvcstring = null;

    public IMQEmbeddedConnection(Service service, PacketRouter packetRouter) throws IOException, BrokerException {
        super(service, null, packetRouter);
    }

    public HandOffQueue getClientToBrokerQueue() {
        return this.inputQueue;
    }

    public HandOffQueue getBrokerToClientQueue() {
        return this.outputQueue;
    }

    public boolean isBlocking() {
        return true;
    }

    public synchronized Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("transport", "Embedded");
        hashtable.put("inputQueue", this.inputQueue.toString());
        hashtable.put("outputQueue", this.outputQueue.toString());
        return hashtable;
    }

    public String getRemoteConnectionString() {
        Object object;
        String string;
        boolean bl;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            bl = false;
            string = "???";
            if (this.state >= 4) {
                try {
                    object = this.getAuthenticatedName();
                    if (object != null) {
                        string = object.getName();
                        bl = true;
                    }
                }
                catch (BrokerException brokerException) {
                    if (!IMQBasicConnection.DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + (Object)((Object)this.conId), (Throwable)brokerException);
                }
            }
        }
        object = string + "@" + "Direct" + ":" + (Object)((Object)this.getConnectionUID());
        if (bl) {
            this.remoteConString = object;
        }
        return object;
    }

    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        this.localsvcstring = this.service.getName();
        return this.localsvcstring;
    }

    public synchronized void closeConnection(boolean bl, int n, String string) {
        super.closeConnection(bl, n, string);
        EOF eOF = new EOF(string);
        try {
            this.inputQueue.put(eOF);
        }
        catch (InterruptedException interruptedException) {
            Globals.getLogger().logStack(4, "nothing we can do", (Throwable)interruptedException);
        }
    }

    protected boolean readInPacket(Packet packet) throws IOException {
        try {
            Packet packet2 = (Packet)this.inputQueue.take();
            if (packet2 instanceof EOF) {
                EOF eOF = (EOF)packet2;
                throw new IOException("Connection has been closed:" + eOF.getReason());
            }
            Packet packet3 = packet2;
            packet.fill(packet3, false);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(4, "Error retrieving message", (Throwable)exception);
            throw new IOException("Issue processing :" + exception);
        }
        return true;
    }

    protected Packet clearReadPacket(Packet packet) {
        return null;
    }

    protected boolean writeOutPacket(Packet packet) throws IOException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.fill(packet, true);
        this.outputQueue.add(readWritePacket);
        return true;
    }

    protected Packet clearWritePacket(Packet packet) {
        return null;
    }

    class EOF {
        String reason = null;

        public EOF(String string) {
            this.reason = string;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

