/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.ExceptionTable;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class CodeAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "Code";
    private byte[] theDataBytes;
    private int maxStack;
    private int maxLocals;
    private byte[] theCodeBytes;
    private Insn theCode;
    private ExceptionTable exceptionTable;
    private AttributeVector codeAttributes;
    CodeEnv codeEnv;

    public int stackUsed() {
        this.makeValid();
        return this.maxStack;
    }

    public void setStackUsed(int used) {
        this.makeValid();
        this.maxStack = used;
    }

    public int localsUsed() {
        this.makeValid();
        return this.maxLocals;
    }

    public void setLocalsUsed(int used) {
        this.makeValid();
        this.maxLocals = used;
    }

    public byte[] byteCodes() {
        this.makeValid();
        return this.theCodeBytes;
    }

    public Insn theCode() {
        this.makeValid();
        if (this.theCode == null && this.codeEnv != null) {
            this.buildInstructions(this.codeEnv);
        }
        return this.theCode;
    }

    public void setTheCode(Insn insn) {
        this.makeValid();
        if (insn != null && insn.opcode() != -1) {
            throw new InsnError("The initial instruction in all methods must be a target");
        }
        this.theCode = insn;
    }

    public ExceptionTable exceptionHandlers() {
        this.makeValid();
        return this.exceptionTable;
    }

    public AttributeVector attributes() {
        this.makeValid();
        return this.codeAttributes;
    }

    public CodeAttribute(ConstUtf8 attrName, int maxStack, int maxLocals, Insn code, ExceptionTable excTable, AttributeVector codeAttrs) {
        this(attrName, maxStack, maxLocals, code, null, excTable, codeAttrs, null);
    }

    public CodeAttribute(ConstUtf8 attrName, int maxStack, int maxLocals, Insn code, byte[] codeBytes, ExceptionTable excTable, AttributeVector codeAttrs, CodeEnv codeEnv) {
        super(attrName);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.theCode = code;
        this.theCodeBytes = codeBytes;
        this.exceptionTable = excTable;
        this.codeAttributes = codeAttrs;
        this.codeEnv = codeEnv;
    }

    public CodeAttribute(ConstUtf8 attrName, byte[] dataBytes, CodeEnv codeEnv) {
        super(attrName);
        this.theDataBytes = dataBytes;
        this.codeEnv = codeEnv;
    }

    static CodeAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        int maxStack = data.readUnsignedShort();
        int maxLocals = data.readUnsignedShort();
        int codeLength = data.readInt();
        byte[] codeBytes = new byte[codeLength];
        data.readFully(codeBytes);
        Insn code = null;
        CodeEnv codeEnv = new CodeEnv(pool);
        ExceptionTable excTable = ExceptionTable.read(data, codeEnv);
        AttributeVector codeAttrs = AttributeVector.readAttributes(data, codeEnv);
        return new CodeAttribute(attrName, maxStack, maxLocals, code, codeBytes, excTable, codeAttrs, codeEnv);
    }

    static CodeAttribute read(ConstUtf8 attrName, int attrLength, DataInputStream data, ConstantPool pool) throws IOException {
        byte[] dataBytes = new byte[attrLength];
        data.readFully(dataBytes);
        return new CodeAttribute(attrName, dataBytes, new CodeEnv(pool));
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        if (this.theDataBytes == null) {
            this.buildInstructionBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream tmpOut = new DataOutputStream(baos);
            tmpOut.writeShort(this.maxStack);
            tmpOut.writeShort(this.maxLocals);
            tmpOut.writeInt(this.theCodeBytes.length);
            tmpOut.write(this.theCodeBytes, 0, this.theCodeBytes.length);
            this.exceptionTable.write(tmpOut);
            this.codeAttributes.write(tmpOut);
            tmpOut.flush();
            byte[] tmpBytes = baos.toByteArray();
            out.writeInt(tmpBytes.length);
            out.write(tmpBytes, 0, tmpBytes.length);
        } else {
            out.writeInt(this.theDataBytes.length);
            out.write(this.theDataBytes, 0, this.theDataBytes.length);
        }
    }

    void print(PrintStream out, int indent) {
        Insn insn;
        this.makeValid();
        ClassPrint.spaces(out, indent);
        out.print("Code:");
        out.print(" max_stack = " + Integer.toString(this.maxStack));
        out.print(" max_locals = " + Integer.toString(this.maxLocals));
        out.println(" Exceptions:");
        this.exceptionTable.print(out, indent + 2);
        ClassPrint.spaces(out, indent);
        out.println("Code Attributes:");
        this.codeAttributes.print(out, indent + 2);
        if (insn != null) {
            ClassPrint.spaces(out, indent);
            out.println("Instructions:");
            for (insn = this.theCode(); insn != null; insn = insn.next()) {
                insn.print(out, indent + 2);
            }
        }
    }

    private int resolveOffsets() {
        int currPC = 0;
        for (Insn insn = this.theCode; insn != null; insn = insn.next()) {
            currPC = insn.resolveOffset(currPC);
        }
        return currPC;
    }

    int codeSize() {
        this.makeValid();
        return this.theCodeBytes.length;
    }

    private void buildInstructions(CodeEnv codeEnv) {
        if (this.theCodeBytes != null) {
            InsnTarget targ;
            InsnReadEnv insnEnv = new InsnReadEnv(this.theCodeBytes, codeEnv);
            Insn currInsn = this.theCode = insnEnv.getTarget(0);
            while (insnEnv.more()) {
                Insn newInsn = Insn.read(insnEnv);
                currInsn.setNext(newInsn);
                currInsn = newInsn;
            }
            Insn prevInsn = null;
            for (currInsn = this.theCode; currInsn != null; currInsn = currInsn.next()) {
                int off = currInsn.offset();
                if (off > 0 && (targ = codeEnv.findTarget(off)) != null) {
                    prevInsn.setNext(targ);
                }
                prevInsn = currInsn;
            }
            targ = codeEnv.findTarget(insnEnv.currentPC());
            if (targ != null) {
                prevInsn.setNext(targ);
            }
        }
    }

    private void buildInstructionBytes() {
        if (this.theCode != null) {
            int size = this.resolveOffsets();
            this.theCodeBytes = new byte[size];
            int index = 0;
            for (Insn insn = this.theCode; insn != null; insn = insn.next()) {
                index = insn.store(this.theCodeBytes, index);
            }
        }
    }

    private void makeValid() {
        if (this.theDataBytes != null) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.theDataBytes));
            try {
                this.maxStack = dis.readUnsignedShort();
                this.maxLocals = dis.readUnsignedShort();
                int codeLength = dis.readInt();
                this.theCodeBytes = new byte[codeLength];
                dis.readFully(this.theCodeBytes);
                this.exceptionTable = ExceptionTable.read(dis, this.codeEnv);
                this.codeAttributes = AttributeVector.readAttributes(dis, this.codeEnv);
            }
            catch (IOException ioe) {
                ClassFormatError cfe = new ClassFormatError("IOException while reading code attribute");
                cfe.initCause(ioe);
                throw cfe;
            }
            this.theDataBytes = null;
        }
    }
}

