/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.http.Constants;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.KeepAliveThreadAttachment;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.http.TaskBase;
import com.sun.grizzly.http.TaskEvent;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.ActionHook;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.InputBuffer;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Processor;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.RequestInfo;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InputFilter;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.tcp.http11.filters.BufferedInputFilter;
import com.sun.grizzly.tcp.http11.filters.ChunkedInputFilter;
import com.sun.grizzly.tcp.http11.filters.ChunkedOutputFilter;
import com.sun.grizzly.tcp.http11.filters.GzipOutputFilter;
import com.sun.grizzly.tcp.http11.filters.IdentityInputFilter;
import com.sun.grizzly.tcp.http11.filters.IdentityOutputFilter;
import com.sun.grizzly.tcp.http11.filters.VoidInputFilter;
import com.sun.grizzly.tcp.http11.filters.VoidOutputFilter;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.StreamAlgorithm;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.HexUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.HtmlHelper;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.net.SSLSupport;
import com.sun.grizzly.util.res.StringManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ProcessorTask
extends TaskBase
implements Processor,
ActionHook {
    private static final Logger logger = SelectorThread.logger();
    private boolean isSecurityEnabled;
    protected static final StringManager sm = StringManager.getManager((String)"com.sun.grizzly.http.res");
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = null;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected SocketChannelOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean connectionHeaderValueSet = false;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected SSLSupport sslSupport;
    protected Socket socket;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int uploadTimeout = 300000;
    protected int maxPostSize = 0x200000;
    protected char[] hostNameC = new char[0];
    protected boolean hasRequestInfoRegistered = false;
    protected int maxHttpHeaderSize = 8192;
    protected static int requestCount;
    protected int requestBufferSize = 8192;
    protected ObjectName oname;
    protected boolean dropConnection = false;
    protected int keepAliveLeft;
    protected StreamAlgorithm streamAlgorithm;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected boolean asyncExecution = false;
    protected RequestInfo requestInfo;
    protected AsyncHandler asyncHandler;
    private Semaphore asyncSemaphore = new Semaphore(1);
    private int sendBufferSize = 131072;
    protected String[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected String[] restrictedUserAgents = null;
    protected boolean bufferResponse = true;
    protected boolean disableUploadTimeout = true;
    protected boolean isAsyncHttpWriteEnabled;
    private int transactionTimeout = 300000;
    private boolean useChunking = true;
    private static final String USE_KEEP_ALIVE = "com.sun.grizzly.useKeepAliveAlgorithm";
    private static final String BLOCKING_KEEP_ALIVE = "com.sun.grizzly.keepAliveLockingThread";
    private boolean useKeepAliveAlgorithm = true;
    protected int maxKeepAliveRequests = 256;
    protected boolean handleKeepAliveBlockingThread = false;
    protected boolean reRegisterSelectionKey = true;
    protected boolean aptCancelKey;
    private final TaskEvent<ProcessorTask> event = new TaskEvent<ProcessorTask>(this);
    private boolean isProcessingCompleted = false;

    public ProcessorTask() {
        this(true);
    }

    public ProcessorTask(boolean init) {
        this.type = 2;
        if (init) {
            this.initialize();
        }
    }

    public ProcessorTask(boolean init, boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
        this.type = 2;
        if (init) {
            this.initialize();
        }
    }

    public void initialize() {
        this.isSecurityEnabled = System.getSecurityManager() != null;
        this.started = true;
        this.request = new Request();
        this.response = new Response();
        this.response.setHook((ActionHook)this);
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.outputBuffer = new SocketChannelOutputBuffer(this.response, this.sendBufferSize, this.bufferResponse);
        this.request.setInputBuffer((InputBuffer)this.inputBuffer);
        this.response.setOutputBuffer((OutputBuffer)this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
        if (System.getProperty(USE_KEEP_ALIVE) != null) {
            this.useKeepAliveAlgorithm = Boolean.valueOf(System.getProperty(USE_KEEP_ALIVE));
            if (!this.useKeepAliveAlgorithm) {
                logger.info("Keep Alive algorith will no be used");
            }
        }
        if (System.getProperty(BLOCKING_KEEP_ALIVE) != null) {
            this.handleKeepAliveBlockingThread = Boolean.valueOf(System.getProperty(BLOCKING_KEEP_ALIVE));
            if (!this.handleKeepAliveBlockingThread) {
                logger.info("Keep Alive blocking thread algorithm will no be used");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        try {
            this.process(this.inputStream, this.outputStream);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, sm.getString("processorTask.errorProcessingRequest"), ex);
            }
        }
        finally {
            this.terminateProcess();
        }
    }

    public void preProcess() throws Exception {
        this.preProcess(this.inputStream, this.outputStream);
    }

    public void preProcess(InputStream input, OutputStream output) throws Exception {
        if (!this.started) {
            this.initialize();
        }
        this.inputBuffer.setInputStream(input);
        if (this.key != null) {
            this.inputStream = (InputReader)input;
            this.outputBuffer.setAsyncHttpWriteEnabled(this.isAsyncHttpWriteEnabled);
            this.outputBuffer.setAsyncQueueWriter(this.selectorHandler.getAsyncQueueWriter());
            this.outputBuffer.setSelectionKey(this.key);
            this.response.setChannel((SocketChannel)this.key.channel());
        }
        this.configPreProcess();
    }

    protected void configPreProcess() throws Exception {
        if (this.selectorThread.isMonitoringEnabled() && !this.hasRequestInfoRegistered) {
            this.registerMonitoring();
        } else if (!this.selectorThread.isMonitoringEnabled() && this.hasRequestInfoRegistered) {
            this.unregisterMonitoring();
        }
        if (this.selectorThread.isMonitoringEnabled()) {
            this.requestInfo = this.request.getRequestProcessor();
            this.requestInfo.setWorkerThreadID(Thread.currentThread().getId());
        }
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localName = null;
        this.localAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.connectionHeaderValueSet = false;
        this.error = false;
        this.keepAlive = true;
        if (this.request.getServerPort() == 0) {
            this.request.setServerPort(this.selectorThread.getPort());
        }
    }

    protected boolean doProcess() throws Exception {
        do {
            int soTimeout = ((InputReader)this.inputStream).getReadTimeout();
            if (this.handleKeepAliveBlockingThread) {
                ExtendedThreadPool st = (ExtendedThreadPool)this.getThreadPool();
                if (this.useKeepAliveAlgorithm) {
                    float threadRatio = (float)st.getActiveCount() / (float)st.getMaximumPoolSize();
                    if ((double)threadRatio > 0.33 && (double)threadRatio <= 0.66) {
                        soTimeout /= 2;
                    } else if ((double)threadRatio > 0.66) {
                        soTimeout /= 5;
                        this.keepAliveLeft = 1;
                    }
                }
            }
            ((InputReader)this.inputStream).setReadTimeout(soTimeout);
            this.isProcessingCompleted = false;
            boolean exitWhile = this.parseRequest();
            if (this.handleKeepAliveBlockingThread && this.maxKeepAliveRequests > 0 && --this.keepAliveLeft == 0) {
                this.keepAlive = false;
            }
            String serverName = "Grizzly/" + Grizzly.getRawVersion();
            if (System.getProperty("product.name") != null) {
                serverName = System.getProperty("product.name");
            }
            int status = this.response.getStatus();
            if (this.statusDropsConnection(this.response.getStatus())) {
                if (Thread.currentThread() instanceof HttpWorkerThread) {
                    HttpWorkerThread workerThread = (HttpWorkerThread)((Object)Thread.currentThread());
                    workerThread.getAttachment().setAttribute("suspend", null);
                }
                ByteBuffer bb = HtmlHelper.getErrorPage((String)this.messageDropConnection(status), (String)("HTTP/1.1 " + this.response.getStatus() + " " + this.messageDropConnection(status) + "\r\n"), (String)serverName);
                this.response.setContentLength(bb.limit());
                this.response.setContentType("text/html");
                this.response.flushHeaders();
                if (this.response.getChannel() != null) {
                    this.response.getChannel().write(bb);
                } else {
                    byte[] b = new byte[bb.limit()];
                    bb.get(b);
                    ByteChunk chunk = new ByteChunk();
                    chunk.setBytes(b, 0, b.length);
                    this.response.doWrite(chunk);
                }
            }
            if (exitWhile) {
                return exitWhile;
            }
            this.invokeAdapter();
            this.postResponse();
        } while (!this.error && this.keepAlive && (this.handleKeepAliveBlockingThread || this.inputBuffer.available() > 0));
        return this.error;
    }

    public void postResponse() throws Exception {
        if (this.isProcessingCompleted) {
            return;
        }
        if (this.response.isSuspended()) {
            WorkerThread wt = (WorkerThread)Thread.currentThread();
            wt.getAttachment().setAttribute("suspend", (Object)Boolean.TRUE);
            this.key.attach(this.response.getResponseAttachment());
            return;
        }
        this.finishResponse();
    }

    public void finishResponse() {
        block11: {
            this.isProcessingCompleted = true;
            try {
                this.adapter.afterService(this.request, this.response);
            }
            catch (Exception ex) {
                this.error = true;
                if (!logger.isLoggable(Level.FINEST)) break block11;
                logger.log(Level.FINEST, sm.getString("processorTask.errorFinishingRequest"), ex);
            }
        }
        try {
            if (this.error) {
                this.inputBuffer.setSwallowInput(false);
            }
            this.inputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, sm.getString("processorTask.errorFinishingRequest"), t);
            this.response.setStatus(500);
            this.error = true;
        }
        try {
            this.outputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, sm.getString("processorTask.errorFinishingResponse"), t);
            this.error = true;
        }
        if (this.error) {
            this.response.setStatus(500);
        }
        if (this.selectorThread.isMonitoringEnabled()) {
            this.request.updateCounters();
        }
        this.inputBuffer.nextRequest();
        this.outputBuffer.nextRequest();
    }

    public void invokeAdapter() {
        if (!this.error) {
            try {
                this.adapter.service(this.request, this.response);
                if (this.keepAlive && !this.error) {
                    this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                }
            }
            catch (InterruptedIOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, sm.getString("processorTask.serviceError"), t);
                this.response.setStatus(500);
                this.error = true;
            }
        }
    }

    public boolean parseRequest() throws Exception {
        try {
            this.inputBuffer.parseRequestLine();
            if (this.selectorThread.isMonitoringEnabled()) {
                this.request.getRequestProcessor().setRequestCompletionTime(0L);
            }
            if (!this.disableUploadTimeout && this.getSelectionKey() != null) {
                ((InputReader)this.inputStream).setReadTimeout(this.uploadTimeout);
            }
            this.inputBuffer.parseHeaders();
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            KeepAliveThreadAttachment k = (KeepAliveThreadAttachment)workerThread.getAttachment();
            k.setIdleTimeoutDelay(this.transactionTimeout);
            this.request.setStartTime(System.currentTimeMillis());
            if (SelectorThread.isEnableNioLogging()) {
                logger.log(Level.INFO, "SocketChannel request line " + this.key.channel() + " is: " + this.request);
                logger.log(Level.INFO, "SocketChannel headers" + this.key.channel() + " are: \n" + this.request.getMimeHeaders());
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, sm.getString("processorTask.nonBlockingError"), e);
            }
            this.error = true;
            this.keepAlive = false;
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, sm.getString("processorTask.nonBlockingError"), t);
            this.response.setStatus(400);
            this.error = true;
            return this.error;
        }
        try {
            this.prepareRequest();
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, sm.getString("processorTask.createRequestError"), t);
            }
            this.response.setStatus(500);
            this.error = true;
        }
        Interceptor handler = this.getHandler();
        if (!this.error && handler != null && handler.handle((Object)this.request, 0) == 1) {
            this.keepAlive(this.request.getMimeHeaders());
            return true;
        }
        return false;
    }

    public void postProcess() throws Exception {
        if (this.response.isSuspended() || this.isProcessingCompleted) {
            return;
        }
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.sslSupport = null;
        if (this.error) {
            this.keepAlive = false;
            this.connectionHeaderValueSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateProcess() {
        try {
            if (this.asyncSemaphore.tryAcquire(0L, TimeUnit.SECONDS) && this.getTaskListener() != null) {
                this.event.setStatus(this.error ? 1 : 2);
                this.getTaskListener().taskEvent(this.event);
            }
        }
        catch (InterruptedException ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, sm.getString("terminateProcess"), ex);
            }
        }
        finally {
            this.asyncSemaphore.release();
        }
    }

    public boolean process(InputStream input, OutputStream output) throws Exception {
        this.preProcess(input, output);
        this.doProcess();
        this.postProcess();
        return this.keepAlive;
    }

    public String getRequestURI() {
        return this.request.requestURI().toString();
    }

    public void action(ActionCode actionCode, Object param) {
        block80: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException ex) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, sm.getString("processorTask.nonBlockingError"), ex);
                        this.error = true;
                    }
                    break block80;
                }
            }
            if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted() || !this.http11) {
                    return;
                }
                MessageBytes expectMB = this.request.getMimeHeaders().getValue("expect");
                if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                    try {
                        this.outputBuffer.sendAck();
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                }
            } else {
                if (actionCode == ActionCode.ACTION_CLOSE) {
                    try {
                        this.outputBuffer.endRequest();
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "End Request", e);
                            this.error = true;
                            this.response.setErrorException((Exception)e);
                        }
                        break block80;
                    }
                }
                if (actionCode == ActionCode.ACTION_RESET) {
                    this.outputBuffer.reset();
                } else if (actionCode == ActionCode.ACTION_DISCARD_UPSTREAM_WRITE) {
                    this.outputBuffer.discardUpstreamBytes();
                } else if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block80;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, sm.getString("processorTask.errorSSL"), e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getInetAddress()) != null) {
                        this.remoteAddr = inetAddr.getHostAddress();
                    }
                    this.request.remoteAddr().setString(this.remoteAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.localName == null && this.socket != null && (inetAddr = this.socket.getLocalAddress()) != null) {
                        this.localName = inetAddr.getHostName();
                    }
                    this.request.localName().setString(this.localName);
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    if (this.remoteHost == null && this.socket != null) {
                        InetAddress inetAddr = this.socket.getInetAddress();
                        if (inetAddr != null) {
                            this.remoteHost = inetAddr.getHostName();
                        }
                        if (this.remoteHost == null) {
                            if (this.remoteAddr != null) {
                                this.remoteHost = this.remoteAddr;
                            } else {
                                this.request.remoteHost().recycle();
                            }
                        }
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                    if (this.localAddr == null) {
                        this.localAddr = this.socket.getLocalAddress().getHostAddress();
                    }
                    this.request.localAddr().setString(this.localAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                    if (this.remotePort == -1 && this.socket != null) {
                        this.remotePort = this.socket.getPort();
                    }
                    this.request.setRemotePort(this.remotePort);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                    if (this.localPort == -1 && this.socket != null) {
                        this.localPort = this.socket.getLocalPort();
                    }
                    this.request.setLocalPort(this.localPort);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                    if (this.sslSupport != null) {
                        InputFilter[] inputFilters = this.inputBuffer.getFilters();
                        ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                        this.inputBuffer.addActiveFilter(inputFilters[3]);
                        try {
                            Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                            if (sslO != null) {
                                this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)sslO);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, sm.getString("processorTask.exceptionSSLcert"), e);
                        }
                    }
                } else if (actionCode == ActionCode.ACTION_POST_REQUEST) {
                    Interceptor handler = this.getHandler();
                    if (this.response.getStatus() == 200 && handler != null && this.compressionLevel == 0) {
                        try {
                            handler.handle((Object)this.request, 1);
                        }
                        catch (IOException ex) {
                            logger.log(Level.FINEST, "Handler exception", ex);
                        }
                    }
                } else if (actionCode == ActionCode.CANCEL_SUSPENDED_RESPONSE) {
                    this.key.attach(null);
                } else if (actionCode == ActionCode.RESET_SUSPEND_TIMEOUT) {
                    Object attachment;
                    if (this.key != null && (attachment = this.key.attachment()) instanceof Response.ResponseAttachment) {
                        ((Response.ResponseAttachment)attachment).resetTimeout();
                    }
                } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
                    if (this.key != null) {
                        try {
                            this.outputBuffer.flush();
                        }
                        catch (IOException ex) {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.log(Level.FINEST, "ACTION_CLIENT_FLUSH", ex);
                            }
                            this.error = true;
                            this.response.setErrorException((Exception)ex);
                        }
                    }
                } else if (actionCode == ActionCode.ACTION_FINISH_RESPONSE) {
                    this.finishResponse();
                    try {
                        this.postProcess();
                    }
                    catch (Exception ex) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "ACTION_FINISH_RESPONSE", ex);
                        }
                        this.error = true;
                        this.response.setErrorException(ex);
                    }
                    if (!this.keepAlive) {
                        this.selectorThread.cancelKey(this.key);
                        this.recycle();
                        this.selectorThread.returnTask(this);
                    }
                }
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    void keepAlive(MimeHeaders headers) {
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
                this.connectionHeaderValueSet = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
                this.connectionHeaderValueSet = true;
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].equals(userAgentValue)) continue;
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        if (this.keepAlive) {
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            KeepAliveThreadAttachment k = (KeepAliveThreadAttachment)workerThread.getAttachment();
            KeepAliveStats ks = this.selectorThread.getKeepAliveStats();
            int count = k.increaseKeepAliveCount();
            if (count == 1 && this.selectorThread.getMaxKeepAliveRequests() < count && ks.isEnabled()) {
                ks.incrementCountRefusals();
                this.setDropConnection(true);
            }
        }
    }

    protected void prepareRequest() {
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        this.keepAlive(headers);
        ByteChunk uriBC = this.request.requestURI().getByteChunk();
        if (uriBC.startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        long contentLength = this.request.getContentLengthLong();
        if (contentLength >= 0L) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getLocalPort());
            InetAddress localAddress = this.socket.getLocalAddress();
            this.request.setLocalHost(localAddress.getHostName());
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null && !"".equals(contentLanguage)) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        int contentLength = this.response.getContentLength();
        if (contentLength != -1) {
            headers.setValue("Content-Length").setInt(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (this.useChunking && entityBody && this.http11 && this.keepAlive) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            this.response.addHeader("Transfer-Encoding", "chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            this.response.setHeader("Content-Encoding", "gzip");
            this.response.setHeader("Vary", "Accept-Encoding");
        }
        if (!this.response.containsHeader("Date")) {
            String date = FastHttpDateFormat.getCurrentDate();
            this.response.addHeader("Date", date);
        }
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode) && !this.dropConnection;
        if (!this.keepAlive) {
            headers.setValue("Connection").setString("close");
            this.connectionHeaderValueSet = false;
        } else if (!this.http11 && !this.error) {
            headers.setValue("Connection").setString("Keep-Alive");
        }
        this.outputBuffer.sendStatus();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter((InputFilter)new IdentityInputFilter());
        this.outputBuffer.addFilter((OutputFilter)new IdentityOutputFilter());
        this.inputBuffer.addFilter((InputFilter)new ChunkedInputFilter());
        this.outputBuffer.addFilter((OutputFilter)new ChunkedOutputFilter());
        this.inputBuffer.addFilter((InputFilter)new VoidInputFilter());
        this.outputBuffer.addFilter((OutputFilter)new VoidOutputFilter());
        this.inputBuffer.addFilter((InputFilter)new BufferedInputFilter());
        this.outputBuffer.addFilter((OutputFilter)new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower((int)buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower((int)buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected String messageDropConnection(int status) {
        switch (status) {
            case 400: {
                return "BAD REQUEST";
            }
            case 408: {
                return "REQUEST TIMEOUT";
            }
            case 411: {
                return "LENGTH REQUIRED";
            }
            case 413: {
                return "REQUEST ENTITY TOO LARGE";
            }
            case 414: {
                return "REQUEST URI TOO LARGE";
            }
            case 500: {
                return "INTERNAL SERVER ERROR";
            }
            case 503: {
                return "SERVICE UNAVAILABLE";
            }
            case 501: {
                return "NOT IMPLEMENTED";
            }
        }
        return "";
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                logger.log(Level.WARNING, sm.getString("processorTask.unknownFilter"), className);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, sm.getString("processorTask.errorFilter"), new Object[]{className, e});
        }
    }

    public void setMaxPostSize(int mps) {
        this.maxPostSize = mps;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setTimeout(int timeouts) {
        this.uploadTimeout = timeouts;
    }

    public int getTimeout() {
        return this.uploadTimeout;
    }

    public boolean isAsyncHttpWriteEnabled() {
        return this.isAsyncHttpWriteEnabled;
    }

    public void setAsyncHttpWriteEnabled(boolean isAsyncHttpWriteEnabled) {
        this.isAsyncHttpWriteEnabled = isAsyncHttpWriteEnabled;
    }

    private void registerMonitoring() {
        this.requestInfo = this.request.getRequestProcessor();
        this.requestInfo.setGlobalProcessor(this.selectorThread.getRequestGroupInfo());
        this.hasRequestInfoRegistered = true;
        if (this.selectorThread.getManagement() == null) {
            return;
        }
        try {
            this.oname = new ObjectName(this.selectorThread.getDomain() + ":type=RequestProcessor,worker=http" + this.selectorThread.getPort() + ",name=HttpRequest" + requestCount++);
            this.selectorThread.getManagement().registerComponent(this.requestInfo, this.oname, null);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, sm.getString("processorTask.errorRegisteringRequest"), ex);
        }
    }

    protected void unregisterMonitoring() {
        if (this.selectorThread.getManagement() == null) {
            return;
        }
        this.requestInfo = this.request.getRequestProcessor();
        this.requestInfo.setGlobalProcessor(null);
        this.requestInfo.reset();
        if (this.oname != null) {
            try {
                this.selectorThread.getManagement().unregisterComponent(this.oname);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, sm.getString("processorTask.errorUnregisteringRequest"), ex);
            }
        }
        this.hasRequestInfoRegistered = false;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public void setDropConnection(boolean dropConnection) {
        this.dropConnection = dropConnection;
    }

    public boolean getDropConnection() {
        return this.dropConnection;
    }

    public void setStreamAlgorithm(StreamAlgorithm streamAlgorithm) {
        this.streamAlgorithm = streamAlgorithm;
    }

    public StreamAlgorithm getStreamAlgorithm() {
        return this.streamAlgorithm;
    }

    private Interceptor getHandler() {
        if (this.streamAlgorithm != null) {
            return this.streamAlgorithm.getHandler();
        }
        return null;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
    }

    public boolean isAsyncExecutionEnabled() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public Request getRequest() {
        return this.request;
    }

    public void recycle() {
        this.setTaskListener(null);
        if (this.streamAlgorithm != null) {
            this.streamAlgorithm.recycle();
            Thread currentThread = Thread.currentThread();
            if (currentThread instanceof HttpWorkerThread && ((HttpWorkerThread)((Object)currentThread)).getStreamAlgorithm() == null) {
                ((HttpWorkerThread)((Object)currentThread)).setStreamAlgorithm(this.streamAlgorithm);
            }
            this.streamAlgorithm = null;
        }
        this.socket = null;
        this.dropConnection = false;
        this.reRegisterSelectionKey = true;
        this.aptCancelKey = false;
        this.key = null;
        this.isProcessingCompleted = false;
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void addNoCompressionUserAgent(String userAgent) {
        this.noCompressionUserAgents = this.addStringArray(this.noCompressionUserAgents, userAgent);
    }

    public void setNoCompressionUserAgents(String[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String[] findNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public void setCompressableMimeType(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    private String[] addStringArray(String[] sArray, String value) {
        if (value == null) {
            return sArray != null ? sArray : new String[]{};
        }
        if (sArray == null) {
            sArray = new String[]{value};
            return sArray;
        }
        String[] results = new String[sArray.length + 1];
        for (int i = 0; i < sArray.length; ++i) {
            results[i] = sArray[i];
        }
        results[sArray.length] = value;
        return results;
    }

    private boolean inStringArray(String[] sArray, String value) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!sArray[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isCompressable() {
        String userAgentValue;
        MessageBytes userAgentValueMB;
        if (!this.http11) {
            return false;
        }
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1 && acceptEncodingMB.indexOf("deflate") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && (contentEncodingMB.indexOf("gzip") != -1 || contentEncodingMB.indexOf("deflate") != -1)) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null && this.inStringArray(this.noCompressionUserAgents, userAgentValue = userAgentValueMB.toString())) {
            return false;
        }
        int contentLength = this.response.getContentLength();
        if ((contentLength == -1 || contentLength > this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void addRestrictedUserAgent(String userAgent) {
        this.restrictedUserAgents = this.addStringArray(this.restrictedUserAgents, userAgent);
    }

    public void setRestrictedUserAgents(String[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String[] findRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public SSLSupport getSSLSupport() {
        return this.sslSupport;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public long getWorkerThreadID() {
        return this.request.getRequestProcessor().getWorkerThreadID();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setConnectionHeaderValueSet(boolean connectionHeaderValueSet) {
        this.connectionHeaderValueSet = connectionHeaderValueSet;
    }

    public boolean isError() {
        return this.error;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public void setReRegisterSelectionKey(boolean reRegisterSelectionKey) {
        this.reRegisterSelectionKey = reRegisterSelectionKey;
    }

    public boolean getReRegisterSelectionKey() {
        return this.reRegisterSelectionKey;
    }

    public void setAptCancelKey(boolean aptCancelKey) {
        this.aptCancelKey = aptCancelKey;
    }

    public boolean getAptCancelKey() {
        return this.aptCancelKey;
    }

    public void setForceKeepAlive(boolean forceKeepAlive) {
        this.keepAlive = forceKeepAlive;
        this.connectionHeaderValueSet = forceKeepAlive;
    }

    public boolean getForceKeepAlive() {
        return this.keepAlive == this.connectionHeaderValueSet;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }
}

