/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.UpdateObjectQuery;

public class CMPPolicy
implements Serializable {
    protected Boolean forceUpdate = null;
    protected Boolean updateAllFields = null;
    protected PessimisticLockingPolicy pessimisticLockingPolicy;
    protected Class mappedClass;
    protected ClassDescriptor descriptor;
    protected int modificationDeferralLevel = 2;
    public static final int NONE = 0;
    public static final int UPDATE_MODIFICATIONS = 1;
    public static final int ALL_MODIFICATIONS = 2;
    protected int nonDeferredCreateTime = 0;
    public static final int UNDEFINED = 0;
    public static final int AFTER_EJBCREATE = 1;
    public static final int AFTER_EJBPOSTCREATE = 2;

    public int getNonDeferredCreateTime() {
        return this.nonDeferredCreateTime;
    }

    public PessimisticLockingPolicy getPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy;
    }

    public void setDeferModificationsUntilCommit(int deferralLevel) {
        this.modificationDeferralLevel = deferralLevel;
    }

    public void setMappedClass(Class newMappedClass) {
        this.mappedClass = newMappedClass;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setNonDeferredCreateTime(int createTime) {
        this.nonDeferredCreateTime = createTime;
    }

    public void setPessimisticLockingPolicy(PessimisticLockingPolicy policy) {
        this.pessimisticLockingPolicy = policy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy != null;
    }

    public int getDeferModificationsUntilCommit() {
        return this.modificationDeferralLevel;
    }

    public boolean getForceUpdate() {
        return Boolean.TRUE.equals(this.forceUpdate);
    }

    public void setForceUpdate(boolean shouldForceUpdate) {
        this.forceUpdate = shouldForceUpdate;
    }

    public boolean getUpdateAllFields() {
        return Boolean.TRUE.equals(this.updateAllFields);
    }

    public void setUpdateAllFields(boolean shouldUpdatAllFields) {
        this.updateAllFields = shouldUpdatAllFields;
    }

    public Boolean internalGetForceUpdate() {
        return this.forceUpdate;
    }

    public Boolean internalGetUpdateAllFields() {
        return this.updateAllFields;
    }

    public void internalSetForceUpdate(Boolean newForceUpdateValue) {
        this.forceUpdate = newForceUpdateValue;
    }

    public void internalSetUpdateAllFields(Boolean newUpdateAllFieldsValue) {
        this.updateAllFields = newUpdateAllFieldsValue;
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        if (this.getUpdateAllFields() && !descriptor.getQueryManager().hasUpdateQuery()) {
            descriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery());
        }
        if (this.getForceUpdate() && !this.getUpdateAllFields()) {
            throw DescriptorException.updateAllFieldsNotSet(descriptor);
        }
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor owningDescriptor) {
        this.descriptor = owningDescriptor;
    }

    public boolean isCMP3Policy() {
        return false;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createPrimaryKeyInstance(Vector key) {
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        if (pkElementArray.length == 1 && pkElementArray[0] instanceof KeyIsElementAccessor) {
            return key.get(0);
        }
        Object keyInstance = this.getPKClassInstance();
        for (int index = 0; index < pkElementArray.length; ++index) {
            KeyElementAccessor accessor = pkElementArray[index];
            Object fieldValue = key.get(index);
            accessor.setValue(keyInstance, fieldValue);
        }
        return keyInstance;
    }

    public Object createPrimaryKeyInstance(Object key, AbstractSession session) {
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        if (pkElementArray.length == 1 && pkElementArray[0] instanceof KeyIsElementAccessor) {
            DatabaseMapping mapping = builder.getMappingForAttributeName(pkElementArray[0].getAttributeName());
            return mapping.getRealAttributeValueFromObject(key, session);
        }
        Object keyInstance = this.getPKClassInstance();
        for (int index = 0; index < pkElementArray.length; ++index) {
            Object keyObj = key;
            KeyElementAccessor accessor = pkElementArray[index];
            DatabaseField field = accessor.getDatabaseField();
            DatabaseMapping mapping = builder.getMappingForField(field);
            while (mapping.isAggregateObjectMapping()) {
                keyObj = mapping.getRealAttributeValueFromObject(keyObj, session);
                mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
            }
            Object fieldValue = mapping.getRealAttributeValueFromObject(keyObj, session);
            accessor.setValue(keyInstance, fieldValue);
        }
        return keyInstance;
    }

    public Object getPKClassInstance() {
        throw new RuntimeException("Should not get here.");
    }

    public Class getPKClass() {
        throw new RuntimeException("Should not get here.");
    }

    public Vector createPkVectorFromKey(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    public Object createBeanUsingKey(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    protected KeyElementAccessor[] getKeyClassFields(Class clazz) {
        throw new RuntimeException("Should not get here.");
    }

    protected static interface KeyElementAccessor {
        public String getAttributeName();

        public DatabaseField getDatabaseField();

        public DatabaseMapping getMapping();

        public Object getValue(Object var1, AbstractSession var2);

        public void setValue(Object var1, Object var2);
    }

    protected class KeyIsElementAccessor
    implements KeyElementAccessor,
    Serializable {
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public KeyIsElementAccessor(String attributeName, DatabaseField databaseField, DatabaseMapping mapping) {
            this.attributeName = attributeName;
            this.databaseField = databaseField;
            this.mapping = mapping;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public Object getValue(Object object, AbstractSession session) {
            return object;
        }

        public void setValue(Object object, Object value) {
        }
    }
}

