/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.jms;

import java.util.Hashtable;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.coordination.jms.JMSTopicRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.broadcast.BroadcastTransportManager;

public class JMSTopicTransportManager
extends BroadcastTransportManager {
    protected String connectionFactoryName;
    public static final String DEFAULT_TOPIC = "jms/EclipseLinkTopic";
    public static final String DEFAULT_CONNECTION_FACTORY = "jms/EclipseLinkTopicConnectionFactory";

    public JMSTopicTransportManager(RemoteCommandManager rcm) {
        super(rcm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExternalConnection() {
        Hashtable hashtable = this.connectionsToExternalServices;
        synchronized (hashtable) {
            if (this.connectionsToExternalServices.isEmpty()) {
                try {
                    this.connectionsToExternalServices.put(this.rcm.getServiceId().getId(), this.createConnection(false));
                }
                catch (RemoteCommandManagerException rcmException) {
                    this.rcm.handleException(rcmException);
                }
            }
        }
    }

    public synchronized void createLocalConnection() {
        if (this.localConnection == null) {
            try {
                this.localConnection = this.createConnection(true);
            }
            catch (RemoteCommandManagerException rcmException) {
                this.rcm.handleException(rcmException);
            }
        }
    }

    protected JMSTopicRemoteConnection createConnection(boolean isLocalConnectionBeingCreated) throws RemoteCommandManagerException {
        Context remoteHostContext = null;
        try {
            remoteHostContext = this.getRemoteHostContext(this.getTopicHostUrl());
            TopicConnectionFactory connectionFactory = this.getTopicConnectionFactory(remoteHostContext);
            Topic topic = this.getTopic(remoteHostContext);
            TopicConnection topicConnection = connectionFactory.createTopicConnection();
            JMSTopicRemoteConnection jMSTopicRemoteConnection = new JMSTopicRemoteConnection(this.rcm, topicConnection, topic, isLocalConnectionBeingCreated);
            return jMSTopicRemoteConnection;
        }
        catch (Exception ex) {
            RemoteCommandManagerException rcmException = isLocalConnectionBeingCreated ? RemoteCommandManagerException.errorCreatingLocalJMSConnection(this.topicName, this.connectionFactoryName, this.getRemoteContextProperties(), ex) : RemoteCommandManagerException.errorCreatingJMSConnection(this.topicName, this.connectionFactoryName, this.getRemoteContextProperties(), ex);
            throw rcmException;
        }
        finally {
            if (remoteHostContext != null) {
                try {
                    remoteHostContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalConnection() {
        JMSTopicRemoteConnection connectionToRemove = (JMSTopicRemoteConnection)this.localConnection;
        JMSTopicTransportManager jMSTopicTransportManager = this;
        synchronized (jMSTopicTransportManager) {
            if (connectionToRemove == this.localConnection) {
                this.localConnection = null;
            } else {
                connectionToRemove = null;
            }
        }
        if (connectionToRemove != null) {
            connectionToRemove.close();
        }
    }

    public void createConnections() {
        this.createExternalConnection();
        this.createLocalConnection();
    }

    public void setTopicConnectionFactoryName(String newTopicConnectionFactoryName) {
        this.connectionFactoryName = newTopicConnectionFactoryName;
    }

    public String getTopicConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void initialize() {
        super.initialize();
        this.topicName = DEFAULT_TOPIC;
        this.connectionFactoryName = DEFAULT_CONNECTION_FACTORY;
    }

    public String getTopicHostUrl() {
        return (String)this.getRemoteContextProperties().get("java.naming.provider.url");
    }

    public void setTopicHostUrl(String jmsHostUrl) {
        this.getRemoteContextProperties().put("java.naming.provider.url", jmsHostUrl);
        this.rcm.getServiceId().setURL(jmsHostUrl);
    }

    public void setNamingServiceType(int serviceType) {
        if (serviceType != 0) {
            throw ValidationException.operationNotSupported("setNamingServiceType");
        }
    }

    protected Topic getTopic(Context remoteHostContext) {
        try {
            return (Topic)remoteHostContext.lookup(this.topicName);
        }
        catch (NamingException e) {
            RemoteCommandManagerException rcmException = RemoteCommandManagerException.errorLookingUpRemoteConnection(this.topicName, this.rcm.getUrl(), e);
            this.rcm.handleException(rcmException);
            throw rcmException;
        }
    }

    protected TopicConnectionFactory getTopicConnectionFactory(Context remoteHostContext) {
        try {
            return (TopicConnectionFactory)remoteHostContext.lookup(this.connectionFactoryName);
        }
        catch (NamingException e) {
            RemoteCommandManagerException rcmException = RemoteCommandManagerException.errorLookingUpRemoteConnection(this.connectionFactoryName, this.rcm.getUrl(), e);
            this.rcm.handleException(rcmException);
            throw rcmException;
        }
    }

    public Hashtable getConnectionsToExternalServicesForCommandPropagation() {
        if (this.getConnectionsToExternalServices().isEmpty() && !this.rcm.isStopped()) {
            this.createExternalConnection();
            if (this.localConnection == null) {
                this.rcm.getServerPlatform().launchContainerRunnable(new Runnable(){

                    public void run() {
                        try {
                            JMSTopicTransportManager.this.createLocalConnection();
                        }
                        catch (RemoteCommandManagerException remoteCommandManagerException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        return super.getConnectionsToExternalServicesForCommandPropagation();
    }
}

