/*
 * Decompiled with CFR 0.152.
 */
package jmaki.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JmakiController
extends HttpServlet {
    private static boolean rDebug = false;
    private Logger logger = null;
    private ServletContext context;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("com.sun.jmaki.Log");
        }
        return this.logger;
    }

    private void logMessage(String message) {
        if (rDebug) {
            this.getLogger().info(message);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        String target = null;
        try {
            InputStream in;
            if (req.getParameter("url") != null) {
                target = req.getParameter("url");
                if (!target.startsWith("/")) {
                    target = "/" + target;
                }
            } else {
                target = req.getPathInfo();
            }
            if ((in = JmakiController.class.getClassLoader().getResourceAsStream("META-INF" + target)) != null) {
                if (target.endsWith(".xml")) {
                    res.setContentType("text/xml");
                } else if (target.endsWith(".js")) {
                    res.setContentType("text/javascript");
                }
                ServletOutputStream out = res.getOutputStream();
                this.writeBinaryResource(in, (OutputStream)out);
            } else {
                PrintWriter out = res.getWriter();
                out.println("Unable to locate resource: " + target);
            }
        }
        catch (IOException iox) {
            this.getLogger().severe("ControllerServlet: caught " + iox);
        }
    }

    private void writeBinaryResource(InputStream in, OutputStream out) {
        byte[] bytes = new byte[1024];
        try {
            int read = 0;
            while ((read = in.read(bytes)) > 0) {
                out.write(bytes, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println("ControllerServlet:loadResource from stream error:" + e);
        }
    }
}

