/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.comm;

import com.sun.btrace.comm.DataCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class StringMapDataCommand
extends DataCommand {
    private Map<String, String> data;

    public StringMapDataCommand() {
        this(null, null);
    }

    public StringMapDataCommand(String name, Map<String, String> data) {
        super((byte)8, name);
        this.data = data != null ? new HashMap(data) : data;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public void print(PrintWriter out) {
        if (this.name != null && !this.name.equals("")) {
            out.println(this.name);
        }
        if (this.data != null) {
            for (Map.Entry<String, String> e : this.data.entrySet()) {
                out.print(e.getKey());
                out.print(" = ");
                out.println(e.getValue());
            }
        }
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.name != null ? this.name : "");
        if (this.data != null) {
            out.writeInt(this.data.size());
            for (String key : this.data.keySet()) {
                out.writeUTF(key);
                out.writeUTF(this.data.get(key));
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void read(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.data = new HashMap<String, String>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            this.data.put(in.readUTF(), in.readUTF());
        }
    }
}

