/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.WeldApplicationContainer;
import org.glassfish.weld.WeldContainer;
import org.glassfish.weld.services.EjbServicesImpl;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.SecurityServicesImpl;
import org.glassfish.weld.services.ServletServicesImpl;
import org.glassfish.weld.services.TransactionServicesImpl;
import org.glassfish.weld.services.ValidationServicesImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.servlet.api.ServletServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.validation.spi.ValidationServices;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WeldDeployer
extends SimpleDeployer<WeldContainer, WeldApplicationContainer>
implements PostConstruct,
EventListener {
    private Logger _logger = LogDomains.getLogger(WeldDeployer.class, (String)"javax.enterprise.system.core");
    public static final String WELD_EXTENSION = "org.glassfish.weld";
    public static final String WELD_DEPLOYMENT = "org.glassfish.weld.WeldDeployment";
    static final String WELD_BOOTSTRAP = "org.glassfish.weld.WeldBootstrap";
    private static final String WELD_LISTENER = "org.jboss.weld.servlet.WeldListener";
    private static final String WELD_SHUTDOWN = "false";
    @Inject
    private Events events;
    @Inject
    private Habitat habitat;
    private Map<Application, WeldBootstrap> appToBootstrap = new HashMap<Application, WeldBootstrap>();
    private Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event event) {
        if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_LOADED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                DeploymentImpl deploymentImpl = (DeploymentImpl)appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
                deploymentImpl = this.buildDeploymentGraph(deploymentImpl);
                System.out.println(deploymentImpl.toString());
                try {
                    bootstrap.startContainer((Environment)Environments.SERVLET, (Deployment)deploymentImpl, (BeanStore)new ConcurrentHashMapBeanStore());
                    bootstrap.startInitialization();
                    bootstrap.deployBeans();
                }
                catch (Throwable t) {
                    DeploymentException de = new DeploymentException(t.getMessage());
                    de.initCause(t);
                    throw de;
                }
            }
        } else if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_STARTED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                try {
                    bootstrap.validateBeans();
                    bootstrap.endInitialization();
                }
                catch (Throwable t) {
                    DeploymentException de = new DeploymentException(t.getMessage());
                    de.initCause(t);
                    throw de;
                }
            }
        } else if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_STOPPED) || event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_UNLOADED)) {
            String shutdown;
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            Application app = (Application)appInfo.getMetaData(Application.class);
            if (app != null) {
                for (BundleDescriptor next : app.getBundleDescriptors()) {
                    if (!(next instanceof EjbBundleDescriptor) && !(next instanceof WebBundleDescriptor)) continue;
                    this.bundleToBeanDeploymentArchive.remove(next);
                }
                this.appToBootstrap.remove(app);
            }
            if (Boolean.valueOf(shutdown = (String)appInfo.getTransientAppMetaData(WELD_SHUTDOWN, String.class)) == Boolean.TRUE) {
                return;
            }
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (null != bootstrap) {
                try {
                    bootstrap.shutdown();
                }
                catch (Exception e) {
                    this._logger.log(Level.WARNING, "JCDI shutdown error", e);
                }
                appInfo.addTransientAppMetaData(WELD_SHUTDOWN, (Object)"true");
            }
        }
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.get(bundle);
    }

    public boolean is299Enabled(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle);
    }

    public WeldBootstrap getBootstrapForApp(Application app) {
        return this.appToBootstrap.get(app);
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public WeldApplicationContainer load(WeldContainer container, DeploymentContext context) {
        WebBundleDescriptor bundle;
        DeploymentImpl deploymentImpl;
        ReadableArchive archive = context.getSource();
        WeldBootstrap bootstrap = (WeldBootstrap)context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        if (null == bootstrap) {
            bootstrap = new WeldBootstrap();
            Application app = (Application)context.getModuleMetaData(Application.class);
            this.appToBootstrap.put(app, bootstrap);
        }
        HashSet<EjbDescriptor> ejbs = new HashSet();
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        if (ejbBundle != null) {
            ejbs = ejbBundle.getEjbs();
            ejbServices = new EjbServicesImpl(this.habitat);
        }
        if (null == (deploymentImpl = (DeploymentImpl)context.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class))) {
            deploymentImpl = new DeploymentImpl(archive, ejbs);
            ServletServicesImpl servletServices = new ServletServicesImpl(context);
            deploymentImpl.getServices().add(ServletServices.class, (org.jboss.weld.bootstrap.api.Service)servletServices);
            TransactionServicesImpl transactionServices = new TransactionServicesImpl(this.habitat);
            deploymentImpl.getServices().add(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)transactionServices);
            ValidationServicesImpl validationServices = new ValidationServicesImpl();
            deploymentImpl.getServices().add(ValidationServices.class, (org.jboss.weld.bootstrap.api.Service)validationServices);
            SecurityServicesImpl securityServices = new SecurityServicesImpl();
            deploymentImpl.getServices().add(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)securityServices);
            if (ejbBundle != null) {
                deploymentImpl.getServices().add(EjbServices.class, (org.jboss.weld.bootstrap.api.Service)ejbServices);
            }
        } else {
            deploymentImpl.scanArchive(archive, ejbs);
        }
        InjectionManager injectionMgr = (InjectionManager)this.habitat.getByContract(InjectionManager.class);
        InjectionServicesImpl injectionServices = new InjectionServicesImpl(injectionMgr);
        for (BeanDeploymentArchive bda : deploymentImpl.getBeanDeploymentArchives()) {
            bda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
        }
        WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
        if (wDesc != null) {
            wDesc.setExtensionProperty(WELD_EXTENSION, "true");
            wDesc.addAppListenerDescriptor(new AppListenerDescriptorImpl(WELD_LISTENER));
        }
        Object object = bundle = wDesc != null ? wDesc : ejbBundle;
        if (bundle != null) {
            BeanDeploymentArchive bda = deploymentImpl.getBeanDeploymentArchiveForArchive(archive.getURI().getPath());
            this.bundleToBeanDeploymentArchive.put((BundleDescriptor)bundle, bda);
        }
        WeldApplicationContainer wbApp = new WeldApplicationContainer(bootstrap);
        context.addTransientAppMetaData(WELD_BOOTSTRAP, (Object)bootstrap);
        context.addTransientAppMetaData(WELD_DEPLOYMENT, (Object)deploymentImpl);
        return wbApp;
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }

    private DeploymentImpl buildDeploymentGraph(DeploymentImpl deploymentImpl) {
        List<BeanDeploymentArchive> jarBDAs = deploymentImpl.getJarBeanDeploymentArchives();
        ListIterator<BeanDeploymentArchive> jarIter = jarBDAs.listIterator();
        while (jarIter.hasNext()) {
            boolean modifiedArchive = false;
            BeanDeploymentArchive jarBDA = jarIter.next();
            ListIterator<BeanDeploymentArchive> jarIter1 = jarBDAs.listIterator();
            while (jarIter1.hasNext()) {
                BeanDeploymentArchive jarBDA1 = jarIter1.next();
                if (jarBDA1.getId().equals(jarBDA.getId())) continue;
                jarBDA.getBeanDeploymentArchives().add(jarBDA1);
                modifiedArchive = true;
            }
            if (!modifiedArchive) continue;
            int idx = deploymentImpl.getBeanDeploymentArchives().indexOf(jarBDA);
            if (idx >= 0) {
                deploymentImpl.getBeanDeploymentArchives().remove(idx);
                deploymentImpl.getBeanDeploymentArchives().add(jarBDA);
            }
            modifiedArchive = false;
        }
        List<BeanDeploymentArchive> warBDAs = deploymentImpl.getWarBeanDeploymentArchives();
        ListIterator<BeanDeploymentArchive> lIter = warBDAs.listIterator();
        boolean modifiedArchive = false;
        while (lIter.hasNext()) {
            BeanDeploymentArchive warBDA = lIter.next();
            jarBDAs = deploymentImpl.getJarBeanDeploymentArchives();
            ListIterator<BeanDeploymentArchive> lIter1 = jarBDAs.listIterator();
            while (lIter1.hasNext()) {
                BeanDeploymentArchive jarBDA = lIter1.next();
                warBDA.getBeanDeploymentArchives().add(jarBDA);
                modifiedArchive = true;
            }
            if (!modifiedArchive) continue;
            int idx = deploymentImpl.getBeanDeploymentArchives().indexOf(warBDA);
            if (idx >= 0) {
                deploymentImpl.getBeanDeploymentArchives().remove(idx);
                deploymentImpl.getBeanDeploymentArchives().add(warBDA);
            }
            modifiedArchive = false;
        }
        return deploymentImpl;
    }
}

