/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.internal.api.Globals;
import org.jboss.weld.injection.spi.InjectionContext;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionServicesImpl
implements InjectionServices {
    private InjectionManager injectionManager;

    public InjectionServicesImpl(InjectionManager injectionMgr) {
        this.injectionManager = injectionMgr;
    }

    public <T> void aroundInject(InjectionContext<T> injectionContext) {
        try {
            EjbDescriptor ejbDesc;
            Habitat h = Globals.getDefaultHabitat();
            ComponentEnvManager compEnvManager = (ComponentEnvManager)h.getByContract(ComponentEnvManager.class);
            EjbContainerServices containerServices = (EjbContainerServices)h.getByContract(EjbContainerServices.class);
            JndiNameEnvironment componentEnv = compEnvManager.getCurrentJndiNameEnvironment();
            ManagedBeanDescriptor mbDesc = null;
            JndiNameEnvironment injectionEnv = componentEnv;
            Object target = injectionContext.getTarget();
            String targetClass = target.getClass().getName();
            if (componentEnv == null) {
                throw new IllegalStateException("No valid EE environment for injection of " + targetClass);
            }
            if (componentEnv instanceof EjbDescriptor && !containerServices.isEjbManagedObject((Object)(ejbDesc = (EjbDescriptor)componentEnv), target.getClass())) {
                BundleDescriptor topLevelBundle = (BundleDescriptor)ejbDesc.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
                if (topLevelBundle instanceof WebBundleDescriptor) {
                    injectionEnv = (WebBundleDescriptor)topLevelBundle;
                } else {
                    mbDesc = ejbDesc.getEjbBundleDescriptor().getManagedBeanByBeanClass(targetClass);
                    if (mbDesc == null) {
                        injectionEnv = ejbDesc.getEjbBundleDescriptor();
                    }
                }
            }
            if (mbDesc != null) {
                this.injectionManager.injectInstance(target, mbDesc.getGlobalJndiName(), false);
            } else if (injectionEnv instanceof EjbBundleDescriptor) {
                this.injectionManager.injectInstance(target, compEnvManager.getComponentEnvId(injectionEnv), false);
            } else {
                this.injectionManager.injectInstance(target, injectionEnv, false);
            }
            injectionContext.proceed();
        }
        catch (InjectionException ie) {
            throw new IllegalStateException(ie.getMessage(), ie);
        }
    }

    public void cleanup() {
    }
}

