/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.impl.transport;

import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.connectioncache.impl.transport.ConnectionCacheBlockingBase;
import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueue;
import com.sun.grizzly.connectioncache.spi.transport.ConnectionFinder;
import com.sun.grizzly.connectioncache.spi.transport.ContactInfo;
import com.sun.grizzly.connectioncache.spi.transport.OutboundConnectionCache;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutboundConnectionCacheBlockingImpl<C extends Closeable>
extends ConnectionCacheBlockingBase<C>
implements OutboundConnectionCache<C> {
    private final int maxParallelConnections;
    private Map<ContactInfo<C>, CacheEntry<C>> entryMap;
    private Map<C, ConnectionState<C>> connectionMap;

    @Override
    public int maxParallelConnections() {
        return this.maxParallelConnections;
    }

    @Override
    protected String thisClassName() {
        return "OutboundConnectionCacheBlockingImpl";
    }

    public OutboundConnectionCacheBlockingImpl(String cacheType, int highWaterMark, int numberToReclaim, int maxParallelConnections, Logger logger) {
        super(cacheType, highWaterMark, numberToReclaim, logger);
        if (maxParallelConnections < 1) {
            throw new IllegalArgumentException("maxParallelConnections must be > 0");
        }
        this.maxParallelConnections = maxParallelConnections;
        this.entryMap = new HashMap<ContactInfo<C>, CacheEntry<C>>();
        this.connectionMap = new HashMap<C, ConnectionState<C>>();
        if (this.debug()) {
            this.dprint(".constructor completed: " + cacheType);
        }
    }

    @Override
    public boolean canCreateNewConnection(ContactInfo<C> cinfo) {
        CacheEntry<C> entry = this.entryMap.get(cinfo);
        if (entry == null) {
            return true;
        }
        return this.internalCanCreateNewConnection(entry);
    }

    private boolean internalCanCreateNewConnection(CacheEntry<C> entry) {
        int totalConnectionsInEntry = entry.totalConnections();
        boolean createNewConnection = totalConnectionsInEntry == 0 || this.numberOfConnections() < (long)this.highWaterMark() && totalConnectionsInEntry < this.maxParallelConnections;
        return createNewConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry<C> getEntry(ContactInfo<C> cinfo) throws IOException {
        CacheEntry<C> cacheEntry;
        if (this.debug()) {
            this.dprint("->getEntry: " + cinfo);
        }
        try {
            CacheEntry<C> result = this.entryMap.get(cinfo);
            if (result == null) {
                if (this.debug()) {
                    this.dprint(".getEntry: " + cinfo + " creating new CacheEntry");
                }
                result = new CacheEntry();
                this.entryMap.put(cinfo, result);
            } else if (this.debug()) {
                this.dprint(".getEntry: " + cinfo + " re-using existing CacheEntry");
            }
            cacheEntry = result;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var5_5 = null;
                if (!this.debug()) break block8;
                this.dprint("<-getEntry: " + cinfo);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-getEntry: " + cinfo);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C tryNewConnection(CacheEntry<C> entry, ContactInfo<C> cinfo) throws IOException {
        C c;
        if (this.debug()) {
            this.dprint("->tryNewConnection: " + cinfo);
        }
        try {
            C conn = null;
            if (this.internalCanCreateNewConnection(entry)) {
                conn = cinfo.createConnection();
                if (this.debug()) {
                    this.dprint(".tryNewConnection: " + cinfo + " created connection " + conn);
                }
            }
            c = conn;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (!this.debug()) break block6;
                this.dprint("<-tryNewConnection: " + cinfo);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-tryNewConnection: " + cinfo);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementTotalIdle() {
        if (this.debug()) {
            this.dprint("->decrementTotalIdle: totalIdle = " + this.totalIdle);
        }
        try {
            if (this.totalIdle > 0) {
                --this.totalIdle;
            } else if (this.debug()) {
                this.dprint(".decrementTotalIdle: incorrect idle count: was already 0");
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.debug()) {
                this.dprint("<-decrementTotalIdle: totalIdle = " + this.totalIdle);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-decrementTotalIdle: totalIdle = " + this.totalIdle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementTotalBusy() {
        if (this.debug()) {
            this.dprint("->decrementTotalBusy: totalBusy = " + this.totalBusy);
        }
        try {
            if (this.totalBusy > 0) {
                --this.totalBusy;
            } else if (this.debug()) {
                this.dprint(".decrementTotalBusy: incorrect idle count: was already 0");
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.debug()) {
                this.dprint("<-decrementTotalBusy: totalBusy = " + this.totalBusy);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-decrementTotalBusy: totalBusy = " + this.totalBusy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeResultBusy(C result, ConnectionState<C> cs, CacheEntry<C> entry) {
        if (this.debug()) {
            this.dprint("->makeResultBusy: " + result + " was previously " + (Object)((Object)cs.csv));
        }
        try {
            switch (cs.csv) {
                case NEW: {
                    ++this.totalBusy;
                    break;
                }
                case IDLE: {
                    ++this.totalBusy;
                    this.decrementTotalIdle();
                    ConcurrentQueue.Handle handle = cs.reclaimableHandle;
                    if (handle == null) break;
                    if (!handle.remove() && this.debug()) {
                        this.dprint(".makeResultBusy: " + cs.cinfo + " result was not on reclaimable Q");
                    }
                    cs.reclaimableHandle = null;
                    break;
                }
            }
            entry.busyConnections.offer(result);
            cs.csv = ConnectionStateValue.BUSY;
            ++cs.busyCount;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.debug()) {
                this.dprint("<-makeResultBusy: " + result);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-makeResultBusy: " + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C tryIdleConnections(CacheEntry<C> entry) {
        Closeable closeable;
        if (this.debug()) {
            this.dprint("->tryIdleConnections");
        }
        try {
            closeable = (Closeable)entry.idleConnections.poll();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!this.debug()) break block4;
                this.dprint("<-tryIdleConnections");
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-tryIdleConnections");
        }
        return (C)closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C tryBusyConnections(CacheEntry<C> entry) {
        Closeable closeable;
        if (this.debug()) {
            this.dprint("->tryBusyConnections");
        }
        try {
            Closeable result = (Closeable)entry.busyConnections.poll();
            if (result == null) {
                throw new RuntimeException("INTERNAL ERROR: no busy connection available");
            }
            closeable = result;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!this.debug()) break block5;
                this.dprint("<-tryBusyConnections");
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-tryBusyConnections");
        }
        return (C)closeable;
    }

    @Override
    public synchronized C get(ContactInfo<C> cinfo) throws IOException {
        return this.get(cinfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConnectionState<C> getConnectionState(ContactInfo<C> cinfo, CacheEntry<C> entry, C conn) {
        ConnectionState<C> connectionState;
        if (this.debug()) {
            this.dprint("->getConnectionState: " + conn);
        }
        try {
            ConnectionState<C> cs = this.connectionMap.get(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".getConnectionState: " + conn + " creating new ConnectionState" + cs);
                }
                cs = new ConnectionState<C>(cinfo, entry, conn);
                this.connectionMap.put(conn, cs);
            } else if (this.debug()) {
                this.dprint(".getConnectionState: " + conn + " found ConnectionState" + cs);
            }
            connectionState = cs;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var7_7 = null;
                if (!this.debug()) break block8;
                this.dprint("<-getConnectionState: " + conn);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-getConnectionState: " + conn);
        }
        return connectionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized C get(ContactInfo<C> cinfo, ConnectionFinder<C> finder) throws IOException {
        C c;
        if (this.debug()) {
            this.dprint("->get: " + cinfo);
        }
        ConnectionState<Object> cs = null;
        try {
            CacheEntry<C> entry = this.getEntry(cinfo);
            C result = null;
            if (this.numberOfConnections() >= (long)this.highWaterMark()) {
                this.reclaim();
            }
            if (finder != null) {
                if (this.debug()) {
                    this.dprint(".get: " + cinfo + " Calling the finder to get a connection");
                }
                if ((result = (C)finder.find(cinfo, entry.idleConnectionsView, entry.busyConnectionsView)) != null) {
                    cs = this.getConnectionState(cinfo, entry, result);
                    if (cs.csv == ConnectionStateValue.BUSY) {
                        entry.busyConnections.remove(result);
                    } else if (cs.csv == ConnectionStateValue.IDLE) {
                        entry.idleConnections.remove(result);
                    }
                }
            }
            if (result == null) {
                result = this.tryIdleConnections(entry);
            }
            if (result == null) {
                result = this.tryNewConnection(entry, cinfo);
            }
            if (result == null) {
                result = this.tryBusyConnections(entry);
            }
            if (cs == null) {
                cs = this.getConnectionState(cinfo, entry, result);
            }
            this.makeResultBusy(result, cs, entry);
            c = result;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block15: {
                Object var8_8 = null;
                if (!this.debug()) break block15;
                this.dprint(".get " + cinfo + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
                this.dprint("<-get " + cinfo + " ConnectionState=" + cs);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint(".get " + cinfo + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
            this.dprint("<-get " + cinfo + " ConnectionState=" + cs);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reclaimOrClose(ConnectionState<C> cs, C conn) {
        boolean bl;
        if (this.debug()) {
            this.dprint("->reclaimOrClose: " + conn);
        }
        try {
            boolean connectionClosed;
            boolean isOverflow = this.numberOfConnections() > (long)this.highWaterMark();
            boolean bl2 = connectionClosed = isOverflow || !this.isConnected(conn);
            if (connectionClosed) {
                if (this.debug()) {
                    this.dprint(".reclaimOrClose: closing overflow connection " + conn);
                }
                this.close(conn);
            } else {
                if (this.debug()) {
                    this.dprint(".reclaimOrClose: queuing reclaimable connection " + conn);
                }
                cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
            }
            bl = connectionClosed;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var7_7 = null;
                if (!this.debug()) break block8;
                this.dprint("<-reclaimOrClose: " + conn);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-reclaimOrClose: " + conn);
        }
        return bl;
    }

    private boolean isConnected(C conn) {
        if (conn instanceof ConnectorHandler) {
            return ((ConnectorHandler)conn).isConnected();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void release(C conn, int numResponsesExpected) {
        ConnectionState<C> cs;
        block14: {
            block13: {
                block12: {
                    if (this.debug()) {
                        this.dprint("->release: " + conn + " expecting " + numResponsesExpected + " responses");
                    }
                    cs = this.connectionMap.get(conn);
                    try {
                        int numBusy;
                        if (cs == null) {
                            if (this.debug()) {
                                this.dprint(".release: " + conn + " was closed");
                            }
                            Object var10_4 = null;
                            break block12;
                        }
                        cs.expectedResponseCount += numResponsesExpected;
                        int numResp = cs.expectedResponseCount;
                        if ((numBusy = --cs.busyCount) < 0) {
                            if (this.debug()) {
                                this.dprint(".release: " + conn + " numBusy=" + numBusy + " is < 0: error");
                            }
                            cs.busyCount = 0;
                            break block13;
                        }
                        if (this.debug()) {
                            this.dprint(".release: " + numResp + " responses expected");
                            this.dprint(".release: " + numBusy + " busy count");
                        }
                        if (numBusy != 0) break block14;
                        CacheEntry entry = cs.entry;
                        boolean wasOnBusy = entry.busyConnections.remove(conn);
                        if (!wasOnBusy && this.debug()) {
                            this.dprint(".release: " + conn + " was NOT on busy queue, " + "but should have been");
                        }
                        boolean connectionClosed = false;
                        if (numResp == 0) {
                            connectionClosed = this.reclaimOrClose(cs, conn);
                        }
                        this.decrementTotalBusy();
                        if (!connectionClosed) {
                            if (this.debug()) {
                                this.dprint(".release: queuing idle connection " + conn);
                            }
                            ++this.totalIdle;
                            entry.idleConnections.offer(conn);
                            cs.csv = ConnectionStateValue.IDLE;
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var10_7 = null;
                        if (!this.debug()) throw throwable;
                        this.dprint(".release " + conn + " cs=" + cs + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
                        this.dprint("<-release" + conn);
                        throw throwable;
                    }
                }
                if (!this.debug()) return;
                this.dprint(".release " + conn + " cs=" + cs + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
                this.dprint("<-release" + conn);
                return;
            }
            Object var10_5 = null;
            if (!this.debug()) return;
            this.dprint(".release " + conn + " cs=" + cs + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
            this.dprint("<-release" + conn);
            return;
        }
        Object var10_6 = null;
        if (!this.debug()) return;
        this.dprint(".release " + conn + " cs=" + cs + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
        this.dprint("<-release" + conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void responseReceived(C conn) {
        block11: {
            block10: {
                block9: {
                    if (this.debug()) {
                        this.dprint("->responseReceived: " + conn);
                    }
                    try {
                        ConnectionState<C> cs = this.connectionMap.get(conn);
                        if (cs == null) {
                            if (this.debug()) {
                                this.dprint(".responseReceived: received response on closed connection " + conn);
                            }
                            Object var5_3 = null;
                            break block9;
                        }
                        int waitCount = --cs.expectedResponseCount;
                        if (this.debug()) {
                            this.dprint(".responseReceived: " + conn + " waitCount=" + waitCount);
                        }
                        if (waitCount < 0) {
                            if (this.debug()) {
                                this.dprint(".responseReceived: " + conn + " incorrect call: error");
                            }
                            cs.expectedResponseCount = 0;
                            break block10;
                        }
                        if (waitCount == 0 && cs.busyCount == 0) {
                            this.reclaimOrClose(cs, conn);
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (!this.debug()) throw throwable;
                        this.dprint("<-responseReceived: " + conn);
                        throw throwable;
                    }
                }
                if (!this.debug()) return;
                this.dprint("<-responseReceived: " + conn);
                return;
            }
            Object var5_4 = null;
            if (!this.debug()) return;
            this.dprint("<-responseReceived: " + conn);
            return;
        }
        Object var5_5 = null;
        if (!this.debug()) return;
        this.dprint("<-responseReceived: " + conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void close(C conn) {
        block17: {
            block15: {
                if (this.debug()) {
                    this.dprint("->close: " + conn);
                }
                try {
                    ConnectionState<C> cs;
                    block16: {
                        ConcurrentQueue.Handle rh;
                        cs = this.connectionMap.remove(conn);
                        if (cs == null) {
                            if (this.debug()) {
                                this.dprint(".close: " + conn + " was already closed");
                            }
                            Object var6_3 = null;
                            break block15;
                        }
                        if (this.debug()) {
                            this.dprint(".close: " + conn + "Connection state=" + cs);
                        }
                        if ((rh = cs.reclaimableHandle) != null) {
                            boolean result = rh.remove();
                            if (this.debug()) {
                                this.dprint(".close: " + conn + "reclaimableHandle .remove = " + result);
                            }
                        }
                        if (cs.entry.busyConnections.remove(conn)) {
                            if (this.debug()) {
                                this.dprint(".close: " + conn + " removed from busyConnections");
                            }
                            this.decrementTotalBusy();
                        }
                        if (cs.entry.idleConnections.remove(conn)) {
                            if (this.debug()) {
                                this.dprint(".close: " + conn + " removed from idleConnections");
                            }
                            this.decrementTotalIdle();
                        }
                        try {
                            conn.close();
                        }
                        catch (IOException exc) {
                            if (!this.debug()) break block16;
                            this.dprint(".close: " + conn + ": Caught IOException on close:" + exc);
                        }
                    }
                    if (cs.entry.totalConnections() == 0) {
                        ContactInfo cinfo = cs.cinfo;
                        this.entryMap.remove(cinfo);
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (!this.debug()) throw throwable;
                    this.dprintStatistics();
                    this.dprint("<-close: " + conn);
                    throw throwable;
                }
            }
            if (!this.debug()) return;
            this.dprintStatistics();
            this.dprint("<-close: " + conn);
            return;
        }
        Object var6_4 = null;
        if (!this.debug()) return;
        this.dprintStatistics();
        this.dprint("<-close: " + conn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheEntry<C extends Closeable> {
        final Queue<C> idleConnections = new LinkedBlockingQueue<C>();
        final Collection<C> idleConnectionsView = Collections.unmodifiableCollection(this.idleConnections);
        final Queue<C> busyConnections = new LinkedBlockingQueue<C>();
        final Collection<C> busyConnectionsView = Collections.unmodifiableCollection(this.busyConnections);

        public int totalConnections() {
            return this.idleConnections.size() + this.busyConnections.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConnectionState<C extends Closeable> {
        ConnectionStateValue csv = ConnectionStateValue.NEW;
        final ContactInfo<C> cinfo;
        final C connection;
        final CacheEntry<C> entry;
        int busyCount;
        int expectedResponseCount;
        ConcurrentQueue.Handle<C> reclaimableHandle;

        protected ConnectionState(ContactInfo<C> cinfo, CacheEntry<C> entry, C conn) {
            this.cinfo = cinfo;
            this.connection = conn;
            this.entry = entry;
            this.busyCount = 0;
            this.expectedResponseCount = 0;
            this.reclaimableHandle = null;
        }

        public String toString() {
            return "ConnectionState[cinfo=" + this.cinfo + " connection=" + this.connection + " busyCount=" + this.busyCount + " expectedResponseCount=" + this.expectedResponseCount + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionStateValue {
        NEW,
        BUSY,
        IDLE;

    }
}

