/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

public class ProtocolConsumerUIDIterator
implements Iterator {
    private int count = 0;
    private int count_read = 0;
    private DataInputStream dis = null;
    private BrokerAddress from = null;

    public ProtocolConsumerUIDIterator(byte[] byArray, int n, BrokerAddress brokerAddress) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.dis = new DataInputStream(byteArrayInputStream);
        this.count = n;
        this.count_read = 0;
        this.from = brokerAddress;
    }

    public ProtocolConsumerUIDIterator(DataInputStream dataInputStream, int n) {
        this.dis = dataInputStream;
        this.count = n;
        this.count_read = 0;
    }

    public boolean hasNext() {
        if (this.count_read < 0) {
            throw new IllegalStateException("ConsumerUIDIterator");
        }
        return this.count_read < this.count;
    }

    public Object next() throws RuntimeException {
        try {
            ConsumerUID consumerUID = ClusterConsumerInfo.readConsumerUID(this.dis);
            if (this.from != null) {
                consumerUID.setBrokerAddress(this.from);
            }
            ++this.count_read;
            return consumerUID;
        }
        catch (IOException iOException) {
            this.count_read = -1;
            throw new RuntimeException(iOException);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

