/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.config;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class FileConfigStore
implements ConfigStore {
    private static boolean DEBUG = false;
    private static final String cluster_prop = "imq.cluster.url";
    private String storedprop_loc = null;
    private final Logger logger = Globals.getLogger();
    static final String PROP_HEADER_STR = "#############################################################################\n#\n# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.\n#\n# Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved.\n#\n# The contents of this file are subject to the terms of either the GNU\n# General Public License Version 2 only (\"GPL\") or the Common Development\n# and Distribution License (\"CDDL\") (collectively, the \"License\").  You may\n# not use this file except in compliance with the License.  You can obtain\n# a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html\n# or mq/legal/LICENSE.txt.  See the License for the specific language\n# governing permissions and limitations under the License.\n#\n# When distributing the software, include this License Header Notice in each\n# file and include the License file at mq/legal/LICENSE.txt.  Sun designates\n# this particular file as subject to the \"Classpath\" exception as provided by\n# Sun in the GPL Version 2 section of the License file that accompanied this\n# code.  If applicable, add the following below the License Header, with the\n# fields enclosed by brackets [] replaced by your own identifying information:\n# \"Portions Copyrighted [year] [name of copyright owner]\"\n#\n# Contributor(s):\n#\n# If you wish your version of this file to be governed by only the CDDL or\n# only the GPL Version 2, indicate your decision by adding \"[Contributor]\n# elects to include this software in this distribution under the [CDDL or GPL\n# Version 2] license.\"  If you don't indicate a single choice of license, a\n# recipient has the option to distribute your version of this file under\n# either the CDDL, the GPL Version 2 or  to extend the choice of license to\n# its licensees as provided above.  However, if you add GPL Version 2 code\n# and therefore, elected the GPL Version 2 license, then the option applies\n# only if the new code is made subject to such option by the copyright holder.\n#\n#\n# @(#)FileConfigStore.java\t1.76 09/05/07\n#\n#############################################################################\n#\n# File: config.properties \n#\n#\n# This file contains the instance specific properties for\n# a running broker.\n#\n# Only some of the properties listed in the default.properties\n# file should be changed (some of the properties are for \n# field support or future features).\n#\n# WARNING: \n#\n#   Use care when editing this file by hand.\n#\n#   This file is automatically update.  Changes made while\n#   the broker is running MAY be lost. Any comments added to\n#   this file may be lost.\n#\n#   Only the properties listed below can be modified in a \n#   supported configuration.\n#\n#   Please make any property changes at the bottom of this file.\n#\n###################################################################\n#\n#  Supported properties are:\n#\n# Connection Services Settings\n# ----------------------------\n#\n#    General Connection Services\n#\n#            imq.service.activelist\n#            imq.shared.connectionMonitor_limit\n#            imq.hostname\n#\n#    Connection Service Specific Settings\n#\n#            imq.<service_name>.threadpool_model\n#            imq.<service_name>.<protocol_name>.port\n#            imq.<service_name>.<protocol_name>.hostname\n#            imq.<service_name>.min_threads\n#            imq.<service_name>.max_threads\n#\n#       configuration for the keystore used by the ssl service\n#\n#            imq.keystore.file.dirpath\n#            imq.keystore.file.name\n#            imq.passfile.enabled\n#            imq.passfile.dirpath\n#            imq.passfile.name\n#            \n#       http specific parameters\n#\n#            imq.httpjms.http.servletHost\n#            imq.httpjms.http.servletPort\n#            imq.httpjms.http.pullPeriod\n#            imq.httpjms.http.connectionTimeout\n#            \n#       https specific parameters\n#\n#            imq.httpsjms.https.servletHost\n#            imq.httpsjms.https.servletPort\n#            imq.httpsjms.https.pullPeriod\n#            imq.httpsjms.https.connectionTimeout\n#\n#    General JMX parameters\n#\n#            imq.jmx.hostname\n#\n#    General JMX Connector Services\n#\n#            imq.jmx.connector.activelist\n#\n#    JMX Connector specific settings\n#\n#            imq.jmx.connector.<connector server name>.urlpath\n#            imq.jmx.connector.<connector server name>.useSSL\n#            imq.jmx.connector.<connector server name>.brokerHostTrusted\n#\n#    RMI Registry (used by RMI JMX Connectors)\n#\n#            imq.jmx.rmiregistry.use\n#            imq.jmx.rmiregistry.start\n#            imq.jmx.rmiregistry.port\n#\n#    Portmapper Settings\n#\n#            imq.portmapper.hostname\n#            imq.portmapper.port\n#            imq.portmapper.backlog\n#\n# Message Router Settings\n# -----------------------\n#\n#    Memory reclamation period\n#\n#            imq.message.expiration.interval\n#\n#    Message limits: broker\n#\n#            imq.system.max_count\n#            imq.system.max_size\n#\n#    Individual message limits\n#\n#            imq.message.max_size\n#\n# Persistence Settings\n# --------------------\n#\n#    Type of data store\n#\n#            imq.persist.store\n#\n#    File-based store\n#\n#            imq.persist.file.message.max_record_size\n#            imq.persist.file.destination.message.filepool.limit\n#            imq.persist.file.message.filepool.cleanratio\n#            imq.persist.file.message.cleanup\n#            imq.persist.file.sync.enabled\n#\n#    JDBC-based store\n#\n#            imq.brokerid\n#            imq.persist.jdbc.dbVendor\n#            imq.persist.jdbc.<dbVendor>.driver\n#            imq.persist.jdbc.<dbVendor>.opendburl\n#            imq.persist.jdbc.<dbVendor>.createdburl\n#            imq.persist.jdbc.<dbVendor>.closedburl\n#            imq.persist.jdbc.<dbVendor>.user\n#            imq.persist.jdbc.<dbVendor>.needpassword\n#            imq.persist.jdbc.<dbVendor>.table.MQVER41\n#            imq.persist.jdbc.<dbVendor>.table.MQCREC41\n#            imq.persist.jdbc.<dbVendor>.table.MQBKR41\n#            imq.persist.jdbc.<dbVendor>.table.MQSES41\n#            imq.persist.jdbc.<dbVendor>.table.MQDST41\n#            imq.persist.jdbc.<dbVendor>.table.MQCON41\n#            imq.persist.jdbc.<dbVendor>.table.MQCONSTATE41\n#            imq.persist.jdbc.<dbVendor>.table.MQMSG41\n#            imq.persist.jdbc.<dbVendor>.table.MQPROP41\n#            imq.persist.jdbc.<dbVendor>.table.MQTXN41\n#\n#\n# Memory Management Settings\n# --------------------------\n#\n#            imq.<resource_state>.threshold\n#            imq.<resource_state>.count\n#\n#\n# Security Settings\n# -----------------\n#\n#    Authentication\n#\n#            imq.authentication.type\n#            imq.<service_name>.authentication.type\n#            imq.authentication.basic.user_repository\n#            imq.authentication.client.response.timeout\n#\n#    User Repository\n#\n#            imq.user_repository.ldap.server\n#            imq.user_repository.ldap.principal\n#            imq.user_repository.ldap.base\n#            imq.user_repository.ldap.uidattr\n#            imq.user_repository.ldap.usrformat\n#            imq.user_repository.ldap.usrfilter\n#            imq.user_repository.ldap.grpsearch\n#            imq.user_repository.ldap.grpbase\n#            imq.user_repository.ldap.gidattr\n#            imq.user_repository.ldap.memattr\n#            imq.user_repository.ldap.grpfilter\n#            imq.user_repository.ldap.ssl.enabled\n#            imq.user_repository.ldap.timeout\n#\n#            imq.user_repository.jaas.name\n#            imq.user_repository.jaas.userPrincipalClass\n#            imq.user_repository.jaas.groupPrincipalClass\n#\n#    Access Control\n#            imq.accesscontrol.enabled\n#            imq.<service_name>.accesscontrol.enabled\n#            imq.accesscontrol.file.filename\n#            imq.<service_name>.accesscontrol.file.filename\n#            imq.accesscontrol.file.url\n#            imq.<service_name>.accesscontrol.file.url\n#\n# Log Settings\n# ------------\n#\n#    Log Level\n#            imq.log.level\n#            imq.log.timezone\n#\n#    Output Channels\n#        File:\n#            imq.log.file.rolloverbytes\n#            imq.log.file.rolloversecs\n#            imq.log.file.dirpath\n#            imq.log.file.filename\n#            imq.log.file.output\n#        Console:\n#            imq.log.console.stream\n#            imq.log.console.output\n#        Solaris syslog:\n#            imq.log.syslog.facility\n#            imq.log.syslog.logpid\n#            imq.log.syslog.logconsole\n#            imq.log.syslog.identity\n#            imq.log.syslog.output\n#\n#    Metrics settings\n#            imq.metrics.enabled\n#            imq.metrics.interval\n#            imq.metrics.topic.enabled\n#            imq.metrics.topic.interval\n#            imq.metrics.topic.persist\n#            imq.metrics.topic.timetolive\n#\n# Destination Management Settings\n# -------------------------------\n#\n#            imq.autocreate.topic\n#            imq.autocreate.topic.consumerFlowLimit\n#            imq.autocreate.queue\n#            imq.autocreate.reaptime\n#            imq.autocreate.queue.consumerFlowLimit\n#            imq.autocreate.queue.maxNumActiveConsumers\n#            imq.autocreate.queue.maxNumBackupConsumers\n#            imq.autocreate.queue.localDeliveryPreferred\n#            imq.autocreate.destination.isLocalOnly\n#            imq.autocreate.destination.maxNumMsgs\n#            imq.autocreate.destination.maxTotalMsgBytes\n#            imq.autocreate.destination.maxNumProducers\n#            imq.autocreate.destination.maxBytesPerMsg\n#            imq.autocreate.destination.limitBehavior\n#            imq.autocreate.destination.useDMQ\n#\n#            imq.destination.DMQ.truncateBody\n#            imq.destination.logDeadMsgs\n#\n#\n# Transaction Settings\n# --------------------\n#\n#            imq.transaction.autorollback\n#            imq.transaction.detachedTimeout\n#            imq.transaction.producer.maxNumMsgs\n#            imq.transaction.consumer.maxNumMsgs\n#\n#\n# Cluster Management Settings\n# ---------------------------\n#\n#    Cluster file location\n#\n#            imq.cluster.url\n#\n#    HA Cluster:\n#\n#        HA Cluster per broker settings\n#\n#            imq.brokerid\n#\n#        HA Cluster Configuration Setting \n#\n#        NOTE: Under normal circumstances, setting for these\n#              properties should be made in the cluster.url file\n#              where then can be accessed by all brokers in the\n#              cluster, not in this file\n#\n#            imq.cluster.ha\n#            imq.cluster.clusterid\n#            imq.persist.store\n#            imq.persist.jdbc.dbVendor\n#\n#    Non-HA Cluster:\n#\n#        Cluster per broker settings\n#\n#            imq.cluster.hostname\n#            imq.cluster.port\n#\n#        Cluster Configuration Setting \n#\n#        NOTE: Under normal circumstances, setting for these\n#              properties should be made in the cluster.url file\n#              where then can be accessed by all brokers in the\n#              cluster, not in this file\n#\n#            imq.cluster.brokerlist\n#            imq.cluster.masterbroker\n#            imq.cluster.transport\n#\n#\n# Miscellaneous Settings\n# ----------------------\n#\n#            imq.ping.interval\n#\n#\n# Bridge Service Manager Settings\n# -------------------------------\n#\n#            imq.bridge.enabled\n#            imq.bridge.activelist\n#            imq.bridge.admin.user\n#\n#\n# Please see the documentation for specifics on how to set these\n# properties.\n#\n##############################################################\n#\n# To plug in a Sun HADB database, either uncomment or\n# set 'dbVendor' property to 'hadb', and edit the \n# values according to your database configuration.\n# Then, finish the steps outlined in the Administrative Guide\n# to plug in and set up the database store.\n#\n##############################################################\n# Beginning of properties to plug in a Sun HADB database\n#\n# Replace 'alphanumeric id' with your broker identifier\n#imq.brokerid=<alphanumeric id>\n#imq.persist.store=jdbc\n#imq.persist.jdbc.dbVendor=hadb\n# Replace 'server list' with your comma-separated list of servers.\n#imq.persist.jdbc.hadb.property.serverList=<server list>\n# Replace username.\n#imq.persist.jdbc.hadb.user=<username>\n#imq.persist.jdbc.hadb.needpassword=[true|false]\n#\n# End of properties to plug in a Sun HADB database\n##############################################################\n#\n# To plug in a MySQL database, either uncomment or\n# set 'dbVendor' property to 'mysql', and edit the \n# values according to your database configuration.\n# Then, finish the steps outlined in the Administrative Guide\n# to plug in and set up the database store.\n#\n##############################################################\n# Beginning of properties to plug in a MySQL database\n#\n# Replace 'alphanumeric id' with your broker identifier\n#imq.brokerid=<alphanumeric id>\n#imq.persist.store=jdbc\n#imq.persist.jdbc.dbVendor=mysql\n# Replace hostname, port and database in imq.persist.jdbc.mysql.property.url.\n#imq.persist.jdbc.mysql.property.url=jdbc:mysql://<hostname>:<port>/<database>\n# Replace username.\n#imq.persist.jdbc.mysql.user=<username>\n#imq.persist.jdbc.mysql.needpassword=[true|false]\n#\n# End of properties to plug in a MySQL database\n##############################################################\n#\n# To plug in a DB2 database, either uncomment or\n# set 'dbVendor' property to 'db2', and edit the \n# values according to your database configuration.\n# Then, finish the steps outlined in the Administrative Guide\n# to plug in and set up the database store.\n#\n##############################################################\n# Beginning of properties to plug in a DB2 database\n#\n# Replace 'alphanumeric id' with your broker identifier\n#imq.brokerid=<alphanumeric id>\n#imq.persist.store=jdbc\n#imq.persist.jdbc.dbVendor=db2\n# Replace hostname, port and database in imq.persist.jdbc.db2.opendburl.\n#imq.persist.jdbc.db2.opendburl=jdbc:db2://<hostname>:<port>/<database>\n# Replace username.\n#imq.persist.jdbc.db2.user=<username>\n#imq.persist.jdbc.db2.needpassword=[true|false]\n#\n# End of properties to plug in a DB2 database\n##############################################################\n#\n# To plug in an Oracle database, either uncomment or\n# set 'dbVendor' property to 'oracle', and edit the \n# values according to your database configuration.\n# Then, finish the steps outlined in the Administrative Guide\n# to plug in and set up the database store.\n#\n##############################################################\n# Beginning of properties to plug in an Oracle database\n#\n# Replace 'alphanumeric id' with your broker identifier\n#imq.brokerid=<alphanumeric id>\n#imq.persist.store=jdbc\n#imq.persist.jdbc.dbVendor=oracle\n# Replace hostname, port and sid in imq.persist.jdbc.oracle.property.url.\n#imq.persist.jdbc.oracle.property.url=jdbc:oracle:thin:@<hostname>:<port>:<sid>\n# Replace username.\n#imq.persist.jdbc.oracle.user=<username>\n#imq.persist.jdbc.oracle.needpassword=[true|false]\n#\n# End of properties to plug in an Oracle database\n##############################################################\n#\n# To plug in a Java DB (Derby) embedded database, either uncomment or\n# set 'dbVendor' property to 'derby', and edit the \n# values according to your database configuration.\n# Then, finish the steps outlined in the Administrative Guide\n# to plug in and set up the database store.\n#\n##############################################################\n# Beginning of properties to plug in a Java DB (Derby) embedded database\n#\n# Replace 'alphanumeric id' with your broker identifier\n#imq.brokerid=<alphanumeric id>\n#imq.persist.store=jdbc\n#imq.persist.jdbc.dbVendor=derby\n#imq.persist.jdbc.derby.createdburl=jdbc:derby:${imq.instanceshome}${/}${imq.instancename}${/}dbstore${/}imqdb;create=true\n#imq.persist.jdbc.derby.opendburl=jdbc:derby:${imq.instanceshome}${/}${imq.instancename}${/}dbstore${/}imqdb\n#imq.persist.jdbc.derby.closedburl=jdbc:derby:;shutdown=true\n# Replace username.\n#imq.persist.jdbc.derby.user=<username>\n#imq.persist.jdbc.derby.needpassword=[true|false]\n#\n# End of properties to plug in a Java DB (Derby) embedded database\n##############################################################\n#\n# To plug in a Java DB (Derby) Network Server, either uncomment or\n# set 'dbVendor' property to 'derby', and edit the \n# values according to your database configuration.\n# Then, finish the steps outlined in the Administrative Guide\n# to plug in and set up the database store.\n#\n##############################################################\n# Beginning of properties to plug in a Java DB (Derby) Network Server\n#\n# Replace 'alphanumeric id' with your broker identifier\n#imq.brokerid=<alphanumeric id>\n#imq.persist.store=jdbc\n#imq.persist.jdbc.dbVendor=derby\n#imq.persist.jdbc.derby.createdburl=\n#imq.persist.jdbc.derby.opendburl=jdbc:derby://<hostname>:<port>/${imq.instanceshome}${/}${imq.instancename}${/}dbstore${/}imqdb\n#imq.persist.jdbc.derby.closedburl=\n# Replace username.\n#imq.persist.jdbc.derby.user=<username>\n#imq.persist.jdbc.derby.needpassword=[true|false]\n#imq.persist.jdbc.derby.driver=org.apache.derby.jdbc.ClientDriver\n#\n# End of properties to plug in a Java DB (Derby) Network Server\n##############################################################\n\n\n##############################################################\n#\n# An example of using Sun Java System Directory Server 5.2 as\n# the user repository\n#\n##############################################################\n#\n#imq.authentication.type=basic\n#imq.authentication.basic.user_repository=ldap\n#imq.user_repository.ldap.server=host:port\n#imq.user_repository.ldap.principal=\n#imq.user_repository.ldap.base=ou=People, dc=sun,dc=com\n#imq.user_repository.ldap.uidattr=uid\n#imq.user_repository.ldap.usrfilter=\n#imq.user_repository.ldap.grpsearch=false\n#imq.user_repository.ldap.grpbase=ou=Groups, dc=sun,dc=com\n#imq.user_repository.ldap.gidattr=cn\n#imq.user_repository.ldap.memattr=uniquemember\n#imq.user_repository.ldap.grpfilter=\n#imq.user_repository.ldap.ssl.enabled=false\n#imq.user_repository.ldap.timeout=180\n#\n##############################################################\n#\n#\n#Last Update:";

    public Properties loadStoredProps(Properties properties, String string) throws BrokerException {
        Object[] objectArray;
        Object object;
        Properties properties2;
        block8: {
            String string2 = Globals.JMQ_INSTANCES_HOME + File.separator + string + File.separator + "props" + File.separator;
            this.storedprop_loc = string2 + "config.properties";
            properties2 = new Properties();
            try {
                object = new FileInputStream(this.storedprop_loc);
                objectArray = new BufferedInputStream((InputStream)object);
                properties2.load((InputStream)objectArray);
                ((FileInputStream)object).close();
                objectArray.close();
            }
            catch (IOException iOException) {
                objectArray = new File(this.storedprop_loc);
                if (objectArray.exists()) {
                    this.logger.logStack(16, "B2001", (Object)string, (Object)this.storedprop_loc, (Throwable)iOException);
                } else {
                    this.logger.log(8, "B1002", (Object)string);
                }
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (objectArray.exists()) break block8;
                try {
                    properties2.setProperty("imq.instanceconfig.version", "300");
                    this.storeProperties(properties2);
                }
                catch (IOException iOException2) {
                    this.logger.logStack(16, "B4176", (Object)objectArray.toString(), (Throwable)iOException);
                }
            }
        }
        object = properties2.getProperty("imq.instanceconfig.version");
        if (object != null && !((String)object).equals("") && !((String)object).equals("300")) {
            objectArray = new Object[]{this.storedprop_loc, "300", object};
            this.logger.log(16, "B2067", objectArray);
        }
        return properties2;
    }

    public Properties loadClusterProps(Properties properties, Properties properties2, Properties properties3) throws BrokerException {
        String string = properties2.getProperty(cluster_prop, properties3.getProperty(cluster_prop, properties.getProperty(cluster_prop)));
        return this.loadClusterProps(string);
    }

    private Properties loadClusterProps(String string) {
        if (string == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            this.logger.log(16, "B2001", (Object)"cluster", (Object)string, (Throwable)iOException);
        }
        return properties;
    }

    public void storeProperties(Properties properties) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.storedprop_loc);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            properties.store(bufferedOutputStream, PROP_HEADER_STR);
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B3003", (Object)this.storedprop_loc, (Throwable)iOException);
            throw iOException;
        }
    }

    public Properties reloadProps(String string, String[] stringArray) throws BrokerException {
        Properties properties = this.loadStoredProps(null, string);
        if (properties == null) {
            return null;
        }
        Properties properties2 = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = properties.getProperty(stringArray[i]);
            if (string2 == null) continue;
            properties2.setProperty(stringArray[i], string2);
        }
        properties = null;
        return properties2;
    }

    public void clearProps(String string) {
        String string2 = Globals.JMQ_INSTANCES_HOME + File.separator + string + File.separator + "props" + File.separator;
        this.storedprop_loc = string2 + "config.properties";
        File file = new File(this.storedprop_loc);
        try {
            file.delete();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B4176", (Object)file.toString(), (Throwable)exception);
        }
    }
}

