/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import org.glassfish.webservices.WebServiceContractImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceResolverImpl<T>
extends InstanceResolver<T> {
    private InstanceResolver<T> resolver;
    private T instance;
    private Class<T> classtobeResolved;
    private WSWebServiceContext wsc;
    private WSEndpoint endpoint;
    private final InjectionManager injManager = WebServiceContractImpl.getInstance().getHabitat().getByContract(InjectionManager.class);

    public InstanceResolverImpl(@NotNull Class<T> clasz) {
        this.classtobeResolved = clasz;
    }

    @NotNull
    public T resolve(Packet request) {
        try {
            this.instance = this.injManager.createManagedObject(this.classtobeResolved);
        }
        catch (InjectionException e) {
            throw new WebServiceException((Throwable)e);
        }
        this.resolver = InstanceResolver.createSingleton(this.instance);
        this.getResourceInjector(this.endpoint).inject(this.wsc, this.instance);
        return (T)this.resolver.resolve(request);
    }

    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        this.wsc = wsc;
        this.endpoint = endpoint;
    }

    public void dispose() {
        try {
            this.injManager.destroyManagedObject(this.classtobeResolved);
        }
        catch (InjectionException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private ResourceInjector getResourceInjector(WSEndpoint endpoint) {
        ResourceInjector ri = (ResourceInjector)endpoint.getContainer().getSPI(ResourceInjector.class);
        if (ri == null) {
            ri = ResourceInjector.STANDALONE;
        }
        return ri;
    }

    @NotNull
    public Invoker createInvoker() {
        return new Invoker(){

            public void start(@NotNull WSWebServiceContext wsc, @NotNull WSEndpoint endpoint) {
                InstanceResolverImpl.this.start(wsc, endpoint);
            }

            public void dispose() {
                InstanceResolverImpl.this.dispose();
            }

            public Object invoke(Packet p, Method m, Object ... args) throws InvocationTargetException, IllegalAccessException {
                return m.invoke(InstanceResolverImpl.this.resolve(p), args);
            }

            public <T> T invokeProvider(@NotNull Packet p, T arg) {
                return (T)((Provider)InstanceResolverImpl.this.resolve(p)).invoke(arg);
            }

            public String toString() {
                return "Default Invoker over " + ((Object)((Object)InstanceResolverImpl.this)).toString();
            }
        };
    }
}

