/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class ColumnMetadata
extends ORMetadata {
    private Boolean m_unique;
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;
    private DatabaseField m_databaseField;
    private Integer m_scale;
    private Integer m_length;
    private Integer m_precision;
    private String m_attributeName;
    private String m_name;
    private String m_table;
    private String m_columnDefinition;

    public ColumnMetadata() {
        super("<column>");
    }

    public ColumnMetadata(MetadataAnnotation column, MetadataAccessibleObject accessibleObject) {
        this(column, accessibleObject, "");
    }

    public ColumnMetadata(MetadataAnnotation column, MetadataAccessibleObject accessibleObject, String attributeName) {
        super(column, accessibleObject);
        this.m_attributeName = attributeName;
        if (column != null) {
            this.setUnique((Boolean)column.getAttribute("unique"));
            this.setNullable((Boolean)column.getAttribute("nullable"));
            this.setUpdatable((Boolean)column.getAttribute("updatable"));
            this.setInsertable((Boolean)column.getAttribute("insertable"));
            this.setScale((Integer)column.getAttribute("scale"));
            this.setLength((Integer)column.getAttribute("length"));
            this.setPrecision((Integer)column.getAttribute("precision"));
            this.setName((String)column.getAttributeString("name"));
            this.setTable((String)column.getAttributeString("table"));
            this.setColumnDefinition((String)column.getAttributeString("columnDefinition"));
        }
    }

    public ColumnMetadata(MetadataAccessibleObject accessibleObject, String attributeName) {
        this(null, accessibleObject, attributeName);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ColumnMetadata) {
            ColumnMetadata column = (ColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_unique, column.getUnique())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nullable, column.getNullable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_updatable, column.getUpdatable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_insertable, column.getInsertable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_scale, column.getScale())) {
                return false;
            }
            if (!this.valuesMatch(this.m_length, column.getLength())) {
                return false;
            }
            if (!this.valuesMatch(this.m_precision, column.getPrecision())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, column.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_table, column.getTable())) {
                return false;
            }
            return this.valuesMatch(this.m_columnDefinition, column.getColumnDefinition());
        }
        return false;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public DatabaseField getDatabaseField() {
        if (this.m_databaseField == null) {
            this.m_databaseField = new DatabaseField();
            this.m_databaseField.setUnique(this.m_unique == null ? false : this.m_unique);
            this.m_databaseField.setNullable(this.m_nullable == null ? true : this.m_nullable);
            this.m_databaseField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
            this.m_databaseField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
            this.m_databaseField.setScale(this.m_scale == null ? 0 : this.m_scale);
            this.m_databaseField.setLength(this.m_length == null ? 255 : this.m_length);
            this.m_databaseField.setPrecision(this.m_precision == null ? 0 : this.m_precision);
            this.m_databaseField.setName(this.m_name == null ? "" : this.m_name);
            this.m_databaseField.setTableName(this.m_table == null ? "" : this.m_table);
            this.m_databaseField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        }
        return this.m_databaseField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public String getUpperCaseAttributeName() {
        return this.m_attributeName.toUpperCase();
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_attributeName = accessibleObject.getAttributeName();
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setDatabaseField(DatabaseField databaseField) {
        this.m_databaseField = databaseField;
    }

    public void setInsertable(Boolean insertable) {
        this.m_insertable = insertable;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNullable(Boolean nullable) {
        this.m_nullable = nullable;
    }

    public void setPrecision(Integer precision) {
        this.m_precision = precision;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }

    public void setTable(String table) {
        this.m_table = table;
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }

    public void setUpdatable(Boolean updatable) {
        this.m_updatable = updatable;
    }
}

