/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.util.Iterator;
import java.util.TreeSet;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service(name="list-contracts", metadata="mode=debug")
public class ListContracts
implements AdminCommand {
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        StringBuilder sb = new StringBuilder();
        this.dumpContracts(sb);
        String msg = sb.toString();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (report instanceof PropsFileActionReporter) {
            msg = ManifestUtils.encode((String)msg);
        }
        report.setMessage(msg);
    }

    private void dumpContracts(StringBuilder sb) {
        sb.append("\n*********** Sorted List of all Registered Contracts in the Habitat **************\n");
        Iterator it = this.habitat.getAllContracts();
        if (it == null) {
            return;
        }
        TreeSet contracts = new TreeSet();
        while (it != null && it.hasNext()) {
            contracts.add(it.next());
        }
        it = contracts.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Contract-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }
}

