/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.VirtualServerInfo;
import com.sun.enterprise.deployment.util.WebServerInfo;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.SDDocumentSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPBinding;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.webservices.HandlerResolverImpl;
import org.glassfish.webservices.Import;
import org.glassfish.webservices.PortInfoImpl;
import org.glassfish.webservices.WebServiceContractImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsUtil {
    public static final String CLIENT_TRANSPORT_LOG_PROPERTY = "com.sun.enterprise.webservice.client.transport.log";
    public static final String ENDPOINT_ADDRESS_PARAM_NAME = "endpointAddressParam";
    public final String WSDL_IMPORT_NAMESPACE_PARAM_NAME = "wsdlImportNamespaceParam";
    public static final String WSDL_IMPORT_LOCATION_PARAM_NAME = "wsdlImportLocationParam";
    public static final String WSDL_INCLUDE_LOCATION_PARAM_NAME = "wsdlIncludeLocationParam";
    public final String SCHEMA_IMPORT_NAMESPACE_PARAM_NAME = "schemaImportNamespaceParam";
    public static final String SCHEMA_IMPORT_LOCATION_PARAM_NAME = "schemaImportLocationParam";
    public static final String SCHEMA_INCLUDE_LOCATION_PARAM_NAME = "schemaIncludeLocationParam";
    private static Logger logger = LogDomains.getLogger(WsUtil.class, (String)"javax.enterprise.webservices");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRelativeImports(URL wsdlFileUrl, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        InputStream is = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
        }
        catch (SAXParseException spe) {
            logger.log(Level.SEVERE, "\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (Exception sxe) {
            logger.log(Level.SEVERE, "Error parsing WSDL" + sxe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException io) {}
        }
    }

    private void addImportsAndIncludes(NodeList list, Collection result, String namespace, String location) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation != null && givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    private void procesSchemaImports(Document document, Collection schemaImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection wsdlImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection schemaIncludeCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection wsdlIncludesCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, File finalWsdlFile) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(finalWsdlFile));
        this.generateFinalWsdl(wsdlFileUrl, webService, wsi, outputStream);
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, OutputStream outputStream) throws Exception {
        HashSet wsdlRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet schemaIncludes = new HashSet();
        if (webService.hasUrlPublishing()) {
            this.parseRelativeImports(wsdlFileUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        }
        Collection endpoints = webService.getEndpoints();
        ArrayList endpointsCopy = new ArrayList();
        endpointsCopy.addAll(endpoints);
        BundleDescriptor bundle = webService.getBundleDescriptor();
        WebServicesDescriptor wsd = bundle.getWebServices();
        Collection webServices = wsd.getWebServices();
        if (webServices.size() > 1) {
            for (WebService aWS : webServices) {
                if (webService.getName().equals(aWS.getName())) continue;
                if (webService.getWsdlFileUri() != null && aWS.getWsdlFileUri() != null && webService.getWsdlFileUri().equals(aWS.getWsdlFileUri())) {
                    endpointsCopy.addAll(aWS.getEndpoints());
                    continue;
                }
                if (webService.getWsdlFileUrl() == null || aWS.getWsdlFileUrl() == null || !webService.getWsdlFileUrl().toString().equals(aWS.getWsdlFileUrl().toString())) continue;
                endpointsCopy.addAll(aWS.getEndpoints());
            }
        }
        BufferedInputStream wsdlInputStream = new BufferedInputStream(wsdlFileUrl.openStream());
        StreamSource XsltWsdlDocument = new StreamSource(wsdlInputStream);
        Templates templates = this.createTemplatesFor(endpointsCopy, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        Transformer transformer = templates.newTransformer();
        WebServiceEndpoint endpointForImport = webService.pickEndpointForRelativeImports();
        URL root = wsi.getWebServerRootURL(endpointForImport.isSecure());
        URL finalWsdlUrl = endpointForImport.composeFinalWsdlUrl(root);
        int wsdlImportNum = 0;
        for (Import next : wsdlRelativeImports) {
            transformer.setParameter("wsdlImportNamespaceParam" + wsdlImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum, relativeUrl);
            ++wsdlImportNum;
        }
        int schemaImportNum = 0;
        for (Import next : schemaRelativeImports) {
            transformer.setParameter("schemaImportNamespaceParam" + schemaImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum, relativeUrl);
            ++schemaImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import next : wsdlIncludes) {
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum, relativeUrl);
            ++wsdlIncludeNum;
        }
        int schemaIncludeNum = 0;
        for (Import next : schemaIncludes) {
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_INCLUDE_LOCATION_PARAM_NAME + schemaIncludeNum, relativeUrl);
            ++schemaIncludeNum;
        }
        int endpointNum = 0;
        for (WebServiceEndpoint next : endpointsCopy) {
            URL rootURL = wsi.getWebServerRootURL(next.isSecure());
            URL actualAddress = next.composeEndpointAddress(rootURL);
            transformer.setParameter(ENDPOINT_ADDRESS_PARAM_NAME + endpointNum, actualAddress.toExternalForm());
            String endpointType = next.implementedByEjbComponent() ? "EJB" : "Servlet";
            logger.log(Level.INFO, "enterprise.deployment.endpoint.registration", new Object[]{endpointType, next.getEndpointName(), actualAddress});
            ++endpointNum;
        }
        transformer.transform(XsltWsdlDocument, new StreamResult(outputStream));
        ((InputStream)wsdlInputStream).close();
        outputStream.close();
    }

    public URL privilegedGetServiceRefWsdl(ServiceReferenceDescriptor desc) throws Exception {
        URL wsdlFileURL;
        try {
            final ServiceReferenceDescriptor serviceRef = desc;
            wsdlFileURL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    URL retVal;
                    if (serviceRef.hasWsdlOverride()) {
                        retVal = serviceRef.getWsdlOverride();
                    } else if (serviceRef.getWsdlFileUrl() != null) {
                        retVal = serviceRef.getWsdlFileUrl();
                    } else if (serviceRef.getWsdlFileUri().startsWith("http")) {
                        retVal = new URL(serviceRef.getWsdlFileUri());
                    } else if (serviceRef.getWsdlFileUri().startsWith("WEB-INF") || serviceRef.getWsdlFileUri().startsWith("META-INF")) {
                        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                        ServerEnvironment se = (ServerEnvironment)wscImpl.getHabitat().getByContract(ServerEnvironment.class);
                        File appFile = new File(se.getApplicationRepositoryPath(), serviceRef.getBundleDescriptor().getApplication().getAppName());
                        retVal = new File(appFile, serviceRef.getWsdlFileUri()).toURL();
                    } else {
                        retVal = new File(serviceRef.getWsdlFileUri()).toURL();
                    }
                    return retVal;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return wsdlFileURL;
    }

    private Templates createTemplatesFor(Collection endpoints, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        String importLocationParam;
        String importLocationParam2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        writer.write("<xsl:transform version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:soap12=\"http://schemas.xmlsoap.org/wsdl/soap12/\">\n");
        int wsdlImportNum = 0;
        for (Import next : wsdlRelativeImports) {
            String importNamespaceParam = "wsdlImportNamespaceParam" + wsdlImportNum;
            importLocationParam2 = WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:import[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:import></xsl:template>");
            ++wsdlImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import next : wsdlIncludes) {
            importLocationParam2 = WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum;
            writer.write("<xsl:param name=\"" + importLocationParam2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:include[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:include>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:include></xsl:template>");
            ++wsdlIncludeNum;
        }
        int schemaImportNum = 0;
        for (Import next : schemaRelativeImports) {
            String importNamespaceParam = "schemaImportNamespaceParam" + schemaImportNum;
            importLocationParam = SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:import[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:import></xsl:template>");
            ++schemaImportNum;
        }
        int schemaIncludeNum = 0;
        for (Import next : schemaIncludes) {
            importLocationParam = SCHEMA_INCLUDE_LOCATION_PARAM_NAME + schemaIncludeNum;
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:include[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:include>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:include></xsl:template>");
            ++schemaIncludeNum;
        }
        int endpointNum = 0;
        for (WebServiceEndpoint endpoint : endpoints) {
            if (!endpoint.hasWsdlPort()) {
                throw new Exception("No WSDL port specified for endpoint " + endpoint.getEndpointName());
            }
            if (!endpoint.hasServiceName()) {
                throw new Exception("Runtime settings error.  Cannot find service name for endpoint " + endpoint.getEndpointName());
            }
            String actualAddressParam = ENDPOINT_ADDRESS_PARAM_NAME + endpointNum;
            writer.write("<xsl:param name=\"" + actualAddressParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
            writer.write(endpoint.getServiceName().getNamespaceURI());
            writer.write("']/wsdl:service[@name='");
            writer.write(endpoint.getServiceName().getLocalPart());
            writer.write("']/wsdl:port[@name='");
            writer.write(endpoint.getWsdlPort().getLocalPart());
            writer.write("']/" + endpoint.getSoapAddressPrefix() + ":address\" mode=\"copy\">");
            writer.write("<" + endpoint.getSoapAddressPrefix() + ":address><xsl:attribute name=\"location\"><xsl:value-of select=\"$" + actualAddressParam + "\"/>");
            writer.write("</xsl:attribute></" + endpoint.getSoapAddressPrefix() + ":address></xsl:template>");
            ++endpointNum;
        }
        writer.write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
        writer.write("</xsl:transform>\n");
        writer.close();
        byte[] stylesheet = bos.toByteArray();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(new String(stylesheet));
        }
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheet));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(stylesheetSource);
        return templates;
    }

    public static void raiseException(HttpServletResponse resp, String binding, String faultString) {
        resp.setStatus(500);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding)) {
            resp.setContentType("text/xml");
            try {
                PrintWriter writer = new PrintWriter((OutputStream)resp.getOutputStream());
                writer.println("<error>" + faultString + "</error>");
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Cannot write out a HTTP XML exception : " + ioe.getMessage());
            }
        } else {
            String protocol = "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(binding) ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
            SOAPMessage fault = WsUtil.getSOAPFault(protocol, faultString);
            if (fault != null) {
                resp.setContentType("text/xml");
                try {
                    fault.writeTo((OutputStream)resp.getOutputStream());
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "cannot write SOAPFault to the HTTP response", ex);
                }
            }
        }
    }

    public static SOAPMessage getSOAPFault(String protocol, String faultString) {
        if (protocol == null) {
            protocol = "SOAP 1.1 Protocol";
        }
        try {
            MessageFactory factory = MessageFactory.newInstance((String)protocol);
            if (factory == null) {
                factory = MessageFactory.newInstance();
            }
            SOAPMessage message = factory.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultString(faultString);
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            String envelopeNamespace = envelope.getNamespaceURI();
            QName faultCode = new QName(envelopeNamespace, "Server", "env");
            fault.setFaultCode(faultCode);
            return message;
        }
        catch (SOAPException e) {
            logger.log(Level.WARNING, "Cannot create soap fault for " + faultString);
            return null;
        }
    }

    void writeInvalidContentType(HttpServletResponse response) throws SOAPException, IOException {
        response.setStatus(415);
        this.setContentTypeAndFlush(response);
    }

    void writeInvalidMethodType(HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("Invalid Method Type");
        out.println("</title></head>");
        out.println("<body>");
        out.println(message);
        out.println("</body>");
        out.println("</html>");
    }

    private void writeNotFoundErrorPage(HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("J2EE Web Services");
        out.println("</title></head>");
        out.println("<body>");
        out.println("<h1>404 Not Found: " + message + "</h1>");
        out.println("</body>");
        out.println("</html>");
    }

    private void setContentTypeAndFlush(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.flushBuffer();
        response.getWriter().close();
    }

    public WebServerInfo getWebServerInfo() {
        return this.getWebServerInfoForDAS();
    }

    private WebServerInfo getWebServerInfoForDAS() {
        WebServerInfo wsi = new WebServerInfo();
        wsi.setHttpVS(new VirtualServerInfo("http", "localhost", 8080));
        wsi.setHttpsVS(new VirtualServerInfo("https", "localhost", 8081));
        return wsi;
    }

    public Collection getWsdlsAndSchemas(File pkgedWsdl) throws Exception {
        ArrayList<SDDocumentSource> cumulative = new ArrayList<SDDocumentSource>();
        this.getWsdlsAndSchemas(pkgedWsdl, cumulative);
        URL id = pkgedWsdl.toURL();
        SDDocumentSource toRemove = null;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            toRemove = source;
        }
        if (toRemove != null) {
            cumulative.remove(toRemove);
        }
        return cumulative;
    }

    public void getWsdlsAndSchemas(File wsdl, ArrayList<SDDocumentSource> cumulative) throws Exception {
        String location;
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        String wsdlRoot = wsdl.getParent();
        this.parseRelativeImports(wsdl.toURL(), wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        for (Import next : schemaRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File file = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(file, cumulative);
        }
        for (Import next : wsdlRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File currentWsdlFile = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(currentWsdlFile, cumulative);
        }
    }

    private void addFileAndDecendents(File file, ArrayList<SDDocumentSource> cumulative) throws Exception {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        URL id = file.toURL();
        boolean alreadyProcessed = false;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            alreadyProcessed = true;
            break;
        }
        if (!alreadyProcessed) {
            cumulative.add(0, SDDocumentSource.create((URL)id));
            this.getWsdlsAndSchemas(file, cumulative);
        }
    }

    public void doPostConstruct(Class impl, Object implObj) {
        this.invokeServiceMethod(PostConstruct.class, impl, implObj);
    }

    public void doPreDestroy(WebServiceEndpoint ep, ClassLoader loader) {
        try {
            Class<?> impl = Class.forName(ep.getServletImplClass(), true, loader);
            this.invokeServiceMethod(PreDestroy.class, impl, impl.newInstance());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Class " + ep.getServletImplClass() + "not found during PreDestroy processing", ex);
        }
        if (!ep.hasHandlerChain()) {
            return;
        }
        for (WebServiceHandlerChain thisHc : ep.getHandlerChain()) {
            for (WebServiceHandler thisHandler : thisHc.getHandlers()) {
                try {
                    Class<?> handlerClass = Class.forName(thisHandler.getHandlerClass(), true, loader);
                    this.invokeServiceMethod(PreDestroy.class, handlerClass, handlerClass.newInstance());
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "Handler class " + thisHandler.getHandlerClass() + "not found during PreDestroy processing", ex);
                }
            }
        }
    }

    private void invokeServiceMethod(Class annType, Class impl, final Object implObj) {
        Method[] methods;
        for (final Method method : methods = impl.getDeclaredMethods()) {
            if (method.getAnnotation(annType) == null) continue;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        method.invoke(implObj, new Object[0]);
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failure while calling PostConstruct/PreDestroy method", e);
            }
            break;
        }
    }

    private boolean matchQNamePatterns(QName cfgQName, QName givenPattern) {
        if (givenPattern.getNamespaceURI().equals(cfgQName.getNamespaceURI())) {
            String expr = givenPattern.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(expr, cfgQName.getLocalPart());
        }
        return false;
    }

    private boolean patternsMatch(WebServiceHandlerChain hc, QName svcName, QName portName, String bindingId) {
        QName portPattern;
        QName svcPattern;
        if (hc.getServiceNamePattern() != null && svcName != null && !this.matchQNamePatterns(svcName, svcPattern = QName.valueOf(hc.getServiceNamePattern()))) {
            return false;
        }
        if (hc.getPortNamePattern() != null && portName != null && !this.matchQNamePatterns(portName, portPattern = QName.valueOf(hc.getPortNamePattern()))) {
            return false;
        }
        if (hc.getProtocolBindings() != null && bindingId != null) {
            String givenBindings = hc.getProtocolBindings();
            if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http") && (givenBindings.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || givenBindings.indexOf("##XML_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || givenBindings.indexOf("##SOAP11_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || givenBindings.indexOf("##SOAP12_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || givenBindings.indexOf("##SOAP11_HTTP_MTOM") != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || givenBindings.indexOf("##SOAP12_HTTP_MTOM") != -1)) {
                return true;
            }
        }
        return true;
    }

    private List<Handler> processConfiguredHandlers(List<WebServiceHandler> handlersList, Set<String> roles) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        for (WebServiceHandler h : handlersList) {
            Class<?> handlerClass;
            Handler handler = null;
            HashMap params = new HashMap();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                handlerClass = Class.forName(h.getHandlerClass(), true, loader);
                handler = (Handler)handlerClass.newInstance();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Unable to load handler class " + h.getHandlerClass());
                t.printStackTrace();
                continue;
            }
            try {
                WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                InjectionManager injManager = (InjectionManager)wscImpl.getHabitat().getByContract(InjectionManager.class);
                injManager.injectInstance((Object)handler);
            }
            catch (InjectionException e) {
                logger.severe("Handler " + h.getHandlerClass() + " instance injection failed : " + e.getMessage());
                continue;
            }
            this.doPostConstruct(handlerClass, handler);
            Collection rolesColl = h.getSoapRoles();
            roles.addAll(rolesColl);
            handlerChain.add(handler);
        }
        return handlerChain;
    }

    public void configureJAXWSServiceHandlers(WebServiceEndpoint ep, String bindingId, WSBinding bindingObj) {
        if (!ep.hasHandlerChain()) {
            return;
        }
        LinkedList handlerChainList = ep.getHandlerChain();
        ArrayList<Handler> finalHandlerList = new ArrayList<Handler>();
        HashSet<String> roles = new HashSet<String>();
        for (WebServiceHandlerChain hc : handlerChainList) {
            if (!this.patternsMatch(hc, ep.getServiceName(), ep.getWsdlPort(), bindingId)) continue;
            List<Handler> handlerInfo = this.processConfiguredHandlers(hc.getHandlers(), roles);
            finalHandlerList.addAll(handlerInfo);
        }
        bindingObj.setHandlerChain(finalHandlerList);
        if (bindingObj instanceof SOAPBinding) {
            ((SOAPBinding)bindingObj).setRoles(roles);
        }
    }

    public void configureJAXWSClientHandlers(Service svcClass, ServiceReferenceDescriptor desc) {
        HandlerResolverImpl resolver = new HandlerResolverImpl();
        HashSet<String> roles = new HashSet<String>();
        Iterator ports = svcClass.getPorts();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            LinkedList handlerChainList = desc.getHandlerChain();
            for (WebServiceHandlerChain hc : handlerChainList) {
                if (!this.patternsMatch(hc, desc.getServiceName(), nextPort, null)) continue;
                ArrayList<String> protocols = new ArrayList<String>();
                if (hc.getProtocolBindings() == null) {
                    protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                } else {
                    String specifiedProtocols = hc.getProtocolBindings();
                    if (specifiedProtocols.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || specifiedProtocols.indexOf("##XML_HTTP") != -1) {
                        protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || specifiedProtocols.indexOf("##SOAP11_HTTP") != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || specifiedProtocols.indexOf("##SOAP12_HTTP") != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || specifiedProtocols.indexOf("##SOAP11_HTTP_MTOM") != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || specifiedProtocols.indexOf("##SOAP12_HTTP_MTOM") != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                    }
                }
                List handlersList = hc.getHandlers();
                for (WebServiceHandler thisOne : handlersList) {
                    Collection portNames = thisOne.getPortNames();
                    if (portNames.isEmpty() || portNames.contains(nextPort.getLocalPart())) continue;
                    handlersList.remove(thisOne);
                }
                List<Handler> handlerInfo = this.processConfiguredHandlers(handlersList, roles);
                Iterator s = protocols.iterator();
                while (s.hasNext()) {
                    PortInfoImpl portInfo = new PortInfoImpl(BindingID.parse((String)((String)s.next())), nextPort, desc.getServiceName());
                    resolver.setHandlerChain(portInfo, handlerInfo);
                }
            }
        }
        svcClass.setHandlerResolver((HandlerResolver)resolver);
    }

    public boolean getMtom(WebServiceEndpoint ep) {
        String currentBinding = ep.getProtocolBinding();
        if (ep.getMtomEnabled() == null && ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding))) {
            return true;
        }
        return new Boolean(ep.getMtomEnabled()) != false && ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(currentBinding) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding));
    }
}

