/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.sniffer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.scripting.jruby.sniffer.Messages;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jruby")
@Scoped(value=Singleton.class)
public class JRubySniffer
implements Sniffer {
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    private static final String containerName = "jruby";
    private static final String RAILS_APP = "app/controllers/application.rb";
    private static final String RUBY_SUFFIX = ".rb";
    private static final String RAKEFILE = "Rakefile";
    private final String[] containers = new String[]{"org.glassfish.scripting.jruby.JRubyContainer"};
    private final String[] defaultFrameworks = new String[]{"merb", "rails", "sinatra"};
    private static final String WEB_XML = "WEB-INF/web.xml";
    private static final String WEB_INF = "WEB-INF/";
    private static final String GRIZZLY_JRUBY_MODULE = "org.glassfish.scripting.grizzly-jruby-module";

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        try {
            if (location.exists(WEB_XML) || location.exists(WEB_INF)) {
                return false;
            }
            if (location.exists(RAILS_APP)) {
                return true;
            }
            Enumeration entries = location.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(RUBY_SUFFIX) && !entryName.equalsIgnoreCase(RAKEFILE)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String[] getURLPatterns() {
        return null;
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    public String getModuleType() {
        return containerName;
    }

    public Module[] setup(String containerHome, Logger logger) throws IOException {
        Collection modules;
        File rootLocation = new File(containerHome);
        if (!rootLocation.exists()) {
            logger.log(Level.SEVERE, Messages.format("sniffer.jruby.home.not.found", rootLocation.getPath(), System.getProperty("com.sun.aas.installRoot") + File.separator + "domains" + File.separator + "domain1" + File.separator + "config" + File.separator + "domain.xml"));
        }
        if ((modules = this.registry.getModules(GRIZZLY_JRUBY_MODULE)).size() == 0) {
            throw new ResolveError(Messages.format("sniffer.jrubymodule.notfound", "grizzly-jruby-module.jar"));
        }
        if (modules.size() > 1) {
            throw new ResolveError(Messages.format("sniffer.jrubymodule.morethanone", GRIZZLY_JRUBY_MODULE));
        }
        Module grizzlyRails = (Module)modules.iterator().next();
        return new Module[]{grizzlyRails};
    }

    public void tearDown() {
    }

    public String[] getContainersNames() {
        return this.containers;
    }

    public boolean isUserVisible() {
        return true;
    }

    public Map<String, String> getDeploymentConfigurations(ReadableArchive readableArchive) throws IOException {
        return Collections.EMPTY_MAP;
    }

    public String[] getIncompatibleSnifferTypes() {
        return new String[0];
    }
}

