/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.WorkerThread;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.stomp.FrameParseException;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompServer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompProtocolParser
implements ProtocolParser<StompFrameMessage> {
    public static Logger _logger = Controller.logger();
    private ByteBuffer _buffer = null;
    private StompFrameMessage _message = null;
    private int _position = 0;
    private boolean _expectingMoreData = true;
    private boolean _hasMoreBytesToParse = false;
    private BridgeContext _bc = null;
    private final String _OOMMSG = "Running low on memory while parsing stomp incoming data";

    protected StompProtocolParser(BridgeContext bridgeContext) {
        this._bc = bridgeContext;
    }

    public boolean isExpectingMoreData() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "expectingMoreData=" + this._expectingMoreData);
        }
        return this._expectingMoreData;
    }

    public boolean hasMoreBytesToParse() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "hasMoreBytesToParse=" + this._hasMoreBytesToParse);
        }
        return this._hasMoreBytesToParse;
    }

    public StompFrameMessage getNextMessage() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "entering: hasmorebytestoparse=" + this._hasMoreBytesToParse + ", expectmoredata=" + this._expectingMoreData + ", _position=" + this._position + ", _buffer=" + this._buffer + ", msgcmd=" + (Object)((Object)this._message.getCommand()));
        }
        StompFrameMessage stompFrameMessage = this._message;
        this._hasMoreBytesToParse = this._buffer.position() - this._position > 0;
        this._expectingMoreData = false;
        this._message = null;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "leaving: hasmorebytestoparse=" + this._hasMoreBytesToParse + ", expectmoredata=" + this._expectingMoreData);
        }
        return stompFrameMessage;
    }

    public boolean hasNextMessage() {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "this: " + this + ", _position=" + this._position + ", _buffer=" + this._buffer);
            }
            if (this._buffer == null) {
                return false;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "_position=" + this._position + ", _buffer_position=:" + this._buffer.position());
                _logger.log(Level.FINEST, "_buffer=" + new String(this._buffer.array(), this._buffer.arrayOffset(), this._buffer.remaining(), "UTF-8"));
            }
            this._hasMoreBytesToParse = false;
            if (this._message == null) {
                if (this._buffer.position() - this._position >= 3) {
                    this._message = StompFrameMessage.parseCommand(this._buffer, this._position);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "returned from parseCommand");
                    }
                }
                if (this._message == null) {
                    if (this._buffer.capacity() - this._buffer.position() < 1024) {
                        _logger.log(Level.FINEST, "_buffer: capacity=" + this._buffer.capacity() + ", position=" + this._buffer.position() + ", extend _buffer for < max-command-len=" + 1024);
                        this.extendByteBuffer();
                    }
                    this._expectingMoreData = true;
                    return false;
                }
                this._position = this._message.getByteBufferPosition();
            }
            if (this._message.getNextParseStage() == StompFrameMessage.ParseStage.HEADER) {
                this._message.parseHeader(this._buffer, this._position);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "returned from parseHeader");
                }
                this._position = this._message.getByteBufferPosition();
            }
            if (this._message.getNextParseStage() == StompFrameMessage.ParseStage.BODY) {
                this._message.readBody(this._buffer, this._position);
                this._position = this._message.getByteBufferPosition();
            }
            if (this._message.getNextParseStage() == StompFrameMessage.ParseStage.NULL) {
                this._message.readNULL(this._buffer, this._position);
                this._position = this._message.getByteBufferPosition();
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "_position=" + this._position + ", _buffer=" + this._buffer + ", nextParseState=" + (Object)((Object)this._message.getNextParseStage()));
            }
            if (this._message.getNextParseStage() != StompFrameMessage.ParseStage.DONE) {
                if (this._buffer.capacity() == this._buffer.position()) {
                    if (this._position < this._buffer.position()) {
                        this.extendByteBuffer();
                    } else {
                        long l = this._message.getContentLength();
                        this.allocateNewByteBuffer(l == -1L ? (long)this._buffer.capacity() : l);
                    }
                } else if (this._position == this._buffer.position()) {
                    this._position = 0;
                    this._buffer.clear();
                }
                this._expectingMoreData = true;
                return false;
            }
            this._expectingMoreData = false;
            Exception exception = this._message.getParseException();
            if (exception != null) {
                this._message = exception instanceof FrameParseException ? ((FrameParseException)exception).getStompMessageERROR() : new FrameParseException(exception.getMessage(), exception).getStompMessageERROR();
            }
            return true;
        }
        catch (Throwable throwable) {
            block27: {
                if (throwable instanceof OutOfMemoryError) {
                    _logger.log(Level.SEVERE, "Running low on memory while parsing stomp incoming data");
                    this._bc.handleGlobalError(throwable, "Running low on memory while parsing stomp incoming data");
                } else {
                    _logger.log(Level.SEVERE, StompServer.getStompBridgeResources().getKString("BSS3003", throwable.getMessage()), throwable);
                }
                try {
                    this._message = throwable instanceof FrameParseException ? ((FrameParseException)throwable).getStompMessageERROR() : new FrameParseException(throwable.getMessage(), throwable).getStompMessageERROR();
                }
                catch (Throwable throwable2) {
                    if (throwable instanceof OutOfMemoryError) {
                        this._message = FrameParseException.OOMMSG;
                        break block27;
                    }
                    _logger.log(Level.SEVERE, StompServer.getStompBridgeResources().getKString("BSS3004", throwable.getMessage()), throwable2);
                    this._expectingMoreData = false;
                    RuntimeException runtimeException = new RuntimeException(throwable2.getMessage());
                    runtimeException.initCause(throwable2);
                    throw runtimeException;
                }
            }
            this._expectingMoreData = false;
            return true;
        }
    }

    private void extendByteBuffer() throws FrameParseException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "entering: _position=" + this._position + ", _buffer=" + this._buffer);
        }
        if (this._position > this._buffer.position()) {
            throw new IllegalStateException(StompServer.getStompBridgeResources().getKString("BSS4035", String.valueOf(this._position), String.valueOf(this._buffer.position())));
        }
        ByteBuffer byteBuffer = ByteBufferFactory.allocateView((int)(this._buffer.capacity() * 2), (boolean)this._buffer.isDirect());
        int n = this._buffer.position();
        this._buffer.position(this._position);
        byteBuffer.put(this._buffer);
        this._buffer = byteBuffer;
        this._buffer.position(n - this._position);
        this._position = 0;
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        workerThread.setByteBuffer(this._buffer);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "leaving: _position=" + this._position + ", _buffer=" + this._buffer);
        }
    }

    private void allocateNewByteBuffer(long l) throws FrameParseException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "entering: _position=" + this._position + ", _buffer=" + this._buffer + ", size=" + l);
        }
        if (this._position != this._buffer.position()) {
            throw new IllegalStateException(StompServer.getStompBridgeResources().getKString("BSS4022", this._position, this._buffer.position()));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this._buffer.capacity());
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        workerThread.setByteBuffer(byteBuffer);
        this._buffer = byteBuffer;
        this._position = 0;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "leaving: _position=" + this._position + ", _buffer=" + this._buffer);
        }
    }

    public void startBuffer(ByteBuffer byteBuffer) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "this:" + this);
        }
        this._buffer = byteBuffer;
    }

    public boolean releaseBuffer() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "expectingMoreData=" + this._expectingMoreData + ", hasMoreBytesToParse=" + this._hasMoreBytesToParse + ", _position=" + this._position);
        }
        if (!this._expectingMoreData) {
            this._position = 0;
            this._hasMoreBytesToParse = false;
        }
        return this._expectingMoreData;
    }
}

