/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfFacesConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Pattern JAR_PATTERN = Pattern.compile(".*/(\\S*\\.jar).*");
    private static final String META_INF_RESOURCES = "META-INF/faces-config.xml";

    @Override
    public Collection<URL> getResources(ServletContext context) {
        WebConfiguration webConfig = WebConfiguration.getInstance(context);
        String duplicateJarPattern = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DuplicateJARPattern);
        Pattern duplicatePattern = null;
        if (duplicateJarPattern != null) {
            duplicatePattern = Pattern.compile(duplicateJarPattern);
        }
        TreeMap<String, HashSet<URL>> sortedJarMap = new TreeMap<String, HashSet<URL>>();
        ArrayList<URL> unsortedResourceList = new ArrayList<URL>();
        try {
            for (URL url : this.loadURLs()) {
                String jarUrl = url.toString();
                String jarName = null;
                Matcher m = JAR_PATTERN.matcher(jarUrl);
                if (m.matches()) {
                    jarName = m.group(1);
                }
                if (jarName != null) {
                    HashSet<URL> urls;
                    if (duplicatePattern != null && (m = duplicatePattern.matcher(jarName)).matches()) {
                        jarName = m.group(1);
                    }
                    if ((urls = (HashSet<URL>)sortedJarMap.get(jarName)) == null) {
                        urls = new HashSet<URL>();
                        sortedJarMap.put(jarName, urls);
                    }
                    urls.add(url);
                    continue;
                }
                unsortedResourceList.add(0, url);
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        ArrayList<URL> result = new ArrayList<URL>(sortedJarMap.size() + unsortedResourceList.size());
        for (Map.Entry entry : sortedJarMap.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        result.addAll(unsortedResourceList);
        return result;
    }

    private Collection<URL> loadURLs() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        Enumeration<URL> e = Util.getCurrentLoader(this).getResources(META_INF_RESOURCES);
        while (e.hasMoreElements()) {
            urls.add(e.nextElement());
        }
        urls.addAll(Arrays.asList(Classpath.search("META-INF/", ".faces-config.xml")));
        return urls;
    }
}

