/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Timer timer;
        context.setCurrentPhaseId(this.getId());
        PhaseEvent event = null;
        if (listeners.hasNext()) {
            event = new PhaseEvent(context, this.getId(), lifecycle);
        }
        if ((timer = Timer.getInstance()) != null) {
            timer.startTiming();
        }
        this.handleBeforePhase(context, listeners, event);
        try {
            if (!this.shouldSkip(context)) {
                this.execute(context);
            }
        }
        catch (Throwable e) {
            this.queueException(context, e);
        }
        finally {
            this.handleAfterPhase(context, listeners, event);
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Execution time for phase (including any PhaseListeners) -> " + this.getId().toString());
            }
            context.getExceptionHandler().handle();
        }
    }

    public abstract void execute(FacesContext var1) throws FacesException;

    public abstract PhaseId getId();

    protected void queueException(FacesContext ctx, Throwable t) {
        this.queueException(ctx, t, null);
    }

    protected void queueException(FacesContext ctx, Throwable t, String booleanKey) {
        ExceptionQueuedEventContext extx = new ExceptionQueuedEventContext(ctx, t);
        if (booleanKey != null) {
            extx.getAttributes().put(booleanKey, Boolean.TRUE);
        }
        ctx.getApplication().publishEvent(ctx, ExceptionQueuedEvent.class, (Object)extx);
    }

    protected void handleAfterPhase(FacesContext context, ListIterator<PhaseListener> listenersIterator, PhaseEvent event) {
        Flash flash = context.getExternalContext().getFlash();
        flash.doPostPhaseActions(context);
        while (listenersIterator.hasPrevious()) {
            PhaseListener listener = listenersIterator.previous();
            if (!this.getId().equals(listener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener.getPhaseId())) continue;
            try {
                listener.afterPhase(event);
            }
            catch (Exception e) {
                this.queueException(context, e, ExceptionQueuedEventContext.IN_AFTER_PHASE_KEY);
                return;
            }
        }
    }

    protected void handleBeforePhase(FacesContext context, ListIterator<PhaseListener> listenersIterator, PhaseEvent event) {
        Flash flash = context.getExternalContext().getFlash();
        flash.doPrePhaseActions(context);
        while (listenersIterator.hasNext()) {
            PhaseListener listener = listenersIterator.next();
            if (!this.getId().equals(listener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener.getPhaseId())) continue;
            try {
                listener.beforePhase(event);
            }
            catch (Exception e) {
                this.queueException(context, e, ExceptionQueuedEventContext.IN_BEFORE_PHASE_KEY);
                if (listenersIterator.hasPrevious()) {
                    listenersIterator.previous();
                }
                return;
            }
        }
    }

    private boolean shouldSkip(FacesContext context) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse() && !PhaseId.RENDER_RESPONSE.equals(this.getId());
    }
}

