/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.util.Hashtable;
import java.util.Vector;

class TransactionReaper
implements Runnable {
    TransactionList translist = null;
    Logger logger = Globals.getLogger();
    Vector committed = new Vector();
    Vector noremoves = new Vector();
    Vector clusterPCommitted = new Vector();
    Vector remoteCommitted = new Vector();
    Vector remoteRCommitted = new Vector();
    WakeupableTimer reapTimer = null;

    public TransactionReaper(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public void addLocalTransaction(TransactionUID transactionUID, boolean bl) {
        if (bl) {
            this.noremoves.add(transactionUID);
        }
        this.committed.add(transactionUID);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public void addClusterTransaction(TransactionUID transactionUID, boolean bl) {
        this.clusterPCommitted.add(transactionUID);
        if (bl) {
            this.noremoves.add(transactionUID);
        }
        this.createTimer();
        this.reapTimer.wakeup();
    }

    public void addCompletedClusterTransaction(TransactionUID transactionUID) {
        this.committed.add(transactionUID);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public void addRemoteTransaction(TransactionUID transactionUID, boolean bl) {
        if (!bl) {
            this.remoteCommitted.add(transactionUID);
        } else {
            this.remoteRCommitted.add(transactionUID);
        }
        this.createTimer();
        if (this.remoteCommitted.size() > TransactionList.TXN_REAPLIMIT || this.remoteRCommitted.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public boolean hasRemoteTransaction(TransactionUID transactionUID) {
        if (this.remoteCommitted.contains(transactionUID)) {
            return true;
        }
        return this.remoteRCommitted.contains(transactionUID);
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String string = Globals.getBrokerResources().getKString("B1285", TransactionList.TXN_REAPLIMIT, TransactionList.TXN_REAPINTERVAL / 1000L);
                String string2 = Globals.getBrokerResources().getKString("B1286");
                this.reapTimer = new WakeupableTimer("TransactionReaper", this, TransactionList.TXN_REAPINTERVAL, TransactionList.TXN_REAPINTERVAL, string, string2, this.logger);
            }
            catch (Exception exception) {
                this.logger.log(16, "B3100", (Object)"Unable to start transaction reaper thread ", (Throwable)exception);
            }
        }
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.committed.clear();
        this.remoteCommitted.clear();
        this.remoteRCommitted.clear();
    }

    public Hashtable getDebugState(TransactionUID transactionUID) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.committed.contains(transactionUID)) {
            hashtable.put(transactionUID.toString(), TransactionState.toString(6));
            return hashtable;
        }
        if (this.clusterPCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(remote)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteRCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(remote-r)", TransactionState.toString(6));
            return hashtable;
        }
        return null;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("comittedCount", new Integer(this.committed.size()));
        for (TransactionUID transactionUID : this.committed) {
            hashtable.put(transactionUID.toString(), TransactionState.toString(6));
        }
        for (TransactionUID transactionUID : this.clusterPCommitted) {
            hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
        }
        hashtable.put("noremovesCount", new Integer(this.noremoves.size()));
        for (TransactionUID transactionUID : this.noremoves) {
            hashtable.put(transactionUID.toString(), TransactionState.toString(6));
        }
        for (TransactionUID transactionUID : this.remoteCommitted) {
            hashtable.put(transactionUID.toString() + "(remote)", TransactionState.toString(6));
        }
        for (TransactionUID transactionUID : this.remoteRCommitted) {
            hashtable.put(transactionUID.toString() + "(remote-r)", TransactionState.toString(6));
        }
        return hashtable;
    }

    public void run() {
        int n;
        TransactionUID[] transactionUIDArray = this.clusterPCommitted.toArray(new TransactionUID[0]);
        for (n = 0; n < transactionUIDArray.length; ++n) {
            try {
                TransactionBroker[] transactionBrokerArray = this.translist.getClusterTransactionBrokers(transactionUIDArray[n]);
                if (transactionBrokerArray == null) continue;
                boolean bl = true;
                BrokerAddress brokerAddress = null;
                for (int i = 0; i < transactionBrokerArray.length; ++i) {
                    if (transactionBrokerArray[i].isCompleted()) continue;
                    bl = false;
                    brokerAddress = transactionBrokerArray[i].getCurrentBrokerAddress();
                    if (brokerAddress != null) {
                        Globals.getClusterBroadcast().sendClusterTransactionInfo(transactionUIDArray[n].longValue(), brokerAddress);
                        continue;
                    }
                    this.logger.log(8, Globals.getBrokerResources().getKString("B2205", transactionUIDArray[n].toString(), transactionBrokerArray[i].toString()));
                }
                if (!bl) continue;
                this.committed.add(transactionUIDArray[n]);
                this.clusterPCommitted.remove(transactionUIDArray[n]);
                continue;
            }
            catch (Exception exception) {
                this.logger.logStack(16, exception.getMessage(), exception);
            }
        }
        transactionUIDArray = this.committed.toArray(new TransactionUID[0]);
        n = transactionUIDArray.length - TransactionList.TXN_REAPLIMIT;
        for (int i = 0; i < n; ++i) {
            if (TransactionList.DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Cleaning up committed transaction " + transactionUIDArray[i]);
            }
            try {
                this.translist.reapTransactionID(transactionUIDArray[i], this.noremoves.contains(transactionUIDArray[i]));
                this.committed.remove(transactionUIDArray[i]);
                this.noremoves.remove(transactionUIDArray[i]);
                continue;
            }
            catch (Exception exception) {
                this.logger.logStack(16, "Failed to cleanup committed transaction " + transactionUIDArray[i], exception);
            }
        }
        for (n = this.remoteCommitted.size() - TransactionList.TXN_REAPLIMIT; n > 0; --n) {
            TransactionUID transactionUID = (TransactionUID)this.remoteCommitted.firstElement();
            this.remoteCommitted.remove(transactionUID);
            if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "Cleaned up committed remote transaction " + transactionUID);
        }
        for (n = this.remoteRCommitted.size() - TransactionList.TXN_REAPLIMIT; n > 0; --n) {
            TransactionUID transactionUID = (TransactionUID)this.remoteRCommitted.firstElement();
            this.remoteRCommitted.remove(transactionUID);
            if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "Cleaned up committed remote transaction " + transactionUID + ".");
        }
    }
}

