/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTxnInfoInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTxnInquiryInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.DestinationUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.MessageAckReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyTracker;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.Resource;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakeoverCleanupThread;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakeoverPendingReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakingoverEntry;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClientClosedHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClusterFlowControlHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ConfigChangeEventHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.DestinationUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetConfigChangesHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetInterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GoodbyeHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.InterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.LockHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageAckHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageDataHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.NewInterestHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.PingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ReloadClusterHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.RemDurableHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverAbortHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverCompleteHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverPendingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TransactionInfoHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TransactionInquiryHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.UnknownPacketHandler;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MQThreadGroup;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class RaptorProtocol
implements Protocol {
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();
    private static boolean DEBUG = false;
    protected static final boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all") || DEBUG;
    protected static final boolean DEBUG_CLUSTER_LOCK = Globals.getConfig().getBooleanProperty("imq.cluster.debug.lock") || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn") || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_TAKEOVER = Globals.getConfig().getBooleanProperty("imq.cluster.debug.takeover") || DEBUG_CLUSTER_ALL;
    private static final int DEFAULT_LOCKTIMEOUT = 60;
    protected int lockTimeout = Globals.getConfig().getIntProperty("imq.cluster.locktimeout", 60);
    private static final int DEFAULT_ACKTIMEOUT = 180;
    protected int ackTimeout = Globals.getConfig().getIntProperty("imq.cluster.acktimeout", 180);
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected BrokerInfo selfInfo = null;
    protected CallbackDispatcher cbDispatcher = null;
    protected int version = ProtocolGlobals.getCurrentVersion();
    private boolean shutdown = false;
    protected Map brokerList = null;
    private Map takingoverBrokers = null;
    protected HashMap resTable = null;
    protected Random r = null;
    protected long startTime = 0L;
    protected boolean configSyncComplete = false;
    protected boolean storeDirtyFlag = false;
    protected boolean isMasterBroker = false;
    private Map eventLogWaiters = null;
    protected Object cfgSrvWaitObject = null;
    protected int cfgSrvRequestCount = 0;
    protected boolean cfgSrvRequestErr = false;
    protected Store store = null;
    protected GPacketHandler[] handlers;
    protected GPacketHandler unknownPacketHandler;
    protected boolean flowStopped = false;
    private ReplyTracker ackackTracker = null;
    private ReplyTracker takeoverPendingReplyTracker = null;
    private int takeoverPendingReplyTimeout = 60;
    private Map myPretakeovers = null;
    private ThreadGroup takeoverCleanupTG = new MQThreadGroup("TakeoverCleanup");
    private FaultInjection fi = null;
    private HashMap ackCounts = new HashMap();

    public RaptorProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress, BrokerInfo brokerInfo) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Initializing RaptorProtocol");
        }
        this.cb = messageBusCallback;
        this.c = cluster;
        this.selfAddress = brokerAddress;
        this.selfInfo = brokerInfo;
        this.cbDispatcher = new CallbackDispatcher(messageBusCallback);
        this.store = Globals.getStore();
        this.resTable = new HashMap();
        this.r = new Random();
        this.brokerList = Collections.synchronizedMap(new LinkedHashMap());
        this.takingoverBrokers = Collections.synchronizedMap(new LinkedHashMap());
        this.myPretakeovers = Collections.synchronizedMap(new LinkedHashMap());
        this.cfgSrvWaitObject = new Object();
        this.eventLogWaiters = Collections.synchronizedMap(new LinkedHashMap());
        if (this.lockTimeout < 0) {
            this.lockTimeout = 60;
        }
        if (this.ackTimeout < 0) {
            this.ackTimeout = 180;
        }
        this.initHandlers();
        String string = Globals.getConfig().getProperty("imq.cluster.masterbroker.backup");
        String string2 = Globals.getConfig().getProperty("imq.cluster.masterbroker.restore");
        if (string != null) {
            this.configServerBackup(string);
        }
        if (string2 != null) {
            this.configServerRestore(string2);
        }
        this.ackackTracker = new ReplyTracker();
        this.takeoverPendingReplyTracker = new ReplyTracker();
        this.fi = FaultInjection.getInjection();
    }

    private void addHandler(int n, GPacketHandler gPacketHandler) {
        if (n > 48) {
            throw new ArrayIndexOutOfBoundsException("Bad ProtocolHandler");
        }
        this.handlers[n] = gPacketHandler;
    }

    private void initHandlers() {
        if (DEBUG) {
            logger.log(4, "Initializing RaptorProtocol handlers");
        }
        this.handlers = new GPacketHandler[49];
        GPacketHandler gPacketHandler = new MessageDataHandler(this);
        this.addHandler(1, gPacketHandler);
        this.addHandler(2, gPacketHandler);
        gPacketHandler = new MessageAckHandler(this);
        this.addHandler(3, gPacketHandler);
        this.addHandler(4, gPacketHandler);
        gPacketHandler = new NewInterestHandler(this);
        this.addHandler(5, gPacketHandler);
        this.addHandler(6, gPacketHandler);
        this.addHandler(35, gPacketHandler);
        this.addHandler(36, gPacketHandler);
        gPacketHandler = new RemDurableHandler(this);
        this.addHandler(7, gPacketHandler);
        this.addHandler(8, gPacketHandler);
        gPacketHandler = new InterestUpdateHandler(this);
        this.addHandler(9, gPacketHandler);
        this.addHandler(10, gPacketHandler);
        gPacketHandler = new LockHandler(this);
        this.addHandler(11, gPacketHandler);
        this.addHandler(12, gPacketHandler);
        gPacketHandler = new DestinationUpdateHandler(this);
        this.addHandler(13, gPacketHandler);
        this.addHandler(14, gPacketHandler);
        this.addHandler(15, gPacketHandler);
        this.addHandler(16, gPacketHandler);
        gPacketHandler = new ConfigChangeEventHandler(this);
        this.addHandler(17, gPacketHandler);
        this.addHandler(18, gPacketHandler);
        gPacketHandler = new GetConfigChangesHandler(this);
        this.addHandler(19, gPacketHandler);
        this.addHandler(20, gPacketHandler);
        gPacketHandler = new ClientClosedHandler(this);
        this.addHandler(21, gPacketHandler);
        this.addHandler(22, gPacketHandler);
        gPacketHandler = new ClusterFlowControlHandler(this);
        this.addHandler(23, gPacketHandler);
        this.addHandler(24, gPacketHandler);
        this.addHandler(25, gPacketHandler);
        this.addHandler(26, gPacketHandler);
        gPacketHandler = new ReloadClusterHandler(this);
        this.addHandler(27, gPacketHandler);
        this.addHandler(28, gPacketHandler);
        gPacketHandler = new GetInterestUpdateHandler(this);
        this.addHandler(29, gPacketHandler);
        this.addHandler(30, gPacketHandler);
        gPacketHandler = new PingHandler(this);
        this.addHandler(33, gPacketHandler);
        this.addHandler(34, gPacketHandler);
        gPacketHandler = new GoodbyeHandler(this);
        this.addHandler(37, gPacketHandler);
        this.addHandler(38, gPacketHandler);
        gPacketHandler = new TakeoverCompleteHandler(this);
        this.addHandler(41, gPacketHandler);
        gPacketHandler = new TakeoverPendingHandler(this);
        this.addHandler(39, gPacketHandler);
        this.addHandler(40, gPacketHandler);
        gPacketHandler = new TakeoverAbortHandler(this);
        this.addHandler(43, gPacketHandler);
        gPacketHandler = new TransactionInquiryHandler(this);
        this.addHandler(47, gPacketHandler);
        gPacketHandler = new TransactionInfoHandler(this);
        this.addHandler(48, gPacketHandler);
        this.unknownPacketHandler = new UnknownPacketHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList arrayList = null;
        Iterator iterator = this.brokerList;
        synchronized (iterator) {
            arrayList = new ArrayList(this.brokerList.keySet());
        }
        hashtable.put("brokerListCount", arrayList.size());
        for (Object object2 : arrayList) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(object2);
            hashtable.put("[brokerList]" + object2.toString(), brokerInfoEx.toString());
        }
        if (this.cbDispatcher != null) {
            hashtable.put("callbackDispatcher", this.cbDispatcher.getDebugState());
        }
        if (Globals.getHAEnabled()) {
            Object object2;
            object2 = this.takingoverBrokers;
            synchronized (object2) {
                arrayList = new ArrayList(this.takingoverBrokers.keySet());
            }
            hashtable.put("takingoverBrokersCount", arrayList.size());
            for (Object object2 : arrayList) {
                hashtable.put(((TakingoverEntry)object2).toString(), ((TakingoverEntry)object2).toLongString());
            }
        }
        return hashtable;
    }

    public int getHighestSupportedVersion() {
        return ProtocolGlobals.getCurrentVersion();
    }

    public int getClusterVersion() {
        return this.version;
    }

    public void receiveUnicast(BrokerAddress brokerAddress, GPacket gPacket) {
        short s;
        if (DEBUG) {
            logger.log(2, "RaptorProtocol.receiveUnicast(GPacket) from : " + brokerAddress + " Packet :\n" + gPacket.toLongString());
        }
        if ((s = gPacket.getType()) > 48) {
            this.unknownPacketHandler.handle(brokerAddress, gPacket);
            return;
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 47: 
            case 48: {
                this.cbDispatcher.processGPacket(brokerAddress, gPacket, this);
                return;
            }
        }
        this.handlers[s].handle(brokerAddress, gPacket);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, GPacket gPacket) {
        short s;
        if (DEBUG) {
            logger.log(2, "RaptorProtocol.receiveBroadcast(GPacket) from : " + brokerAddress + " Packet :\n" + gPacket.toLongString());
        }
        if ((s = gPacket.getType()) > 48) {
            this.unknownPacketHandler.handle(brokerAddress, gPacket);
            return;
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 47: 
            case 48: {
                this.cbDispatcher.processGPacket(brokerAddress, gPacket, this);
                return;
            }
        }
        this.handlers[s].handle(brokerAddress, gPacket);
    }

    public void handleGPacket(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        this.handlers[gPacket.getType()].handle(messageBusCallback, brokerAddress, gPacket);
    }

    public void receiveUnicast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray, boolean bl) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public BrokerInfo getBrokerInfo() {
        logger.logStack(32, "B3100", "Unexpected call", (Throwable)new Exception());
        return null;
    }

    public ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo brokerInfo) throws Exception {
        this.checkUIDPrefixClash(brokerInfo);
        int n = 0;
        if (this.isTakeoverTarget(brokerInfo.getBrokerAddr())) {
            n = 1;
        }
        ClusterBrokerInfoReply clusterBrokerInfoReply = ClusterBrokerInfoReply.newInstance(this.selfInfo, n);
        return clusterBrokerInfoReply;
    }

    private void checkUIDPrefixClash(BrokerInfo brokerInfo) throws BrokerException {
        if (this.c.getConfigServer() == null && UniqueID.getPrefix(brokerInfo.getBrokerAddr().getBrokerSessionUID().longValue()) == UniqueID.getPrefix(this.selfInfo.getBrokerAddr().getBrokerSessionUID().longValue())) {
            BrokerAddress brokerAddress = brokerInfo.getBrokerAddr();
            if (this.selfInfo.getStartTime() > brokerInfo.getStartTime() || this.selfInfo.getStartTime() == brokerInfo.getStartTime() && this.selfInfo.getBrokerAddr().getMQAddress().toString().compareTo(brokerAddress.getMQAddress().toString()) > 0) {
                String string = br.getKString("B3185", brokerAddress);
                BrokerException brokerException = new BrokerException(string);
                logger.logStack(32, string, brokerException);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), string, BrokerEvent.Type.RESTART, null, false, true, false);
            }
        }
    }

    public void setMatchProps(Properties properties) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.setMatchProps :\n" + properties);
        }
        this.c.setMatchProps(properties);
    }

    public void startClusterIO() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.startClusterIO");
        }
        try {
            BrokerAddress brokerAddress = this.c.getConfigServer();
            if (brokerAddress == null) {
                this.configSyncComplete = true;
                if (DEBUG) {
                    logger.log(4, "No master broker. configSyncComplete=true");
                }
            } else if (brokerAddress.equals(this.selfAddress)) {
                this.initConfigServer();
                long l = -1L;
                l = this.getLastRefreshTime();
                this.sendConfigChangesRequest(this.selfAddress, l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopClusterIO(boolean bl) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.shutdown");
        }
        Object object = this.brokerList;
        synchronized (object) {
            this.shutdown = true;
        }
        this.cbDispatcher.shutdown();
        try {
            if (Globals.getClusterBroadcast().getClusterVersion() < 400) {
                return;
            }
        }
        catch (Exception exception) {
            logger.log(4, "Unable to get cluster version on stop cluster IO:" + exception.getMessage());
            return;
        }
        object = ClusterGoodbyeInfo.newInstance(bl, this.c);
        Map map = this.brokerList;
        synchronized (map) {
            for (BrokerInfoEx brokerInfoEx : this.brokerList.values()) {
                BrokerAddress brokerAddress = brokerInfoEx.getBrokerInfo().getBrokerAddr();
                GPacket gPacket = ((ClusterGoodbyeInfo)object).getGPacket();
                try {
                    Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), "[" + object + "]", brokerAddress};
                    logger.log(8, br.getKString("B1172", objectArray));
                    this.c.unicast(brokerAddress, gPacket);
                    brokerInfoEx.goodbyeSent();
                }
                catch (IOException iOException) {
                    logger.logStack(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress), iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReceived(BrokerAddress brokerAddress, ClusterGoodbyeInfo clusterGoodbyeInfo) {
        Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(37), "[" + clusterGoodbyeInfo + "]", brokerAddress};
        logger.log(8, br.getKString("B1173", objectArray));
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
            if (brokerInfoEx != null) {
                brokerInfoEx.setGoodbyeInfo(clusterGoodbyeInfo);
                brokerInfoEx.goodbyeReceived();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReplySent(BrokerAddress brokerAddress) {
        boolean bl = false;
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
            if (brokerInfoEx != null) {
                brokerInfoEx.goodbyeReplySent();
                if (DEBUG) {
                    logger.log(8, "Sent GOODBYE_REPLY to " + brokerAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReplyReceived(BrokerAddress brokerAddress) {
        boolean bl = false;
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
            if (brokerInfoEx != null) {
                brokerInfoEx.goodbyeReplyReceived();
                if (DEBUG) {
                    logger.log(8, "Received GOODBYE_REPLY from " + brokerAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGoodbye(BrokerAddress brokerAddress) {
        try {
            Map map = this.brokerList;
            synchronized (map) {
                BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
                if (brokerInfoEx != null) {
                    if (brokerInfoEx.sentGoodbye()) {
                        return;
                    }
                    brokerInfoEx.goodbyeSent();
                }
            }
            this.c.unicast(brokerAddress, ClusterGoodbyeInfo.newInstance(this.c).getGPacket());
            if (DEBUG) {
                logger.log(8, "Sent GOODBYE to " + brokerAddress);
            }
        }
        catch (Exception exception) {
            logger.logStack(16, "Unable to send GOODBYE to " + brokerAddress, exception);
        }
    }

    private BrokerAddress[] getBrokerList() {
        return this.getBrokerList(null);
    }

    public BrokerAddress lookupBrokerAddress(String string) {
        if (!Globals.getHAEnabled()) {
            return null;
        }
        Iterator iterator = this.brokerList.keySet().iterator();
        BrokerAddress brokerAddress = null;
        while (iterator.hasNext()) {
            brokerAddress = (BrokerAddress)iterator.next();
            if (!brokerAddress.getBrokerID().equals(string)) continue;
            return brokerAddress;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerAddress[] getBrokerList(BrokerAddress brokerAddress) {
        BrokerAddress[] brokerAddressArray = null;
        Map map = this.brokerList;
        synchronized (map) {
            brokerAddressArray = brokerAddress == null || this.brokerList.get(brokerAddress) == null ? new BrokerAddress[this.brokerList.size()] : new BrokerAddress[this.brokerList.size() - 1];
            int n = 0;
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            BrokerAddress brokerAddress2 = null;
            while (iterator.hasNext()) {
                BrokerInfoEx brokerInfoEx = (BrokerInfoEx)iterator.next();
                brokerAddress2 = brokerInfoEx.getBrokerInfo().getBrokerAddr();
                if (brokerAddress != null && brokerAddress2.equals(brokerAddress)) continue;
                brokerAddressArray[n++] = brokerAddress2;
            }
        }
        return brokerAddressArray;
    }

    public boolean isTakeoverTarget(BrokerAddress brokerAddress) {
        if (!Globals.getHAEnabled()) {
            return false;
        }
        TakingoverEntry takingoverEntry = (TakingoverEntry)this.takingoverBrokers.get(new TakingoverEntry(brokerAddress.getBrokerID(), brokerAddress.getStoreSessionUID()));
        if (takingoverEntry == null) {
            return false;
        }
        return takingoverEntry.isTakeoverTarget(brokerAddress);
    }

    public void preTakeover(String string, UID uID, String string2, UID uID2) throws BrokerException {
        logger.log(8, br.getKString("B1175", "[brokerID=" + string + ", storeSession=" + uID + "]"));
        Long l = new Long(UniqueID.generateID(UID.getPrefix()));
        ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(string, uID, string2, uID2, l, true);
        TakingoverEntry takingoverEntry = TakingoverEntry.addTakingoverEntry(this.takingoverBrokers, clusterTakeoverInfo);
        this.myPretakeovers.put(takingoverEntry, l);
        this.takeoverCleanup(takingoverEntry, false);
        this.takeoverPendingConvergecast(null, clusterTakeoverInfo);
        takingoverEntry.preTakeoverDone(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverPendingConvergecast(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        if (!clusterTakeoverInfo.isFromTaker()) {
            return;
        }
        BrokerAddress[] brokerAddressArray = null;
        Map map = this.brokerList;
        synchronized (map) {
            brokerAddressArray = this.getBrokerList(brokerAddress);
            if (brokerAddressArray.length == 0) {
                this.sendTakeoverPendingReply(brokerAddress, clusterTakeoverInfo, 200, null);
                return;
            }
            this.takeoverPendingReplyTracker.addWaiter(clusterTakeoverInfo.getXid(), new TakeoverPendingReplyWaiter(brokerAddressArray));
        }
        try {
            try {
                for (int i = 0; i < brokerAddressArray.length; ++i) {
                    this.c.unicast(brokerAddressArray[i], clusterTakeoverInfo.getGPacket((short)39));
                }
            }
            catch (Exception exception) {
                logger.log(16, exception.getMessage());
            }
            ReplyStatus replyStatus = null;
            int n = 200;
            String string = null;
            try {
                replyStatus = this.takeoverPendingReplyTracker.waitForReply(clusterTakeoverInfo.getXid(), this.takeoverPendingReplyTimeout);
                if (replyStatus != null && replyStatus.getStatus() != 200) {
                    n = replyStatus.getStatus();
                    string = replyStatus.getReason();
                    Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), clusterTakeoverInfo.toString(), Status.getString(n), string};
                    logger.log(16, br.getKString("B2111", objectArray));
                }
            }
            catch (BrokerException brokerException) {
                n = brokerException.getStatusCode();
                string = brokerException.getMessage();
                Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), clusterTakeoverInfo.toString(), Status.getString(n), string};
                logger.log(16, br.getKString("B2112", objectArray));
            }
            this.sendTakeoverPendingReply(brokerAddress, clusterTakeoverInfo, n, string);
            Object var10_14 = null;
            this.takeoverPendingReplyTracker.removeWaiter(clusterTakeoverInfo.getXid());
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.takeoverPendingReplyTracker.removeWaiter(clusterTakeoverInfo.getXid());
            throw throwable;
        }
    }

    private void sendTakeoverPendingReply(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo, int n, String string) {
        if (brokerAddress != null && clusterTakeoverInfo.needReply()) {
            GPacket gPacket = clusterTakeoverInfo.getReplyGPacket((short)40, n, string);
            try {
                this.c.unicast(brokerAddress, gPacket);
            }
            catch (IOException iOException) {
                logger.logStack(16, "Unable send to " + brokerAddress + " TAKEOVER_PENDING reply " + ClusterTakeoverInfo.toString(gPacket), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverCleanup(TakingoverEntry takingoverEntry, boolean bl) {
        if (takingoverEntry.isTakeoverTarget(this.selfAddress)) {
            String string = br.getKString("B3187");
            logger.logStack(32, string, new BrokerException(string));
            Broker broker = Broker.getBroker();
            Globals.getBrokerStateHandler();
            broker.exit(BrokerStateHandler.getRestartCode(), string, BrokerEvent.Type.RESTART, null, true, true, true);
            return;
        }
        BrokerAddress brokerAddress = null;
        BrokerInfoEx[] brokerInfoExArray = this.brokerList.values().toArray(new BrokerInfoEx[0]);
        for (int i = 0; i < brokerInfoExArray.length; ++i) {
            brokerAddress = brokerInfoExArray[i].getBrokerInfo().getBrokerAddr();
            if (!takingoverEntry.isTakeoverTarget(brokerAddress)) continue;
            if (bl) {
                logger.log(16, "Force closing broker link to " + brokerAddress + " because it has been TAKEOVER");
            } else {
                logger.log(16, "Force closing broker link to " + brokerAddress + " because it is being TAKEOVER");
            }
            this.c.closeLink(brokerAddress, true);
            BrokerInfoEx brokerInfoEx = brokerInfoExArray[i];
            synchronized (brokerInfoEx) {
                while (!brokerInfoExArray[i].deactivated()) {
                    logger.log(8, "Waiting for broker link to " + brokerAddress + " deactivated ..");
                    try {
                        brokerInfoExArray[i].wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
        }
    }

    public void postTakeover(String string, UID uID, boolean bl) {
        if (bl) {
            logger.log(8, br.getKString("B1176", "[brokerID=" + string + ", storeSession=" + uID + "]"));
            Long l = (Long)this.myPretakeovers.get(new TakingoverEntry(string, uID));
            if (l == null) {
                logger.log(16, Globals.getBrokerResources().getKString("B2206", "[brokerID=" + string + ", storeSession=" + uID + "]"));
                return;
            }
            ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(string, uID, null, null, l, true);
            GPacket gPacket = null;
            try {
                gPacket = clusterTakeoverInfo.getGPacket((short)43);
                this.c.broadcast(gPacket);
            }
            catch (Exception exception) {
                if (gPacket == null) {
                    logger.logStack(32, "B3100", exception);
                }
                logger.logStack(16, "Unable to broadcast TAKEOVER_ABORT " + ClusterTakeoverInfo.newInstance(gPacket), exception);
            }
            this.receivedTakeoverAbort(null, clusterTakeoverInfo);
            return;
        }
        try {
            ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(string, uID);
            logger.log(8, br.getKString("B1177", "[brokerID=" + string + ", storeSession=" + uID + "]"));
            this.receivedTakeoverComplete(null, clusterTakeoverInfo);
            this.c.broadcast(clusterTakeoverInfo.getGPacket((short)41));
        }
        catch (Exception exception) {
            logger.logStack(16, "Broadcast TAKEOVER_COMPLETE got exception", exception);
        }
    }

    public void receivedTakeoverComplete(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        Object[] objectArray;
        if (brokerAddress != null) {
            objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(41), "[" + clusterTakeoverInfo + "]", brokerAddress};
            logger.log(8, br.getKString("B1178", objectArray));
        }
        if ((objectArray = TakingoverEntry.takeoverComplete(this.takingoverBrokers, clusterTakeoverInfo)) == null) {
            return;
        }
        TakeoverCleanupThread takeoverCleanupThread = new TakeoverCleanupThread(this.takeoverCleanupTG, this, brokerAddress, clusterTakeoverInfo, (TakingoverEntry)objectArray, 41);
        takeoverCleanupThread.start();
    }

    public void receivedTakeoverPending(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        Object[] objectArray;
        TakingoverEntry takingoverEntry = TakingoverEntry.addTakingoverEntry(this.takingoverBrokers, clusterTakeoverInfo);
        if (takingoverEntry != null || DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_TAKEOVER) {
            objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(39), "[" + clusterTakeoverInfo + "]", brokerAddress};
            logger.log(8, br.getKString("B1178", objectArray));
        }
        if (takingoverEntry == null || this.getBrokerList(brokerAddress).length == 0) {
            this.sendTakeoverPendingReply(brokerAddress, clusterTakeoverInfo, 200, null);
            return;
        }
        objectArray = new TakeoverCleanupThread(this.takeoverCleanupTG, this, brokerAddress, clusterTakeoverInfo, takingoverEntry, 39);
        objectArray.start();
    }

    public void receivedTakeoverPendingReply(BrokerAddress brokerAddress, GPacket gPacket) {
        Object[] objectArray;
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_TAKEOVER) {
            objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), "[" + ClusterTakeoverInfo.toString(gPacket) + "]", brokerAddress};
            logger.log(8, br.getKString("B1173", objectArray));
        }
        if ((objectArray = ClusterTakeoverInfo.getReplyXid(gPacket)) == null) {
            logger.log(32, "B3100", "Received takeover reply without correlation ID from " + brokerAddress + " : " + ClusterTakeoverInfo.toString(gPacket));
            return;
        }
        if (!this.takeoverPendingReplyTracker.notifyReply((Long)objectArray, brokerAddress, gPacket)) {
            Object[] objectArray2 = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), "[" + ClusterTakeoverInfo.toString(gPacket) + "]", brokerAddress};
            logger.log(16, br.getKString("B2114", objectArray2));
        }
    }

    public void receivedTakeoverAbort(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        if (brokerAddress != null) {
            Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(43), "[" + clusterTakeoverInfo + "]", brokerAddress};
            logger.log(8, br.getKString("B1178", objectArray));
        }
        TakingoverEntry.removeTakingoverEntry(this.takingoverBrokers, clusterTakeoverInfo);
        this.takeoverPendingReplyTracker.abortWaiter(clusterTakeoverInfo.getXid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardTakeoverBrokers(BrokerAddress brokerAddress, boolean bl) {
        if (!Globals.getHAEnabled()) {
            return;
        }
        if (bl) {
            TakingoverEntry takingoverEntry2 = null;
            GPacket[] gPacketArray = null;
            Map map = this.takingoverBrokers;
            synchronized (map) {
                for (TakingoverEntry takingoverEntry2 : this.takingoverBrokers.keySet()) {
                    gPacketArray = takingoverEntry2.getGPackets();
                    for (int i = 0; i < gPacketArray.length; ++i) {
                        try {
                            this.c.unicast(brokerAddress, gPacketArray[i]);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            return;
        }
        TakingoverEntry takingoverEntry = (TakingoverEntry)this.takingoverBrokers.get(new TakingoverEntry(brokerAddress.getBrokerID(), brokerAddress.getStoreSessionUID()));
        if (takingoverEntry == null) {
            return;
        }
        GPacket gPacket = takingoverEntry.getGPacket(brokerAddress);
        if (gPacket == null) {
            return;
        }
        try {
            this.c.unicastAndClose(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initConfigServer() {
        Object[] objectArray;
        this.isMasterBroker = true;
        logger.log(8, "B1069");
        boolean bl = false;
        BrokerAddress brokerAddress = this.getLastConfigServer();
        BrokerMQAddress brokerMQAddress = this.selfAddress.getMQAddress();
        if (brokerAddress != null) {
            objectArray = brokerAddress.getMQAddress();
            if (!this.selfAddress.equals(brokerAddress) && brokerMQAddress.getHost().getCanonicalHostName().equals(objectArray.getHost().getCanonicalHostName()) && this.selfAddress.getInstanceName().equals(brokerAddress.getInstanceName())) {
                logger.log(8, br.getKString("B1226", brokerAddress, this.selfAddress));
                bl = true;
            }
        }
        try {
            objectArray = this.store.getAllConfigRecords();
            byte[] byArray = RaptorProtocol.prepareResetPersistenceRecord();
            if (((ArrayList)objectArray[1]).size() == 0) {
                logger.log(8, "B1068");
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            } else if (bl) {
                ArrayList arrayList = this.compressConfigRecords(objectArray);
                this.store.clearAllConfigChangeRecords(false);
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
                ChangeRecord changeRecord = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    changeRecord = (ChangeRecord)arrayList.get(i);
                    if (changeRecord.discard) continue;
                    this.store.storeConfigChangeRecord(System.currentTimeMillis(), changeRecord.getBytes(), false);
                }
            }
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Master broker initialization failed.", (Throwable)exception);
        }
    }

    public void reloadCluster() {
        logger.log(8, "B1074");
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)27);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.c.reloadCluster();
    }

    public void stopMessageFlow() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = true;
        this.sendFlowControlUpdate(null);
    }

    public void resumeMessageFlow() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = false;
        this.sendFlowControlUpdate(null);
    }

    private void sendFlowControlUpdate(BrokerAddress brokerAddress) {
        GPacket gPacket = GPacket.getInstance();
        if (this.flowStopped) {
            gPacket.setType((short)23);
        } else {
            gPacket.setType((short)25);
        }
        try {
            if (brokerAddress == null) {
                this.c.broadcast(gPacket);
            } else {
                this.c.unicast(brokerAddress, gPacket);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean waitForConfigSync() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            return true;
        }
        if (brokerAddress == null) {
            return false;
        }
        if (brokerAddress.equals(this.selfAddress)) {
            return false;
        }
        return !this.configSyncComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(PacketReference packetReference, Collection collection, boolean bl) {
        ArrayList<Object> arrayList;
        Cloneable cloneable;
        Serializable serializable;
        HashMap<Cloneable, ArrayList<Object>> hashMap = new HashMap<Cloneable, ArrayList<Object>>();
        if (DEBUG) {
            logger.log(2, "MessageBus: sending message {0} to {1} targets.", (Object)packetReference.getSysMessageID(), Integer.toString(collection.size()));
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        for (Object object : collection) {
            ConsumerUID object2 = ((Consumer)object).getConsumerUID();
            serializable = ((Consumer)object).getStoredConsumerUID();
            try {
                packetReference.delivered(object2, (ConsumerUID)serializable, object2.isUnsafeAck(), true);
            }
            catch (Exception exception) {
                logger.logStack(16, "B3100", "saving redeliver flag for " + packetReference.getSysMessageID() + " to " + object2, (Throwable)exception);
            }
            cloneable = ((Consumer)object).getConsumerUID().getBrokerAddress();
            arrayList = (ArrayList)hashMap.get(cloneable);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(cloneable, arrayList);
            }
            arrayList.add(object);
            stringBuffer.append("\t").append(((Consumer)object).toString()).append("\n");
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Local Targets = {0}", stringBuffer);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            serializable = (BrokerAddress)entry.getKey();
            cloneable = (ArrayList)entry.getValue();
            arrayList = ClusterMessageInfo.newInstance(packetReference, (ArrayList)cloneable, bl, this.c);
            try {
                Map map = this.brokerList;
                synchronized (map) {
                    BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(serializable);
                    if (brokerInfoEx == null) {
                        throw new BrokerException("NOTFOUND: Could not deliver message " + ((ClusterMessageInfo)((Object)arrayList)).toString() + " to " + serializable);
                    }
                    if (brokerInfoEx.sentGoodbye()) {
                        throw new BrokerException("GOODBYE: Could not deliver message " + ((ClusterMessageInfo)((Object)arrayList)).toString() + " to " + serializable);
                    }
                }
                this.c.unicast((BrokerAddress)serializable, ((ClusterMessageInfo)((Object)arrayList)).getGPacket(), true);
                if (!DEBUG) continue;
                logger.log(1, "MessageBus: Broker {0} Targets = {1}", (Object)serializable, stringBuffer + ((ClusterMessageInfo)((Object)arrayList)).toString());
            }
            catch (Exception exception) {
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    ConsumerUID consumerUID = ((Consumer)((ArrayList)cloneable).get(i)).getConsumerUID();
                    try {
                        this.cb.processRemoteAck(packetReference.getSysMessageID(), consumerUID, 1, null);
                        continue;
                    }
                    catch (BrokerException brokerException) {
                        logger.log(16, brokerException.getMessage(), brokerException);
                    }
                }
                if (!DEBUG) continue;
                logger.log(1, "RaptorProtocol: Could not deliver message to broker {0}", serializable);
            }
        }
    }

    public void sendMessageAck(BrokerAddress brokerAddress, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, Map map, boolean bl) throws BrokerException {
        block3: {
            SysMessageID[] sysMessageIDArray = new SysMessageID[]{sysMessageID};
            ConsumerUID[] consumerUIDArray = new ConsumerUID[]{consumerUID};
            if (bl) {
                this.sendMessageAcks(brokerAddress, sysMessageIDArray, consumerUIDArray, n, map, null, bl, false);
                return;
            }
            try {
                this.sendMessageAcks(brokerAddress, sysMessageIDArray, consumerUIDArray, n, map, null, bl, false);
            }
            catch (BrokerException brokerException) {
                if (!DEBUG_CLUSTER_MSG) break block3;
                logger.logStack(16, "Acknowledge (type=" + ClusterGlobals.getAckTypeString(n) + ")" + " message [" + sysMessageID + ":" + consumerUID + "] failed", brokerException);
            }
        }
    }

    public void sendMessageAck2P(BrokerAddress brokerAddress, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Map map, Long l, boolean bl) throws BrokerException {
        this.sendMessageAcks(brokerAddress, sysMessageIDArray, consumerUIDArray, n, map, l, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageAcks(BrokerAddress brokerAddress, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Map map, Long l, boolean bl, boolean bl2) throws BrokerException {
        if (this.fi.FAULT_INJECTION) {
            ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, "msg.remote_ack.p.", "1");
        }
        Long l2 = null;
        if (bl) {
            l2 = this.ackackTracker.addWaiter(new MessageAckReplyWaiter(brokerAddress));
        }
        ClusterMessageAckInfo clusterMessageAckInfo = ClusterMessageAckInfo.newInstance(sysMessageIDArray, consumerUIDArray, n, l2, map, l, brokerAddress, this.c, bl2);
        if (DEBUG) {
            logger.log(1, "MessageBus: Sending message ack: " + clusterMessageAckInfo.toString());
        }
        try {
            block35: {
                try {
                    Object object;
                    Object object2 = this.brokerList;
                    synchronized (object2) {
                        object = (BrokerInfoEx)this.brokerList.get(brokerAddress);
                        if (object == null && brokerAddress != Globals.getMyAddress()) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4249", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        if (object != null && (((BrokerInfoEx)object).sentGoodbye() || ((BrokerInfoEx)object).gotGoodbye())) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4247", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        if (this.isTakeoverTarget(brokerAddress)) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4244", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        this.c.unicast(brokerAddress, clusterMessageAckInfo.getGPacket());
                        if (this.fi.FAULT_INJECTION) {
                            ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, "msg.remote_ack.p.", "2");
                        }
                    }
                    if (!bl) break block35;
                    object2 = null;
                    try {
                        object2 = this.ackackTracker.waitForReply(l2, this.ackTimeout);
                    }
                    catch (BrokerException brokerException) {
                        if (brokerException.getStatusCode() == 410) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4245", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        if (brokerException.getStatusCode() == 408) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4285", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        throw brokerException;
                    }
                    if (((ReplyStatus)object2).getStatus() != 200) {
                        logger.log(16, br.getKString("B2117", brokerAddress, ClusterMessageAckInfo.toString(((ReplyStatus)object2).getReply())));
                        object = ClusterMessageAckInfo.getAckEntryNotFoundException(((ReplyStatus)object2).getReply());
                        if (object != null) {
                            throw object;
                        }
                        throw new BrokerException(((ReplyStatus)object2).getReason(), ((ReplyStatus)object2).getStatus());
                    }
                    if (!this.fi.FAULT_INJECTION) break block35;
                    if (n == 9) {
                        object = this.fi;
                        synchronized (object) {
                            if (this.fi.checkFault("msg.remote_ack.p.txnprepare.3_1", null)) {
                                this.fi.unsetFault("msg.remote_ack.p.txnprepare.3_1");
                                BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4285", clusterMessageAckInfo.toString(), brokerAddress), 410);
                                brokerDownException.setRemote(true);
                                brokerDownException.setRemoteBrokerAddress(brokerAddress);
                                throw brokerDownException;
                            }
                        }
                    }
                    ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, "msg.remote_ack.p.", "3");
                }
                catch (Exception exception) {
                    if (exception instanceof BrokerDownException) {
                        throw (BrokerException)exception;
                    }
                    Map map2 = this.brokerList;
                    synchronized (map2) {
                        BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
                        if (brokerInfoEx == null && brokerAddress != Globals.getMyAddress()) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4249", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        if (brokerInfoEx != null && (brokerInfoEx.sentGoodbye() || brokerInfoEx.gotGoodbye())) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4247", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                        if (this.isTakeoverTarget(brokerAddress)) {
                            BrokerDownException brokerDownException = new BrokerDownException(br.getKString("B4244", clusterMessageAckInfo.toString(), brokerAddress), 410);
                            brokerDownException.setRemote(true);
                            brokerDownException.setRemoteBrokerAddress(brokerAddress);
                            throw brokerDownException;
                        }
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    throw new BrokerException(exception.getMessage(), exception, 500);
                }
            }
            Object var18_28 = null;
            if (bl) {
                this.ackackTracker.removeWaiter(l2);
            }
        }
        catch (Throwable throwable) {
            Object var18_29 = null;
            if (bl) {
                this.ackackTracker.removeWaiter(l2);
            }
            throw throwable;
        }
    }

    public void receivedMessageAckReply(BrokerAddress brokerAddress, GPacket gPacket) {
        Long l = ClusterMessageAckInfo.getAckAckXid(gPacket);
        if (l == null) {
            try {
                if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                    logger.log(16, "B3100", "Received message ack reply without correlation ID from " + brokerAddress + " : " + ClusterMessageAckInfo.toString(gPacket));
                } else {
                    logger.log(32, "B3100", "Received message ack reply without correlation ID from " + brokerAddress + " : " + ClusterMessageAckInfo.toString(gPacket));
                }
            }
            catch (Exception exception) {
                logger.log(16, "XXXI18n-Unable to get cluster version to process message ack reply" + ClusterMessageAckInfo.toString(gPacket) + ": " + exception.getMessage() + " from " + brokerAddress);
            }
            return;
        }
        if (!this.ackackTracker.notifyReply(l, brokerAddress, gPacket)) {
            Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(4), "[" + ClusterMessageAckInfo.toString(gPacket) + "]", brokerAddress};
            logger.log(16, br.getKString("B2114", objectArray));
        }
    }

    public static byte[] prepareResetPersistenceRecord() {
        if (DEBUG) {
            Globals.getLogger().log(4, "RaptorProtocol.prepareResetPersistenceRecord");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)31);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void sendNewInterestUpdate(Consumer consumer) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewInterestUpdate : " + consumer.toString());
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(consumer, this.c);
        try {
            this.c.broadcast(clusterConsumerInfo.getGPacket((short)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendNewInterestUpdate(BrokerAddress brokerAddress, Collection collection) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewInterestUpdate to " + brokerAddress);
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(collection, this.c);
        try {
            this.c.unicast(brokerAddress, clusterConsumerInfo.getGPacket((short)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendAttachDurable(BrokerAddress brokerAddress, Subscription subscription, Consumer consumer) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendAttachDurable : " + subscription.getDurableName() + ":" + subscription.getClientID() + " --- " + consumer + (brokerAddress == null ? "" : "to " + brokerAddress));
        }
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription, consumer, this.c);
        try {
            if (brokerAddress == null) {
                this.c.broadcast(clusterSubscriptionInfo.getGPacket((short)35));
            } else {
                this.c.unicast(brokerAddress, clusterSubscriptionInfo.getGPacket((short)35));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendRemDurableUpdate(Consumer consumer) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendRemDurableUpdate : " + consumer);
        }
        Subscription subscription = null;
        subscription = consumer instanceof Subscription ? (Subscription)consumer : consumer.getSubscription();
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
        try {
            this.c.broadcast(clusterSubscriptionInfo.getGPacket((short)7, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInterestUpdate(Consumer consumer, int n) {
        this.sendInterestUpdate(consumer, n, null, false);
    }

    private void sendInterestUpdate(Consumer consumer, int n, Map map, boolean bl) {
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(consumer, map, bl, this.c);
        Object[] objectArray = this.getBrokerList();
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendInterestUpdate. consumer=" + consumer + ", cleanup=" + bl + ", subtype=" + ProtocolGlobals.getInterestUpdateSubTypeString(n) + ", pendingmsgs=" + map + " to brokers " + Arrays.toString(objectArray));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                this.c.unicast(objectArray[i], clusterConsumerInfo.getGPacket((short)9, n, objectArray[i]));
                continue;
            }
            catch (IOException iOException) {
                logger.logStack(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(9) + "[" + ProtocolGlobals.getInterestUpdateSubTypeString(n) + "]", objectArray[i]), iOException);
            }
        }
    }

    private void sendInterestUpdate(BrokerAddress brokerAddress, Collection collection, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendInterestUpdate. to = " + brokerAddress);
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(collection, this.c);
        try {
            this.c.unicast(brokerAddress, clusterConsumerInfo.getGPacket((short)9, n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendClientClosedUpdate(ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendClientClosedUpdate. conid = " + connectionUID);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)21);
        gPacket.putProp("I", new Long(connectionUID.longValue()));
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientClosed(ConnectionUID connectionUID, boolean bl) {
        Object object;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.clientClosed. conid = " + connectionUID);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            object = this.resTable.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                if (!connectionUID.equals(resource.getOwner())) continue;
                arrayList.add(string);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            this.unlockResource((String)object);
        }
        if (bl) {
            this.sendClientClosedUpdate(connectionUID);
            this.cbDispatcher.clientDown(connectionUID);
        }
    }

    public int lockSharedResource(String string, ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", owner = " + connectionUID);
        }
        return this.lockResource(string, 0L, connectionUID, true);
    }

    public int lockResource(String string, ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", owner = " + connectionUID);
        }
        return this.lockResource(string, 0L, connectionUID);
    }

    public int lockResource(String string, long l, ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", timestamp = " + l + ", owner = " + connectionUID);
        }
        return this.lockResource(string, l, connectionUID, false);
    }

    private int lockResource(String string, long l, ConnectionUID connectionUID, boolean bl) {
        boolean bl2 = string.startsWith("destCreate:");
        int n = 1;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.tryLockResource(string, l, connectionUID, bl, bl2)) == 0 || n3 == 1) {
                if (DEBUG) {
                    logger.log(4, "Lock resId = " + string + "returned : " + n3);
                }
                return n3;
            }
            if (++n2 == 10) break;
            int n4 = this.r.nextInt(n *= 2);
            try {
                Thread.sleep(n4 * 1000);
            }
            catch (Exception exception) {}
        }
        logger.log(16, "B2034", string);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryLockResource(String string, long l, ConnectionUID connectionUID, boolean bl, boolean bl2) {
        Resource resource;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.tryLockResource.resId = " + string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
            if (resource != null) {
                if (bl && resource.getShared()) {
                    return 0;
                }
                return 1;
            }
            resource = new Resource(string, this.c);
            resource.setShared(bl);
            resource.setOwner(connectionUID);
            if (l != 0L) {
                resource.setTimestamp(l);
            }
            this.resTable.put(string, resource);
        }
        resource.setLockState(0);
        block15: while (true) {
            if (DEBUG) {
                logger.log(4, "MessageBus: Trying to lock resource {0}", string);
            }
            int n = 0;
            if (this.brokerList.size() > 0) {
                this.sendLockRequest(resource);
                n = resource.waitForStatusChange(this.lockTimeout, bl2);
            } else {
                n = 0;
            }
            if (DEBUG) {
                logger.log(4, "MessageBus: Lock attempt status = {0} for resource {1}", (Object)Integer.toString(n), string);
            }
            switch (n) {
                case 0: {
                    resource.setLockState(1);
                    return n;
                }
                case 1: 
                case 2: {
                    HashMap hashMap2 = this.resTable;
                    synchronized (hashMap2) {
                        this.resTable.remove(string);
                    }
                    return n;
                }
                case -1: {
                    logger.log(16, "B2062", (Object)resource.getResId(), resource.showRecipients());
                    HashMap hashMap3 = this.resTable;
                    synchronized (hashMap3) {
                        this.resTable.remove(string);
                    }
                    return 1;
                }
                case 3: {
                    if (!DEBUG_CLUSTER_ALL && !DEBUG_CLUSTER_LOCK) continue block15;
                    logger.log(4, "Active brokerlist changed. Restarting Lock election for {0}." + resource.getResId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockResource(String string) {
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            logger.log(4, "MessageBus: Unlocking resource = {0}", string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Resource resource = (Resource)this.resTable.remove(string);
            if (resource != null) {
                resource.impliedFailure();
            }
        }
    }

    private void sendLockRequest(Resource resource) {
        Object object;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendLockRequest");
        }
        long l = System.currentTimeMillis();
        BrokerAddress[] brokerAddressArray = this.getBrokerList();
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            object = "";
            for (int i = 0; i < brokerAddressArray.length; ++i) {
                object = (String)object + "\n\t" + brokerAddressArray[i];
            }
            logger.log(4, "Sending resource lock request for : " + resource.getResId() + "\nExpecting responses from : " + (String)object);
        }
        resource.prepareLockRequest(brokerAddressArray, l);
        object = GPacket.getInstance();
        ((GPacket)object).setType((short)11);
        ((GPacket)object).putProp("I", resource.getResId());
        ((GPacket)object).putProp("TS", new Long(resource.getTimestamp()));
        ((GPacket)object).putProp("X", new Long(l));
        ((GPacket)object).putProp("SH", resource.getShared());
        try {
            this.c.broadcast((GPacket)object);
        }
        catch (Exception exception) {
            logger.log(8, "Unexpected protocol exception broadcasing msgs", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockRequest(BrokerAddress brokerAddress, String string, long l, long l2, boolean bl) {
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveLockRequest. resId = " + string + ", xid = " + l2);
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null || bl && resource.getShared()) {
            n = 0;
        } else if (resource.getLockState() == 1) {
            n = 1;
        } else if (l < resource.getTimestamp()) {
            resource.impliedFailure();
            n = 0;
        } else {
            n = l > resource.getTimestamp() ? 1 : 2;
        }
        this.sendLockResponse(brokerAddress, string, l2, n);
    }

    private void sendLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendLockResponse. resId = " + string + ", xid = " + l + "to = " + brokerAddress + ", response = " + n);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)12);
        gPacket.putProp("I", string);
        gPacket.putProp("X", new Long(l));
        gPacket.putProp("S", new Integer(n));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            logger.log(16, br.getString("B2101", string, brokerAddress.toString()), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveLockResponse. resId = " + string + ", xid = " + l + "from = " + brokerAddress + ", response = " + n);
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null) {
            return;
        }
        if ((DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) && resource.getXid() == l) {
            logger.log(4, "Received Lock Response.\n\tSender = " + brokerAddress + "\n\tResource = " + resource.getResId() + "\n\tResponse = " + ProtocolGlobals.lockResponseStrings[n]);
        }
        resource.consumeResponse(l, brokerAddress, n);
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        ClusterDestInfo clusterDestInfo;
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordUpdateDestination");
        }
        if ((n = this.recordConfigChangeEvent((clusterDestInfo = ClusterDestInfo.newInstance(destination)).getGPacket((short)13, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "UPDATE_DESTINATION[" + destination.getDestinationName() + "]"));
        }
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        ClusterDestInfo clusterDestInfo;
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordRemoveDestination");
        }
        if ((n = this.recordConfigChangeEvent((clusterDestInfo = ClusterDestInfo.newInstance(destination)).getGPacket((short)15, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "REM_DESTINATION[" + destination.getDestinationName() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordConfigChangeEvent(GPacket gPacket) throws BrokerException {
        BrokerAddress brokerAddress;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordConfigChangeEvent");
        }
        if (DEBUG) {
            logger.log(1, "Event = " + gPacket.toLongString());
        }
        if ((brokerAddress = this.c.getConfigServer()) == null) {
            return 1;
        }
        Long l = new Long(UniqueID.generateID(UID.getPrefix()));
        EventLogWaiter eventLogWaiter = new EventLogWaiter(0);
        this.eventLogWaiters.put(l, eventLogWaiter);
        try {
            EventLogWaiter eventLogWaiter2 = eventLogWaiter;
            synchronized (eventLogWaiter2) {
                this.sendConfigChangeEvent(l, gPacket);
                while (eventLogWaiter.getStatus() == 0) {
                    try {
                        logger.log(8, br.getString("B1265", brokerAddress.toString()));
                        eventLogWaiter.wait(60000L);
                    }
                    catch (Exception exception) {}
                }
                if (eventLogWaiter.getStatus() == 1) {
                    this.storeDirtyFlag = true;
                }
                return eventLogWaiter.getStatus();
            }
        }
        catch (BrokerException brokerException) {
            this.eventLogWaiters.remove(l);
            if (DEBUG) {
                logger.logStack(16, brokerException.getMessage() + ": " + gPacket.toLongString(), brokerException);
            }
            throw brokerException;
        }
    }

    private void sendConfigChangeEvent(Long l, GPacket gPacket) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangeEvent. xid = " + l);
        }
        BrokerAddress brokerAddress = this.c.getConfigServer();
        GPacket gPacket2 = GPacket.getInstance();
        gPacket2.setType((short)17);
        gPacket2.putProp("X", l);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket2.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, gPacket2);
        }
        catch (Exception exception) {
            throw new BrokerException(br.getKString("B4094"), "B4094", null, 403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangeEvent(BrokerAddress brokerAddress, Long l, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangeEvent. xid = " + l);
        }
        boolean bl = false;
        try {
            ChangeRecord changeRecord;
            if (Globals.nowaitForMasterBroker() && (changeRecord = ChangeRecord.makeChangeRecord(byArray)).getOperation() == 15 && DestType.isQueue(((DestinationUpdateChangeRecord)changeRecord).getType())) {
                Object[] objectArray;
                Object object;
                HashSet<Object[]> hashSet = new HashSet<Object[]>();
                Object object2 = this.brokerList;
                synchronized (object2) {
                    object = this.brokerList.keySet().iterator();
                    while (object.hasNext()) {
                        objectArray = ((BrokerAddress)object.next()).getMQAddress();
                        hashSet.add(objectArray);
                    }
                }
                object2 = Globals.getClusterManager().getConfigBrokers();
                object = null;
                while (object2.hasNext()) {
                    object = (ClusteredBroker)object2.next();
                    if (hashSet.contains(object.getBrokerURL()) || object.isLocalBroker()) continue;
                    objectArray = new String[]{((DestinationUpdateChangeRecord)changeRecord).getName(), brokerAddress.toString(), ServiceRestriction.NO_SYNC_WITH_MASTERBROKER.toString(), object.getBrokerURL().toString()};
                    bl = true;
                    throw new BrokerException(br.getKString("B4289", objectArray));
                }
            }
            this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            this.sendConfigChangeEventAck(brokerAddress, l, 1);
        }
        catch (Exception exception) {
            if (bl) {
                logger.log(32, exception.getMessage(), exception);
            } else {
                logger.logStack(32, exception.getMessage(), exception);
            }
            this.sendConfigChangeEventAck(brokerAddress, l, 2);
            return;
        }
    }

    private void sendConfigChangeEventAck(BrokerAddress brokerAddress, Long l, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangeEventAck. xid = " + l);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)18);
        gPacket.putProp("X", l);
        gPacket.putProp("S", new Integer(n));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            logger.log(1, "Unable to unicast message ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangeEventReply(BrokerAddress brokerAddress, Long l, int n) {
        EventLogWaiter eventLogWaiter;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangeEventAck. xid = " + l);
        }
        if ((eventLogWaiter = (EventLogWaiter)this.eventLogWaiters.remove(l)) == null) {
            Object[] objectArray = new String[]{String.valueOf(l), String.valueOf(n)};
            logger.log(16, "B2107", objectArray);
            return;
        }
        EventLogWaiter eventLogWaiter2 = eventLogWaiter;
        synchronized (eventLogWaiter2) {
            eventLogWaiter.setStatus(n);
            eventLogWaiter.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangesRequest. timestamp = " + l);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)19);
        gPacket.putProp("TS", new Long(l));
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            try {
                this.c.unicast(brokerAddress, gPacket);
                ++this.cfgSrvRequestCount;
                this.cfgSrvRequestErr = false;
            }
            catch (Exception exception) {
                this.cfgSrvRequestCount = 0;
                this.cfgSrvRequestErr = true;
                this.cfgSrvWaitObject.notifyAll();
            }
        }
    }

    public void receiveConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangesRequest. from = " + brokerAddress);
        }
        try {
            ArrayList arrayList = this.store.getConfigChangeRecordsSince(l);
            long l2 = System.currentTimeMillis();
            this.sendConfigChangesResponse(brokerAddress, l2, arrayList);
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Could not send config change response..", (Throwable)exception);
            return;
        }
    }

    private void sendConfigChangesResponse(BrokerAddress brokerAddress, long l, ArrayList arrayList) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangesResponse. to = " + brokerAddress);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)20);
        gPacket.putProp("TS", new Long(l));
        gPacket.putProp("C", new Integer(arrayList.size()));
        gPacket.putProp("S", new Integer(200));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = (byte[])arrayList.get(i);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            logger.log(1, "Exception in unicast ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangesReply(BrokerAddress brokerAddress, long l, int n, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangesResponse.");
        }
        boolean bl = false;
        BrokerAddress brokerAddress2 = this.getLastConfigServer();
        if (brokerAddress2 != null && !brokerAddress2.equals(brokerAddress)) {
            bl = true;
            if (n == 0) {
                logger.log(32, "B3095");
                Broker.getBroker().exit(1, br.getString("B3095"), BrokerEvent.Type.FATAL_ERROR);
            }
        }
        DataInputStream dataInputStream = null;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
        }
        try {
            boolean bl2 = false;
            ArrayList<GPacket> arrayList = null;
            for (int i = 0; i < n; ++i) {
                GPacket gPacket = GPacket.getInstance();
                gPacket.read(dataInputStream);
                if (i == 0) {
                    if (gPacket.getType() == 31) {
                        bl2 = true;
                        arrayList = new ArrayList<GPacket>();
                    }
                    if (bl && !bl2) {
                        logger.log(32, "B3095");
                        Broker.getBroker().exit(1, br.getString("B3095"), BrokerEvent.Type.FATAL_ERROR);
                    }
                }
                if (bl2) {
                    arrayList.add(gPacket);
                    continue;
                }
                this.receiveBroadcast(brokerAddress, gPacket);
            }
            if (bl2) {
                this.applyPersistentStateChanges(brokerAddress, arrayList);
            }
            if (!this.configSyncComplete) {
                this.configSyncComplete = true;
                this.cbDispatcher.configSyncComplete();
                this.sendGetInterestUpdate(brokerAddress);
                logger.log(8, "B1075");
            }
            Object object = this.cfgSrvWaitObject;
            synchronized (object) {
                --this.cfgSrvRequestCount;
                if (this.cfgSrvRequestCount == 0) {
                    this.cfgSrvWaitObject.notifyAll();
                }
            }
            this.storeLastRefreshTime(l - 120000L);
            this.storeLastConfigServer(brokerAddress);
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Error while applying the config changes...", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitConfigChangesResponse() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.waitConfigChangesResponse.");
        }
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            while (this.cfgSrvRequestCount > 0) {
                try {
                    this.cfgSrvWaitObject.wait();
                }
                catch (Exception exception) {}
            }
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.waitConfigChangesResponse returning :" + !this.cfgSrvRequestErr);
            }
            return !this.cfgSrvRequestErr;
        }
    }

    private void applyPersistentStateChanges(BrokerAddress brokerAddress, ArrayList arrayList) throws Exception {
        Object object;
        Object object2;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.applyPersistentStateChanges.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<DestinationUID, Serializable> hashMap2 = new HashMap<DestinationUID, Serializable>();
        Set set = Subscription.getAllSubscriptions(null);
        for (Serializable serializable : set) {
            object2 = ((Consumer)serializable).getConsumerUID();
            object = ((Subscription)serializable).getDurableName() + ":" + ((Subscription)serializable).getClientID();
            hashMap.put((String)object, object2);
        }
        set = null;
        Iterator<Object> iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            Serializable serializable;
            serializable = (Destination)iterator.next();
            if (((Destination)serializable).isAutoCreated() || ((Destination)serializable).isInternal() || ((Destination)serializable).isTemporary() || ((Destination)serializable).isDMQ()) continue;
            hashMap2.put(((Destination)serializable).getDestinationUID(), serializable);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            object2 = (GPacket)arrayList.get(i);
            if (((GPacket)object2).getType() == 31) {
                if (!DEBUG) continue;
                logger.log(4, "applyPersistentStateChanges : RESET_PERSISTENCE");
                continue;
            }
            if (((GPacket)object2).getType() == 5 || ((GPacket)object2).getType() == 7) {
                this.receiveBroadcast(brokerAddress, (GPacket)object2);
                object = ClusterSubscriptionInfo.newInstance((GPacket)object2);
                string = ((ClusterSubscriptionInfo)object).getDurableName() + ":" + ((ClusterSubscriptionInfo)object).getClientID();
                hashMap.remove(string);
                if (!DEBUG) continue;
                if (((GPacket)object2).getType() == 5) {
                    logger.log(4, "Added subscription : " + string);
                    continue;
                }
                logger.log(4, "Remove subscription : " + string);
                continue;
            }
            if (((GPacket)object2).getType() != 13 && ((GPacket)object2).getType() != 15) continue;
            object = ClusterDestInfo.newInstance((GPacket)object2);
            string = ((ClusterDestInfo)object).getDestName();
            int n = ((ClusterDestInfo)object).getDestType();
            DestinationUID destinationUID = DestinationUID.getUID(string, DestType.isQueue(n));
            Destination destination = (Destination)hashMap2.get(destinationUID);
            if (((GPacket)object2).getType() == 13 && destination != null && destination.getType() != n) {
                DestinationUID destinationUID2 = DestinationUID.getUID(destination.getDestinationName(), DestType.isQueue(destination.getType()));
                this.cbDispatcher.notifyDestroyDestination(destinationUID2);
            }
            this.receiveBroadcast(brokerAddress, (GPacket)object2);
            hashMap2.remove(destinationUID);
            if (!DEBUG) continue;
            if (((GPacket)object2).getType() == 13) {
                logger.log(4, "Updated destination : " + destinationUID);
                continue;
            }
            logger.log(4, "Removed destination : " + destinationUID);
        }
        for (ConsumerUID consumerUID : hashMap.values()) {
            object2 = Consumer.getConsumer(consumerUID);
            if (object2 == null) continue;
            this.cbDispatcher.interestRemoved((Consumer)object2, null, false);
            if (!DEBUG) continue;
            logger.log(4, "Removed stale subscription : " + object2);
        }
        for (DestinationUID destinationUID : hashMap2.keySet()) {
            this.cbDispatcher.notifyDestroyDestination(destinationUID);
            if (!DEBUG) continue;
            logger.log(4, "Removed stale destination : " + destinationUID);
        }
    }

    public void sendNewDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending New Destination " + destination);
        }
        this.sendUpdateDestination(destination);
    }

    public void sendUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending Update Destination " + destination);
        }
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        try {
            this.c.broadcast(clusterDestInfo.getGPacket((short)13, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendRemovedDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending New Destination " + destination);
        }
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        try {
            this.c.broadcast(clusterDestInfo.getGPacket((short)15, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        ClusterSubscriptionInfo clusterSubscriptionInfo;
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordCreateSubscription");
        }
        if ((n = this.recordConfigChangeEvent((clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription)).getGPacket((short)5, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "NEW_INTEREST[" + subscription.getClientID() + ", " + subscription.getDurableName() + "]"));
        }
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        ClusterSubscriptionInfo clusterSubscriptionInfo;
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordUnsubscribe");
        }
        if ((n = this.recordConfigChangeEvent((clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription)).getGPacket((short)7, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "REMOVE_DURABLE[" + subscription.getClientID() + ", " + subscription.getDurableName() + "]"));
        }
    }

    public void sendNewSubscription(Subscription subscription, Consumer consumer, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewSubscription");
        }
        this.sendNewInterestUpdate(subscription);
        this.sendAttachDurable(null, subscription, consumer);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendNewConsumer(Consumer consumer, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewConsumer");
        }
        this.sendNewInterestUpdate(consumer);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendRemovedConsumer(Consumer consumer, Map map, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendRemovedConsumer: " + consumer + ", pending=" + map + ", cleanup=" + bl);
        }
        if (consumer instanceof Subscription) {
            this.sendRemDurableUpdate(consumer);
        } else if (consumer.getSubscription() != null) {
            this.sendInterestUpdate(consumer, 3, map, bl);
        } else {
            this.sendInterestUpdate(consumer, 2, map, bl);
        }
    }

    private void sendGetInterestUpdate(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendGetInterestUpdate");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)29);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receiveGetInterestUpdate(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Received request for a full interest update from {0}.", brokerAddress);
        }
        this.forwardLocalInterests(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int addBrokerInfo(BrokerInfo brokerInfo) {
        BrokerAddress brokerAddress;
        block33: {
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.addBrokerInfo : " + brokerInfo);
            }
            if (brokerInfo.getClusterProtocolVersion() == null) {
                logger.log(16, "B2086", brokerInfo.getBrokerAddr());
                return 2;
            }
            if (brokerInfo.getClusterProtocolVersion() == 400) {
                logger.log(16, "XXXI18N - Reject no cluster support broker version 400:" + brokerInfo.getBrokerAddr());
                return 2;
            }
            if (brokerInfo.getClusterProtocolVersion() >= 400) {
                try {
                    this.checkUIDPrefixClash(brokerInfo);
                }
                catch (Exception exception) {
                    return 2;
                }
            }
            if (brokerInfo.getClusterProtocolVersion() < 400 && Globals.getHAEnabled()) {
                logger.log(16, br.getKString("B2118", brokerInfo.getBrokerAddr()));
                return 2;
            }
            if (brokerInfo.getBrokerAddr().getHAEnabled() != Globals.getHAEnabled()) {
                logger.log(16, "HA mode not match with remote broker " + brokerInfo.getBrokerAddr());
                return 2;
            }
            brokerAddress = null;
            try {
                brokerAddress = this.c.getConfigServer();
            }
            catch (Exception exception) {
                logger.log(16, "Master broker not resolved yet, ask remote broker " + brokerInfo.getBrokerAddr() + " retry later");
                return 1;
            }
            Map map = this.brokerList;
            synchronized (map) {
                if (this.shutdown) {
                    return 2;
                }
                if (this.isTakeoverTarget(brokerInfo.getBrokerAddr())) {
                    logger.log(16, br.getKString("B2119", brokerInfo));
                    this.forwardTakeoverBrokers(brokerInfo.getBrokerAddr(), false);
                    return 1;
                }
                Object v = this.brokerList.get(brokerInfo.getBrokerAddr());
                if (v != null) {
                    logger.log(16, br.getKString("B2120", brokerInfo));
                    return 1;
                }
                BrokerInfoEx brokerInfoEx = new BrokerInfoEx(brokerInfo);
                this.brokerList.put(brokerInfo.getBrokerAddr(), brokerInfoEx);
            }
            if (!this.configSyncComplete) {
                try {
                    if (brokerAddress != null && brokerAddress.equals(brokerInfo.getBrokerAddr())) {
                        long l = -1L;
                        l = this.getLastRefreshTime();
                        this.sendConfigChangesRequest(brokerAddress, l);
                        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
                            logger.log(8, "B1070");
                        }
                        break block33;
                    }
                    if (DEBUG) {
                        logger.log(4, "Config sync not complete. Rejecting addBrokerInfo : " + brokerInfo);
                    }
                    this.brokerList.remove(brokerInfo.getBrokerAddr());
                    return 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (DEBUG) {
            logger.log(4, "MessageBus: New Broker : {0}", brokerInfo);
        }
        try {
            if (brokerInfo.getStoreDirtyFlag() && brokerAddress != null && !brokerAddress.equals(brokerInfo.getBrokerAddr())) {
                long l = -1L;
                l = this.getLastRefreshTime();
                this.sendConfigChangesRequest(brokerAddress, l);
                if (!this.waitConfigChangesResponse()) {
                    this.brokerList.remove(brokerInfo.getBrokerAddr());
                    return 2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (brokerInfo.getBrokerAddr().getHAEnabled()) {
                Globals.getClusterManager().activateBroker(brokerInfo.getBrokerAddr().getBrokerID(), brokerInfo.getBrokerAddr().getBrokerSessionUID(), brokerInfo.getBrokerAddr().getInstanceName(), (Object)brokerInfo);
            }
            Globals.getClusterManager().activateBroker(brokerInfo.getBrokerAddr().getMQAddress(), brokerInfo.getBrokerAddr().getBrokerSessionUID(), brokerInfo.getBrokerAddr().getInstanceName(), null);
        }
        catch (Exception exception) {
            logger.logStack(32, br.getKString("B2115", brokerInfo, exception.getMessage()), exception);
            this.brokerList.remove(brokerInfo.getBrokerAddr());
            return 1;
        }
        logger.log(8, br.getKString("B1179", brokerInfo));
        if (Globals.getHAEnabled()) {
            this.forwardTakeoverBrokers(brokerInfo.getBrokerAddr(), true);
        }
        if (this.flowStopped) {
            this.sendFlowControlUpdate(brokerInfo.getBrokerAddr());
        }
        if (brokerAddress == null || !this.selfAddress.equals(brokerAddress)) {
            this.forwardLocalInterests(brokerInfo.getBrokerAddr());
        }
        this.sendTransactionInquiries(brokerInfo.getBrokerAddr());
        this.restartElections(brokerInfo.getBrokerAddr());
        logger.log(64, "B1071", brokerInfo.getBrokerAddr().toString() + (brokerInfo.getRealRemoteString() == null ? "" : "[" + brokerInfo.getRealRemoteString() + "]"));
        return 0;
    }

    private void forwardLocalInterests(BrokerAddress brokerAddress) {
        Serializable serializable;
        Serializable serializable2;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.forwardLocalInterests to : " + brokerAddress);
        }
        Iterator iterator = Destination.getTempDestinations(this.selfAddress);
        while (iterator.hasNext()) {
            serializable2 = (Destination)iterator.next();
            try {
                this.sendUpdateDestination((Destination)serializable2);
            }
            catch (BrokerException brokerException) {
                logger.logStack(4, brokerException.getMessage(), brokerException);
            }
        }
        serializable2 = new HashSet();
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        HashSet<Consumer> hashSet2 = new HashSet<Consumer>();
        HashSet<Subscription> hashSet3 = new HashSet<Subscription>();
        iterator = Consumer.getAllConsumers();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            serializable = consumer.getFirstDestination();
            if (serializable != null && ((Destination)serializable).getIsLocal()) continue;
            if (!consumer.isValid()) {
                logger.log(8, br.getKString("B1313", consumer.toString()));
                continue;
            }
            if (consumer instanceof Subscription) continue;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (this.selfAddress == consumerUID.getBrokerAddress()) {
                if (consumer.getSubscription() != null) {
                    Subscription subscription = consumer.getSubscription();
                    hashSet2.add(consumer);
                    if (!consumer.getSubscription().isDurable()) {
                        hashSet3.add(subscription);
                    } else {
                        hashSet3.add(subscription);
                    }
                } else {
                    serializable2.add(consumer);
                }
            }
            if (!consumer.getIsActiveConsumer() || serializable == null || ((Destination)serializable).getMaxActiveConsumers() != 1) continue;
            hashSet.add(consumer);
        }
        if (!hashSet2.isEmpty()) {
            if (DEBUG) {
                logger.log(8, "forward local subscriptions " + hashSet3.size() + " to " + brokerAddress);
            }
            this.sendNewInterestUpdate(brokerAddress, hashSet3);
            for (Consumer consumer : hashSet2) {
                serializable = consumer.getSubscription();
                if (DEBUG) {
                    logger.log(8, "forward local attached consumer  " + consumer + " to " + brokerAddress);
                }
                this.sendAttachDurable(brokerAddress, (Subscription)serializable, consumer);
            }
        }
        if (!serializable2.isEmpty()) {
            if (DEBUG) {
                logger.log(8, "forward local activeInterest " + serializable2.size() + " to " + brokerAddress);
            }
            this.sendNewInterestUpdate(brokerAddress, (Collection)((Object)serializable2));
        }
        if (!hashSet.isEmpty()) {
            this.sendInterestUpdate(brokerAddress, hashSet, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartElections(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.restartElections. broker : " + brokerAddress);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Set set = this.resTable.keySet();
            for (String string : set) {
                Resource resource = (Resource)this.resTable.get(string);
                resource.brokerAdded(brokerAddress);
            }
        }
    }

    private void sendTransactionInquiries(BrokerAddress brokerAddress) {
        TransactionList transactionList = Globals.getTransactionList();
        ArrayList arrayList = transactionList.getPreparedRemoteTransactions();
        TransactionUID transactionUID = null;
        Iterator iterator = arrayList.iterator();
        ClusterTxnInquiryInfo clusterTxnInquiryInfo = null;
        TransactionBroker transactionBroker = null;
        while (iterator.hasNext()) {
            transactionUID = (TransactionUID)iterator.next();
            transactionBroker = transactionList.getRemoteTransactionHomeBroker(transactionUID);
            clusterTxnInquiryInfo = ClusterTxnInquiryInfo.newInstance(transactionUID.longValue(), transactionBroker == null ? null : transactionBroker.getBrokerAddress(), null);
            if (DEBUG_CLUSTER_TXN) {
                logger.log(8, "Sending transaction inquiry: " + clusterTxnInquiryInfo + " to " + brokerAddress);
            }
            try {
                this.c.unicast(brokerAddress, clusterTxnInquiryInfo.getGPacket());
            }
            catch (Exception exception) {
                logger.log(16, "Sending transaction inquiry " + clusterTxnInquiryInfo + " to " + brokerAddress + " failed");
            }
        }
    }

    public void receivedTransactionInquiry(GPacket gPacket, BrokerAddress brokerAddress) {
        BrokerAddress brokerAddress2;
        TransactionList transactionList;
        TransactionState transactionState;
        ClusterTxnInquiryInfo clusterTxnInquiryInfo = ClusterTxnInquiryInfo.newInstance(gPacket);
        if (DEBUG_CLUSTER_TXN) {
            logger.log(8, "Received transaction inquiry " + clusterTxnInquiryInfo.toString() + " from " + brokerAddress);
        }
        TransactionUID transactionUID = new TransactionUID(clusterTxnInquiryInfo.getTransactionID());
        BrokerAddress brokerAddress3 = clusterTxnInquiryInfo.getTransactionHome();
        TransactionBroker transactionBroker = null;
        if (brokerAddress3 != null) {
            transactionBroker = new TransactionBroker(brokerAddress3);
        }
        if ((transactionState = (transactionList = Globals.getTransactionList()).retrieveState(transactionUID, true)) == null && DEBUG_CLUSTER_TXN) {
            logger.log(8, "Transaction " + transactionUID + " not found in local transaction");
        }
        if (transactionState != null) {
            BrokerAddress brokerAddress4;
            BrokerAddress brokerAddress5 = brokerAddress4 = transactionBroker == null ? null : transactionBroker.getCurrentBrokerAddress();
            if (brokerAddress4 != null && !brokerAddress4.equals(Globals.getMyAddress())) {
                logger.log(16, "Incorrect transaction home broker info:" + brokerAddress3 + " from " + brokerAddress + " TID=" + transactionUID);
            }
            this.sendClusterTransactionInfo(transactionUID, brokerAddress, clusterTxnInquiryInfo.getXid());
            return;
        }
        if (transactionState == null && transactionBroker != null && (brokerAddress2 = transactionBroker.getCurrentBrokerAddress()) != null && Globals.getMyAddress().equals(brokerAddress2)) {
            this.sendClusterTransactionInfo(transactionUID, brokerAddress, clusterTxnInquiryInfo.getXid());
            return;
        }
        this.sendRemoteTransactionInfo(transactionUID, brokerAddress, clusterTxnInquiryInfo.getXid());
    }

    private void sendRemoteTransactionInfo(TransactionUID transactionUID, BrokerAddress brokerAddress, Long l) {
        TransactionList transactionList = Globals.getTransactionList();
        TransactionState transactionState = transactionList.getRemoteTransactionState(transactionUID);
        if (transactionState == null) {
            if (DEBUG_CLUSTER_TXN) {
                logger.log(8, "Remote transaction " + transactionUID + " not found");
            }
            return;
        }
        int n = transactionState.getState();
        if (n == 7 || n == 6) {
            TransactionBroker transactionBroker = transactionList.getRemoteTransactionHomeBroker(transactionUID);
            ClusterTxnInfoInfo clusterTxnInfoInfo = ClusterTxnInfoInfo.newInstance(new Long(transactionUID.longValue()), n, null, null, transactionBroker == null ? null : transactionBroker.getBrokerAddress(), false, this.c, l);
            if (DEBUG_CLUSTER_TXN) {
                logger.log(8, "Sending remote transaction info " + clusterTxnInfoInfo.toString() + " to " + brokerAddress);
            }
            try {
                this.c.unicast(brokerAddress, clusterTxnInfoInfo.getGPacket());
            }
            catch (Exception exception) {
                logger.log(16, "Sending transaction info " + clusterTxnInfoInfo.toString() + " to " + brokerAddress + " failed:" + exception.getMessage());
            }
        }
    }

    public void sendClusterTransactionInfo(long l, BrokerAddress brokerAddress) {
        this.sendClusterTransactionInfo(new TransactionUID(l), brokerAddress, null);
    }

    private void sendClusterTransactionInfo(TransactionUID transactionUID, BrokerAddress brokerAddress, Long l) {
        Object object;
        TransactionList transactionList = Globals.getTransactionList();
        TransactionState transactionState = transactionList.retrieveState(transactionUID, true);
        BrokerAddress[] brokerAddressArray = null;
        BrokerAddress[] brokerAddressArray2 = null;
        TransactionBroker[] transactionBrokerArray = null;
        if (transactionState != null) {
            try {
                transactionBrokerArray = transactionList.getClusterTransactionBrokers(transactionUID);
            }
            catch (Exception exception) {
                logger.log(16, "Can't retrieve cluster transaction brokers:" + exception.getMessage());
            }
            if (transactionBrokerArray == null) {
                logger.log(16, "No cluster transaction brokers information for TID=" + transactionUID);
            } else {
                brokerAddressArray = new BrokerAddress[transactionBrokerArray.length];
                object = new ArrayList();
                for (int i = 0; i < transactionBrokerArray.length; ++i) {
                    brokerAddressArray[i] = transactionBrokerArray[i].getBrokerAddress();
                    if (transactionBrokerArray[i].isCompleted()) continue;
                    ((ArrayList)object).add(transactionBrokerArray[i].getBrokerAddress());
                }
                if (((ArrayList)object).size() > 0) {
                    brokerAddressArray2 = ((ArrayList)object).toArray(new BrokerAddress[0]);
                }
            }
        }
        object = ClusterTxnInfoInfo.newInstance(new Long(transactionUID.longValue()), transactionState == null ? -1 : transactionState.getState(), brokerAddressArray, brokerAddressArray2, Globals.getMyAddress(), true, this.c, l);
        if (DEBUG_CLUSTER_TXN) {
            logger.log(8, "Sending local transaction info " + ((ClusterTxnInfoInfo)object).toString() + " to " + brokerAddress);
        }
        try {
            this.c.unicast(brokerAddress, ((ClusterTxnInfoInfo)object).getGPacket());
        }
        catch (Exception exception) {
            logger.log(16, "Sending transaction info " + ((ClusterTxnInfoInfo)object).toString() + " to " + brokerAddress + " failed:" + exception.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void receivedTransactionInfo(GPacket var1_1, BrokerAddress var2_2, MessageBusCallback var3_3) {
        var4_4 = ClusterTxnInfoInfo.newInstance(var1_1, this.c);
        if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
            RaptorProtocol.logger.log(8, "Received transaction information from " + var2_2 + ": " + var4_4.toString());
        }
        var5_5 = Globals.getTransactionList();
        var6_6 = var4_4.getTransactionID();
        var7_7 = new TransactionUID(var6_6);
        var8_8 = var4_4.getTransactionState();
        if ((!var4_4.isOwner() || var4_4.isOwner() && var2_2.equals(this.selfAddress)) && var5_5.retrieveState(var7_7, true) != null) {
            if (var5_5.getClusterTransactionBroker(var7_7, var2_2) != null) {
                if (var8_8 == 6) {
                    if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
                        RaptorProtocol.logger.log(8, "Update broker " + var2_2 + " for committed cluster transaction " + var7_7);
                    }
                    try {
                        var5_5.completeClusterTransactionBrokerState(var7_7, 6, var2_2, true);
                        if (var4_4.isOwner()) ** GOTO lbl27
                        this.sendClusterTransactionInfo(var7_7, var2_2, null);
                    }
                    catch (Exception var9_9) {
                        RaptorProtocol.logger.logStack(16, "Unable to update transaction broker state for " + var2_2 + ", TUID=" + var7_7, var9_9);
                        if (var4_4.isOwner()) ** GOTO lbl27
                        return;
                    }
                }
            } else {
                RaptorProtocol.logger.log(16, "Unable to find transaction broker " + var2_2 + " TUID=" + var7_7);
            }
lbl27:
            // 5 sources

            if (!var4_4.isOwner()) {
                return;
            }
        }
        if (var5_5.getRemoteTransactionState(var7_7) == null) {
            return;
        }
        if (var8_8 == -1 && !var4_4.isOwner()) {
            return;
        }
        var9_10 = -1;
        switch (var8_8) {
            case 2: 
            case 7: {
                var9_10 = 10;
                break;
            }
            case -1: {
                RaptorProtocol.logger.log(8, Globals.getBrokerResources().getKString("B1311", var7_7, var2_2));
                var9_10 = 10;
                break;
            }
            case 6: {
                var9_10 = 3;
                break;
            }
            default: {
                return;
            }
        }
        try {
            var3_3.processRemoteAck2P(null, null, var9_10, null, var6_6, var2_2);
            if (var8_8 == 6) {
                var10_11 = var4_4.getBrokers();
                var11_13 = var4_4.getWaitfor();
                if (var10_11 == null && var11_13 == null) {
                    return;
                }
                if (var11_13 != null) {
                    this.sendRemoteTransactionInfo(var7_7, var2_2, null);
                }
            }
        }
        catch (Exception var10_12) {
            if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
                RaptorProtocol.logger.logStack(16, var10_12.getMessage(), var10_12);
            }
            RaptorProtocol.logger.log(16, var10_12.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeBrokerInfo(BrokerAddress brokerAddress) {
        Object object;
        Set set;
        Object object2;
        BrokerInfoEx brokerInfoEx;
        block28: {
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.removeBrokerInfo. broker : " + brokerAddress);
            }
            brokerInfoEx = null;
            brokerInfoEx = (BrokerInfoEx)this.brokerList.remove(brokerAddress);
            if (DEBUG) {
                logger.log(4, "Broker down " + brokerAddress);
            }
            try {
                if (!this.c.getConfigServer().equals(brokerAddress)) break block28;
                Long l = null;
                object2 = null;
                set = this.eventLogWaiters.keySet();
                Iterator iterator = this.eventLogWaiters;
                synchronized (iterator) {
                    Object object3 = set.iterator();
                    while (object3.hasNext()) {
                        l = (Long)object3.next();
                        object2 = (EventLogWaiter)this.eventLogWaiters.get(l);
                        object3.remove();
                        object = object2;
                        synchronized (object) {
                            if (((EventLogWaiter)object2).getStatus() == 0) {
                                ((EventLogWaiter)object2).setStatus(2);
                            }
                            object2.notify();
                        }
                    }
                }
                iterator = this.cfgSrvWaitObject;
                synchronized (iterator) {
                    if (this.cfgSrvRequestCount > 0) {
                        this.cfgSrvRequestCount = 0;
                        this.cfgSrvRequestErr = true;
                        this.cfgSrvWaitObject.notifyAll();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.log(64, "B1072", brokerAddress.toString());
        this.cbDispatcher.brokerDown(brokerAddress);
        boolean bl = false;
        if (brokerInfoEx != null) {
            bl = brokerInfoEx.goodbyeDone();
        }
        this.ackackTracker.removeBroker(brokerAddress, bl, this.shutdown);
        this.takeoverPendingReplyTracker.removeBroker(brokerAddress, bl, this.shutdown);
        object2 = this.resTable;
        synchronized (object2) {
            set = this.resTable.keySet();
            for (Object object3 : set) {
                object = (Resource)this.resTable.get(object3);
                ((Resource)object).brokerRemoved(brokerAddress);
            }
        }
        if (brokerInfoEx == null) {
            return;
        }
        object2 = brokerInfoEx.getBrokerInfo();
        try {
            if (brokerInfoEx.getBrokerInfo().getBrokerAddr().getHAEnabled()) {
                Globals.getClusterManager().deactivateBroker(((BrokerInfo)object2).getBrokerAddr().getBrokerID(), (Object)((BrokerInfo)object2).getBrokerAddr().getBrokerSessionUID());
            } else {
                Globals.getClusterManager().deactivateBroker(((BrokerInfo)object2).getBrokerAddr().getMQAddress(), (Object)((BrokerInfo)object2).getBrokerAddr().getBrokerSessionUID());
            }
            logger.log(8, br.getKString("B1180", object2));
        }
        catch (NoSuchElementException noSuchElementException) {
            if (DEBUG) {
                logger.logStack(8, "Unable to deactivate " + object2, noSuchElementException);
            }
        }
        catch (Exception exception) {
            logger.logStack(16, br.getKString("B2116", object2, exception.getMessage()), exception);
        }
        brokerInfoEx.deactivate();
    }

    private void configServerBackup(String string) {
        if (DEBUG) {
            logger.log(4, "ConfigServerBackup. fileName : " + string);
        }
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            logger.log(16, "B2054");
            return;
        }
        if (brokerAddress == null || !brokerAddress.equals(this.selfAddress)) {
            logger.log(16, "B2054");
            return;
        }
        try {
            File file = new File(string);
            if (!file.createNewFile()) {
                logger.log(16, "B2055", string);
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Object[] objectArray = this.store.getAllConfigRecords();
            ArrayList arrayList = this.compressConfigRecords(objectArray);
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF("imq.cluster.masterbroker.backup");
            byte[] byArray = RaptorProtocol.prepareResetPersistenceRecord();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            for (int i = 0; i < arrayList.size(); ++i) {
                ChangeRecord changeRecord = (ChangeRecord)arrayList.get(i);
                if (changeRecord.discard) continue;
                byte[] byArray2 = changeRecord.getBytes();
                dataOutputStream.writeInt(byArray2.length);
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.writeInt(0);
        }
        catch (Exception exception) {
            logger.logStack(16, "B2056", exception);
        }
        if (DEBUG) {
            logger.log(4, "ConfigServerBackup complete.");
        }
    }

    private ArrayList compressConfigRecords(Object[] objectArray) throws Exception {
        ArrayList arrayList = (ArrayList)objectArray[1];
        ArrayList<ChangeRecord> arrayList2 = new ArrayList<ChangeRecord>();
        HashMap<String, ChangeRecord> hashMap = new HashMap<String, ChangeRecord>();
        if (DEBUG) {
            logger.log(4, "CompressConfigRecords: Retrieved " + arrayList.size() + " change records");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            ChangeRecord changeRecord = ChangeRecord.makeChangeRecord(byArray);
            if (DEBUG) {
                logger.log(4, "CompressConfigRecords: #" + i + " " + ((ArrayList)objectArray[0]).get(i) + " " + ProtocolGlobals.getPacketTypeString(changeRecord.getOperation()) + " key=" + changeRecord.getUniqueKey());
            }
            arrayList2.add(changeRecord);
            ChangeRecord changeRecord2 = (ChangeRecord)hashMap.get(changeRecord.getUniqueKey());
            if (changeRecord2 != null) {
                changeRecord2.discard = true;
                if (DEBUG) {
                    logger.log(4, ">>>>CompressConfigRecords: discard previous record " + ProtocolGlobals.getPacketTypeString(changeRecord2.getOperation()) + " key=" + changeRecord.getUniqueKey());
                }
            }
            if (!changeRecord.isAddOp()) {
                changeRecord.discard = true;
                if (DEBUG) {
                    logger.log(4, ">>>>CompressConfigRecords: discard this 'non-add' record ");
                }
            }
            hashMap.put(changeRecord.getUniqueKey(), changeRecord);
        }
        return arrayList2;
    }

    private void configServerRestore(String string) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.configServerRestore. fileName = " + string);
        }
        try {
            int n;
            File file = new File(string);
            if (!file.exists()) {
                logger.log(16, "B2057", string);
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n2 = dataInputStream.readInt();
            String string2 = dataInputStream.readUTF();
            if (!string2.equals("imq.cluster.masterbroker.backup")) {
                logger.log(16, "B2058", string);
                return;
            }
            if (n2 < 350 || n2 > this.version) {
                logger.log(16, "B2059");
                return;
            }
            this.store.clearAllConfigChangeRecords(false);
            while ((n = dataInputStream.readInt()) != 0) {
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray, 0, n);
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            }
            dataInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            logger.logStack(16, "B2060", exception);
            return;
        }
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.configServerRestore complete.");
        }
    }

    private void storeLastConfigServer(BrokerAddress brokerAddress) throws BrokerException {
        this.store.updateProperty("MessageBus.lastConfigServer", brokerAddress, false);
    }

    private BrokerAddress getLastConfigServer() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = (BrokerAddress)this.store.getProperty("MessageBus.lastConfigServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brokerAddress;
    }

    private void storeLastRefreshTime(long l) throws BrokerException {
        Long l2 = new Long(l);
        this.store.updateProperty("MessageBus.lastRefreshTime", l2, false);
    }

    private long getLastRefreshTime() {
        Long l = null;
        try {
            l = (Long)this.store.getProperty("MessageBus.lastRefreshTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public boolean getConfigSyncComplete() {
        return this.configSyncComplete;
    }

    private static byte[] getEventData(GPacket gPacket) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] generateAddDurableRecord(Subscription subscription) {
        try {
            ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
            return RaptorProtocol.getEventData(clusterSubscriptionInfo.getGPacket((short)5, true));
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateAddDurableRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateRemDurableRecord(Subscription subscription) {
        try {
            ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
            return RaptorProtocol.getEventData(clusterSubscriptionInfo.getGPacket((short)7, true));
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateRemDurableRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateAddDestinationRecord(Destination destination) {
        try {
            ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
            GPacket gPacket = clusterDestInfo.getGPacket((short)13, true);
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateRemDestinationRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateRemDestinationRecord(Destination destination) {
        try {
            ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
            GPacket gPacket = clusterDestInfo.getGPacket((short)15, true);
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateRemDestinationRecord failed.", exception);
            return null;
        }
    }

    class EventLogWaiter {
        private int status = 2;

        public EventLogWaiter(int n) {
            this.status = n;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized void setStatus(int n) {
            this.status = n;
        }
    }

    class BrokerInfoEx {
        private int GOODBYE_SENT = 1;
        private int GOODBYE_RECEIVED = 2;
        private int GOODBYE_REPLY_SENT = 4;
        private int GOODBYE_REPLY_RECEIVED = 8;
        private int finStatus = 0;
        private BrokerInfo info = null;
        private ClusterGoodbyeInfo cgi = null;
        private boolean deactivated = false;

        public BrokerInfoEx(BrokerInfo brokerInfo) {
            this.info = brokerInfo;
        }

        public synchronized boolean deactivated() {
            return this.deactivated;
        }

        public synchronized void deactivate() {
            this.deactivated = true;
            this.notifyAll();
        }

        public synchronized void setGoodbyeInfo(ClusterGoodbyeInfo clusterGoodbyeInfo) {
            this.cgi = clusterGoodbyeInfo;
        }

        public synchronized ClusterGoodbyeInfo getGoodbyeInfo() {
            return this.cgi;
        }

        public BrokerInfo getBrokerInfo() {
            return this.info;
        }

        public void setBrokerInfo(BrokerInfo brokerInfo) {
            this.info = brokerInfo;
        }

        public synchronized boolean goodbyeDone() {
            return this.sentGoodbyeReply() && this.gotGoodbyeReply();
        }

        public synchronized void goodbyeSent() {
            this.finStatus |= this.GOODBYE_SENT;
        }

        public synchronized void goodbyeReceived() {
            this.finStatus |= this.GOODBYE_RECEIVED;
        }

        public synchronized void goodbyeReplySent() {
            this.finStatus |= this.GOODBYE_REPLY_SENT;
        }

        public synchronized void goodbyeReplyReceived() {
            this.finStatus |= this.GOODBYE_REPLY_RECEIVED;
        }

        public synchronized boolean gotGoodbye() {
            return this.cgi != null && (this.finStatus & this.GOODBYE_RECEIVED) == this.GOODBYE_RECEIVED;
        }

        public synchronized boolean sentGoodbye() {
            return (this.finStatus & this.GOODBYE_SENT) == this.GOODBYE_SENT;
        }

        public synchronized boolean gotGoodbyeReply() {
            return (this.finStatus & this.GOODBYE_REPLY_RECEIVED) == this.GOODBYE_REPLY_RECEIVED;
        }

        public synchronized boolean sentGoodbyeReply() {
            return (this.finStatus & this.GOODBYE_REPLY_SENT) == this.GOODBYE_REPLY_SENT;
        }
    }
}

