/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgimain;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Main
implements BundleActivator {
    private static final String DIR_NAME_PROP = Main.class.getPackage().getName() + ".bundlesDir";
    private static final Logger logger = Logger.getLogger(Main.class.getPackage().getName());
    private BundleContext context;
    private File bundlesDir;
    private Bundle primordialBundle;
    private static final String AUTO_START_BUNDLES_PROP = Main.class.getPackage().getName() + ".autostartBundles";
    private Map<String, Long> autoStartBundleIds = new HashMap<String, Long>();
    private List<String> autoStartBundleLocations = new ArrayList<String>();

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.bundlesDir = new File(context.getProperty(DIR_NAME_PROP));
        StringTokenizer st = new StringTokenizer(context.getProperty(AUTO_START_BUNDLES_PROP), ",");
        while (st.hasMoreTokens()) {
            String bundleRelPath = st.nextToken().trim();
            String bundleURI = new File(this.bundlesDir, bundleRelPath).toURI().normalize().toString();
            this.autoStartBundleLocations.add(bundleURI);
        }
        this.installBundles();
        for (String location : this.autoStartBundleLocations) {
            Long id = this.autoStartBundleIds.get(location);
            if (id == null) {
                logger.logp(Level.WARNING, "Main", "start", "Not able to locate autostart bundle for location = {0}", new Object[]{location});
                continue;
            }
            Bundle bundle = context.getBundle(id.longValue());
            if (bundle == null) continue;
            bundle.start(1);
        }
    }

    public void stop(BundleContext context) throws Exception {
        ArrayList<String> bundlesToStop = new ArrayList<String>(this.autoStartBundleLocations);
        Collections.reverse(bundlesToStop);
        for (String location : bundlesToStop) {
            Long id = this.autoStartBundleIds.get(location);
            if (id == null) {
                logger.logp(Level.WARNING, "Main", "stop", "Not able to locate autostart bundle for location = {0}", new Object[]{location});
                continue;
            }
            Bundle bundle = context.getBundle(id.longValue());
            if (bundle == null) continue;
            bundle.stop();
        }
    }

    private void installBundles() {
        this.bundlesDir.listFiles(new FileFilter(){
            final String JAR_EXT = ".jar";

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (pathname.isFile() && pathname.getName().endsWith(".jar")) {
                    Main.this.installBundle(pathname);
                    return true;
                }
                return false;
            }
        });
    }

    private void installBundle(File jar) {
        try {
            String location = jar.toURI().normalize().toString();
            Bundle b = this.context.installBundle(location, (InputStream)new FileInputStream(jar));
            if (this.autoStartBundleLocations.contains(location)) {
                this.autoStartBundleIds.put(location, b.getBundleId());
            }
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "Installer", "install", "Failed to install {0} because of {1}", new Object[]{jar, e});
        }
    }
}

