/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.cluster.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import java.util.ArrayList;
import java.util.Hashtable;

class RemoteTransactionInformation
extends TransactionInformation {
    RemoteTransactionAckEntry txnAckEntry = null;
    ArrayList recoveryTxnAckEntrys = new ArrayList();
    TransactionBroker txnhome = null;

    public RemoteTransactionInformation(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl, boolean bl2) {
        super(transactionUID, transactionState, bl2);
        this.type = 3;
        this.txnhome = new TransactionBroker(brokerAddress, true);
        if (bl) {
            this.addRecoveryTransactionAcks(transactionAcknowledgementArray);
        } else {
            this.txnAckEntry = new RemoteTransactionAckEntry(transactionAcknowledgementArray, false);
        }
    }

    public synchronized String toString() {
        return "RemoteTransactionInfo[" + this.tid + "]remote - " + this.txnhome.toString();
    }

    public synchronized TransactionBroker getTransactionHomeBroker() {
        return this.txnhome;
    }

    public synchronized RemoteTransactionAckEntry getTransactionAcks() {
        return this.txnAckEntry;
    }

    public synchronized RemoteTransactionAckEntry[] getRecoveryTransactionAcks() {
        if (this.recoveryTxnAckEntrys.size() == 0) {
            return null;
        }
        return this.recoveryTxnAckEntrys.toArray(new RemoteTransactionAckEntry[0]);
    }

    public synchronized void addRecoveryTransactionAcks(TransactionAcknowledgement[] transactionAcknowledgementArray) {
        if (this.getState().getState() == 5) {
            this.recoveryTxnAckEntrys.add(new RemoteTransactionAckEntry(transactionAcknowledgementArray, true, false));
        } else {
            this.recoveryTxnAckEntrys.add(new RemoteTransactionAckEntry(transactionAcknowledgementArray, true, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessed() {
        if (this.txnAckEntry != null && !this.txnAckEntry.isProcessed()) {
            return false;
        }
        RemoteTransactionInformation remoteTransactionInformation = this;
        synchronized (remoteTransactionInformation) {
            RemoteTransactionAckEntry remoteTransactionAckEntry2 = null;
            for (RemoteTransactionAckEntry remoteTransactionAckEntry2 : this.recoveryTxnAckEntrys) {
                if (remoteTransactionAckEntry2.isProcessed()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean isRecovery() {
        return this.recoveryTxnAckEntrys.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        RemoteTransactionInformation remoteTransactionInformation = this;
        synchronized (remoteTransactionInformation) {
            hashtable.put("state", this.getState().getDebugState());
            if (this.txnhome != null) {
                hashtable.put("txnhome", this.txnhome.toString());
            }
            if (this.txnAckEntry != null) {
                hashtable.put("txnAckEntry", this.txnAckEntry.getDebugState());
            }
            if (this.recoveryTxnAckEntrys != null) {
                ArrayList<Hashtable> arrayList = new ArrayList<Hashtable>();
                int n = this.recoveryTxnAckEntrys.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(((RemoteTransactionAckEntry)this.recoveryTxnAckEntrys.get(i)).getDebugState());
                }
                hashtable.put("recoveryTxnAckEntrys", arrayList);
            }
        }
        return hashtable;
    }
}

