/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.List;

public class TransactionListLoader {
    Logger logger = Globals.getLogger();
    Store store = null;
    TransactionList transactionList;

    public TransactionListLoader(Store store, TransactionList transactionList) {
        this.store = store;
        this.transactionList = transactionList;
    }

    public void loadTransactions() throws BrokerException, IOException {
        this.logger.log(8, "B1136");
        this.loadLocalTransactions();
        this.loadClusterTransactions();
        this.loadRemoteTransactions();
    }

    public void loadLocalTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(1);
        String string = " loading " + list.size() + " incomplete Local transactions:  ";
        this.logger.log(4, string);
        for (BaseTransaction baseTransaction : list) {
            TransactionUID transactionUID = baseTransaction.getTid();
            string = " loadTransactions: processing local transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = baseTransaction.getTransactionState();
            this.transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionWork transactionWork = baseTransaction.getTransactionWork();
            this.handleTransactionWork(transactionUID, transactionWork);
        }
    }

    public void loadClusterTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(3);
        String string = " loading " + list.size() + " incomplete cluster transactions:  ";
        this.logger.log(4, string);
        for (ClusterTransaction clusterTransaction : list) {
            TransactionUID transactionUID = clusterTransaction.getTid();
            string = " loadTransactions: processing cluster transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = clusterTransaction.getTransactionState();
            this.transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionBroker[] transactionBrokerArray = clusterTransaction.getTransactionBrokers();
            this.transactionList.logClusterTransaction(transactionUID, transactionState, transactionBrokerArray, true, false);
            TransactionWork transactionWork = clusterTransaction.getTransactionWork();
            this.handleTransactionWork(transactionUID, transactionWork);
        }
    }

    public void loadRemoteTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(2);
        String string = " loading " + list.size() + " incomplete remote transactions:  ";
        this.logger.log(4, string);
        for (RemoteTransaction remoteTransaction : list) {
            TransactionUID transactionUID = remoteTransaction.getTid();
            string = " loadTransactions: processing remote transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = remoteTransaction.getTransactionState();
            TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransaction.getTxnAcks();
            BrokerAddress brokerAddress = remoteTransaction.getTxnHomeBroker();
            this.transactionList.logRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, true, true, false);
        }
    }

    void handleTransactionWork(TransactionUID transactionUID, TransactionWork transactionWork) throws BrokerException {
        Object object;
        int n;
        for (n = 0; n < transactionWork.numSentMessages(); ++n) {
            object = transactionWork.getSentMessages().get(n);
            Packet packet = ((TransactionWorkMessage)object).getMessage();
            DestinationUID destinationUID = ((TransactionWorkMessage)object).getDestUID();
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            Destination destination = Destination.getDestination(destinationUID);
            this.logger.log(4, " loadTransactions: processing prepared sent message " + packet.getMessageID());
            boolean bl = destination.queueMessage(packetReference, true);
            this.transactionList.addMessage(packetReference.getTransactionID(), packetReference.getSysMessageID(), true);
        }
        for (n = 0; n < transactionWork.numMessageAcknowledgments(); ++n) {
            object = transactionWork.getMessageAcknowledgments().get(n);
            this.logger.log(4, " loadTransactions: processing prepared acknowledged message " + ((TransactionWorkMessageAck)object).getSysMessageID());
            this.transactionList.addAcknowledgement(transactionUID, ((TransactionWorkMessageAck)object).getSysMessageID(), ((TransactionWorkMessageAck)object).getConsumerID(), ((TransactionWorkMessageAck)object).getConsumerID(), true, false);
        }
    }
}

