/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.CheckpointManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.txnlog.CheckPointListener;
import com.sun.messaging.jmq.util.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.util.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogManager
implements CheckPointListener {
    static final String TXNLOG_PROP_PREFIX = "imq.persist.file.txnLog";
    static final String TXNLOG_FILE_SIZE_PROP = "imq.persist.file.txnLogfile.size";
    static final String SYNC_TXNLOG_WRITES_PROP = "imq.persist.file.txnLogsyncWrites";
    static final long DEFAULT_TXNLOG_FILE_SIZE = 10240L;
    static final String MSG_LOG_FILENAME = "txnlog";
    public static final BrokerResources br = Globals.getBrokerResources();
    Store store;
    MsgStore msgStore;
    File rootDir;
    private TransactionLogWriter msgLogWriter = null;
    LocalTransactionManager localTransactionManager;
    ClusterTransactionManager clusterTransactionManager;
    RemoteTransactionManager remoteTransactionManager;
    CheckpointManager checkpointManager;
    PreparedTxnStore preparedTxnStore;
    public static final Logger logger = Globals.getLogger();

    public TransactionLogManager(Store store, PreparedTxnStore preparedTxnStore, MsgStore msgStore, File file) {
        this.store = store;
        this.preparedTxnStore = preparedTxnStore;
        this.msgStore = msgStore;
        this.rootDir = file;
        this.localTransactionManager = new LocalTransactionManager(this);
        this.clusterTransactionManager = new ClusterTransactionManager(this);
        this.remoteTransactionManager = new RemoteTransactionManager(this);
        this.checkpointManager = new CheckpointManager(this);
    }

    public void startup() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " startup");
        }
        this.processStoredTxnsOnStartup();
        this.initTransactionLogOnStartUp();
        this.replayTransactionLogOnStartup();
        this.store.syncDestination(null);
        try {
            this.msgLogWriter.reset();
        }
        catch (IOException iOException) {
            throw new BrokerException("failed to reset transaction log", iOException);
        }
        this.removeCommittedTransactionsOnStartup();
    }

    void processStoredTxnsOnStartup() throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " processStoredTxnsOnStartup";
            logger.log(4, (String)object);
        }
        this.preparedTxnStore.loadTransactions();
        object = this.preparedTxnStore.txnEnumeration();
        while (object.hasMoreElements()) {
            BaseTransaction baseTransaction = (BaseTransaction)object.nextElement();
            int n = baseTransaction.getType();
            BaseTransactionManager baseTransactionManager = this.getTransactionManager(n);
            baseTransactionManager.processStoredTxnOnStartup(baseTransaction);
        }
    }

    void removeCommittedTransactionsOnStartup() throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " removeCommitedTransactionsInPreparedTxnStore";
            logger.log(4, (String)object);
        }
        object = this.preparedTxnStore.txnEnumeration();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (object.hasMoreElements()) {
            BaseTransaction baseTransaction = (BaseTransaction)object.nextElement();
            if (baseTransaction.getState() != 6) continue;
            arrayList.add(baseTransaction);
        }
        for (BaseTransaction baseTransaction : arrayList) {
            TransactionUID transactionUID = baseTransaction.getTid();
            this.preparedTxnStore.removeTransaction(transactionUID, true);
            if (!Store.getDEBUG()) continue;
            String string = this.getPrefix() + " removed committed transaction from preparedTxnStore. Tid=" + transactionUID;
            logger.log(4, string);
        }
    }

    public void initTransactionLogOnStartUp() throws BrokerException {
        String string;
        if (Store.getDEBUG()) {
            string = this.getPrefix() + " initTransactionLogOnStartUp";
            logger.log(4, string);
        }
        logger.log(8, "B1269");
        string = null;
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            SizeString sizeString = brokerConfig.getSizeProperty(TXNLOG_FILE_SIZE_PROP, 10240L);
            boolean bl = brokerConfig.getBooleanProperty(SYNC_TXNLOG_WRITES_PROP, true);
            if (Store.getDEBUG()) {
                logger.log(4, "syncAllTxnWrites = " + bl);
            }
            string = MSG_LOG_FILENAME;
            String string2 = "rwd";
            boolean bl2 = true;
            if (!bl) {
                string2 = "rw";
                bl2 = false;
            }
            this.msgLogWriter = new FileTransactionLogWriter(this.rootDir, string, sizeString.getBytes(), string2, bl2);
            this.msgLogWriter.setCheckPointListener((CheckPointListener)this);
            if (Store.getDEBUG()) {
                logger.log(4, "created txn log");
            }
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3225", (Object)string, (Throwable)iOException);
            throw new BrokerException(br.getString("B3225", string), iOException);
        }
    }

    public void replayTransactionLogOnStartup() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " replayTransactionLogOnStartup");
        }
        try {
            if (this.msgLogWriter.playBackRequired()) {
                Object object;
                if (Store.getDEBUG()) {
                    object = this.getPrefix() + " replayTransactionLogOnStartup: playBackRequired";
                    logger.log(4, (String)object);
                }
                logger.log(64, "B1270");
                Destination.init();
                Subscription.initSubscriptions();
                object = new HashSet();
                int n = 0;
                HashMap hashMap = new HashMap();
                Iterator iterator = this.msgLogWriter.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    ++n;
                    TransactionLogRecord transactionLogRecord = (TransactionLogRecord)iterator.next();
                    byte[] byArray = transactionLogRecord.getBody();
                    TransactionEvent transactionEvent = this.readTransactionEvent(byArray);
                    int n2 = transactionEvent.getType();
                    if (Store.getDEBUG()) {
                        object2 = this.getPrefix() + " replayTransactionLogOnStartup() read " + transactionEvent;
                        logger.log(4, (String)object2);
                    }
                    object2 = this.getTransactionManager(n2);
                    ((BaseTransactionManager)object2).replayTransactionEvent(transactionEvent, (HashSet)object);
                }
            } else if (Store.getDEBUG()) {
                logger.log(4, "no playBackRequired");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void replayTransactionWork(TransactionWork transactionWork, TransactionUID transactionUID, Set set) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " replayTransactionWork for tid " + transactionUID + " txnWork=" + transactionWork;
            logger.log(4, string);
        }
        this.replaySentMessages(transactionWork.getSentMessages(), set);
        this.replayAcknowledgedMessages(transactionWork.getMessageAcknowledgments(), set);
    }

    TransactionEvent readTransactionEvent(byte[] byArray) throws IOException, BrokerException {
        TransactionEvent transactionEvent = TransactionEvent.createFromBytes(byArray);
        return transactionEvent;
    }

    private void replaySentMessages(List<TransactionWorkMessage> list, Set set) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " replaySentMessages");
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            TransactionWorkMessage transactionWorkMessage = list.get(i);
            Packet packet = transactionWorkMessage.getMessage();
            SysMessageID sysMessageID = packet.getSysMessageID();
            if (Store.getDEBUG()) {
                object = this.getPrefix() + " replaying sent message: " + transactionWorkMessage;
                logger.log(4, (String)object);
            }
            object = Destination.getDestination(packet.getDestination(), packet.getIsQueue() ? 1 : 2, true, true);
            DestinationUID destinationUID = ((Destination)object).getDestinationUID();
            if (!set.contains(object)) {
                ((Destination)object).load();
                set.add(object);
            }
            if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1276", (Object)sysMessageID);
                this.msgStore.removeMessage(destinationUID, sysMessageID, false);
            } else {
                logger.log(64, "B1277", (Object)sysMessageID);
            }
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            try {
                ((Destination)object).routeNewMessage(packetReference);
                continue;
            }
            catch (SelectorFormatException selectorFormatException) {
                throw new BrokerException(br.getString("B3227", sysMessageID), selectorFormatException);
            }
        }
    }

    private void replayAcknowledgedMessages(List<TransactionWorkMessageAck> list, Set set) throws IOException, BrokerException {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            TransactionWorkMessageAck transactionWorkMessageAck = list.get(i);
            String string = transactionWorkMessageAck.getDest();
            DestinationUID destinationUID = new DestinationUID(string);
            SysMessageID sysMessageID = transactionWorkMessageAck.getSysMessageID();
            ConsumerUID consumerUID = transactionWorkMessageAck.getConsumerID();
            if (Store.getDEBUG()) {
                object = this.getPrefix() + " replaying acknowledged message " + transactionWorkMessageAck;
                logger.log(4, (String)object);
            }
            if (!set.contains(object = Destination.getDestination(destinationUID.getName(), destinationUID.isQueue() ? 1 : 2, true, true))) {
                ((Destination)object).load();
                set.add(object);
            }
            if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1278", (Object)consumerUID, (Object)sysMessageID);
                if (((Destination)object).isQueue() && consumerUID.longValue() != 0L) {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, PacketReference.getQueueUID(), 2, false);
                    continue;
                }
                this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, 2, false);
                continue;
            }
            logger.log(64, "B1279", (Object)consumerUID, (Object)sysMessageID);
        }
    }

    public void replayRemoteAcks(TransactionAcknowledgement[] transactionAcknowledgementArray, TransactionUID transactionUID, HashSet hashSet) throws BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " replayRemoteAcks ";
            logger.log(4, string);
        }
        for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
            Object object;
            TransactionAcknowledgement transactionAcknowledgement = transactionAcknowledgementArray[i];
            SysMessageID sysMessageID = transactionAcknowledgement.getSysMessageID();
            ConsumerUID consumerUID = transactionAcknowledgement.getConsumerUID();
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference == null) {
                object = " could not find packet for replayed message ack " + transactionAcknowledgement + " in transaction " + transactionUID;
                logger.log(16, (String)object);
                continue;
            }
            object = packetReference.getDestination();
            DestinationUID destinationUID = ((Destination)object).getDestinationUID();
            if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1278", (Object)consumerUID, (Object)sysMessageID);
                if (((Destination)object).isQueue() && consumerUID.longValue() != 0L) {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, PacketReference.getQueueUID(), 2, false);
                    continue;
                }
                this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, 2, false);
                continue;
            }
            logger.log(64, "B1279", (Object)consumerUID, (Object)sysMessageID);
        }
    }

    public void loggedCommitWrittenToMessageStore(TransactionUID transactionUID, int n) {
        BaseTransactionManager baseTransactionManager = this.getTransactionManager(n);
        baseTransactionManager.playingToMessageStoreComplete(transactionUID);
    }

    BaseTransactionManager getTransactionManager(int n) {
        BaseTransactionManager baseTransactionManager = null;
        switch (n) {
            case 1: {
                baseTransactionManager = this.localTransactionManager;
                break;
            }
            case 3: {
                baseTransactionManager = this.clusterTransactionManager;
                break;
            }
            case 2: {
                baseTransactionManager = this.remoteTransactionManager;
                break;
            }
            case 0: {
                throw new UnsupportedOperationException("UNDEFINED_TRANSACTION_TYPE");
            }
            default: {
                throw new UnsupportedOperationException("unknown type:" + n);
            }
        }
        return baseTransactionManager;
    }

    public void logTxn(BaseTransaction baseTransaction) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " logTxn() " + baseTransaction);
        }
        try {
            try {
                this.store.txnLogSharedLock.lock();
                int n = baseTransaction.getType();
                BaseTransactionManager baseTransactionManager = this.getTransactionManager(n);
                baseTransactionManager.processTxn(baseTransaction);
                TransactionEvent transactionEvent = baseTransactionManager.generateEvent(baseTransaction, false);
                byte[] byArray = transactionEvent.writeToBytes();
                TransactionLogRecord transactionLogRecord = this.msgLogWriter.newTransactionLogRecord();
                transactionLogRecord.setBody(byArray);
                this.msgLogWriter.write(transactionLogRecord);
            }
            catch (IOException iOException) {
                throw new BrokerException("error logging transaction", iOException);
            }
            Object var8_8 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    public void logTxnCompletion(TransactionUID transactionUID, int n, int n2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " logTxnCompletion() " + transactionUID);
        }
        try {
            try {
                this.store.txnLogSharedLock.lock();
                BaseTransactionManager baseTransactionManager = this.getTransactionManager(n2);
                BaseTransaction baseTransaction = baseTransactionManager.processTxnCompletion(transactionUID, n);
                TransactionEvent transactionEvent = baseTransactionManager.generateEvent(baseTransaction, true);
                byte[] byArray = transactionEvent.writeToBytes();
                TransactionLogRecord transactionLogRecord = this.msgLogWriter.newTransactionLogRecord();
                transactionLogRecord.setBody(byArray);
                this.msgLogWriter.write(transactionLogRecord);
            }
            catch (IOException iOException) {
                throw new BrokerException("error in logTxnCompletion", iOException);
            }
            Object var10_10 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doCheckpoint() {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " doCheckpoint");
        }
        Store store = null;
        try {
            store = Globals.getStore();
        }
        catch (Throwable throwable) {
            logger.logStack(32, "failed to getStore", throwable);
        }
        try {
            try {
                store.txnLogExclusiveLock.lock();
                this.localTransactionManager.waitForPlayingToMessageStoreCompletion();
                this.clusterTransactionManager.waitForPlayingToMessageStoreCompletion();
                this.remoteTransactionManager.waitForPlayingToMessageStoreCompletion();
                store.syncStore();
                this.localTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
                this.clusterTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
                this.remoteTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
                this.preparedTxnStore.sync();
                this.msgLogWriter.checkpoint();
                this.localTransactionManager.removeCompleteTransactionsAfterCheckpoint();
                this.clusterTransactionManager.removeCompleteTransactionsAfterCheckpoint();
                this.remoteTransactionManager.removeCompleteTransactionsAfterCheckpoint();
            }
            catch (Throwable throwable) {
                String string = this.getPrefix() + "Failed to synchronize persistence store for transaction log checkpoint";
                logger.logStack(32, "B3100", (Object)string, throwable);
                Object var5_5 = null;
                store.txnLogExclusiveLock.unlock();
                if (!Store.getDEBUG()) return;
                logger.log(4, this.getPrefix() + " doCheckpoint complete");
                return;
            }
            Object var5_4 = null;
            store.txnLogExclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            store.txnLogExclusiveLock.unlock();
            if (!Store.getDEBUG()) throw throwable;
            logger.log(4, this.getPrefix() + " doCheckpoint complete");
            throw throwable;
        }
        if (!Store.getDEBUG()) return;
        logger.log(4, this.getPrefix() + " doCheckpoint complete");
    }

    public final void checkpoint() {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " request a checkpoint");
        }
        this.checkpointManager.enqueueCheckpoint();
    }

    String getPrefix() {
        return "TransactionLogManager: " + Thread.currentThread().getName();
    }

    public LocalTransactionManager getLocalTransactionManager() {
        return this.localTransactionManager;
    }

    public ClusterTransactionManager getClusterTransactionManager() {
        return this.clusterTransactionManager;
    }

    public RemoteTransactionManager getRemoteTransactionManager() {
        return this.remoteTransactionManager;
    }
}

