/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;

class ConfigRecordStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ArrayList timeList = new ArrayList(32);
    private ArrayList recordList = new ArrayList(32);

    ConfigRecordStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.add(new Long(l));
            this.recordList.add(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConfigChangeRecordsSince(long l) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.timeList;
        synchronized (arrayList2) {
            Long l2;
            int n;
            int n2 = this.timeList.size();
            for (n = 0; n < n2 && (l2 = (Long)this.timeList.get(n)) <= l; ++n) {
            }
            while (n < n2) {
                arrayList.add(this.recordList.get(n));
                ++n;
            }
            return arrayList;
        }
    }

    public Object[] getAllConfigRecords() throws BrokerException {
        Object[] objectArray = new Object[]{this.timeList.clone(), this.recordList.clone()};
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigRecordStore.clearAll() called");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigRecordStore: closing, " + this.timeList.size() + " in-memory records");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Config change records", String.valueOf(this.timeList.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nConfiguration Change Record");
        printStream.println("---------------------------");
        printStream.println("number of records: " + this.timeList.size());
    }
}

