/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.dump;

import com.sun.xml.ws.api.message.Packet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class MessageDumper {
    private static final com.sun.xml.ws.commons.Logger DUMPER_LOGGER = com.sun.xml.ws.commons.Logger.getLogger(MessageDumper.class);
    private final String tubeName;
    private final Logger logger;
    private Level loggingLevel;
    private final XMLOutputFactory xmlOutputFactory;
    private AtomicBoolean logMissingStaxUtilsWarning;

    public MessageDumper(String tubeName, Logger logger, Level loggingLevel) {
        this.tubeName = tubeName;
        this.logger = logger;
        this.loggingLevel = loggingLevel;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.logMissingStaxUtilsWarning = new AtomicBoolean(false);
    }

    final boolean isLoggable() {
        return this.logger.isLoggable(this.loggingLevel);
    }

    final void setLoggingLevel(Level level) {
        this.loggingLevel = level;
    }

    final String createLogMessage(MessageType messageType, ProcessingState processingState, int tubeId, String engineId, String message) {
        return String.format("%s %s in Tube [ %s ] Instance [ %d ] Engine [ %s ] Thread [ %s ]:%n%s", new Object[]{messageType, processingState, this.tubeName, tubeId, engineId, Thread.currentThread().getName(), message});
    }

    final String dump(MessageType messageType, ProcessingState processingState, String message, int tubeId, String engineId) {
        String logMessage = this.createLogMessage(messageType, processingState, tubeId, engineId, message);
        this.logger.log(this.loggingLevel, logMessage);
        return logMessage;
    }

    final String convertToString(Throwable throwable) {
        if (throwable == null) {
            return "[ No exception ]";
        }
        StringWriter stringOut = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringOut));
        return stringOut.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String convertToString(Packet packet) {
        if (packet == null) {
            return "[ Null packet ]";
        }
        StringWriter stringOut = null;
        try {
            stringOut = new StringWriter();
            if (packet.getMessage() == null) {
                stringOut.write("[ Empty packet ]");
            } else {
                XMLStreamWriter writer = null;
                try {
                    writer = this.xmlOutputFactory.createXMLStreamWriter(stringOut);
                    writer = this.createIndenter(writer);
                    packet.getMessage().copy().writeTo(writer);
                }
                catch (XMLStreamException e) {
                    DUMPER_LOGGER.log(Level.WARNING, "Unexpected exception occured while dumping message", e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (XMLStreamException ignored) {
                            DUMPER_LOGGER.fine("Unexpected exception occured while closing XMLStreamWriter", ignored);
                        }
                    }
                }
            }
            String string2 = stringOut.toString();
            return string2;
        }
        finally {
            if (stringOut != null) {
                try {
                    stringOut.close();
                }
                catch (IOException ex) {
                    DUMPER_LOGGER.finest("An exception occured when trying to close StringWriter", ex);
                }
            }
        }
    }

    final XMLStreamWriter createIndenter(XMLStreamWriter writer) {
        block2: {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
                Constructor<?> c = clazz.getConstructor(XMLStreamWriter.class);
                writer = (XMLStreamWriter)XMLStreamWriter.class.cast(c.newInstance(writer));
            }
            catch (Exception ex) {
                if (!this.logMissingStaxUtilsWarning.compareAndSet(false, true)) break block2;
                DUMPER_LOGGER.log(Level.WARNING, "Put stax-utils.jar to the classpath to indent the dump output", ex);
            }
        }
        return writer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MessageType {
        Request("Request message"),
        Response("Response message"),
        Exception("Response exception");

        private final String name;

        private MessageType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ProcessingState {
        Received("received"),
        Processed("processed");

        private final String name;

        private ProcessingState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

