/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.runtime.DestinationMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTask;
import com.sun.xml.ws.rx.rm.runtime.SourceMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.ScheduledTaskManager;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.concurrent.ScheduledFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeContext {
    public final RxConfiguration configuration;
    public final AddressingVersion addressingVersion;
    public final SOAPVersion soapVersion;
    public final RmVersion rmVersion;
    public final SequenceManager sequenceManager;
    public final Communicator communicator;
    public final SuspendedFiberStorage suspendedFiberStorage;
    public final WsrmProtocolHandler protocolHandler;
    public final ScheduledTaskManager scheduledTaskManager;
    final RedeliveryTask redeliveryTask;
    final SourceMessageHandler sourceMessageHandler;
    final DestinationMessageHandler destinationMessageHandler;

    public static Builder getBuilder(@NotNull RxConfiguration configuration, @NotNull SequenceManager sequenceManager, @NotNull Communicator communicator) {
        return new Builder(configuration, sequenceManager, communicator);
    }

    private RuntimeContext(RxConfiguration configuration, SequenceManager sequenceManager, Communicator communicator, SuspendedFiberStorage suspendedFiberStorage, WsrmProtocolHandler protocolHandler, ScheduledTaskManager scheduledTaskManager, SourceMessageHandler srcMsgHandler, DestinationMessageHandler dstMsgHandler, RedeliveryTask redeliveryTask) {
        this.configuration = configuration;
        this.sequenceManager = sequenceManager;
        this.communicator = communicator;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.protocolHandler = protocolHandler;
        this.scheduledTaskManager = scheduledTaskManager;
        this.sourceMessageHandler = srcMsgHandler;
        this.destinationMessageHandler = dstMsgHandler;
        this.addressingVersion = configuration.getAddressingVersion();
        this.soapVersion = configuration.getSoapVersion();
        this.rmVersion = configuration.getRmVersion();
        this.redeliveryTask = redeliveryTask;
    }

    public ScheduledFuture<?> startTask(Runnable task) {
        return this.scheduledTaskManager.startTask(task);
    }

    public ScheduledFuture<?> startTask(Runnable task, long delay, long period) {
        return this.scheduledTaskManager.startTask(task, delay, period);
    }

    public ScheduledFuture<?> startRedeliveryTask() {
        return this.scheduledTaskManager.startTask(this.redeliveryTask, this.configuration.getMessageRetransmissionInterval(), this.configuration.getMessageRetransmissionInterval());
    }

    public ScheduledFuture<?> startAckRequesterTask(Runnable ackRequesterTask) {
        return this.scheduledTaskManager.startTask(ackRequesterTask, this.configuration.getAcknowledgementRequestInterval(), this.configuration.getAcknowledgementRequestInterval());
    }

    public void stopAllTasks() {
        this.scheduledTaskManager.stopAll();
    }

    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        return this.sequenceManager.getSequence(sequenceId);
    }

    public Sequence getBoundSequence(String sequenceId) throws UnknownSequenceException {
        return this.sequenceManager.getBoundSequence(sequenceId);
    }

    public String getBoundSequenceId(String sequenceId) throws UnknownSequenceException {
        Sequence boundSequence = this.sequenceManager.getBoundSequence(sequenceId);
        return boundSequence != null ? boundSequence.getId() : null;
    }

    public static final class Builder {
        @NotNull
        private final RxConfiguration configuration;
        @NotNull
        private final SequenceManager sequenceManager;
        @NotNull
        private final Communicator communicator;
        @NotNull
        private final SourceMessageHandler sourceMessageHandler;
        @NotNull
        private final DestinationMessageHandler destinationMessageHandler;
        @NotNull
        private final RedeliveryTask redeliveryTask;

        public Builder(@NotNull RxConfiguration configuration, @NotNull SequenceManager sequenceManager, @NotNull Communicator communicator) {
            assert (configuration != null);
            assert (sequenceManager != null);
            assert (communicator != null);
            this.configuration = configuration;
            this.sequenceManager = sequenceManager;
            this.communicator = communicator;
            this.sourceMessageHandler = new SourceMessageHandler(sequenceManager);
            this.destinationMessageHandler = new DestinationMessageHandler(sequenceManager);
            this.redeliveryTask = new RedeliveryTask(this.sourceMessageHandler, sequenceManager);
        }

        public RuntimeContext build() {
            return new RuntimeContext(this.configuration, this.sequenceManager, this.communicator, new SuspendedFiberStorage(), WsrmProtocolHandler.getInstance(this.configuration, this.communicator, this.sequenceManager), new ScheduledTaskManager(), this.sourceMessageHandler, this.destinationMessageHandler, this.redeliveryTask);
        }
    }
}

