/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;

class SourceMessageHandler
implements RedeliveryTask.DeliveryHandler {
    private final SequenceManager sequenceManager;

    SourceMessageHandler(@NotNull SequenceManager sequenceManager) {
        assert (sequenceManager != null);
        this.sequenceManager = sequenceManager;
    }

    public void registerMessage(@NotNull ApplicationMessage outMessage, @NotNull String outboundSequenceId) throws DuplicateMessageRegistrationException, UnknownSequenceException {
        assert (outMessage != null);
        assert (outboundSequenceId != null);
        Sequence outboundSequence = this.sequenceManager.getSequence(outboundSequenceId);
        outboundSequence.registerMessage(outMessage, true);
    }

    public void attachAcknowledgementInfo(@NotNull ApplicationMessage outMessage) throws UnknownSequenceException {
        assert (outMessage != null);
        assert (outMessage.getSequenceId() != null);
        outMessage.setAcknowledgementData(this.getAcknowledgementData(outMessage.getSequenceId()));
    }

    public AcknowledgementData getAcknowledgementData(String outboundSequenceId) throws UnknownSequenceException {
        Sequence outboundSequence;
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        Sequence inboundSequence = this.sequenceManager.getBoundSequence(outboundSequenceId);
        if (inboundSequence != null && inboundSequence.isAckRequested()) {
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageIds());
            inboundSequence.clearAckRequestedFlag();
        }
        if ((outboundSequence = this.sequenceManager.getSequence(outboundSequenceId)).hasUnacknowledgedMessages()) {
            ackDataBuilder.ackReqestedSequenceId(outboundSequenceId);
            outboundSequence.updateLastAcknowledgementRequestTime();
        }
        AcknowledgementData acknowledgementData = ackDataBuilder.build();
        return acknowledgementData;
    }

    public void putToDeliveryQueue(ApplicationMessage message) throws RxRuntimeException {
        this.sequenceManager.getSequence(message.getSequenceId()).getDeliveryQueue().put(message);
    }
}

