/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceClosedException;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceTerminatedException;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence
implements Sequence {
    protected final SequenceData data;
    private final DeliveryQueue deliveryQueue;
    private final TimeSynchronizer timeSynchronizer;

    AbstractSequence(@NotNull SequenceData data, @NotNull DeliveryQueueBuilder deliveryQueueBuilder, @NotNull TimeSynchronizer timeSynchronizer) {
        assert (data != null);
        assert (deliveryQueueBuilder != null);
        assert (timeSynchronizer != null);
        this.data = data;
        this.timeSynchronizer = timeSynchronizer;
        deliveryQueueBuilder.sequence(this);
        this.deliveryQueue = deliveryQueueBuilder.build();
    }

    public SequenceData getData() {
        return this.data;
    }

    @Override
    public String getId() {
        return this.data.getSequenceId();
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.data.getBoundSecurityTokenReferenceId();
    }

    @Override
    public long getLastMessageId() {
        return this.data.getLastMessageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sequence.AckRange> getAcknowledgedMessageIds() {
        this.data.lockRead();
        try {
            if (this.getLastMessageId() == 0L) {
                List<Sequence.AckRange> list = Collections.emptyList();
                return list;
            }
            if (this.getUnackedMessageIdStorage().isEmpty()) {
                List<Sequence.AckRange> list = Arrays.asList(new Sequence.AckRange(1L, this.getLastMessageId()));
                return list;
            }
            LinkedList<Sequence.AckRange> result = new LinkedList<Sequence.AckRange>();
            Iterator<Long> unackedIndexIterator = this.getUnackedMessageIdStorage().iterator();
            long lastBottomAckRange = 1L;
            while (unackedIndexIterator.hasNext()) {
                long lastUnacked = unackedIndexIterator.next();
                if (lastBottomAckRange < lastUnacked) {
                    result.add(new Sequence.AckRange(lastBottomAckRange, lastUnacked - 1L));
                }
                lastBottomAckRange = lastUnacked + 1L;
            }
            if (lastBottomAckRange <= this.getLastMessageId()) {
                result.add(new Sequence.AckRange(lastBottomAckRange, this.getLastMessageId()));
            }
            LinkedList<Sequence.AckRange> linkedList = result;
            return linkedList;
        }
        finally {
            this.data.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcknowledged(long messageId) {
        try {
            this.data.lockRead();
            if (messageId > this.getLastMessageId()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.getUnackedMessageIdStorage().contains(messageId);
            return bl;
        }
        finally {
            this.data.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUnacknowledgedMessages() {
        try {
            this.data.lockRead();
            boolean bl = !this.getUnackedMessageIdStorage().isEmpty();
            return bl;
        }
        finally {
            this.data.unlockRead();
        }
    }

    @Override
    public Sequence.State getState() {
        return this.data.getState();
    }

    public void setState(Sequence.State newState) {
        this.data.setState(newState);
    }

    @Override
    public void setAckRequestedFlag() {
        this.data.setAckRequestedFlag(true);
    }

    @Override
    public void clearAckRequestedFlag() {
        this.data.setAckRequestedFlag(false);
    }

    @Override
    public boolean isAckRequested() {
        return this.data.getAckRequestedFlag();
    }

    @Override
    public void updateLastAcknowledgementRequestTime() {
        this.data.setLastAcknowledgementRequestTime(this.timeSynchronizer.currentTimeInMillis());
    }

    @Override
    public long getLastActivityTime() {
        return this.data.getLastActivityTime();
    }

    public void updateLastActivityTime() {
        this.data.setLastActivityTime(this.timeSynchronizer.currentTimeInMillis());
    }

    @Override
    public boolean isStandaloneAcknowledgementRequestSchedulable(long delayPeriod) {
        return this.timeSynchronizer.currentTimeInMillis() - this.data.getLastAcknowledgementRequestTime() > delayPeriod && this.hasUnacknowledgedMessages();
    }

    @Override
    public void close() {
        this.data.setState(Sequence.State.CLOSED);
    }

    @Override
    public boolean isClosed() {
        Sequence.State currentStatus = this.data.getState();
        return currentStatus == Sequence.State.CLOSING || currentStatus == Sequence.State.CLOSED || currentStatus == Sequence.State.TERMINATING;
    }

    @Override
    public boolean isExpired() {
        return this.data.getExpirationTime() == -1L ? false : this.timeSynchronizer.currentTimeInMillis() < this.data.getExpirationTime();
    }

    @Override
    public void preDestroy() {
    }

    abstract Collection<Long> getUnackedMessageIdStorage();

    public final void storeMessage(ApplicationMessage message, Long msgNumberKey) throws UnsupportedOperationException {
        this.data.storeMessage(message, msgNumberKey);
    }

    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        return this.data.retrieveMessage(correlationId);
    }

    @Override
    public ApplicationMessage retrieveUnackedMessage(long messageNumber) {
        return this.data.retrieveUnackedMessage(messageNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeliveryQueue getDeliveryQueue() {
        try {
            this.data.lockRead();
            DeliveryQueue deliveryQueue = this.deliveryQueue;
            return deliveryQueue;
        }
        finally {
            this.data.unlockRead();
        }
    }

    protected final void checkSequenceCreatedStatus(String message, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
        switch (this.getState()) {
            case CLOSING: 
            case CLOSED: {
                throw new SequenceClosedException(message);
            }
            case TERMINATING: {
                throw new SequenceTerminatedException(message, code);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSequence other = (AbstractSequence)obj;
        return !(this.data.getSequenceId() == null ? other.data.getSequenceId() != null : !this.data.getSequenceId().equals(other.data.getSequenceId()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.data.getSequenceId() != null ? this.data.getSequenceId().hashCode() : 0);
        return hash;
    }
}

