/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceManager;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SequenceManagerFactory {
    INSTANCE;

    private final SequenceManager clientSequenceManager = new InVmSequenceManager(SequenceManager.Type.CLIENT, null);
    private final ReadWriteLock serviceCacheLock = new ReentrantReadWriteLock();
    private final Map<Object, SequenceManager> serviceSequenceManagerCache = new WeakHashMap<Object, SequenceManager>();

    public SequenceManager getClientSequenceManager(ManagedObjectManager managedObjectManager) {
        return this.clientSequenceManager;
    }

    public SequenceManager getServerSequenceManager(Object correlationId, ManagedObjectManager managedObjectManager) {
        return this.getInMemorySequenceManager(correlationId, SequenceManager.Type.SERVICE, managedObjectManager, this.serviceSequenceManagerCache, this.serviceCacheLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SequenceManager getInMemorySequenceManager(Object correlationId, SequenceManager.Type type, ManagedObjectManager mom, Map<Object, SequenceManager> cache, ReadWriteLock cacheLock) {
        try {
            cacheLock.readLock().lock();
            SequenceManager sequenceManager = cache.get(correlationId);
            if (sequenceManager == null) {
                cacheLock.readLock().unlock();
                try {
                    cacheLock.writeLock().lock();
                    sequenceManager = cache.get(correlationId);
                    if (sequenceManager == null) {
                        sequenceManager = new InVmSequenceManager(type, mom);
                        cache.put(correlationId, sequenceManager);
                    }
                }
                finally {
                    cacheLock.readLock().lock();
                    cacheLock.writeLock().unlock();
                }
            }
            SequenceManager sequenceManager2 = sequenceManager;
            return sequenceManager2;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }
}

