/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistentSequenceData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentSequenceManager
implements SequenceManager {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceManager.class);
    private static final String RM_JDBC_POOL_NAME = "jdbc/ReliableMessagingPool";
    private Connection sqlConnection = null;
    private final ReadWriteLock internalDataAccessLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();
    private final ManagedObjectManager managedObjectManager;

    public PersistentSequenceManager(SequenceManager.Type type, ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
        if (managedObjectManager != null) {
            managedObjectManager.registerAtRoot((Object)this, type.toString());
        }
    }

    @Override
    public Map<String, ? extends Sequence> sequences() {
        return null;
    }

    @Override
    public Map<String, String> boundSequences() {
        return null;
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime, DeliveryQueueBuilder deliveryQueueBuilder) throws DuplicateSequenceException {
        PersistentSequenceData data = new PersistentSequenceData(sequenceId, PersistentSequenceData.SequenceType.OUTBOUND, strId, expirationTime, 0L, this.currentTimeInMillis());
        return this.registerSequence(new OutboundSequence(data, deliveryQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime, DeliveryQueueBuilder deliveryQueueBuilder) throws DuplicateSequenceException {
        PersistentSequenceData data = new PersistentSequenceData(sequenceId, PersistentSequenceData.SequenceType.INBOUND, strId, expirationTime, 0L, this.currentTimeInMillis());
        return this.registerSequence(new InboundSequence(data, deliveryQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(String sequenceId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            PersistentSequenceData data = (PersistentSequenceData)PersistentSequenceData.class.cast(sequence.getData());
            data = PersistentSequenceData.insert(this.sqlConnection, data);
            this.sequences.put(sequence.getId(), sequence);
            if (this.managedObjectManager != null) {
                this.managedObjectManager.register((Object)this, (Object)sequence, sequence.getId().replace(':', '-'));
            }
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    protected void abort() {
        try {
            this.sqlConnection.rollback();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    protected void commit() throws SQLException {
        this.sqlConnection.commit();
    }

    protected void beginTransaction() {
    }

    synchronized void connect() throws PersistenceException {
        try {
            InitialContext ic = new InitialContext();
            Object __ds = ic.lookup(RM_JDBC_POOL_NAME);
            if (!(__ds instanceof DataSource)) {
                throw new PersistenceException(String.format("Object of class '%s' bound in the JNDI under '%s' is not an instance of '%s'.", __ds.getClass().getName(), RM_JDBC_POOL_NAME, DataSource.class.getName()));
            }
            DataSource ds = (DataSource)DataSource.class.cast(__ds);
            this.sqlConnection = ds.getConnection("username", "password");
            this.sqlConnection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw LOGGER.logSevereException(new PersistenceException("Unable to retrieve JDBC connection to Metro reliable messaging database", ex));
        }
        catch (NamingException ex) {
            throw LOGGER.logSevereException(new PersistenceException("Unable to lookup Metro reliable messaging JDBC connection pool", ex));
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }
}

