/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.misc.TimingDelta;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.config.AMXConfigLoader;
import org.glassfish.admin.amx.loader.J2EELoader;
import org.glassfish.admin.amx.loader.LoadAMX;
import org.glassfish.admin.amx.util.ImplUtil;
import org.glassfish.admin.amx.util.InjectedValues;
import org.glassfish.admin.amx.util.SingletonEnforcer;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.BooterOldMBean;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Transactions;

@Service
public final class AMXStartupService
implements PostConstruct,
PreDestroy,
AMXStartupServiceMBean {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    Transactions mTransactions;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    private volatile PendingConfigBeans mPendingConfigBeans;
    private volatile ObjectName mAMXLoaderObjectName;
    private volatile J2EELoader mJ2EELoader;
    private volatile AMXConfigLoader mConfigLoader;

    private static void debug(String s) {
        System.out.println(s);
    }

    public AMXStartupService() {
        AMXStartupService.debug(this.getClass().getName());
    }

    private static ObjectName getObjectName() {
        return OBJECT_NAME;
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        SingletonEnforcer.register(this.getClass(), this);
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        if (this.mPendingConfigBeans == null) {
            throw new Error("AMXStartup: null mPendingConfigBeans");
        }
        try {
            StandardMBean mbean = new StandardMBean(this, AMXStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, AMXStartupService.getObjectName());
        }
        catch (JMException e) {
            throw new Error(e);
        }
        ImplUtil.getLogger().fine("Initialized AMX Startup service in " + delta.elapsedMillis() + " ms, registered as " + AMXStartupService.getObjectName());
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("AMXStartupService.preDestroy(): stopping AMX");
        this.stopAMX();
    }

    public synchronized ObjectName getDomainRootObjectName() {
        try {
            return Util.getObjectName((AMX)this.getDomainRootProxy());
        }
        catch (Exception e) {
            return null;
        }
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        try {
            return (JMXServiceURL[])this.mMBeanServer.getAttribute(BooterOldMBean.OBJECT_NAME, "JMXServiceURLs");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public static AMXStartupServiceMBean getAMXStartupServiceMBeanProxy(MBeanServer mbs) {
        AMXStartupServiceMBean ss = null;
        if (mbs.isRegistered(AMXStartupService.getObjectName())) {
            ss = (AMXStartupServiceMBean)AMXStartupServiceMBean.class.cast(MBeanServerInvocationHandler.newProxyInstance(mbs, AMXStartupService.getObjectName(), AMXStartupServiceMBean.class, false));
        }
        return ss;
    }

    public DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRoot();
    }

    public ObjectName getDomainRoot() {
        return this.getDomainRootObjectName();
    }

    public ObjectName loadAMXMBeans() {
        return this.startAMX();
    }

    public void unloadAMXMBeans() {
        this.stopAMX();
    }

    public synchronized ObjectName startAMX() {
        if (this.getDomainRootObjectName() == null) {
            TimingDelta delta = new TimingDelta();
            this.mAMXLoaderObjectName = LoadAMX.loadAMX(this.mMBeanServer);
            this.mJ2EELoader = new J2EELoader(this.mMBeanServer);
            this.mJ2EELoader.start();
            this.mConfigLoader = new AMXConfigLoader(this.mMBeanServer, this.mPendingConfigBeans, this.mTransactions);
            this.mConfigLoader.start();
            SingletonEnforcer.register(AMXConfigLoader.class, this.mConfigLoader);
            this.getDomainRootProxy().waitAMXReady();
            long elapsedMillis = delta.elapsedMillis();
            Set all = this.getDomainRootProxy().getQueryMgr().queryAllObjectNameSet();
            ImplUtil.getLogger().info("AMXStartupService: loaded " + all.size() + " AMX MBeans in " + elapsedMillis + " ms (wall-clock time)");
        }
        return this.getDomainRootObjectName();
    }

    public synchronized void stopAMX() {
        if (this.getDomainRoot() != null) {
            ImplUtil.unregisterAMXMBeans((AMX)this.getDomainRootProxy());
        }
    }
}

