/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.proxy;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeanProxyMethodHandler
implements MethodHandler {
    static final transient Log log = Logging.getLog(EnterpriseBeanProxyMethodHandler.class);
    private static final ThreadLocal<EnterpriseBean<?>> enterpriseBean = new ThreadLocal();
    final SessionObjectReference reference;
    final Class<?> objectInterface;
    boolean destroyed = false;

    public static EnterpriseBean<?> getEnterpriseBean() {
        return enterpriseBean.get();
    }

    private static void setEnterpriseBean(EnterpriseBean<?> bean) {
        enterpriseBean.set(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBeanProxyMethodHandler(EnterpriseBean<?> bean) {
        this.objectInterface = bean.getEjbDescriptor().getObjectInterface();
        try {
            EnterpriseBeanProxyMethodHandler.setEnterpriseBean(bean);
            this.reference = bean.createReference();
        }
        finally {
            EnterpriseBeanProxyMethodHandler.setEnterpriseBean(null);
        }
        log.trace((Object)("Created enterprise bean proxy method handler for " + bean), new Object[0]);
    }

    @Override
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        if ("isDestroyed".equals(method.getName())) {
            return this.destroyed;
        }
        if ("setDestroyed".equals(method.getName())) {
            if (args.length != 1) {
                throw new IllegalArgumentException("enterpriseBeanInstance.setDestroyed() called with >1 argument");
            }
            if (!args[0].getClass().equals(Boolean.TYPE)) {
                throw new IllegalArgumentException("enterpriseBeanInstance.setDestroyed() called with non-boolean argument");
            }
            this.destroyed = (Boolean)args[0];
        }
        if (this.destroyed) {
            return null;
        }
        Class<?> businessInterface = method.getDeclaringClass();
        if (businessInterface.equals(Object.class)) {
            businessInterface = this.objectInterface;
        }
        Object proxiedInstance = this.reference.getBusinessObject(businessInterface);
        Method proxiedMethod = Reflections.lookupMethod(method, proxiedInstance);
        Object returnValue = Reflections.invokeAndWrap(proxiedMethod, proxiedInstance, args);
        log.trace((Object)("Executed " + method + " on " + proxiedInstance + " with parameters " + args + " and got return value " + returnValue), new Object[0]);
        return returnValue;
    }
}

