/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.TransformerBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class BasicIndirectionPolicy
extends IndirectionPolicy {
    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        ValueHolderInterface valueHolder = (ValueHolderInterface)attributeValue;
        ValueHolder result = new ValueHolder();
        if (!(valueHolder instanceof UnitOfWorkValueHolder) || valueHolder.isInstantiated()) {
            result.setValue(super.backupCloneAttribute(valueHolder.getValue(), clone, backup, unitOfWork));
        } else {
            ((UnitOfWorkValueHolder)valueHolder).setBackupValueHolder(result);
        }
        return result;
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolder) {
        return valueHolder;
    }

    public Object cloneAttribute(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        WeavedAttributeValueHolderInterface result;
        ValueHolderInterface valueHolder = (ValueHolderInterface)attributeValue;
        if (!buildDirectlyFromRow && unitOfWork.isOriginalNewObject(original)) {
            if (valueHolder instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolder).isInstantiated() && ((DatabaseValueHolder)valueHolder).getSession() == null && !((DatabaseValueHolder)valueHolder).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(original, this.getMapping());
            }
            if (this.getMapping().getRelationshipPartner() == null) {
                result = new ValueHolder();
                result.setValue(this.getMapping().buildCloneForPartObject(valueHolder.getValue(), original, clone, unitOfWork, false));
            } else {
                AbstractRecord row = null;
                if (valueHolder instanceof DatabaseValueHolder) {
                    row = ((DatabaseValueHolder)valueHolder).getRow();
                }
                result = this.getMapping().createUnitOfWorkValueHolder(valueHolder, original, clone, row, unitOfWork, buildDirectlyFromRow);
                Object newObject = this.getMapping().buildCloneForPartObject(valueHolder.getValue(), original, clone, unitOfWork, false);
                ((UnitOfWorkValueHolder)result).privilegedSetValue(newObject);
                ((UnitOfWorkValueHolder)result).setInstantiated();
            }
        } else {
            AbstractRecord row = null;
            if (valueHolder instanceof DatabaseValueHolder) {
                row = ((DatabaseValueHolder)valueHolder).getRow();
            }
            result = this.getMapping().createUnitOfWorkValueHolder(valueHolder, original, clone, row, unitOfWork, buildDirectlyFromRow);
        }
        return result;
    }

    public Vector extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        if (this.objectIsInstantiated(referenceObject)) {
            return super.extractPrimaryKeyForReferenceObject(((ValueHolderInterface)referenceObject).getValue(), session);
        }
        return this.getOneToOneMapping().extractPrimaryKeysForReferenceObjectFromRow(this.extractReferenceRow(referenceObject));
    }

    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (this.objectIsInstantiated(referenceObject)) {
            return null;
        }
        return ((DatabaseValueHolder)referenceObject).getRow();
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object attributeValue = this.getMapping().getAttributeValueFromObject(object);
        if (attributeValue instanceof RemoteValueHolder) {
            RemoteValueHolder rvh = (RemoteValueHolder)this.getMapping().getAttributeValueFromObject(object);
            rvh.setSession(session);
            rvh.setMapping(this.getMapping());
            if (!query.shouldMaintainCache() && (!query.shouldCascadeParts() || query.shouldCascadePrivateParts() && !this.getMapping().isPrivateOwned())) {
                rvh.setQuery(null);
            } else {
                rvh.setQuery(query);
            }
            rvh.setUninstantiated();
        } else {
            this.getMapping().fixRealObjectReferences(object, objectDescriptors, processedObjects, query, session);
        }
    }

    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        return this.getOriginalValueHolder(unitOfWorkIndirectionObject, session);
    }

    public Object getOriginalValueHolder(Object unitOfWorkIndirectionObject, AbstractSession session) {
        if (unitOfWorkIndirectionObject instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolder = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder();
            if (valueHolder == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController controller = ((RemoteUnitOfWork)session).getParentSessionController();
                ObjID id = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolderRemoteID();
                if (id == null) {
                    Object object = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getSourceObject();
                    AbstractRecord row = this.getMapping().getDescriptor().getObjectBuilder().buildRow(object, session);
                    ReadObjectQuery query = new ReadObjectQuery();
                    query.setSession(((RemoteUnitOfWork)session).getParent());
                    valueHolder = (ValueHolderInterface)this.getMapping().valueFromRow(row, null, query);
                } else {
                    valueHolder = (ValueHolderInterface)controller.getRemoteValueHolders().get(id);
                }
            }
            if (valueHolder != null && valueHolder instanceof DatabaseValueHolder) {
                ((DatabaseValueHolder)valueHolder).releaseWrappedValueHolder();
            }
            return valueHolder;
        }
        return unitOfWorkIndirectionObject;
    }

    public void reset(Object target) {
        this.getMapping().setAttributeValueInObject(target, new ValueHolder());
    }

    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        if (attribute instanceof ValueHolderInterface) {
            return ((ValueHolderInterface)attribute).getValue();
        }
        return attribute;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return remoteValueHolder.getValue();
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        iterator.iterateValueHolderForMapping((ValueHolderInterface)attributeValue, this.getMapping());
    }

    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        RemoteValueHolder serverValueHolder = (RemoteValueHolder)this.getMapping().getAttributeValueFromObject(serverSideDomainObject);
        this.mergeClientIntoServerValueHolder(serverValueHolder, mergeManager);
        this.getMapping().setAttributeValueInObject(clientSideDomainObject, serverValueHolder);
    }

    public Object nullValueFromRow() {
        return new ValueHolder();
    }

    public boolean objectIsInstantiated(Object object) {
        return ((ValueHolderInterface)object).isInstantiated();
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        ValueHolderInterface holder = (ValueHolderInterface)this.getMapping().getAttributeValueFromObject(target);
        if (holder == null) {
            holder = new ValueHolder(attributeValue);
        } else {
            holder.setValue(attributeValue);
        }
        super.setRealAttributeValueInObject(target, holder);
    }

    protected boolean typeIsValid(Class attributeType) {
        return attributeType == ClassConstants.ValueHolderInterface_Class || attributeType == ClassConstants.WeavedAttributeValueHolderInterface_Class;
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (attributeValue == null) {
            return new ValueHolder();
        }
        if (!(attributeValue instanceof ValueHolderInterface)) {
            throw DescriptorException.valueHolderInstantiationMismatch(attributeValue, this.getMapping());
        }
        return attributeValue;
    }

    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeType(attributeType, checker);
        if (!this.typeIsValid(attributeType)) {
            checker.handleError(DescriptorException.attributeAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnType(returnType, checker);
        if (!this.typeIsValid(returnType)) {
            checker.handleError(DescriptorException.returnAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterType(parameterType, checker);
        if (!this.typeIsValid(parameterType)) {
            checker.handleError(DescriptorException.parameterAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery) {
        return new BatchValueHolder(batchQuery, row, this.getForeignReferenceMapping(), originalQuery);
    }

    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        return new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, row, session);
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        return new QueryBasedValueHolder(query, row, session);
    }

    public Object valueFromRow(Object object) {
        return new ValueHolder(object);
    }
}

