/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;

public class XMLCollectionReferenceMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private XMLCollectionReferenceMapping xmlCollectionReferenceMapping;
    private XMLField xmlField;
    private static final String SPACE = " ";

    public XMLCollectionReferenceMappingNodeValue(XMLCollectionReferenceMapping xmlCollectionReferenceMapping, XMLField xmlField) {
        this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
        this.xmlField = xmlField;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        if (value != null) {
            Object realValue = this.xmlField.convertValueBasedOnSchemaType(value, (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager(), unmarshalRecord);
            this.xmlCollectionReferenceMapping.buildReference(unmarshalRecord, this.xmlField, realValue, unmarshalRecord.getSession());
        }
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (!this.xmlField.getLastXPathFragment().nameIsText()) {
            return;
        }
        Object value = unmarshalRecord.getStringBuffer().toString();
        unmarshalRecord.resetStringBuffer();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = this.xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value = xmlConversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = this.xmlField.convertValueBasedOnSchemaType(value, xmlConversionManager, unmarshalRecord);
        }
        this.xmlCollectionReferenceMapping.buildReference(unmarshalRecord, this.xmlField, value, unmarshalRecord.getSession());
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            return xPathFragment.nameIsText() || xPathFragment.isAttribute();
        }
        XPathFragment nextFragment = xPathFragment.getNextFragment();
        return nextFragment != null && (nextFragment.nameIsText() || nextFragment.isAttribute());
    }

    public boolean isContainerValue() {
        return true;
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCollectionReferenceMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlCollectionReferenceMapping.getContainerPolicy();
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object objectValue;
        ContainerPolicy cp = this.xmlCollectionReferenceMapping.getContainerPolicy();
        Object collection = this.xmlCollectionReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (!cp.hasNext(iterator)) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        String stringValue = "";
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(objectValue, this.xmlField, session);
                if (fieldValue == null) {
                    return false;
                }
                QName schemaType = this.getSchemaType(this.xmlField, fieldValue, session);
                String newValue = this.getValueToWrite(schemaType, fieldValue, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), namespaceResolver);
                if (newValue == null) continue;
                stringValue = stringValue + newValue;
                if (!cp.hasNext(iterator)) continue;
                stringValue = stringValue + SPACE;
            }
            this.marshalSingleValue(xPathFragment, marshalRecord, object, stringValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        } else {
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            }
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        if (this.xmlField.getLastXPathFragment().isAttribute() && !this.xmlCollectionReferenceMapping.usesSingleNode()) {
            String namespaceURI = this.xmlField.getLastXPathFragment().getNamespaceURI();
            String value = namespaceURI == null ? atts.getValue(this.xmlField.getLastXPathFragment().getLocalName()) : atts.getValue(namespaceURI, this.xmlField.getLastXPathFragment().getLocalName());
            this.xmlCollectionReferenceMapping.buildReference(unmarshalRecord, this.xmlField, value, unmarshalRecord.getSession());
            return true;
        }
        return true;
    }

    public void marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, (String)value);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment);
                marshalRecord.characters((String)value);
            }
        } else {
            Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(value, this.xmlField, session);
            if (fieldValue == null) {
                return;
            }
            QName schemaType = this.getSchemaType(this.xmlField, fieldValue, session);
            String stringValue = this.getValueToWrite(schemaType, fieldValue, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), namespaceResolver);
            if (stringValue != null) {
                marshalRecord.openStartElement(xPathFragment, namespaceResolver);
                XPathFragment nextFragment = xPathFragment.getNextFragment();
                if (nextFragment.isAttribute()) {
                    marshalRecord.attribute(nextFragment, namespaceResolver, stringValue);
                    marshalRecord.closeStartElement();
                } else {
                    marshalRecord.closeStartElement();
                    marshalRecord.characters(stringValue);
                }
                marshalRecord.endElement(xPathFragment, namespaceResolver);
            }
        }
    }

    public XMLCollectionReferenceMapping getMapping() {
        return this.xmlCollectionReferenceMapping;
    }
}

