/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine {
    private static XPathEngine instance = null;
    private UnmarshalXPathEngine unmarshalXPathEngine;
    private DocumentPreservationPolicy noDocPresPolicy = new NoDocumentPreservationPolicy();
    private DocumentPreservationPolicy xmlBinderPolicy = new XMLBinderPolicy();

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    private XPathEngine() {
        this.unmarshalXPathEngine = new UnmarshalXPathEngine();
    }

    public Node create(XMLField xmlField, Node element, AbstractSession session) throws XMLMarshalException {
        return this.create(xmlField, element, this, session);
    }

    public Node create(XMLField xmlField, Node element, Object value, AbstractSession session) {
        return this.create(xmlField, element, value, null, this.noDocPresPolicy, session);
    }

    public Node create(XMLField xmlField, Node element, Object value, XMLField lastUpdated, DocumentPreservationPolicy docPresPolicy, AbstractSession session) throws XMLMarshalException {
        XPathFragment fragment;
        if (null == value) {
            return null;
        }
        if (docPresPolicy == null) {
            docPresPolicy = this.noDocPresPolicy;
        }
        if ((fragment = xmlField.getXPathFragment()).getNextFragment() == null && fragment.nameIsText()) {
            Object textValue = this.getValueToWrite(value, xmlField, session);
            if (textValue instanceof String) {
                if (xmlField.isTypedTextField()) {
                    XMLNodeList createdElements = new XMLNodeList();
                    createdElements.add(element);
                    this.addTypeAttributes(createdElements, xmlField, value, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)));
                }
                return this.addText(xmlField, element, (String)textValue);
            }
            return null;
        }
        NodeList created = this.createCollection(xmlField, element, value, lastUpdated, docPresPolicy, session);
        if (created == null || created.getLength() == 0) {
            return null;
        }
        return created.item(0);
    }

    private NodeList createCollection(XMLField xmlField, Node element, Object value, XMLField lastUpdated, DocumentPreservationPolicy docPresPolicy, AbstractSession session) throws XMLMarshalException {
        NodeList nodes;
        XMLNodeList createdElements = new XMLNodeList();
        if (value == null || value instanceof Collection && ((Collection)value).size() == 0) {
            return createdElements;
        }
        Node nextElement = element;
        Element sibling = null;
        if (lastUpdated != null && !lastUpdated.getXPathFragment().isAttribute() && !lastUpdated.getXPathFragment().nameIsText() && (nodes = this.unmarshalXPathEngine.selectElementNodes(element, lastUpdated.getXPathFragment(), this.getNamespaceResolverForField(lastUpdated))).getLength() > 0) {
            sibling = (Element)nodes.item(nodes.getLength() - 1);
        }
        XPathFragment next = xmlField.getXPathFragment();
        while (next != null) {
            boolean hasMore;
            if (next.isAttribute()) {
                this.addAttribute(next, xmlField, nextElement, value, session);
            } else if (next.containsIndex()) {
                boolean bl = hasMore = !next.getHasText() && next.getNextFragment() != null;
                if (hasMore) {
                    nextElement = this.addIndexedElement(next, xmlField, nextElement, this, !hasMore, session);
                } else {
                    Object valueToWrite = this.getValueToWrite(value, xmlField, session);
                    nextElement = this.addIndexedElement(next, xmlField, nextElement, valueToWrite, !hasMore, session);
                    createdElements.add(nextElement);
                }
            } else {
                NodeList elements;
                boolean bl = hasMore = !next.getHasText() && next.getNextFragment() != null;
                if (hasMore) {
                    elements = this.addElements(next, xmlField, nextElement, this, !hasMore, sibling, docPresPolicy, session);
                } else {
                    XPathFragment nextFragment = next.getNextFragment();
                    if (nextFragment != null && nextFragment.isAttribute() && !(value instanceof List)) {
                        elements = this.addElements(next, xmlField, nextElement, this, hasMore, sibling, docPresPolicy, session);
                    } else {
                        Object valueToWrite = this.getValueToWrite(value, xmlField, session);
                        elements = this.addElements(next, xmlField, nextElement, valueToWrite, !hasMore, sibling, docPresPolicy, session);
                        createdElements.addAll(elements);
                    }
                }
                nextElement = elements.item(elements.getLength() - 1);
            }
            next = next.getNextFragment();
            sibling = null;
            if (next == null || !next.nameIsText()) continue;
            next = null;
        }
        if (xmlField.isTypedTextField()) {
            this.addTypeAttributes(createdElements, xmlField, value, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)));
        }
        return createdElements;
    }

    private Object getNonNodeValueToWrite(Object value, XMLField xmlField, AbstractSession session) {
        if (this == value) {
            return this;
        }
        QName schemaType = null;
        if (xmlField.getLeafElementType() != null) {
            schemaType = xmlField.getLeafElementType();
        } else {
            if (xmlField.isUnionField()) {
                return this.getValueToWriteForUnion((XMLUnionField)xmlField, value, session);
            }
            if (xmlField.isTypedTextField()) {
                schemaType = xmlField.getXMLType(value.getClass());
            } else if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        if (value instanceof List) {
            if (xmlField.usesSingleNode()) {
                String returnString = "";
                for (int i = 0; i < ((List)value).size(); ++i) {
                    Object nextItem = ((List)value).get(i);
                    String nextConvertedItem = (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(nextItem, ClassConstants.STRING, schemaType);
                    returnString = returnString + nextConvertedItem;
                    if (i >= ((List)value).size() - 1) continue;
                    returnString = returnString + " ";
                }
                return returnString;
            }
            ArrayList items = new ArrayList(((List)value).size());
            for (int index = 0; index < ((List)value).size(); ++index) {
                String nextConvertedItem;
                Object nextItem = ((List)value).get(index);
                if (nextItem instanceof Node) {
                    items.add(nextItem);
                    continue;
                }
                if (schemaType != null && schemaType.equals(XMLConstants.QNAME_QNAME)) {
                    nextConvertedItem = this.getStringForQName((QName)nextItem, this.getNamespaceResolverForField(xmlField));
                    items.add(nextConvertedItem);
                    continue;
                }
                nextConvertedItem = (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(nextItem, ClassConstants.STRING, schemaType);
                items.add(nextConvertedItem);
            }
            return items;
        }
        if (schemaType != null && schemaType.equals(XMLConstants.QNAME_QNAME)) {
            return this.getStringForQName((QName)value, this.getNamespaceResolverForField(xmlField));
        }
        return ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
    }

    private Object getValueToWrite(Object value, XMLField xmlField, AbstractSession session) {
        if (value instanceof Node) {
            return value;
        }
        return this.getNonNodeValueToWrite(value, xmlField, session);
    }

    private String getSingleValueToWriteForUnion(XMLUnionField xmlField, Object value, AbstractSession session) {
        ArrayList schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        for (int i = 0; i < schemaTypes.size(); ++i) {
            QName nextQName = (QName)xmlField.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                Class javaClass = xmlField.getJavaClass(nextQName);
                value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
    }

    private Object getValueToWriteForUnion(XMLUnionField xmlField, Object value, AbstractSession session) {
        if (value instanceof List) {
            if (xmlField.usesSingleNode()) {
                String returnString = "";
                Object next = null;
                for (int i = 0; i < ((List)value).size(); ++i) {
                    next = ((List)value).get(i);
                    returnString = returnString + this.getSingleValueToWriteForUnion(xmlField, next, session);
                    if (i >= ((List)value).size() - 1) continue;
                    returnString = returnString + " ";
                }
                return returnString;
            }
            ArrayList<String> items = new ArrayList<String>(((List)value).size());
            Object next = null;
            for (int i = 0; i < ((List)value).size(); ++i) {
                next = ((List)value).get(i);
                items.add(this.getSingleValueToWriteForUnion(xmlField, next, session));
            }
            return items;
        }
        return this.getSingleValueToWriteForUnion(xmlField, value, session);
    }

    private Node addIndexedElement(XPathFragment fragment, XMLField xmlField, Node parent, Object value, boolean forceCreate, AbstractSession session) throws XMLMarshalException {
        Node existingElement;
        String element = fragment.getShortName();
        int index = fragment.getIndexValue();
        if (index < 0) {
            throw XMLMarshalException.invalidXPathIndexString(fragment.getXPath());
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(xmlField);
        for (int i = 1; i < index; ++i) {
            XMLField field = new XMLField(element + "[" + i + "]");
            field.setNamespaceResolver(namespaceResolver);
            existingElement = (Node)this.unmarshalXPathEngine.selectSingleNode(parent, field, (XMLNamespaceResolver)namespaceResolver);
            if (existingElement != null) continue;
            this.addElement(new XPathFragment(element), xmlField, parent, this, true, session);
        }
        XMLField field = new XMLField(fragment.getXPath());
        field.setNamespaceResolver(namespaceResolver);
        existingElement = (Node)this.unmarshalXPathEngine.selectSingleNode(parent, field, (XMLNamespaceResolver)namespaceResolver);
        if (existingElement == null) {
            return this.addElement(new XPathFragment(element), field, parent, value, true, session);
        }
        if (existingElement != null && !forceCreate) {
            return existingElement;
        }
        String namespace = this.resolveNamespacePrefix(fragment, namespaceResolver);
        Element elementToReturn = parent.getOwnerDocument().createElementNS(namespace, element);
        if (value != this && value != null && value instanceof String) {
            this.addText(xmlField, elementToReturn, (String)value);
        }
        parent.replaceChild(elementToReturn, existingElement);
        return elementToReturn;
    }

    private Node addElement(XPathFragment fragment, XMLField xmlField, Node parent, Object value, boolean forceCreate, AbstractSession session) {
        return this.addElement(fragment, xmlField, parent, null, value, forceCreate, session);
    }

    private Node addElement(XPathFragment fragment, XMLField xmlField, Node parent, QName schemaType, Object value, boolean forceCreate, AbstractSession session) {
        NodeList list = this.addElements(fragment, xmlField, parent, value, forceCreate, null, this.noDocPresPolicy, session);
        if (list.getLength() > 0) {
            return list.item(0);
        }
        return null;
    }

    private NodeList addElements(XPathFragment fragment, XMLField xmlField, Node parent, Object value, boolean forceCreate, Element sibling, DocumentPreservationPolicy docPresPolicy, AbstractSession session) {
        NodeList nodes;
        if (!forceCreate && (nodes = this.unmarshalXPathEngine.selectElementNodes(parent, fragment, this.getNamespaceResolverForField(xmlField))).getLength() > 0) {
            return nodes;
        }
        XMLNodeList elementsToReturn = new XMLNodeList();
        if (value == this) {
            String namespace = this.resolveNamespacePrefix(fragment, this.getNamespaceResolverForField(xmlField));
            Element newElement = parent.getOwnerDocument().createElementNS(namespace, fragment.getShortName());
            elementsToReturn.add(newElement);
            docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
        } else if (value == null) {
            elementsToReturn.add(parent);
        } else if (value instanceof List) {
            List values = (List)value;
            for (int index = 0; index < values.size(); ++index) {
                Element newElement = (Element)this.createElement(parent, fragment, xmlField, values.get(index), session);
                docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
                elementsToReturn.add(newElement);
                sibling = newElement;
            }
        } else {
            Element newElement = (Element)this.createElement(parent, fragment, xmlField, value, session);
            docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
            elementsToReturn.add(newElement);
        }
        return elementsToReturn;
    }

    private Node createElement(Node parent, XPathFragment fragment, XMLField xmlField, Object value, AbstractSession session) {
        if (value == null) {
            return parent;
        }
        if (value instanceof Node) {
            return this.createElement(parent, fragment, this.getNamespaceResolverForField(xmlField), (Node)value);
        }
        Element element = null;
        if (parent.getOwnerDocument() == null) {
            element = ((Document)parent).getDocumentElement();
        } else {
            String namespace = this.resolveNamespacePrefix(fragment, this.getNamespaceResolverForField(xmlField));
            element = parent.getOwnerDocument().createElementNS(namespace, fragment.getXPath());
            if (fragment.isGeneratedPrefix()) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + fragment.getPrefix(), fragment.getNamespaceURI());
            }
        }
        XPathFragment nextFragment = fragment.getNextFragment();
        if (nextFragment != null && nextFragment.isAttribute()) {
            this.addAttribute(nextFragment, xmlField, element, value, session);
        } else if (value instanceof String && !"".equals(value)) {
            this.addText(xmlField, element, (String)value);
        }
        return element;
    }

    public Element createUnownedElement(Node parent, XMLField xmlField) {
        XPathFragment lastFragment = xmlField.getXPathFragment();
        while (lastFragment.getNextFragment() != null) {
            lastFragment = lastFragment.getNextFragment();
        }
        String nodeName = lastFragment.getShortName();
        String namespace = this.resolveNamespacePrefix(lastFragment, this.getNamespaceResolverForField(xmlField));
        Element elem = parent.getOwnerDocument().createElementNS(namespace, nodeName);
        if (lastFragment.isGeneratedPrefix()) {
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + lastFragment.getPrefix(), lastFragment.getNamespaceURI());
        }
        return elem;
    }

    private void addTypeAttributes(NodeList elements, XMLField field, Object value, String schemaInstancePrefix) {
        ArrayList<Object> values;
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(field);
        if (!field.isTypedTextField()) {
            return;
        }
        if (value instanceof List) {
            values = (ArrayList<Object>)value;
        } else {
            values = new ArrayList<Object>();
            values.add(value);
        }
        int size = elements.getLength();
        int valuesSize = values.size();
        if (size != valuesSize) {
            return;
        }
        Node next = null;
        for (int i = 0; i < size; ++i) {
            String type;
            String prefix;
            QName qname;
            Class<?> valueClass;
            next = elements.item(i);
            if (next.getNodeType() != 1 || (valueClass = values.get(i).getClass()) == ClassConstants.STRING || (qname = field.getXMLType(valueClass)) == null) continue;
            if (null == schemaInstancePrefix) {
                schemaInstancePrefix = namespaceResolver.generatePrefix("xsi");
                ((Element)next).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + schemaInstancePrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
            if ((prefix = this.resolveNamespacePrefixForURI(qname.getNamespaceURI(), namespaceResolver)) == null || prefix.equals("")) {
                type = qname.getLocalPart();
                prefix = namespaceResolver.generatePrefix();
                ((Element)next).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, qname.getNamespaceURI());
            }
            type = prefix + ":" + qname.getLocalPart();
            ((Element)next).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", schemaInstancePrefix + ":" + "type", type);
        }
    }

    private Node createElement(Node parent, XPathFragment fragment, NamespaceResolver namespaceResolver, Node value) {
        String elementName = fragment.getXPath();
        Document document = parent.getOwnerDocument();
        if (document == null && parent.getNodeType() == 9) {
            document = (Document)parent;
        }
        String nodeUri = value.getNamespaceURI();
        String nodeName = value.getLocalName();
        String fragUri = fragment.getNamespaceURI();
        String fragName = fragment.getLocalName();
        if (nodeName != null && nodeName.equals(fragName) && (nodeUri != null && nodeUri.equals(fragUri) || nodeUri == null && fragUri == null)) {
            if (document != value.getOwnerDocument()) {
                return document.importNode(value, true);
            }
            return value;
        }
        String namespace = this.resolveNamespacePrefix(fragment, namespaceResolver);
        Element clone = document.createElementNS(namespace, elementName);
        NamedNodeMap attributes = value.getAttributes();
        int attributesLength = attributes.getLength();
        for (int index = 0; index < attributesLength; ++index) {
            Node attribute = document.importNode(attributes.item(index), true);
            clone.setAttributeNode((Attr)attribute);
        }
        NodeList elements = value.getChildNodes();
        int elementsLength = elements.getLength();
        for (int index = 0; index < elementsLength; ++index) {
            Node attribute = document.importNode(elements.item(index), true);
            clone.appendChild(attribute);
        }
        return clone;
    }

    private Node addAttribute(XPathFragment attributeFragment, XMLField xmlField, Node parent, Object value, AbstractSession session) {
        Object valueToWrite = null;
        if (!(parent instanceof Element)) {
            return parent;
        }
        Element parentElement = (Element)parent;
        if (value instanceof Node) {
            if (((Node)value).getNodeType() == 2) {
                Attr attr = (Attr)value;
                if (parent.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) == null) {
                    String pfx = null;
                    if (xmlField.getNamespaceResolver() != null) {
                        pfx = this.getNamespaceResolverForField(xmlField).resolveNamespaceURI(attr.getNamespaceURI());
                    }
                    if (pfx != null) {
                        parentElement.setAttributeNS(attr.getNamespaceURI(), pfx + ":" + attr.getLocalName(), attr.getNodeValue());
                    } else {
                        parentElement.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getNodeValue());
                    }
                }
                return parent;
            }
            valueToWrite = value;
        } else {
            valueToWrite = this.getNonNodeValueToWrite(value, xmlField, session);
        }
        String attributeName = attributeFragment.getLocalName();
        String attributeNamespace = this.resolveNamespacePrefix(attributeFragment, this.getNamespaceResolverForField(xmlField));
        if (valueToWrite != null && parent.getAttributes().getNamedItemNS(attributeNamespace, attributeName) == null) {
            if (valueToWrite == this) {
                parentElement.setAttributeNS(attributeNamespace, attributeFragment.getShortName(), "");
            } else if (valueToWrite instanceof String) {
                parentElement.setAttributeNS(attributeNamespace, attributeFragment.getShortName(), (String)valueToWrite);
            }
            if (attributeFragment.isGeneratedPrefix()) {
                parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attributeFragment.getPrefix(), attributeFragment.getNamespaceURI());
            }
        }
        return parent;
    }

    public NodeList remove(XMLField xmlField, Node element) throws XMLMarshalException {
        return this.remove(xmlField, element, false);
    }

    public NodeList remove(XMLField xmlField, Node element, boolean forceRemove) throws XMLMarshalException {
        String xpathString = xmlField.getXPath();
        NodeList nodes = this.unmarshalXPathEngine.selectNodes(element, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField));
        int numberOfNodes = nodes.getLength();
        boolean shouldNullOutNode = this.containsIndex(xpathString) && !forceRemove;
        for (int i = 0; i < numberOfNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 2) {
                ((Attr)node).getOwnerElement().removeAttribute(node.getNodeName());
                continue;
            }
            if (shouldNullOutNode) {
                Element blankNode = node.getParentNode().getOwnerDocument().createElementNS(node.getNamespaceURI(), node.getNodeName());
                node.getParentNode().replaceChild(blankNode, node);
                continue;
            }
            node.getParentNode().removeChild(node);
        }
        return nodes;
    }

    public NodeList replaceValue(XMLField xmlField, Node parent, Object value, AbstractSession session) throws XMLMarshalException {
        NodeList nodes = this.unmarshalXPathEngine.selectNodes(parent, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField));
        int numberOfNodes = nodes.getLength();
        for (int i = 0; i < numberOfNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) {
                if ((node.getNodeType() == 3 || node.getNodeType() == 4) && value == null) {
                    Node parentNode = node.getParentNode();
                    Node grandParentNode = parentNode.getParentNode();
                    grandParentNode.removeChild(parentNode);
                    continue;
                }
                node.setNodeValue((String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING));
                continue;
            }
            Element element = (Element)node;
            Node parentNode = element.getParentNode();
            if (value == null) {
                parentNode.removeChild(element);
                continue;
            }
            String elementName = element.getTagName();
            Element newElement = null;
            Object valueToWrite = this.getValueToWrite(value, xmlField, session);
            XPathFragment childFrag = new XPathFragment(elementName);
            childFrag.setNamespaceURI(element.getNamespaceURI());
            newElement = (Element)this.createElement(parentNode, childFrag, xmlField, valueToWrite, session);
            if (newElement == element) continue;
            parentNode.replaceChild(newElement, element);
        }
        return nodes;
    }

    public NodeList replaceCollection(XMLField xmlField, Node parent, Collection values, AbstractSession session) throws XMLMarshalException {
        int i;
        NodeList nodes = null;
        nodes = xmlField != null ? this.unmarshalXPathEngine.selectNodes(parent, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField)) : parent.getChildNodes();
        if (nodes.getLength() == 0) {
            return nodes;
        }
        Iterator collectionValues = values.iterator();
        int nodesLength = nodes.getLength();
        Vector<Element> newNodes = new Vector<Element>();
        boolean performedReplace = true;
        Object value = null;
        for (i = 0; i < nodesLength && collectionValues.hasNext(); ++i) {
            Node oldChild = nodes.item(i);
            Element newChild = null;
            if (performedReplace) {
                value = collectionValues.next();
            }
            Node parentNode = oldChild.getParentNode();
            if (oldChild.getNodeType() != 1) {
                if ((oldChild.getNodeType() == 3 || oldChild.getNodeType() == 4) && value == null) {
                    Node grandParentNode = parentNode.getParentNode();
                    grandParentNode.removeChild(parentNode);
                    continue;
                }
                oldChild.setNodeValue((String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING));
                continue;
            }
            Element element = (Element)oldChild;
            String elementName = element.getTagName();
            Object valueToWrite = this.getValueToWrite(value, xmlField, session);
            XPathFragment childFragment = new XPathFragment(elementName);
            childFragment.setNamespaceURI(element.getNamespaceURI());
            newChild = (Element)this.createElement(parentNode, childFragment, xmlField, valueToWrite, session);
            if (!newNodes.contains(oldChild)) {
                if (newChild != oldChild) {
                    parentNode.replaceChild(newChild, oldChild);
                }
                newNodes.addElement(newChild);
                performedReplace = true;
                continue;
            }
            performedReplace = false;
        }
        while (i < nodesLength) {
            Node toRemove = nodes.item(i);
            Node removedParent = toRemove.getParentNode();
            if (removedParent != null && !newNodes.contains(toRemove)) {
                removedParent.removeChild(toRemove);
            }
            ++i;
        }
        if (value != null && !performedReplace) {
            if (xmlField.getXPathFragment().getNextFragment() == null || xmlField.getXPathFragment().getHasText()) {
                this.create(xmlField, parent, value, xmlField, this.xmlBinderPolicy, session);
            } else {
                this.create(xmlField, parent, value, session);
            }
        }
        while (collectionValues.hasNext()) {
            value = collectionValues.next();
            if (xmlField.getXPathFragment().getNextFragment() == null || xmlField.getXPathFragment().getHasText()) {
                this.create(xmlField, parent, value, xmlField, this.xmlBinderPolicy, session);
                continue;
            }
            this.create(xmlField, parent, value, session);
        }
        return nodes;
    }

    private boolean containsIndex(String xpathString) {
        return xpathString.lastIndexOf(91) != -1 && xpathString.lastIndexOf(93) != -1;
    }

    private String resolveNamespacePrefix(XPathFragment fragment, NamespaceResolver namespaceResolver) {
        try {
            if (fragment.getNamespaceURI() != null) {
                return fragment.getNamespaceURI();
            }
            if (fragment.getPrefix() == null && fragment.isAttribute()) {
                return null;
            }
            return namespaceResolver.resolveNamespacePrefix(fragment.getPrefix());
        }
        catch (Exception e) {
            return null;
        }
    }

    private String resolveNamespacePrefixForURI(String namespaceURI, NamespaceResolver namespaceResolver) {
        if (null == namespaceResolver) {
            return null;
        }
        Enumeration prefixes = namespaceResolver.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            if (!namespaceResolver.resolveNamespacePrefix(prefix).equals(namespaceURI)) continue;
            return prefix;
        }
        return null;
    }

    private Node addText(XMLField xmlField, Node element, String textValue) {
        if (xmlField.isCDATA()) {
            CDATASection cdata = element.getOwnerDocument().createCDATASection(textValue);
            element.appendChild(cdata);
            return cdata;
        }
        Text text = element.getOwnerDocument().createTextNode(textValue);
        element.appendChild(text);
        return text;
    }

    private String getStringForQName(QName qName, NamespaceResolver namespaceResolver) {
        if (null == qName) {
            return null;
        }
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    private NamespaceResolver getNamespaceResolverForField(XMLField field) {
        NamespaceResolver nr = field.getNamespaceResolver();
        if (nr == null) {
            field.setNamespaceResolver(new NamespaceResolver());
        }
        return field.getNamespaceResolver();
    }
}

