/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class DirectCollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.DirectCollectionChangeRecord {
    protected HashMap addObjectMap;
    protected HashMap removeObjectMap;
    protected HashMap commitAddMap;
    protected Map changedIndexes;
    protected int oldSize;
    protected int newSize;
    protected boolean isFirstToAddAlreadyInCollection;
    protected boolean isFirstToRemoveAlreadyOutCollection;
    protected boolean isFirstToAdd = true;
    protected boolean isFirstToRemove = true;

    public DirectCollectionChangeRecord() {
    }

    public DirectCollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(HashMap additions, HashMap databaseCount) {
        for (Object object : additions.keySet()) {
            if (databaseCount.containsKey(object)) {
                this.getCommitAddMap().put(object, databaseCount.get(object));
            }
            this.addAdditionChange(object, (Integer)additions.get(object));
        }
    }

    public void addAdditionChange(Object key, Integer count) {
        int addValue;
        if (this.getRemoveObjectMap().containsKey(key)) {
            int addition;
            int removeValue = (Integer)this.getRemoveObjectMap().get(key);
            int result = removeValue - (addition = count.intValue());
            if (result > 0) {
                this.getRemoveObjectMap().put(key, new Integer(result));
            } else if (result < 0) {
                this.getRemoveObjectMap().remove(key);
                this.getAddObjectMap().put(key, new Integer(Math.abs(result)));
            } else {
                this.getRemoveObjectMap().remove(key);
            }
        } else if (this.getAddObjectMap().containsKey(key)) {
            addValue = (Integer)this.getAddObjectMap().get(key);
            this.getAddObjectMap().put(key, new Integer(addValue += count.intValue()));
        } else {
            this.getAddObjectMap().put(key, count);
        }
        if (this.isFirstToAdd) {
            this.isFirstToAdd = false;
            if (!this.isFirstToAddAlreadyInCollection) {
                return;
            }
        }
        addValue = count;
        int commitValue = 0;
        if (this.getCommitAddMap().containsKey(key)) {
            commitValue = (Integer)this.getCommitAddMap().get(key);
        }
        this.getCommitAddMap().put(key, new Integer(addValue + commitValue));
    }

    public void addRemoveChange(HashMap additions, HashMap databaseCount) {
        for (Object object : additions.keySet()) {
            if (databaseCount.containsKey(object)) {
                this.getCommitAddMap().put(object, databaseCount.get(object));
            }
            this.addRemoveChange(object, (Integer)additions.get(object));
        }
    }

    public void addRemoveChange(Object key, Integer count) {
        int removeValue;
        if (this.getAddObjectMap().containsKey(key)) {
            int addition;
            removeValue = (Integer)this.getAddObjectMap().get(key);
            int result = removeValue - (addition = count.intValue());
            if (result > 0) {
                this.getAddObjectMap().put(key, new Integer(result));
            } else if (result < 0) {
                this.getAddObjectMap().remove(key);
                this.getRemoveObjectMap().put(key, new Integer(Math.abs(result)));
            } else {
                this.getAddObjectMap().remove(key);
            }
        } else if (this.getRemoveObjectMap().containsKey(key)) {
            int addValue = (Integer)this.getRemoveObjectMap().get(key);
            this.getRemoveObjectMap().put(key, new Integer(addValue += count.intValue()));
        } else {
            this.getRemoveObjectMap().put(key, count);
        }
        if (this.isFirstToRemove) {
            this.isFirstToRemove = false;
            if (this.isFirstToRemoveAlreadyOutCollection) {
                return;
            }
        }
        removeValue = count;
        int commitValue = 0;
        if (this.getCommitAddMap().containsKey(key)) {
            commitValue = (Integer)this.getCommitAddMap().get(key);
        }
        this.getCommitAddMap().put(key, new Integer(commitValue - removeValue));
    }

    public void setCommitAddition(Hashtable additions) {
        Enumeration enumtr = additions.keys();
        while (enumtr.hasMoreElements()) {
            Object object = enumtr.nextElement();
            this.getCommitAddMap().put(object, additions.get(object));
        }
    }

    public void storeDatabaseCounts(Object collection, ContainerPolicy containerPolicy, AbstractSession session) {
        Object iterator = containerPolicy.iteratorFor(collection);
        while (containerPolicy.hasNext(iterator)) {
            Object object = containerPolicy.next(iterator, session);
            this.incrementDatabaseCount(object);
        }
    }

    public void incrementDatabaseCount(Object object) {
        if (this.getCommitAddMap().containsKey(object)) {
            int count = (Integer)this.getCommitAddMap().get(object);
            this.getCommitAddMap().put(object, new Integer(++count));
        } else {
            this.getCommitAddMap().put(object, new Integer(1));
        }
    }

    public void decrementDatabaseCount(Object object) {
        if (this.getCommitAddMap().containsKey(object)) {
            int count = (Integer)this.getCommitAddMap().get(object);
            if (count > 1) {
                this.getCommitAddMap().put(object, new Integer(--count));
            } else {
                this.getCommitAddMap().remove(object);
            }
        }
    }

    public Vector getAddObjectList() {
        Vector vector = new Vector();
        for (Object object : this.getAddObjectMap().keySet()) {
            for (int count = ((Integer)this.getAddObjectMap().get(object)).intValue(); count > 0; --count) {
                vector.add(object);
            }
        }
        return vector;
    }

    public HashMap getAddObjectMap() {
        if (this.addObjectMap == null) {
            this.addObjectMap = new HashMap(1);
        }
        return this.addObjectMap;
    }

    public HashMap getCommitAddMap() {
        if (this.commitAddMap == null) {
            this.commitAddMap = new HashMap(1);
        }
        return this.commitAddMap;
    }

    public Vector getRemoveObjectList() {
        Vector vector = new Vector();
        for (Object object : this.getRemoveObjectMap().keySet()) {
            for (int count = ((Integer)this.getRemoveObjectMap().get(object)).intValue(); count > 0; --count) {
                vector.add(object);
            }
        }
        return vector;
    }

    public HashMap getRemoveObjectMap() {
        if (this.removeObjectMap == null) {
            this.removeObjectMap = new HashMap(1);
        }
        return this.removeObjectMap;
    }

    public boolean hasChanges() {
        return this.addObjectMap != null && !this.addObjectMap.isEmpty() || this.removeObjectMap != null && !this.removeObjectMap.isEmpty() || this.changedIndexes != null && !this.changedIndexes.isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        HashMap addMapToMerge = ((DirectCollectionChangeRecord)mergeFromRecord).getAddObjectMap();
        HashMap removeMapToMerge = ((DirectCollectionChangeRecord)mergeFromRecord).getRemoveObjectMap();
        for (Object added : addMapToMerge.keySet()) {
            if (!((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().containsKey(added)) {
                this.getCommitAddMap().put(added, ((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().get(added));
            }
            this.addAdditionChange(added, (Integer)addMapToMerge.get(added));
        }
        for (Object removed : removeMapToMerge.keySet()) {
            if (!((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().containsKey(removed)) {
                this.getCommitAddMap().put(removed, ((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().get(removed));
            }
            this.addRemoveChange(removed, (Integer)removeMapToMerge.get(removed));
        }
        if (this.changedIndexes != null) {
            if (((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes() != null) {
                for (Map.Entry entry : ((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes().entrySet()) {
                    Object obj = entry.getValue();
                    Set[] indexes = (Set[])entry.getValue();
                    if (this.changedIndexes.containsKey(obj)) {
                        ((Set[])this.changedIndexes.get(obj))[1] = indexes[1];
                        continue;
                    }
                    this.changedIndexes.put(obj, indexes);
                }
                this.newSize = ((DirectCollectionChangeRecord)mergeFromRecord).getNewSize();
            }
        } else if (((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes() != null) {
            this.changedIndexes = new HashMap(((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes());
            this.oldSize = ((DirectCollectionChangeRecord)mergeFromRecord).getOldSize();
            this.newSize = ((DirectCollectionChangeRecord)mergeFromRecord).getNewSize();
        }
    }

    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }

    public void firstToAddAlreadyInCollection() {
        this.isFirstToAddAlreadyInCollection = true;
    }

    public boolean isFirstToAddAlreadyInCollection() {
        return this.isFirstToAddAlreadyInCollection;
    }

    public void firstToRemoveAlreadyOutCollection() {
        this.isFirstToRemoveAlreadyOutCollection = true;
    }

    public boolean isFirstToRemoveAlreadyOutCollection() {
        return this.isFirstToRemoveAlreadyOutCollection;
    }

    public void setChangedIndexes(Map changedIndexes) {
        this.changedIndexes = changedIndexes;
    }

    public Map getChangedIndexes() {
        return this.changedIndexes;
    }

    public void setOldSize(int size) {
        this.oldSize = size;
    }

    public int getOldSize() {
        return this.oldSize;
    }

    public void setNewSize(int size) {
        this.newSize = size;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public void recreateOriginalCollection(Object currentCollection, ContainerPolicy cp, AbstractSession session) {
        int i;
        int n;
        Object obj;
        this.setOriginalCollection(currentCollection);
        if (currentCollection == null) {
            return;
        }
        if (this.removeObjectMap != null) {
            for (Map.Entry entry : this.removeObjectMap.entrySet()) {
                obj = entry.getKey();
                n = (Integer)entry.getValue();
                for (i = 0; i < n; ++i) {
                    cp.addInto(obj, currentCollection, session);
                }
            }
            this.removeObjectMap.clear();
        }
        if (this.addObjectMap != null) {
            for (Map.Entry entry : this.addObjectMap.entrySet()) {
                obj = entry.getKey();
                n = (Integer)entry.getValue();
                for (i = 0; i < n; ++i) {
                    cp.removeFrom(obj, currentCollection, session);
                }
            }
            this.addObjectMap.clear();
        }
    }

    public static class NULL {
        public boolean equals(Object object) {
            return object instanceof NULL;
        }
    }
}

