/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionMapping
extends ForeignReferenceMapping
implements ContainerMapping {
    protected transient ModifyQuery deleteAllQuery;
    protected transient boolean hasCustomDeleteAllQuery;
    protected ContainerPolicy containerPolicy;
    protected transient boolean hasOrderBy;
    protected DatabaseField listOrderField;
    protected boolean isListOrderFieldSupported;
    protected transient DataModifyQuery changeOrderTargetQuery;
    protected OrderedListContainerPolicy.OrderValidationMode listOrderFieldValidationMode;

    public CollectionMapping() {
        this.selectionQuery = new ReadAllQuery();
        this.hasCustomDeleteAllQuery = false;
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
        this.hasOrderBy = false;
        this.isListOrderFieldSupported = false;
    }

    public void addAscendingOrdering(String queryKeyName) {
        this.hasOrderBy = true;
        if (queryKeyName == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addAscendingOrdering(queryKeyName);
    }

    public void addDescendingOrdering(String queryKeyName) {
        this.hasOrderBy = true;
        if (queryKeyName == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addDescendingOrdering(queryKeyName);
    }

    public void addOrderBy(String queryKeyName, boolean isDescending) {
        if (isDescending) {
            this.addDescendingOrdering(queryKeyName);
        } else {
            this.addAscendingOrdering(queryKeyName);
        }
    }

    public void addAggregateOrderBy(String aggregateName, String queryKeyName, boolean isDescending) {
        this.hasOrderBy = true;
        ReadAllQuery readAllQuery = (ReadAllQuery)this.getSelectionQuery();
        ExpressionBuilder builder = readAllQuery.getExpressionBuilder();
        Expression expression = null;
        if (aggregateName.contains(".")) {
            StringTokenizer st = new StringTokenizer(aggregateName, ".");
            while (st.hasMoreTokens()) {
                if (expression == null) {
                    expression = builder.get(st.nextToken());
                    continue;
                }
                expression = expression.get(st.nextToken());
            }
            expression = expression.get(queryKeyName);
        } else {
            expression = builder.get(aggregateName).get(queryKeyName);
        }
        if (isDescending) {
            readAllQuery.addOrdering(expression.descending());
        } else {
            readAllQuery.addOrdering(expression.ascending());
        }
    }

    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return this.getContainerPolicy().containerInstance(1);
        }
        return this.getContainerPolicy().cloneFor(attributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            Object container = containerPolicy.containerInstance(1);
            if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && clone != null && ((ChangeTracker)clone)._persistence_getPropertyChangeListener() != null && container instanceof CollectionChangeTracker) {
                ((CollectionChangeTracker)container).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)container)._persistence_setPropertyChangeListener(((ChangeTracker)clone)._persistence_getPropertyChangeListener());
            }
            return container;
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object valuesIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(valuesIterator)) {
            containerPolicy.addNextValueFromIteratorInto(valuesIterator, clone, clonedAttributeValue, this, unitOfWork, isExisting);
        }
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && clone != null && ((ChangeTracker)clone)._persistence_getPropertyChangeListener() != null && clonedAttributeValue instanceof CollectionChangeTracker) {
            ((CollectionChangeTracker)clonedAttributeValue).setTrackedAttributeName(this.getAttributeName());
            ((CollectionChangeTracker)clonedAttributeValue)._persistence_setPropertyChangeListener(((ChangeTracker)clone)._persistence_getPropertyChangeListener());
        }
        if (temporaryCollection instanceof IndirectList) {
            ((IndirectList)clonedAttributeValue).setIsListOrderBrokenInDb(((IndirectList)temporaryCollection).isListOrderBrokenInDb());
        }
        return clonedAttributeValue;
    }

    @Override
    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(original, policy.getSession());
        Object valuesIterator = this.getContainerPolicy().iteratorFor(attributeValue);
        attributeValue = this.getContainerPolicy().containerInstance(this.getContainerPolicy().sizeFor(attributeValue));
        while (this.getContainerPolicy().hasNext(valuesIterator)) {
            Object originalValue;
            Object copyValue = originalValue = this.getContainerPolicy().next(valuesIterator, policy.getSession());
            if (policy.shouldCascadeAllParts() || policy.shouldCascadePrivateParts() && this.isPrivateOwned()) {
                copyValue = policy.getSession().copyObject(originalValue, policy);
            } else {
                copyValue = policy.getCopies().get(originalValue);
                if (copyValue == null) {
                    copyValue = originalValue;
                }
            }
            this.getContainerPolicy().addInto(copyValue, attributeValue, policy.getSession());
        }
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    public Object buildElementClone(Object element, Object parent, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (isExisting) {
            return unitOfWork.registerExistingObject(element);
        }
        return unitOfWork.registerObject(element);
    }

    @Override
    public Object[] buildReferencesPKList(Object entity, Object attribute, AbstractSession session) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        Object collection = this.getIndirectionPolicy().getRealAttributeValueFromObject(entity, attribute);
        Object[] result = new Object[this.getContainerPolicy().sizeFor(collection)];
        Iterator iterator = (Iterator)this.getContainerPolicy().iteratorFor(collection);
        int index = 0;
        while (iterator.hasNext()) {
            Object target = iterator.next();
            if (target == null) continue;
            Vector pks = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(target, session);
            CMPPolicy policy = referenceDescriptor.getCMPPolicy();
            result[index] = policy != null && policy.isCMP3Policy() ? policy.createPrimaryKeyInstance(pks) : pks;
            ++index;
        }
        return result;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.isCascadeRemove()) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            uow.performRemove(nextObject, visitedObjects);
            cp.cascadePerformRemoveIfRequired(wrappedObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.getIndirectionPolicy().objectIsInstantiated(attributeValue)) {
            Object realObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
            ContainerPolicy cp = this.getContainerPolicy();
            Object cloneIter = cp.iteratorFor(realObjectCollection);
            while (cp.hasNext(cloneIter)) {
                Object nextObject = cp.next(cloneIter, uow);
                if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
                visitedObjects.put(nextObject, nextObject);
                uow.performRemovePrivateOwnedObjectFromChangeSet(nextObject, visitedObjects);
            }
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        Object cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            IndirectCollection collection;
            if (cloneAttribute instanceof IndirectCollection && (collection = (IndirectCollection)cloneAttribute).hasDeferredChanges()) {
                Iterator iterator = collection.getAddedElements().iterator();
                boolean cascade = this.isCascadePersist();
                while (iterator.hasNext()) {
                    Object nextObject = iterator.next();
                    if (this.isCandidateForPrivateOwnedRemoval()) {
                        uow.removePrivateOwnedObject(this, nextObject);
                    }
                    uow.discoverAndPersistUnregisteredNewObjects(nextObject, cascade, newObjects, unregisteredExistingObjects, visitedObjects);
                }
            }
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object iterator = containerPolicy.iteratorFor(cloneObjectCollection);
        boolean cascade = this.isCascadePersist();
        while (containerPolicy.hasNext(iterator)) {
            Object wrappedObject = containerPolicy.nextEntry(iterator, uow);
            Object nextObject = containerPolicy.unwrapIteratorResult(wrappedObject);
            if (this.isCandidateForPrivateOwnedRemoval()) {
                uow.removePrivateOwnedObject(this, nextObject);
            }
            uow.discoverAndPersistUnregisteredNewObjects(nextObject, cascade, newObjects, unregisteredExistingObjects, visitedObjects);
            containerPolicy.cascadeDiscoverAndPersistUnregisteredNewObjects(wrappedObject, newObjects, unregisteredExistingObjects, visitedObjects, uow);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        boolean shouldAddPrivateOwnedObject;
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.isCascadePersist() || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        boolean bl = shouldAddPrivateOwnedObject = this.isCandidateForPrivateOwnedRemoval() && uow.shouldDiscoverNewObjects() && uow.isObjectNew(object);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (shouldAddPrivateOwnedObject && nextObject != null) {
                uow.addPrivateOwnedObject(this, nextObject);
            }
            uow.registerNewObjectForPersist(nextObject, visitedObjects);
            cp.cascadeRegisterNewIfRequired(wrappedObject, uow, visitedObjects);
        }
    }

    @Override
    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        CollectionChangeRecord collectionRecord = (CollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
        if (this.isPrivateOwned()) {
            this.postCalculateChanges(collectionRecord, (UnitOfWorkImpl)session);
        }
    }

    @Override
    public void cascadeMerge(Object sourceElement, MergeManager mergeManager) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            mergeManager.mergeChanges(mergeManager.getObjectToMerge(sourceElement), null);
        }
    }

    @Override
    public Object clone() {
        CollectionMapping clone = (CollectionMapping)super.clone();
        clone.setDeleteAllQuery((ModifyQuery)this.getDeleteAllQuery().clone());
        if (this.listOrderField != null) {
            clone.listOrderField = (DatabaseField)this.listOrderField.clone();
        }
        if (this.changeOrderTargetQuery != null) {
            clone.changeOrderTargetQuery = (DataModifyQuery)this.changeOrderTargetQuery.clone();
        }
        return clone;
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        this.getContainerPolicy().compareCollectionsForChange(oldCollection, newCollection, (CollectionChangeRecord)changeRecord, session, this.getReferenceDescriptor());
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        Object backUpObjectCollection = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (cloneAttribute == null && backUpAttribute == null) {
                return null;
            }
            backUpObjectCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        Object cloneObjectCollection = null;
        cloneObjectCollection = cloneAttribute != null ? this.getRealCollectionAttributeValueFromObject(clone, session) : this.getContainerPolicy().containerInstance(1);
        CollectionChangeRecord changeRecord = new CollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.compareCollectionsForChange(backUpObjectCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        return super.compareObjects(firstObjectCollection, secondObjectCollection, session);
    }

    protected void compareObjectsAndWrite(Object previousObjects, Object currentObjects, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object wrappedObject;
        if (query.getObjectChangeSet() != null && !this.isAggregateCollectionMapping()) {
            ObjectChangeSet changeSet = query.getObjectChangeSet();
            CollectionChangeRecord record = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (record != null) {
                ObjectChangeSet removedChangeSet2 = null;
                ObjectChangeSet addedChangeSet = null;
                for (ObjectChangeSet removedChangeSet2 : record.getRemoveObjectList().values()) {
                    this.objectRemovedDuringUpdate(query, this.getContainerPolicy().getCloneDataFromChangeSet(removedChangeSet2), null);
                    if (removedChangeSet2.getOldKey() == null) continue;
                    this.containerPolicy.propogatePostUpdate(query, removedChangeSet2.getOldKey());
                }
                Iterator addedObjects = record.getAddObjectList().values().iterator();
                HashMap<DatabaseField, Integer> extraData = null;
                while (addedObjects.hasNext()) {
                    addedChangeSet = (ObjectChangeSet)addedObjects.next();
                    if (this.listOrderField != null) {
                        extraData = new HashMap<DatabaseField, Integer>(1);
                        Integer addedIndexInList = (Integer)record.getOrderedAddObjectIndices().get(addedChangeSet);
                        if (addedIndexInList == null) {
                            addedIndexInList = ((List)currentObjects).indexOf(addedChangeSet.getUnitOfWorkClone());
                        }
                        extraData.put(this.listOrderField, addedIndexInList);
                    }
                    this.objectAddedDuringUpdate(query, this.getContainerPolicy().getCloneDataFromChangeSet(addedChangeSet), addedChangeSet, extraData);
                    if (addedChangeSet.getNewKey() == null) continue;
                    this.containerPolicy.propogatePostUpdate(query, addedChangeSet.getNewKey());
                }
                if (this.listOrderField != null) {
                    List previousList = (List)previousObjects;
                    int previousSize = previousList.size();
                    List currentList = (List)currentObjects;
                    int currentSize = currentList.size();
                    boolean shouldRepairOrder = false;
                    if (currentList instanceof IndirectList) {
                        shouldRepairOrder = ((IndirectList)currentList).isListOrderBrokenInDb();
                    }
                    if (previousList == currentList) {
                        List<Integer> currentIndexes = record.getCurrentIndexesOfOriginalObjects(currentList);
                        for (int i = 0; i < currentIndexes.size(); ++i) {
                            int currentIndex = currentIndexes.get(i);
                            if ((currentIndex == i || currentIndex < 0) && !shouldRepairOrder) continue;
                            this.objectOrderChangedDuringUpdate(query, currentList.get(currentIndex), currentIndex);
                        }
                    } else {
                        for (int i = 0; i < previousSize; ++i) {
                            int newIndex;
                            Object prevObject = previousList.get(i);
                            Object currentObject = null;
                            if (i < currentSize) {
                                currentObject = currentList.get(i);
                            }
                            if (prevObject == currentObject && !shouldRepairOrder || (newIndex = currentList.indexOf(prevObject)) < 0) continue;
                            this.objectOrderChangedDuringUpdate(query, prevObject, newIndex);
                        }
                    }
                    if (shouldRepairOrder) {
                        ((IndirectList)currentList).setIsListOrderBrokenInDb(false);
                    }
                }
            }
            return;
        }
        if (this.listOrderField != null && this.isAggregateCollectionMapping()) {
            this.compareListsAndWrite((List)previousObjects, (List)currentObjects, query);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Hashtable<CacheKey, Object> previousObjectsByKey = new Hashtable<CacheKey, Object>(cp.sizeFor(previousObjects) + 2);
        Hashtable<CacheKey, Object> currentObjectsByKey = new Hashtable<CacheKey, Object>(cp.sizeFor(currentObjects) + 2);
        IdentityHashMap<Object, CacheKey> cacheKeysOfCurrentObjects = new IdentityHashMap<Object, CacheKey>(cp.sizeFor(currentObjects) + 1);
        Object currentObjectsIter = cp.iteratorFor(currentObjects);
        while (cp.hasNext(currentObjectsIter)) {
            Object currentObject = cp.next(currentObjectsIter, query.getSession());
            try {
                Vector primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(currentObject, query.getSession());
                CacheKey key = new CacheKey(primaryKey);
                currentObjectsByKey.put(key, currentObject);
                cacheKeysOfCurrentObjects.put(currentObject, key);
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
        Object previousObjectsIter = cp.iteratorFor(previousObjects);
        while (cp.hasNext(previousObjectsIter)) {
            wrappedObject = cp.nextEntry(previousObjectsIter, query.getSession());
            Map mapKeyFields = this.containerPolicy.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession());
            Object previousObject = this.containerPolicy.unwrapIteratorResult(wrappedObject);
            Vector primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(previousObject, query.getSession());
            CacheKey key = new CacheKey(primaryKey);
            previousObjectsByKey.put(key, previousObject);
            if (currentObjectsByKey.containsKey(key)) continue;
            this.objectRemovedDuringUpdate(query, wrappedObject, mapKeyFields);
            cp.propogatePostUpdate(query, wrappedObject);
        }
        currentObjectsIter = cp.iteratorFor(currentObjects);
        while (cp.hasNext(currentObjectsIter)) {
            wrappedObject = cp.nextEntry(currentObjectsIter, query.getSession());
            Object currentObject = this.containerPolicy.unwrapIteratorResult(wrappedObject);
            try {
                Map mapKeyFields = this.containerPolicy.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession());
                CacheKey cacheKey = (CacheKey)cacheKeysOfCurrentObjects.get(currentObject);
                if (!previousObjectsByKey.containsKey(cacheKey)) {
                    this.objectAddedDuringUpdate(query, currentObject, null, mapKeyFields);
                    cp.propogatePostUpdate(query, wrappedObject);
                    continue;
                }
                this.objectUnchangedDuringUpdate(query, currentObject, previousObjectsByKey, cacheKey);
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
    }

    protected void compareListsAndWrite(List previousList, List currentList, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    @Override
    protected boolean compareObjectsWithoutPrivateOwned(Object firstCollection, Object secondCollection, AbstractSession session) {
        Vector primaryKey;
        if (this.listOrderField != null) {
            return this.compareLists((List)firstCollection, (List)secondCollection, session, false);
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.sizeFor(firstCollection) != cp.sizeFor(secondCollection)) {
            return false;
        }
        Object firstIter = cp.iteratorFor(firstCollection);
        Object secondIter = cp.iteratorFor(secondCollection);
        Vector<CacheKey> keyValue = new Vector<CacheKey>();
        while (cp.hasNext(secondIter)) {
            Object secondObject = cp.next(secondIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
            keyValue.addElement(new CacheKey(primaryKey));
        }
        while (cp.hasNext(firstIter)) {
            Object firstObject = cp.next(firstIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            if (keyValue.contains(new CacheKey(primaryKey))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean compareObjectsWithPrivateOwned(Object firstCollection, Object secondCollection, AbstractSession session) {
        Vector primaryKey;
        if (this.listOrderField != null) {
            return this.compareLists((List)firstCollection, (List)secondCollection, session, true);
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.sizeFor(firstCollection) != cp.sizeFor(secondCollection)) {
            return false;
        }
        Object firstIter = cp.iteratorFor(firstCollection);
        Object secondIter = cp.iteratorFor(secondCollection);
        Hashtable<CacheKey, Object> keyValueToObject = new Hashtable<CacheKey, Object>(cp.sizeFor(firstCollection) + 2);
        while (cp.hasNext(secondIter)) {
            Object secondObject = cp.next(secondIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
            keyValueToObject.put(new CacheKey(primaryKey), secondObject);
        }
        while (cp.hasNext(firstIter)) {
            Object firstObject = cp.next(firstIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            CacheKey cacheKey = new CacheKey(primaryKey);
            if (keyValueToObject.containsKey(cacheKey)) {
                Object object = keyValueToObject.get(cacheKey);
                if (session.compareObjects(firstObject, object)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected boolean compareLists(List firstList, List secondList, AbstractSession session, boolean withPrivateOwned) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        int size = firstList.size();
        for (int i = 0; i < size; ++i) {
            CacheKey secondKey;
            CacheKey firstKey;
            Object firstObject = firstList.get(i);
            Object secondObject = secondList.get(i);
            if (!(withPrivateOwned ? !session.compareObjects(firstObject, secondObject) : !(firstKey = new CacheKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session))).equals(secondKey = new CacheKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session))))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
    }

    @Override
    public void fixRealObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object attributeValue = this.getRealAttributeValueFromObject(object, session);
        if (attributeValue == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        ObjectLevelReadQuery tempQuery = query;
        if (!tempQuery.shouldMaintainCache() && (!tempQuery.shouldCascadeParts() || tempQuery.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            tempQuery = null;
        }
        Object remoteAttributeValue = session.getObjectsCorrespondingToAll(attributeValue, objectDescriptors, processedObjects, tempQuery, this.getContainerPolicy());
        this.setRealAttributeValueInObject(object, remoteAttributeValue);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    protected ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    @Override
    public Expression getJoinCriteria(QueryKeyExpression exp) {
        Expression selectionCriteria = this.getSelectionCriteria();
        Expression keySelectionCriteria = this.containerPolicy.getKeySelectionCriteria();
        if (keySelectionCriteria != null) {
            selectionCriteria = selectionCriteria.and(keySelectionCriteria);
        }
        return exp.getBaseExpression().twist(selectionCriteria, exp);
    }

    @Override
    public Object getObjectCorrespondingTo(Object object, RemoteSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return session.getObjectsCorrespondingToAll(object, objectDescriptors, processedObjects, query, this.getContainerPolicy());
    }

    public Vector getOrderByQueryKeyExpressions() {
        Vector<Expression> expressions = new Vector<Expression>();
        if (this.getSelectionQuery() != null && this.getSelectionQuery().isReadAllQuery()) {
            Enumeration orderExpressions = ((ReadAllQuery)this.getSelectionQuery()).getOrderByExpressions().elements();
            while (orderExpressions.hasMoreElements()) {
                Expression orderExpression = (Expression)orderExpressions.nextElement();
                if (!orderExpression.isFunctionExpression() || !((FunctionExpression)orderExpression).getBaseExpression().isQueryKeyExpression()) continue;
                expressions.add(orderExpression);
            }
        }
        return expressions;
    }

    protected ContainerPolicy getSelectionQueryContainerPolicy() {
        return ((ReadAllQuery)this.getSelectionQuery()).getContainerPolicy();
    }

    @Override
    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = this.getRealAttributeValueFromObject(object, session);
        if (value == null) {
            value = this.getContainerPolicy().containerInstance(1);
        }
        return value;
    }

    public DatabaseField getListOrderField() {
        return this.listOrderField;
    }

    public List<DatabaseField> getTargetPrimaryKeyFields() {
        return this.getReferenceDescriptor().getPrimaryKeyFields();
    }

    public OrderedListContainerPolicy.OrderValidationMode getListOrderFieldValidationMode() {
        return this.listOrderFieldValidationMode;
    }

    protected boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public boolean hasOrderBy() {
        return this.hasOrderBy;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.setFields(this.collectFields());
        this.getContainerPolicy().prepare(this.getSelectionQuery(), session);
        if (!this.usesIndirection() && !this.getAttributeAccessor().getAttributeClass().isAssignableFrom(this.getContainerPolicy().getContainerClass())) {
            throw DescriptorException.incorrectCollectionPolicy(this, this.getAttributeAccessor().getAttributeClass(), this.getContainerPolicy().getContainerClass());
        }
        if (this.listOrderField != null) {
            this.initializeListOrderField(session);
        }
    }

    protected void initializeListOrderField(AbstractSession session) {
        if (!List.class.isAssignableFrom(this.getAttributeAccessor().getAttributeClass())) {
            throw DescriptorException.listOrderFieldRequiersList(this.getDescriptor(), this);
        }
        if (this.listOrderFieldValidationMode == null) {
            this.listOrderFieldValidationMode = OrderedListContainerPolicy.OrderValidationMode.NONE;
        } else if (this.listOrderFieldValidationMode == OrderedListContainerPolicy.OrderValidationMode.CORRECTION && !this.getAttributeAccessor().getAttributeClass().isAssignableFrom(IndirectList.class)) {
            throw DescriptorException.listOrderFieldRequiersIndirectList(this.getDescriptor(), this);
        }
        ContainerPolicy originalQueryContainerPolicy = this.getSelectionQueryContainerPolicy();
        if (!this.getContainerPolicy().isOrderedListPolicy()) {
            this.setContainerPolicy(new OrderedListContainerPolicy(this.getContainerPolicy().getContainerClass()));
        }
        OrderedListContainerPolicy orderedListContainerPolicy = (OrderedListContainerPolicy)this.getContainerPolicy();
        orderedListContainerPolicy.setListOrderField(this.listOrderField);
        orderedListContainerPolicy.setOrderValidationMode(this.listOrderFieldValidationMode);
        if (this.getContainerPolicy().getContainerClass().isAssignableFrom(IndirectList.class) && !IndirectList.class.isAssignableFrom(originalQueryContainerPolicy.getContainerClass()) && this.listOrderFieldValidationMode != OrderedListContainerPolicy.OrderValidationMode.CORRECTION || originalQueryContainerPolicy == this.getSelectionQueryContainerPolicy()) {
            OrderedListContainerPolicy queryOrderedListContainerPolicy = originalQueryContainerPolicy.isOrderedListPolicy() ? (OrderedListContainerPolicy)originalQueryContainerPolicy : new OrderedListContainerPolicy(originalQueryContainerPolicy.getContainerClass());
            queryOrderedListContainerPolicy.setListOrderField(this.listOrderField);
            queryOrderedListContainerPolicy.setOrderValidationMode(this.listOrderFieldValidationMode);
            this.setSelectionQueryContainerPolicy(queryOrderedListContainerPolicy);
        }
        if (this.listOrderField.getType() == null) {
            this.listOrderField.setType(Integer.class);
        }
        this.buildListOrderField();
        if (this.getSelectionQuery().isReadAllQuery()) {
            ReadAllQuery readAllQuery = (ReadAllQuery)this.getSelectionQuery();
            Expression expField = this.getListOrderFieldExpression(readAllQuery.getExpressionBuilder());
            readAllQuery.addOrdering(expField);
            readAllQuery.addAdditionalField(expField);
        }
        this.initializeChangeOrderTargetQuery(session);
    }

    protected void buildListOrderField() {
        if (this.listOrderField.hasTableName()) {
            if (!this.getReferenceDescriptor().getDefaultTable().equals(this.listOrderField.getTable())) {
                throw DescriptorException.listOrderFieldTableIsWrong(this.getDescriptor(), this, this.listOrderField.getTable(), this.getReferenceDescriptor().getDefaultTable());
            }
        } else {
            this.listOrderField.setTable(this.getReferenceDescriptor().getDefaultTable());
        }
        this.listOrderField = this.getReferenceDescriptor().buildField(this.listOrderField);
    }

    public Expression getListOrderFieldExpression(Expression baseExpression) {
        if (this.shouldUseListOrderFieldTableExpression()) {
            baseExpression = baseExpression.getTable(this.listOrderField.getTable());
        }
        return baseExpression.getField(this.listOrderField);
    }

    public boolean shouldUseListOrderFieldTableExpression() {
        return false;
    }

    protected void initializeChangeOrderTargetQuery(AbstractSession session) {
    }

    @Override
    public boolean isCollectionMapping() {
        return true;
    }

    public boolean isAttributeValueInstantiatedOrChanged(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiatedOrChanged(this.getAttributeValueFromObject(object));
    }

    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        iterator.iterateReferenceObjectForMapping(element, this);
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        if (realAttributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(realAttributeValue);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, iterator.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            this.iterateOnElement(iterator, object);
            cp.iterateOnMapKey(iterator, wrappedObject);
        }
    }

    protected boolean mustDeleteReferenceObjectsOneByOne() {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        return referenceDescriptor.hasDependencyOnParts() || referenceDescriptor.usesOptimisticLocking() || referenceDescriptor.hasInheritance() && referenceDescriptor.getInheritancePolicy().shouldReadSubclasses() || referenceDescriptor.hasMultipleTables() || this.containerPolicy.propagatesEventsToCollection();
    }

    @Override
    public void mergeChangesIntoObject(Object target, org.eclipse.persistence.internal.sessions.ChangeRecord chgRecord, Object source, MergeManager mergeManager) {
        Object valueOfTarget = null;
        Object valueOfSource = null;
        AbstractSession parentSession = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        CollectionChangeRecord changeRecord = (CollectionChangeRecord)chgRecord;
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet();
        if (this.isAttributeValueInstantiated(target)) {
            valueOfTarget = changeRecord.getOwner().isNew() ? containerPolicy.containerInstance(changeRecord.getAddObjectList().size()) : this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
            parentSession = mergeManager.getSession().isUnitOfWork() ? ((UnitOfWorkImpl)mergeManager.getSession()).getParent() : mergeManager.getSession();
            containerPolicy.mergeChanges(changeRecord, valueOfTarget, this.shouldMergeCascadeParts(mergeManager), mergeManager, parentSession);
        } else {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            if (!this.isAttributeValueInstantiated(source)) {
                return;
            }
            valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
            Object iterator = containerPolicy.iteratorFor(valueOfSource);
            valueOfTarget = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
            while (containerPolicy.hasNext(iterator)) {
                Object objectToMerge = containerPolicy.next(iterator, mergeManager.getSession());
                if (this.shouldMergeCascadeParts(mergeManager) && valueOfSource != null) {
                    ObjectChangeSet changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(objectToMerge);
                    mergeManager.mergeChanges(objectToMerge, changeSet);
                }
                containerPolicy.addInto(mergeManager.getTargetVersionOfSourceObject(objectToMerge), valueOfTarget, mergeManager.getSession());
            }
        }
        if (valueOfTarget == null) {
            valueOfTarget = containerPolicy.containerInstance();
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            if (!this.isAttributeValueInstantiated(target)) {
                Object attributeValue = this.getAttributeValueFromObject(source);
                Object clonedAttributeValue = this.getIndirectionPolicy().cloneAttribute(attributeValue, source, target, (UnitOfWorkImpl)mergeManager.getSession(), false);
                this.setAttributeValueInObject(target, clonedAttributeValue);
                return;
            }
        } else if (!this.isAttributeValueInstantiatedOrChanged(source)) {
            return;
        }
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        AbstractSession mergeSession = mergeManager.getSession();
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        containerPolicy.sizeFor(valueOfTarget);
        boolean fireChangeEvents = false;
        if (!mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            Object newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
            if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
                fireChangeEvents = valueOfSource != valueOfTarget;
                Object iterator = containerPolicy.iteratorFor(valueOfTarget);
                PropertyChangeListener listener = ((ChangeTracker)target)._persistence_getPropertyChangeListener();
                if (fireChangeEvents) {
                    while (containerPolicy.hasNext(iterator)) {
                        ((ObjectChangeListener)listener).internalPropertyChange(new CollectionChangeEvent(target, this.getAttributeName(), valueOfTarget, containerPolicy.next(iterator, mergeSession), CollectionChangeEvent.REMOVE));
                    }
                }
                if (newContainer instanceof ChangeTracker) {
                    ((CollectionChangeTracker)newContainer).setTrackedAttributeName(this.getAttributeName());
                    ((CollectionChangeTracker)newContainer)._persistence_setPropertyChangeListener(listener);
                }
                if (valueOfTarget instanceof ChangeTracker) {
                    ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
                }
            }
            valueOfTarget = newContainer;
        } else {
            this.setRealAttributeValueInObject(target, containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource)));
            containerPolicy.clear(valueOfTarget);
        }
        Object object = valueOfSource;
        synchronized (object) {
            CollectionChangeRecord changeRecord;
            ObjectChangeSet changeSet;
            Object sourceIterator = containerPolicy.iteratorFor(valueOfSource);
            while (containerPolicy.hasNext(sourceIterator)) {
                Object wrappedObject = containerPolicy.nextEntry(sourceIterator, mergeManager.getSession());
                Object object2 = containerPolicy.unwrapIteratorResult(wrappedObject);
                if (object2 == null) continue;
                if (this.shouldMergeCascadeParts(mergeManager)) {
                    if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                        mergeManager.mergeChanges(mergeManager.getObjectToMerge(object2), (ObjectChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object2));
                    } else {
                        mergeManager.mergeChanges(mergeManager.getObjectToMerge(object2), null);
                    }
                }
                wrappedObject = containerPolicy.createWrappedObjectFromExistingWrappedObject(wrappedObject, source, this.referenceDescriptor, mergeManager);
                Object object3 = valueOfTarget;
                synchronized (object3) {
                    if (fireChangeEvents) {
                        ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(target, this.getAttributeName(), valueOfTarget, wrappedObject, CollectionChangeEvent.ADD));
                    }
                    containerPolicy.addInto(wrappedObject, valueOfTarget, mergeManager.getSession());
                }
            }
            if (fireChangeEvents && this.descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
                if (!changeRecord.isDeferred()) {
                    if (!changeRecord.hasChanges()) {
                        changeSet.removeChange(this.getAttributeName());
                    }
                } else {
                    changeRecord.setLatestCollection(valueOfTarget);
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChangesForCollectionMembers(Object valueOfSource, Object valueOfTarget, Object target, MergeManager mergeManager, boolean fireChangeEvents) {
        Object sourceIterator = this.containerPolicy.iteratorFor(valueOfSource);
        while (this.containerPolicy.hasNext(sourceIterator)) {
            Object wrappedObject = this.containerPolicy.nextEntry(sourceIterator, mergeManager.getSession());
            Object object = this.containerPolicy.unwrapIteratorResult(wrappedObject);
            if (object == null) continue;
            if (this.shouldMergeCascadeParts(mergeManager)) {
                if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                    mergeManager.mergeChanges(mergeManager.getObjectToMerge(object), (ObjectChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object));
                } else {
                    mergeManager.mergeChanges(mergeManager.getObjectToMerge(object), null);
                }
            }
            object = this.referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(object), mergeManager.getSession());
            Object object2 = valueOfTarget;
            synchronized (object2) {
                if (fireChangeEvents) {
                    ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(target, this.getAttributeName(), valueOfTarget, object, CollectionChangeEvent.ADD));
                }
                this.containerPolicy.addInto(wrappedObject, valueOfTarget, mergeManager.getSession());
            }
        }
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet, Map extraData) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            insertQuery.setIsExecutionClone(true);
            insertQuery.setObject(this.containerPolicy.unwrapIteratorResult(objectAdded));
            insertQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(insertQuery);
        } else {
            UnitOfWorkChangeSet uowChangeSet = null;
            if (changeSet == null && query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(query.getObject());
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(this.containerPolicy.unwrapIteratorResult(objectAdded));
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    protected void objectOrderChangedDuringUpdate(WriteObjectQuery query, Object orderChangedObject, int orderIndex) {
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        DatabaseRecord databaseRow = new DatabaseRecord();
        List<DatabaseField> targetPrimaryKeyFields = this.getTargetPrimaryKeyFields();
        int size = targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(orderChangedObject, targetPrimaryKey, query.getSession());
            databaseRow.put(targetPrimaryKey, targetKeyValue);
        }
        databaseRow.put(this.listOrderField, (Object)orderIndex);
        query.getSession().executeQuery((DatabaseQuery)this.changeOrderTargetQuery, databaseRow);
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted, Map extraData) throws DatabaseException, OptimisticLockException {
        if (this.isPrivateOwned() && !query.shouldCascadeOnlyDependentParts()) {
            this.containerPolicy.deleteWrappedObject(objectDeleted, query.getSession());
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        WriteObjectQuery writeQuery = new WriteObjectQuery();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(object);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        query.getSession().executeQuery(writeQuery);
    }

    @Override
    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl uow) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet ocs : collectionChangeRecord.getRemoveObjectList().values()) {
            this.containerPolicy.postCalculateChanges(ocs, this.referenceDescriptor, this, uow);
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Iterator it = (Iterator)this.containerPolicy.iteratorFor(this.getRealAttributeValueFromObject(object, uow));
            while (it.hasNext()) {
                Object clone = it.next();
                this.containerPolicy.recordPrivateOwnedRemovals(clone, this.referenceDescriptor, uow);
            }
        }
    }

    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, AbstractSession session) {
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePostDelete(query, wrappedObject);
            }
        }
    }

    @Override
    public void postInitialize(AbstractSession session) {
        this.getContainerPolicy().postInitialize(session);
    }

    public void postInsert(UpdateObjectQuery query) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePostInsert(query, query.getObject());
            }
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePreInsert(query, wrappedObject);
            }
        }
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePreUpdate(query, wrappedObject);
            }
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Hashtable backupclones, CacheKey keys) throws DatabaseException, OptimisticLockException {
        this.objectUnchangedDuringUpdate(query, object);
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            return this.getRealCollectionAttributeValueFromObject(modifyQuery.getBackupClone(), modifyQuery.getSession());
        }
        this.prepareTranslationRow(modifyQuery.getTranslationRow(), modifyQuery.getObject(), modifyQuery.getSession());
        return modifyQuery.getSession().executeQuery((DatabaseQuery)this.getSelectionQuery(), modifyQuery.getTranslationRow());
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersInAll(object, this.getContainerPolicy());
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteAllQuery(ModifyQuery query) {
        this.setDeleteAllQuery(query);
        this.setHasCustomDeleteAllQuery(true);
    }

    protected void setDeleteAllQuery(ModifyQuery query) {
        this.deleteAllQuery = query;
    }

    public void setDeleteAllSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteAllQuery(query);
    }

    public void setDeleteAllCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteAllQuery(query);
    }

    protected void setHasCustomDeleteAllQuery(boolean bool) {
        this.hasCustomDeleteAllQuery = bool;
    }

    protected void setSelectionQueryContainerPolicy(ContainerPolicy containerPolicy) {
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setSessionName(String name) {
        this.getDeleteAllQuery().setSessionName(name);
        this.getSelectionQuery().setSessionName(name);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
        }
        this.getContainerPolicy().recordAddToCollectionInChangeRecord((ObjectChangeSet)changeSetToAdd, collectionChangeRecord);
        if (referenceKey != null) {
            ((ObjectChangeSet)changeSetToAdd).setNewKey(referenceKey);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
        }
        this.getContainerPolicy().recordRemoveFromCollectionInChangeRecord((ObjectChangeSet)changeSetToRemove, collectionChangeRecord);
        if (referenceKey != null) {
            ((ObjectChangeSet)changeSetToRemove).setOldKey(referenceKey);
        }
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.recreateOriginalCollection(oldValue, this.getContainerPolicy(), uow);
        }
        collectionChangeRecord.setLatestCollection(newValue);
    }

    @Override
    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, UnitOfWorkImpl uow) {
        if (event != null && event.getNewValue() != null) {
            Object newValue = event.getNewValue();
            ClassDescriptor descriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : uow.getDescriptor(newValue);
            newValue = descriptor.getObjectBuilder().unwrapObject(newValue, uow);
            ObjectChangeSet changeSetToAdd = descriptor.getObjectBuilder().createObjectChangeSet(newValue, (UnitOfWorkChangeSet)changeSet.getUOWChangeSet(), uow);
            CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (collectionChangeRecord == null) {
                collectionChangeRecord = new CollectionChangeRecord(changeSet);
                collectionChangeRecord.setAttribute(this.getAttributeName());
                collectionChangeRecord.setMapping(this);
                changeSet.addChange(collectionChangeRecord);
            }
            if (!collectionChangeRecord.isDeferred()) {
                this.getContainerPolicy().recordUpdateToCollectionInChangeRecord(event, changeSetToAdd, collectionChangeRecord);
            }
        }
    }

    @Override
    public void setChangeListener(Object clone, PropertyChangeListener listener, UnitOfWorkImpl uow) {
        if (this.getIndirectionPolicy().usesTransparentIndirection() && this.isAttributeValueInstantiated(clone)) {
            Object attributeValue = this.getRealAttributeValueFromObject(clone, uow);
            if (!(attributeValue instanceof CollectionChangeTracker)) {
                Object container = attributeValue;
                ContainerPolicy containerPolicy = this.getContainerPolicy();
                if (attributeValue == null) {
                    container = containerPolicy.containerInstance(1);
                } else {
                    container = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
                    Object iterator = containerPolicy.iteratorFor(attributeValue);
                    while (containerPolicy.hasNext(iterator)) {
                        containerPolicy.addInto(containerPolicy.next(iterator, uow), container, uow);
                    }
                }
                this.setRealAttributeValueInObject(clone, container);
                ((CollectionChangeTracker)container).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)container)._persistence_setPropertyChangeListener(listener);
            } else {
                ((CollectionChangeTracker)attributeValue).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)attributeValue)._persistence_setPropertyChangeListener(listener);
            }
        }
    }

    public boolean isListOrderFieldSupported() {
        return this.isListOrderFieldSupported;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setListOrderField(DatabaseField field) {
        if (field != null) {
            if (!this.isListOrderFieldSupported) throw ValidationException.listOrderFieldNotSupported(this);
            this.listOrderField = field;
            return;
        } else {
            this.listOrderField = null;
        }
    }

    public void setListOrderFieldName(String fieldName) {
        this.setListOrderField(new DatabaseField(fieldName));
    }

    public void setListOrderFieldValidationMode(OrderedListContainerPolicy.OrderValidationMode orderValidationMode) {
        this.listOrderFieldValidationMode = orderValidationMode;
    }

    @Override
    public void useCollectionClass(Class concreteClass) {
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass, this.hasOrderBy() || this.listOrderField != null);
        this.setContainerPolicy(policy);
    }

    public void useSortedSetClass(Class concreteClass, Comparator comparator) {
        try {
            SortedCollectionContainerPolicy policy = (SortedCollectionContainerPolicy)ContainerPolicy.buildPolicyFor(concreteClass);
            policy.setComparator(comparator);
            this.setContainerPolicy(policy);
        }
        catch (ClassCastException e) {
            this.useCollectionClass(concreteClass);
        }
    }

    public void useSortedSetClassName(String className) {
        this.useSortedSetClassName(className, null);
    }

    public void useSortedSetClassName(String className, String comparatorClassName) {
        SortedCollectionContainerPolicy policy = new SortedCollectionContainerPolicy(className);
        policy.setComparatorClassName(comparatorClassName);
        this.setContainerPolicy(policy);
    }

    public void useCollectionClassName(String concreteClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteClassName));
    }

    public void useListClassName(String concreteClassName) {
        this.setContainerPolicy(new ListContainerPolicy(concreteClassName));
    }

    @Override
    public void useMapClass(Class concreteClass, String keyName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        policy.setKeyName(keyName, this.getReferenceClassName());
        this.setContainerPolicy(policy);
    }

    public void useMapClass(Class concreteClass) {
        this.useMapClass(concreteClass, null);
    }

    public void useMapClassName(String concreteClassName, String methodName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy policy = new MapContainerPolicy(concreteClassName);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    public void useTransparentCollection() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
    }

    public void useTransparentSet() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(IndirectSet.class);
        this.setSelectionQueryContainerPolicy(ContainerPolicy.buildPolicyFor(HashSet.class));
    }

    public void useTransparentList() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
        this.setSelectionQueryContainerPolicy(ContainerPolicy.buildPolicyFor(Vector.class, this.hasOrderBy() || this.listOrderField != null));
    }

    public void useTransparentMap(String methodName) {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class, methodName);
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(Hashtable.class);
        policy.setKeyName(methodName, this.getReferenceClass());
        this.setSelectionQueryContainerPolicy(policy);
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        this.getIndirectionPolicy().validateContainerPolicy(session.getIntegrityChecker());
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeTypeForCollection(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnTypeForCollection(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterTypeForCollection(parameterType, session.getIntegrityChecker());
        }
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        if (this.isPrivateOwned()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        this.prepareTranslationRow(row, object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return this.getIndirectionPolicy().usesTransparentIndirection();
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        IdentityHashMap<Object, Object> cloneKeyValues = new IdentityHashMap<Object, Object>();
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = cloneAttribute != null ? this.getRealCollectionAttributeValueFromObject(clone, session) : cp.containerInstance(1);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object firstObject = cp.next(cloneIter, session);
            if (firstObject == null) continue;
            cloneKeyValues.put(firstObject, firstObject);
        }
        CollectionChangeRecord changeRecord = new CollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.addAdditionChange(cloneKeyValues, cp, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    @Override
    public Object valueFromPKList(Object[] pks, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object result = cp.containerInstance();
        for (int index = 0; index < pks.length; ++index) {
            Vector pk = null;
            pk = this.getReferenceDescriptor().hasCMPPolicy() ? this.getReferenceDescriptor().getCMPPolicy().createPkVectorFromKey(pks[index], session) : (Vector)pks[index];
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(this.getReferenceClass());
            query.setSelectionKey(pk);
            query.setIsExecutionClone(true);
            cp.addInto(session.executeQuery(query), result, session);
        }
        return result;
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object value = this.getContainerPolicy().containerInstance();
        Vector sourceKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(row, executionSession);
        CacheKey sourceCacheKey = new CacheKey(sourceKey);
        List rows = joinManager.getDataResultsByPrimaryKey().get(sourceCacheKey);
        ObjectLevelReadQuery nestedQuery = this.prepareNestedJoinQueryClone(row, rows, joinManager, sourceQuery, executionSession);
        HashSet<CacheKey> targetCacheKeys = new HashSet<CacheKey>();
        for (int index = 0; index < rows.size(); ++index) {
            AbstractRecord sourceRow;
            AbstractRecord targetRow = sourceRow = (AbstractRecord)rows.get(index);
            targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession);
            Vector targetKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(targetRow, executionSession);
            if (targetKey == null) {
                return this.getIndirectionPolicy().valueFromRow(value);
            }
            CacheKey targetCacheKey = new CacheKey(targetKey);
            if (targetCacheKeys.contains(targetCacheKey)) continue;
            nestedQuery.setTranslationRow(targetRow);
            targetCacheKeys.add(targetCacheKey);
            Object targetObject = this.getReferenceDescriptor().getObjectBuilder().buildObject(nestedQuery, targetRow);
            Object targetMapKey = this.getContainerPolicy().buildKeyFromJoinedRow(targetRow, joinManager, nestedQuery, executionSession);
            nestedQuery.setTranslationRow(null);
            if (targetMapKey == null) {
                if (this.listOrderField != null) {
                    this.getContainerPolicy().addInto(targetObject, value, executionSession, targetRow, nestedQuery);
                    continue;
                }
                this.getContainerPolicy().addInto(targetObject, value, executionSession);
                continue;
            }
            this.getContainerPolicy().addInto(targetMapKey, targetObject, value, executionSession);
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }
}

