/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.FragmentContentHandler;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLMarshaller {
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private XMLTransformer transformer;
    private XMLContext xmlContext;
    private XMLMarshalListener marshalListener;
    private XMLAttachmentMarshaller attachmentMarshaller;
    private Properties marshalProperties;
    private Schema schema;

    public XMLMarshaller(XMLContext xmlContext) {
        this.setXMLContext(xmlContext);
        this.initialize();
    }

    private void initialize() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.transformer = xmlPlatform.newXMLTransformer();
        this.setEncoding(DEFAULT_XML_ENCODING);
        this.setFormattedOutput(true);
        this.marshalProperties = new Properties();
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void setXMLContext(XMLContext value) {
        this.xmlContext = value;
    }

    public boolean isFormattedOutput() {
        return this.transformer.isFormattedOutput();
    }

    public void setFormattedOutput(boolean shouldFormat) {
        this.transformer.setFormattedOutput(shouldFormat);
    }

    public String getEncoding() {
        return this.transformer.getEncoding();
    }

    public void setEncoding(String newEncoding) {
        this.transformer.setEncoding(newEncoding);
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        this.schemaLocation = newSchemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public Properties getProperties() {
        return this.marshalProperties;
    }

    public Object getProperty(Object key) {
        return this.marshalProperties.get(key);
    }

    public void setNoNamespaceSchemaLocation(String newNoNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = newNoNamespaceSchemaLocation;
    }

    public void setXMLMarshalHandler(XMLMarshalListener marshalListener) {
        this.marshalListener = marshalListener;
    }

    public XMLMarshalListener getMarshalListener() {
        return this.marshalListener;
    }

    public void setMarshalListener(XMLMarshalListener listener) {
        this.marshalListener = listener;
    }

    public void marshal(Object object, Result result) throws XMLMarshalException {
        if (object == null || result == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        AbstractSession session = this.xmlContext.getSession(xmlDescriptor);
        if (session == null || !this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument()) {
            if (result instanceof DOMResult) {
                DOMResult domResult = (DOMResult)result;
                this.marshal(object, domResult.getNode());
            } else if (result instanceof SAXResult) {
                SAXResult saxResult = (SAXResult)result;
                this.marshal(object, saxResult.getHandler());
            } else if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                Writer writer = streamResult.getWriter();
                if (writer != null) {
                    this.marshal(object, writer);
                } else if (streamResult.getOutputStream() != null) {
                    this.marshal(object, streamResult.getOutputStream());
                } else {
                    try {
                        File f = new File(new URL(streamResult.getSystemId()).toURI());
                        this.marshal(object, new FileWriter(f));
                    }
                    catch (Exception e) {
                        throw XMLMarshalException.marshalException(e);
                    }
                }
            } else {
                StringWriter writer = new StringWriter();
                this.marshal(object, writer);
                System.out.println(writer.toString());
                StreamSource source = new StreamSource(new StringReader(writer.toString()));
                this.transformer.transform(source, result);
            }
            return;
        }
        try {
            Document document = this.objectToXML(object, xmlDescriptor, isXMLRoot);
            if (result instanceof SAXResult && this.isFragment()) {
                FragmentContentHandler fragmentHandler = new FragmentContentHandler(((SAXResult)result).getHandler());
                if (isXMLRoot) {
                    String oldEncoding = this.transformer.getEncoding();
                    String oldVersion = this.transformer.getVersion();
                    if (((XMLRoot)object).getEncoding() != null) {
                        this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                    }
                    if (((XMLRoot)object).getXMLVersion() != null) {
                        this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                    }
                    this.transformer.transform((Node)document, fragmentHandler);
                    this.transformer.setEncoding(oldEncoding);
                    this.transformer.setVersion(oldVersion);
                } else {
                    this.transformer.transform((Node)document, fragmentHandler);
                }
            } else if (isXMLRoot) {
                String oldEncoding = this.transformer.getEncoding();
                String oldVersion = this.transformer.getVersion();
                if (((XMLRoot)object).getEncoding() != null) {
                    this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                }
                if (((XMLRoot)object).getXMLVersion() != null) {
                    this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                }
                this.transformer.transform((Node)document, result);
                this.transformer.setEncoding(oldEncoding);
                this.transformer.setVersion(oldVersion);
            } else {
                this.transformer.transform((Node)document, result);
            }
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws XMLMarshalException {
        if (object == null || outputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            String encoding = this.getEncoding();
            if (object instanceof XMLRoot && ((XMLRoot)object).getEncoding() != null) {
                encoding = ((XMLRoot)object).getEncoding();
            }
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);
            this.marshal(object, writer);
            writer.flush();
        }
        catch (UnsupportedEncodingException exception) {
            throw XMLMarshalException.marshalException(exception);
        }
        catch (Exception ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    public void marshal(Object object, Writer writer) throws XMLMarshalException {
        if (object == null || writer == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean isXMLRoot = false;
        String version = DEFAULT_XML_VERSION;
        String encoding = this.getEncoding();
        if (object instanceof XMLRoot) {
            isXMLRoot = true;
            XMLRoot xroot = (XMLRoot)object;
            version = xroot.getXMLVersion() != null ? xroot.getXMLVersion() : version;
            encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
        }
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        AbstractSession session = this.xmlContext.getSession(xmlDescriptor);
        WriterRecord writerRecord = this.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
        writerRecord.setMarshaller(this);
        writerRecord.setWriter(writer);
        if (session == null || !this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument()) {
            this.marshal(object, writerRecord, xmlDescriptor, isXMLRoot);
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
            return;
        }
        try {
            Node xmlDocument = this.objectToXMLNode(object, xmlDescriptor, isXMLRoot);
            writerRecord.setSession(session);
            if (this.isFragment()) {
                writerRecord.node(xmlDocument, xmlDescriptor.getNamespaceResolver());
            } else {
                writerRecord.startDocument(encoding, version);
                writerRecord.node(xmlDocument, writerRecord.getNamespaceResolver());
                writerRecord.endDocument();
            }
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws XMLMarshalException {
        this.marshal(object, contentHandler, null);
    }

    public void marshal(Object object, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XMLMarshalException {
        if (object == null || contentHandler == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        AbstractSession session = this.xmlContext.getSession(xmlDescriptor);
        if (session == null || !this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument()) {
            ContentHandlerRecord contentHandlerRecord = new ContentHandlerRecord();
            contentHandlerRecord.setMarshaller(this);
            contentHandlerRecord.setContentHandler(contentHandler);
            contentHandlerRecord.setLexicalHandler(lexicalHandler);
            this.marshal(object, contentHandlerRecord, xmlDescriptor, isXMLRoot);
            return;
        }
        try {
            Document xmlDocument = this.objectToXML(object, xmlDescriptor, isXMLRoot);
            DOMReader reader = new DOMReader();
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            if (this.isFragment()) {
                FragmentContentHandler fragmentHandler = new FragmentContentHandler(contentHandler);
                reader.setContentHandler(fragmentHandler);
            } else {
                reader.setContentHandler(contentHandler);
            }
            reader.parse(xmlDocument);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.marshalException(e);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void marshal(Object object, Node node) throws XMLMarshalException {
        if (object == null || node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            boolean isXMLRoot = object instanceof XMLRoot;
            XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
            AbstractSession session = this.xmlContext.getSession(xmlDescriptor);
            if (session == null || !this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument()) {
                NodeRecord nodeRecord = new NodeRecord();
                nodeRecord.setMarshaller(this);
                nodeRecord.setDOM(node);
                if (!isXMLRoot && null == xmlDescriptor.getDefaultRootElement() && node.getNodeType() == 1 && xmlDescriptor.getSchemaReference() != null && xmlDescriptor.getSchemaReference().getType() == 1) {
                    Attr typeAttr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (typeAttr == null) {
                        NamespaceResolver namespaceResolver = xmlDescriptor.getNamespaceResolver();
                        String xsiPrefix = null;
                        if (null == namespaceResolver) {
                            namespaceResolver = new NamespaceResolver();
                            xmlDescriptor.setNamespaceResolver(namespaceResolver);
                        } else {
                            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                        }
                        if (null == xsiPrefix) {
                            xsiPrefix = namespaceResolver.generatePrefix("xsi");
                        }
                        String value = xmlDescriptor.getSchemaReference().getSchemaContext();
                        ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                        ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", xsiPrefix + ":" + "type", value);
                    } else {
                        String value = xmlDescriptor.getSchemaReference().getSchemaContext();
                        typeAttr.setValue(value);
                    }
                }
                this.marshal(object, nodeRecord, xmlDescriptor, isXMLRoot);
                return;
            }
            Node doc = this.objectToXMLNode(object, node, xmlDescriptor, isXMLRoot);
            DOMResult result = new DOMResult(node);
            if (isXMLRoot) {
                String oldEncoding = this.transformer.getEncoding();
                String oldVersion = this.transformer.getVersion();
                if (((XMLRoot)object).getEncoding() != null) {
                    this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                }
                if (((XMLRoot)object).getXMLVersion() != null) {
                    this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                }
                this.transformer.transform(doc, (Result)result);
                this.transformer.setEncoding(oldEncoding);
                this.transformer.setVersion(oldVersion);
            } else {
                this.transformer.transform(doc, (Result)result);
            }
        }
        catch (Exception exception) {
            if (exception instanceof XMLMarshalException) {
                throw (XMLMarshalException)exception;
            }
            throw XMLMarshalException.marshalException(exception);
        }
    }

    public void marshal(Object object, MarshalRecord marshalRecord) {
        boolean isXMLRoot = object instanceof XMLRoot;
        this.marshal(object, marshalRecord, this.getDescriptor(object, isXMLRoot), isXMLRoot);
    }

    private void marshal(Object object, MarshalRecord marshalRecord, XMLDescriptor descriptor, boolean isXMLRoot) {
        if (this.getAttachmentMarshaller() != null) {
            marshalRecord.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
        }
        this.addDescriptorNamespacesToXMLRecord(descriptor, marshalRecord);
        NamespaceResolver nr = marshalRecord.getNamespaceResolver();
        XMLRoot root = null;
        if (isXMLRoot) {
            root = (XMLRoot)object;
        }
        if (this.getMarshalListener() != null) {
            this.getMarshalListener().beforeMarshal(object);
        }
        if (!this.isFragment()) {
            String encoding = this.getEncoding();
            String version = DEFAULT_XML_VERSION;
            if (!isXMLRoot) {
                marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
            } else {
                if (root.getEncoding() != null) {
                    encoding = root.getEncoding();
                }
                if (root.getXMLVersion() != null) {
                    version = root.getXMLVersion();
                }
            }
            marshalRecord.startDocument(encoding, version);
        }
        XPathFragment rootFragment = this.buildRootFragment(object, descriptor, isXMLRoot, marshalRecord);
        boolean shouldWriteTypeAttribute = this.shouldWriteTypeAttribute(object, descriptor, isXMLRoot);
        String schemaLocation = this.getSchemaLocation();
        String noNsSchemaLocation = this.getNoNamespaceSchemaLocation();
        if (isXMLRoot) {
            object = root.getObject();
            if (root.getSchemaLocation() != null) {
                schemaLocation = root.getSchemaLocation();
            }
            if (root.getNoNamespaceSchemaLocation() != null) {
                noNsSchemaLocation = root.getNoNamespaceSchemaLocation();
            }
            marshalRecord.setLeafElementType(root.getSchemaType());
        }
        String xsiPrefix = null;
        if ((null != this.getSchemaLocation() || null != this.getNoNamespaceSchemaLocation() || shouldWriteTypeAttribute) && null == (xsiPrefix = nr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance"))) {
            xsiPrefix = "xsi";
            nr.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        TreeObjectBuilder treeObjectBuilder = null;
        AbstractSession session = null;
        if (descriptor != null) {
            session = this.xmlContext.getSession(object);
            treeObjectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
        } else {
            session = (AbstractSession)((Object)this.xmlContext.getSession(0));
        }
        marshalRecord.setSession(session);
        if (null != rootFragment) {
            marshalRecord.startPrefixMappings(nr);
            if (!isXMLRoot && descriptor.getNamespaceResolver() == null && rootFragment.hasNamespace()) {
                throw XMLMarshalException.namespaceResolverNotSpecified(rootFragment.getShortName());
            }
            marshalRecord.openStartElement(rootFragment, nr);
            if (null != schemaLocation) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", xsiPrefix + ":" + "schemaLocation", schemaLocation);
            }
            if (null != noNsSchemaLocation) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", xsiPrefix + ":" + "noNamespaceSchemaLocation", noNsSchemaLocation);
            }
            if (descriptor != null) {
                if (shouldWriteTypeAttribute) {
                    this.writeTypeAttribute(marshalRecord, descriptor, xsiPrefix);
                }
                treeObjectBuilder.marshalAttributes(marshalRecord, object, session);
            }
            marshalRecord.namespaceDeclarations(nr);
            marshalRecord.closeStartElement();
        }
        if (treeObjectBuilder != null) {
            treeObjectBuilder.buildRow((AbstractRecord)marshalRecord, object, session, this);
        } else if (isXMLRoot) {
            String value = null;
            value = (String)XMLConversionManager.getDefaultXMLManager().convertObject(object, String.class, root.getSchemaType());
            marshalRecord.characters(value);
        }
        if (null != rootFragment) {
            marshalRecord.endElement(rootFragment, nr);
            marshalRecord.endPrefixMappings(nr);
        }
        if (!this.isFragment()) {
            marshalRecord.endDocument();
        }
        if (this.getMarshalListener() != null) {
            this.getMarshalListener().afterMarshal(object);
        }
    }

    private XPathFragment buildRootFragment(Object object, XMLDescriptor descriptor, boolean isXMLRoot, MarshalRecord marshalRecord) {
        XPathFragment rootFragment = null;
        if (isXMLRoot) {
            rootFragment = ((XMLRoot)object).getRootFragment();
            String xmlRootUri = ((XMLRoot)object).getNamespaceURI();
            String xmlRootLocalName = ((XMLRoot)object).getLocalName();
            if (xmlRootUri != null) {
                if (descriptor != null) {
                    String xmlRootPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(marshalRecord.getNamespaceResolver().getDefaultNamespaceURI())) {
                        xmlRootPrefix = marshalRecord.getNamespaceResolver().generatePrefix();
                        marshalRecord.getNamespaceResolver().put(xmlRootPrefix, xmlRootUri);
                    }
                    if (xmlRootPrefix == null) {
                        rootFragment.setXPath(xmlRootLocalName);
                    } else {
                        rootFragment.setXPath(xmlRootPrefix + ":" + xmlRootLocalName);
                    }
                } else {
                    String xmlRootPrefix = "ns0";
                    marshalRecord.getNamespaceResolver().put(xmlRootPrefix, xmlRootUri);
                    rootFragment.setXPath(xmlRootPrefix + ":" + xmlRootLocalName);
                }
            }
        } else {
            String rootName = descriptor.getDefaultRootElement();
            if (null != rootName) {
                rootFragment = new XPathFragment(rootName);
                NamespaceResolver descriptorNamespaceResolver = descriptor.getNamespaceResolver();
                if (rootFragment.getPrefix() != null && rootFragment.getNamespaceURI() == null) {
                    String uri = null;
                    if (null == descriptorNamespaceResolver) {
                        throw XMLMarshalException.namespaceResolverNotSpecified(null);
                    }
                    uri = descriptor.getNamespaceResolver().resolveNamespacePrefix(rootFragment.getPrefix());
                    if (uri == null) {
                        throw XMLMarshalException.namespaceNotFound(rootFragment.getPrefix());
                    }
                    rootFragment.setNamespaceURI(uri);
                } else if (descriptorNamespaceResolver != null) {
                    rootFragment.setNamespaceURI(descriptorNamespaceResolver.getDefaultNamespaceURI());
                }
            }
        }
        return rootFragment;
    }

    private void writeTypeAttribute(MarshalRecord marshalRecord, XMLDescriptor descriptor, String xsiPrefix) {
        String typeValue = descriptor.getSchemaReference().getSchemaContext();
        if (typeValue == null) {
            QName contextAsQName = descriptor.getSchemaReference().getSchemaContextAsQName();
            if (contextAsQName == null) {
                return;
            }
            String uri = contextAsQName.getNamespaceURI();
            String localPart = contextAsQName.getLocalPart();
            String prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(uri);
            if (prefix == null) {
                String defaultUri = marshalRecord.getNamespaceResolver().getDefaultNamespaceURI();
                if (defaultUri != null && defaultUri.equals(uri)) {
                    typeValue = localPart;
                } else {
                    prefix = marshalRecord.getNamespaceResolver().generatePrefix();
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns:" + prefix, uri);
                    typeValue = prefix + ":" + localPart;
                }
            } else {
                typeValue = prefix + ":" + localPart;
            }
        } else {
            typeValue = typeValue.substring(1);
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ":" + "type", typeValue);
    }

    private boolean isSimpleXMLRoot(XMLRoot xmlRoot) {
        Class<?> xmlRootObjectClass = xmlRoot.getObject().getClass();
        return XMLConversionManager.getDefaultJavaTypes().get(xmlRootObjectClass) != null || ClassConstants.List_Class.isAssignableFrom(xmlRootObjectClass) || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(xmlRootObjectClass) || ClassConstants.DURATION.isAssignableFrom(xmlRootObjectClass);
    }

    public Document objectToXML(Object object) throws XMLMarshalException {
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        return this.objectToXML(object, xmlDescriptor, isXMLRoot);
    }

    protected Document objectToXML(Object object, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        AbstractSession session = this.xmlContext.getSession(descriptor);
        DocumentPreservationPolicy docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = null;
            if (!isXMLRoot) {
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(session));
                xmlRow.setMarshaller(this);
                if (this.getAttachmentMarshaller() != null) {
                    xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
                }
                this.addDescriptorNamespacesToXMLRecord(descriptor, xmlRow);
            }
            return this.objectToXML(object, descriptor, xmlRow, isXMLRoot, docPresPolicy);
        }
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    protected Node objectToXMLNode(Object object, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        return this.objectToXMLNode(object, null, descriptor, isXMLRoot);
    }

    protected Node objectToXMLNode(Object object, Node rootNode, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        AbstractSession session = this.xmlContext.getSession(descriptor);
        DocumentPreservationPolicy docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = null;
            if (!isXMLRoot) {
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(session));
                xmlRow.setMarshaller(this);
                if (this.getAttachmentMarshaller() != null) {
                    xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
                }
                if (xmlRow.getDOM().getNodeType() == 1) {
                    this.addDescriptorNamespacesToXMLRecord(descriptor, xmlRow);
                }
            }
            Document doc = this.objectToXML(object, rootNode, descriptor, xmlRow, isXMLRoot, docPresPolicy);
            if (xmlRow != null && xmlRow.getDOM().getNodeType() == 11) {
                return xmlRow.getDOM();
            }
            return doc;
        }
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        marshalRecord.getNamespaceResolver().setDOM(rootNode);
        this.marshal(object, marshalRecord, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    private void addDescriptorNamespacesToXMLRecord(XMLDescriptor xmlDescriptor, XMLRecord record) {
        if (null == xmlDescriptor) {
            return;
        }
        this.copyNamespaces(xmlDescriptor.getNamespaceResolver(), record.getNamespaceResolver());
    }

    private void copyNamespaces(NamespaceResolver source, NamespaceResolver target) {
        if (null != source && null != target) {
            Vector namespaces = source.getNamespaces();
            for (int i = 0; i < namespaces.size(); ++i) {
                Namespace next = (Namespace)namespaces.get(i);
                target.put(next.getPrefix(), next.getNamespaceURI());
            }
            target.setDefaultNamespaceURI(source.getDefaultNamespaceURI());
        }
    }

    public Document objectToXML(Object object, Node parent) throws XMLMarshalException {
        return this.objectToXML(object, parent, null);
    }

    public Document objectToXML(Object object, Node parent, DocumentPreservationPolicy docPresPolicy) {
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor descriptor = this.getDescriptor(object, isXMLRoot);
        String localRootName = descriptor.getDefaultRootElement();
        if (null == localRootName) {
            throw XMLMarshalException.defaultRootElementNotSpecified(descriptor);
        }
        AbstractSession session = this.xmlContext.getSession(descriptor);
        if (docPresPolicy == null) {
            docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        }
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecord(localRootName, parent, session);
            xmlRow.setMarshaller(this);
            if (this.getAttachmentMarshaller() != null) {
                xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
            }
            return this.objectToXML(object, descriptor, xmlRow, isXMLRoot, docPresPolicy);
        }
        NodeRecord marshalRecord = new NodeRecord(localRootName, parent);
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    public Document objectToXML(Object object, XMLDescriptor descriptor, XMLRecord xmlRow, boolean isXMLRoot, DocumentPreservationPolicy docPresPolicy) {
        return this.objectToXML(object, null, descriptor, xmlRow, isXMLRoot, docPresPolicy);
    }

    public Document objectToXML(Object object, Node rootNode, XMLDescriptor descriptor, XMLRecord xmlRow, boolean isXMLRoot, DocumentPreservationPolicy docPresPolicy) {
        short rootNodeType;
        if (null != rootNode && (rootNodeType = rootNode.getNodeType()) != 9 && rootNodeType != 1 && rootNodeType != 11) {
            throw XMLMarshalException.marshalException(null);
        }
        Document document = null;
        NamespaceResolver resolver = new NamespaceResolver();
        resolver.setDOM(rootNode);
        this.copyNamespaces(descriptor.getNamespaceResolver(), resolver);
        boolean shouldCallSetAttributeNS = false;
        boolean isRootDocumentFragment = false;
        AbstractSession session = this.xmlContext.getSession(descriptor);
        if (xmlRow != null) {
            boolean bl = isRootDocumentFragment = xmlRow.getDOM().getNodeType() == 11;
        }
        if (isXMLRoot) {
            String xmlRootUri = ((XMLRoot)object).getNamespaceURI();
            String xmlRootPrefix = null;
            if (xmlRow == null) {
                String recordName = ((XMLRoot)object).getLocalName();
                if (xmlRootUri != null) {
                    xmlRootPrefix = resolver.resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(resolver.getDefaultNamespaceURI())) {
                        xmlRootPrefix = resolver.generatePrefix();
                        resolver.put(xmlRootPrefix, xmlRootUri);
                        shouldCallSetAttributeNS = true;
                    }
                    if (xmlRootPrefix != null) {
                        recordName = xmlRootPrefix + ":" + recordName;
                    }
                }
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(((XMLRoot)object).getObject(), docPresPolicy, recordName, xmlRootUri);
                xmlRow.setMarshaller(this);
                if (this.getAttachmentMarshaller() != null) {
                    xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
                }
                if (!isRootDocumentFragment && shouldCallSetAttributeNS) {
                    if (xmlRootPrefix != null) {
                        ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xmlRootPrefix, xmlRootUri);
                    }
                    shouldCallSetAttributeNS = false;
                }
            }
            this.copyNamespaces(resolver, xmlRow.getNamespaceResolver());
            document = xmlRow.getDocument();
            Element docElement = document.getDocumentElement();
            xmlRow.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            boolean writeTypeAttribute = this.shouldWriteTypeAttribute(object, descriptor, isXMLRoot);
            if (writeTypeAttribute && descriptor.getSchemaReference() != null && descriptor.getSchemaReference().getSchemaContext() != null) {
                ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String typeValue = descriptor.getSchemaReference().getSchemaContext();
                typeValue = typeValue.substring(1);
                XMLField xsiTypefield = new XMLField("@xsi:type");
                xsiTypefield.setNamespaceResolver(xmlRow.getNamespaceResolver());
                XPathEngine.getInstance().create(xsiTypefield, docElement, typeValue, session);
            }
            object = ((XMLRoot)object).getObject();
        }
        XMLObjectBuilder bldr = (XMLObjectBuilder)descriptor.getObjectBuilder();
        xmlRow = (XMLRecord)bldr.buildRow(xmlRow, object, this.xmlContext.getSession(object), isXMLRoot);
        xmlRow.setMarshaller(this);
        if (shouldCallSetAttributeNS && !isRootDocumentFragment) {
            ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        document = xmlRow.getDocument();
        this.addSchemaLocations(document, session);
        return document;
    }

    private void addSchemaLocations(Document document, AbstractSession session) {
        XMLField field;
        Element docElement = document.getDocumentElement();
        NamespaceResolver resolver = new NamespaceResolver();
        resolver.put("xmlns", "http://www.w3.org/2000/xmlns/");
        resolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null) {
            field = new XMLField("@xmlns:xsi");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, "http://www.w3.org/2001/XMLSchema-instance", session);
        }
        if (this.getSchemaLocation() != null) {
            field = new XMLField("@xsi:schemaLocation");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, this.getSchemaLocation(), session);
        }
        if (this.getNoNamespaceSchemaLocation() != null) {
            field = new XMLField("@xsi:noNamespaceSchemaLocation");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, this.getNoNamespaceSchemaLocation(), session);
        }
    }

    public boolean shouldWriteTypeAttribute(Object object, XMLDescriptor descriptor, boolean isXMLRoot) {
        boolean writeTypeAttribute = false;
        if (isXMLRoot && descriptor != null) {
            QName qName;
            XMLDescriptor xdesc;
            XMLRoot xr = (XMLRoot)object;
            if (descriptor.hasInheritance()) {
                XMLField classIndicatorField = (XMLField)descriptor.getInheritancePolicy().getClassIndicatorField();
                String classIndicatorUri = null;
                String classIndicatorLocalName = classIndicatorField.getXPathFragment().getLocalName();
                String classIndicatorPrefix = classIndicatorField.getXPathFragment().getPrefix();
                if (classIndicatorPrefix != null) {
                    classIndicatorUri = descriptor.getNamespaceResolver().resolveNamespacePrefix(classIndicatorPrefix);
                }
                if (classIndicatorLocalName != null && classIndicatorLocalName.equals("type") && classIndicatorUri != null && classIndicatorUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    return false;
                }
            }
            if ((xdesc = this.xmlContext.getDescriptor(qName = new QName(xr.getNamespaceURI(), xr.getLocalName()))) != null) {
                return xdesc.getJavaClass() != descriptor.getJavaClass();
            }
            if (descriptor.getSchemaReference() == null) {
                return false;
            }
            String xmlRootLocalName = xr.getLocalName();
            String xmlRootUri = xr.getNamespaceURI();
            writeTypeAttribute = true;
            for (int i = 0; i < descriptor.getTableNames().size() && writeTypeAttribute; ++i) {
                String defaultRootQualifiedName = (String)descriptor.getTableNames().get(i);
                if (defaultRootQualifiedName != null) {
                    String defaultRootLocalName = null;
                    String defaultRootUri = null;
                    int colonIndex = defaultRootQualifiedName.indexOf(58);
                    if (colonIndex > 0) {
                        String defaultRootPrefix = defaultRootQualifiedName.substring(0, colonIndex);
                        defaultRootLocalName = defaultRootQualifiedName.substring(colonIndex + 1);
                        if (descriptor.getNamespaceResolver() != null) {
                            defaultRootUri = descriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                        }
                    } else {
                        defaultRootLocalName = defaultRootQualifiedName;
                    }
                    if (xmlRootLocalName == null || (defaultRootLocalName != null || xmlRootLocalName != null) && !defaultRootLocalName.equals(xmlRootLocalName) || (defaultRootUri != null || xmlRootUri != null) && (xmlRootUri == null || defaultRootUri == null || !defaultRootUri.equals(xmlRootUri))) continue;
                    writeTypeAttribute = false;
                    continue;
                }
                if (xmlRootLocalName != null) continue;
                writeTypeAttribute = false;
            }
        }
        return writeTypeAttribute;
    }

    protected XMLDescriptor getDescriptor(Object object) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(Object object, boolean isXMLRoot) {
        if (isXMLRoot) {
            return this.getDescriptor((XMLRoot)object);
        }
        return this.getDescriptor(object);
    }

    protected XMLDescriptor getDescriptor(XMLRoot object) throws XMLMarshalException {
        XMLDescriptor descriptor = null;
        try {
            descriptor = (XMLDescriptor)this.xmlContext.getSession(object.getObject()).getDescriptor(object.getObject());
        }
        catch (XMLMarshalException marshalException) {
            if (descriptor == null && this.isSimpleXMLRoot(object)) {
                return null;
            }
            throw marshalException;
        }
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    public void setFragment(boolean fragment) {
        this.transformer.setFragment(fragment);
    }

    public boolean isFragment() {
        return this.transformer.isFragment();
    }

    public void setAttachmentMarshaller(XMLAttachmentMarshaller atm) {
        this.attachmentMarshaller = atm;
    }

    public XMLAttachmentMarshaller getAttachmentMarshaller() {
        return this.attachmentMarshaller;
    }

    public XMLTransformer getTransformer() {
        return this.transformer;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

