/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLCompositeObjectMapping
extends AbstractCompositeObjectMapping
implements XMLMapping,
XMLNillableMapping {
    private static final String EMPTY_STRING = "";
    AbstractNullPolicy nullPolicy = new NullPolicy();
    private AttributeAccessor containerAccessor;
    private UnmarshalKeepAsElementPolicy keepAsElementPolicy;
    private boolean isWriteOnly;

    public AttributeAccessor getContainerAccessor() {
        return this.containerAccessor;
    }

    public void setContainerAccessor(AttributeAccessor anAttributeAccessor) {
        this.containerAccessor = anAttributeAccessor;
    }

    public void setContainerAttributeName(String attributeName) {
        if (attributeName != null) {
            if (this.containerAccessor == null) {
                this.containerAccessor = new InstanceVariableAttributeAccessor();
            }
            this.getContainerAccessor().setAttributeName(attributeName);
        }
    }

    public String getContainerAttributeName() {
        if (this.containerAccessor == null) {
            return null;
        }
        return this.getContainerAccessor().getAttributeName();
    }

    public void setContainerGetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.containerAccessor == null) {
            this.containerAccessor = new MethodAttributeAccessor();
        }
        if (!this.getContainerAccessor().isMethodAttributeAccessor()) {
            String attributeName = this.containerAccessor.getAttributeName();
            this.setContainerAccessor(new MethodAttributeAccessor());
            this.getContainerAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getContainerAccessor()).setGetMethodName(methodName);
    }

    public void setContainerSetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.containerAccessor == null) {
            this.containerAccessor = new MethodAttributeAccessor();
        }
        if (!this.getContainerAccessor().isMethodAttributeAccessor()) {
            String attributeName = this.containerAccessor.getAttributeName();
            this.setContainerAccessor(new MethodAttributeAccessor());
            this.getContainerAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getContainerAccessor()).setSetMethodName(methodName);
    }

    public String getContainerGetMethodName() {
        if (this.getContainerAccessor() == null || !this.getContainerAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getContainerAccessor()).getGetMethodName();
    }

    public String getContainerSetMethodName() {
        if (this.getContainerAccessor() == null || !this.getContainerAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getContainerAccessor()).getSetMethodName();
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null && this.getReferenceClassName() != null) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        if (this.getReferenceClass() != null) {
            super.initialize(session);
        } else {
            if (this.getField() == null) {
                throw DescriptorException.fieldNameNotSetInMapping(this);
            }
            this.setField(this.getDescriptor().buildField(this.getField()));
            this.setFields(this.collectFields());
            if (this.hasConverter()) {
                this.getConverter().initialize(this, session);
            }
        }
        if (null != this.containerAccessor) {
            this.containerAccessor.initializeAttributes(this.referenceClass);
        }
    }

    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public boolean isXMLMapping() {
        return true;
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    protected Object buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord databaseRow) {
        XMLDescriptor xmlReferenceDescriptor = null;
        try {
            xmlReferenceDescriptor = (XMLDescriptor)this.getReferenceDescriptor(attributeValue, session);
        }
        catch (Exception e) {
            // empty catch block
        }
        XMLField xmlFld = (XMLField)this.getField();
        if (xmlFld.hasLastXPathFragment() && xmlFld.getLastXPathFragment().hasLeafElementType()) {
            XMLRecord xmlRec = (XMLRecord)databaseRow;
            xmlRec.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
        }
        XMLRecord parent = (XMLRecord)databaseRow;
        if (xmlReferenceDescriptor != null) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)xmlReferenceDescriptor.getObjectBuilder();
            boolean addXsiType = this.shouldAddXsiType((XMLRecord)databaseRow, xmlReferenceDescriptor);
            XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)this.getField(), parent, this);
            child.setNamespaceResolver(parent.getNamespaceResolver());
            objectBuilder.buildIntoNestedRow(child, attributeValue, session, addXsiType);
            return child;
        }
        if (attributeValue instanceof Element && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            return new DOMRecord((Element)attributeValue);
        }
        Node newNode = XPathEngine.getInstance().create((XMLField)this.getField(), parent.getDOM(), attributeValue, session);
        DOMRecord newRow = new DOMRecord(newNode);
        return newRow;
    }

    protected Object buildCompositeObject(ObjectBuilder objectBuilder, AbstractRecord nestedRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager) {
        return objectBuilder.buildObject(query, nestedRow, joinManager);
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object fieldValue = databaseRow.getIndicatingNoEntry(this.getField());
        if (null == fieldValue || fieldValue instanceof String) {
            if (!this.getNullPolicy().getIsSetPerformedForAbsentNode()) {
                return null;
            }
            this.setAttributeValueInObject(targetObject, null);
            return null;
        }
        XMLRecord nestedRow = (XMLRecord)this.getDescriptor().buildNestedRowFromFieldValue(fieldValue);
        if (this.getNullPolicy().valueIsNull((Element)nestedRow.getDOM())) {
            this.setAttributeValueInObject(targetObject, null);
            return null;
        }
        Object attributeValue = this.valueFromRow(fieldValue, nestedRow, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(targetObject, attributeValue);
        if (null != this.containerAccessor) {
            this.containerAccessor.setAttributeValueInObject(attributeValue, targetObject);
        }
        return attributeValue;
    }

    public Object valueFromRow(Object fieldValue, XMLRecord nestedRow, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object toReturn = null;
        ClassDescriptor aDescriptor = this.getReferenceDescriptor((DOMRecord)nestedRow);
        if (aDescriptor == null) {
            String type;
            if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                XMLPlatformFactory.getInstance().getXMLPlatform().namespaceQualifyFragment((Element)nestedRow.getDOM());
                toReturn = nestedRow.getDOM();
                if (this.getConverter() != null) {
                    toReturn = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(toReturn, executionSession, nestedRow.getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(toReturn, executionSession);
                }
                return toReturn;
            }
            NodeList children = ((Element)nestedRow.getDOM()).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node nextNode = children.item(i);
                if (nextNode.getNodeType() != 1) continue;
                throw XMLMarshalException.noDescriptorFound(this);
            }
            Node textchild = ((Element)nestedRow.getDOM()).getFirstChild();
            if (textchild != null && textchild.getNodeType() == 3) {
                toReturn = ((Text)textchild).getNodeValue();
            }
            if (toReturn != null && !toReturn.equals(EMPTY_STRING) && null != (type = ((Element)nestedRow.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) && !type.equals(EMPTY_STRING)) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = nestedRow.resolveNamespacePrefix(typeFragment.getPrefix());
                QName schemaTypeQName = new QName(namespaceURI, typeFragment.getLocalName());
                Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(schemaTypeQName);
                if (theClass != null) {
                    toReturn = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertObject(toReturn, theClass, schemaTypeQName);
                }
            }
        } else {
            if (aDescriptor.hasInheritance()) {
                QName leafElementType;
                Class classValue = aDescriptor.getInheritancePolicy().classFromRow(nestedRow, executionSession);
                if (classValue == null && (leafElementType = ((XMLField)this.getField()).getLeafElementType()) != null) {
                    Object indicator = aDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                    if (indicator == null) {
                        throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, aDescriptor.getInheritancePolicy().getDescriptor());
                    }
                    classValue = (Class)indicator;
                }
                if (classValue != null) {
                    aDescriptor = this.getReferenceDescriptor(classValue, executionSession);
                } else if (Modifier.isAbstract(aDescriptor.getJavaClass().getModifiers())) {
                    throw DescriptorException.missingClassIndicatorField(nestedRow, aDescriptor.getInheritancePolicy().getDescriptor());
                }
            }
            ObjectBuilder objectBuilder = aDescriptor.getObjectBuilder();
            toReturn = this.buildCompositeObject(objectBuilder, nestedRow, sourceQuery, joinManager);
        }
        if (this.getConverter() != null) {
            toReturn = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(toReturn, executionSession, nestedRow.getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(toReturn, executionSession);
        }
        return toReturn;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object fieldValue = row.get(this.getField());
        if (fieldValue == null || fieldValue instanceof String) {
            return null;
        }
        XMLRecord nestedRow = (XMLRecord)this.getDescriptor().buildNestedRowFromFieldValue(fieldValue);
        if (this.getNullPolicy().valueIsNull((Element)nestedRow.getDOM())) {
            return null;
        }
        return this.valueFromRow(fieldValue, nestedRow, joinManager, sourceQuery, executionSession);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord databaseRow, AbstractSession session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        this.writeSingleValue(attributeValue, object, (XMLRecord)databaseRow, session);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object attributeValue = value;
        if (this.getConverter() != null) {
            attributeValue = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(attributeValue, session, record.getMarshaller()) : this.getConverter().convertObjectValueToDataValue(attributeValue, session);
        }
        if (((XMLField)this.getField()).isSelfField()) {
            if ((this.keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || this.keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && attributeValue instanceof Node) {
                Document doc = record.getDocument();
                Node root = record.getDOM();
                NodeList children = ((Node)attributeValue).getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node importedCopy = doc.importNode(children.item(i), true);
                    root.appendChild(importedCopy);
                }
            } else {
                XMLObjectBuilder objectBuilder = (XMLObjectBuilder)this.getReferenceDescriptor(attributeValue.getClass(), session).getObjectBuilder();
                objectBuilder.buildIntoNestedRow(record, attributeValue, session);
            }
        } else {
            Object fieldValue = null;
            if (attributeValue != null) {
                fieldValue = this.buildCompositeRow(attributeValue, session, record);
            } else if (this.getNullPolicy().compositeObjectMarshal(record, parent, (XMLField)this.getField(), session)) {
                return;
            }
            record.put(this.getField(), fieldValue);
        }
    }

    public void configureNestedRow(AbstractRecord parent, AbstractRecord child) {
        XMLRecord parentRecord = (XMLRecord)parent;
        XMLRecord childRecord = (XMLRecord)child;
        childRecord.setUnmarshaller(parentRecord.getUnmarshaller());
        childRecord.setOwningObject(parentRecord.getCurrentObject());
    }

    public ClassDescriptor getReferenceDescriptor(DOMRecord xmlRecord) {
        ClassDescriptor returnDescriptor = this.referenceDescriptor;
        if (returnDescriptor == null) {
            String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != type && !type.equals(EMPTY_STRING)) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
                typeFragment.setNamespaceURI(namespaceURI);
                returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(typeFragment);
            } else {
                QName leafType = ((XMLField)this.getField()).getLastXPathFragment().getLeafElementType();
                if (leafType != null) {
                    XPathFragment frag = new XPathFragment();
                    String xpath = leafType.getLocalPart();
                    String uri = leafType.getNamespaceURI();
                    if (uri != null && !uri.equals(EMPTY_STRING)) {
                        frag.setNamespaceURI(uri);
                        String prefix = ((XMLDescriptor)this.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                        if (prefix != null && !prefix.equals(EMPTY_STRING)) {
                            xpath = prefix + ":" + xpath;
                        }
                    }
                    frag.setXPath(xpath);
                    returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(frag);
                }
            }
        }
        return returnDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subDescriptor = session.getDescriptor(theClass);
        if (subDescriptor == null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    public boolean shouldAddXsiType(XMLRecord record, ClassDescriptor aDescriptor) {
        XMLDescriptor xmlDescriptor = (XMLDescriptor)aDescriptor;
        if (this.getReferenceDescriptor() == null && xmlDescriptor.getSchemaReference() != null) {
            XMLField indicatorField;
            if (aDescriptor.hasInheritance() && (indicatorField = (XMLField)aDescriptor.getInheritancePolicy().getClassIndicatorField()).getLastXPathFragment().getNamespaceURI() != null && indicatorField.getLastXPathFragment().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && indicatorField.getLastXPathFragment().getLocalName().equals("type")) {
                return false;
            }
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (xmlRef.getType() == 1 && xmlRef.isGlobalDefinition()) {
                QName ctxQName = xmlRef.getSchemaContextAsQName(xmlDescriptor.getNamespaceResolver());
                QName leafType = ((XMLField)this.getField()).getLeafElementType();
                if (leafType == null || !ctxQName.equals(record.getLeafElementType())) {
                    return true;
                }
            }
        }
        return false;
    }

    public UnmarshalKeepAsElementPolicy getKeepAsElementPolicy() {
        return this.keepAsElementPolicy;
    }

    public void setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy keepAsElementPolicy) {
        this.keepAsElementPolicy = keepAsElementPolicy;
    }

    protected XMLDescriptor getDescriptor(XMLRecord xmlRecord, AbstractSession session, QName rootQName) throws XMLMarshalException {
        XMLContext xmlContext;
        XMLDescriptor xmlDescriptor;
        if (rootQName == null) {
            rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName());
        }
        if (null == (xmlDescriptor = (xmlContext = xmlRecord.getUnmarshaller().getXMLContext()).getDescriptor(rootQName)) && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(xmlRecord.getLocalName());
        }
        return xmlDescriptor;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }
}

