/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.expressions.ClassTypeExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

public class ReportQueryResult
implements Serializable,
Map {
    protected Vector names;
    protected Vector results;
    protected Vector primaryKeyValues;
    protected StringBuffer key;

    public ReportQueryResult(Vector results, Vector primaryKeyValues) {
        this.results = results;
        this.primaryKeyValues = primaryKeyValues;
    }

    public ReportQueryResult(ReportQuery query, AbstractRecord row, Vector toManyResults) {
        this.names = query.getNames();
        this.buildResult(query, row, toManyResults);
    }

    protected void buildResult(ReportQuery query, AbstractRecord row, Vector toManyData) {
        if (query.shouldDistinctBeUsed() && query.shouldFilterDuplicates()) {
            this.key = new StringBuffer();
        }
        Vector items = query.getItems();
        int itemSize = items.size();
        Vector<Object> results = new Vector<Object>(itemSize);
        if (query.shouldRetrievePrimaryKeys()) {
            this.setPrimaryKeyValues(query.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(row, query.getSession()));
        }
        for (int index = 0; index < itemSize; ++index) {
            Object value;
            ReportItem item = (ReportItem)items.get(index);
            if (item.isConstructorItem()) {
                ConstructorReportItem constructorItem = (ConstructorReportItem)item;
                Class[] constructorArgTypes = constructorItem.getConstructorArgTypes();
                int numberOfArguments = constructorItem.getReportItems().size();
                Object[] constructorArgs = new Object[numberOfArguments];
                for (int argumentIndex = 0; argumentIndex < numberOfArguments; ++argumentIndex) {
                    ReportItem argumentItem = (ReportItem)constructorItem.getReportItems().get(argumentIndex);
                    Object result = this.processItem(query, row, toManyData, argumentItem);
                    constructorArgs[argumentIndex] = ConversionManager.getDefaultManager().convertObject(result, constructorArgTypes[argumentIndex]);
                }
                try {
                    Constructor constructor = constructorItem.getConstructor();
                    Object returnValue = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            returnValue = AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, constructorArgs));
                        }
                        catch (PrivilegedActionException exception) {
                            throw QueryException.exceptionWhileUsingConstructorExpression(exception.getException(), query);
                        }
                    } else {
                        returnValue = PrivilegedAccessHelper.invokeConstructor(constructor, constructorArgs);
                    }
                    results.add(returnValue);
                    continue;
                }
                catch (IllegalAccessException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (InvocationTargetException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (InstantiationException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
            }
            if (item.getAttributeExpression() != null && item.getAttributeExpression().isClassTypeExpression()) {
                value = this.processItem(query, row, toManyData, item);
                ClassDescriptor descriptor = ((ClassTypeExpression)item.getAttributeExpression()).getContainingDescriptor(query);
                value = descriptor != null && descriptor.hasInheritance() ? descriptor.getInheritancePolicy().classFromValue(value, query.getSession()) : query.getSession().getDatasourcePlatform().convertObject(value, Class.class);
                results.addElement(value);
                continue;
            }
            value = this.processItem(query, row, toManyData, item);
            results.addElement(value);
        }
        this.setResults(results);
    }

    protected Object processItem(ReportQuery query, AbstractRecord row, Vector toManyData, ReportItem item) {
        JoinedAttributeManager joinManager = null;
        if (item.hasJoining() && (joinManager = item.getJoinedAttributeManager()).isToManyJoin() && joinManager.getDataResults_() == null) {
            joinManager.setDataResults(new ArrayList(toManyData), query.getSession());
        }
        Object value = null;
        DatabaseMapping mapping = item.getMapping();
        int rowSize = row.size();
        int itemIndex = item.getResultIndex();
        ClassDescriptor descriptor = item.getDescriptor();
        if (!item.isPlaceHolder()) {
            if (descriptor == null && mapping != null) {
                descriptor = mapping.getReferenceDescriptor();
            }
            if (mapping != null && mapping.isAbstractDirectMapping()) {
                if (itemIndex >= rowSize) {
                    throw QueryException.reportQueryResultSizeMismatch(itemIndex + 1, rowSize);
                }
                value = row.getValues().get(itemIndex);
                value = ((AbstractDirectMapping)mapping).getAttributeValue(value, query.getSession());
                if (this.key != null) {
                    this.key.append(value);
                    this.key.append("_");
                }
            } else if (descriptor != null) {
                if (itemIndex + descriptor.getAllFields().size() > rowSize) {
                    throw QueryException.reportQueryResultSizeMismatch(itemIndex + descriptor.getAllFields().size(), rowSize);
                }
                AbstractRecord subRow = row;
                if (itemIndex > 0) {
                    NonSynchronizedSubVector trimedFields = new NonSynchronizedSubVector(row.getFields(), itemIndex, rowSize);
                    NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), itemIndex, rowSize);
                    subRow = new DatabaseRecord(trimedFields, trimedValues);
                }
                value = descriptor.getObjectBuilder().buildObject(query, subRow, joinManager);
                if (item.getAttributeExpression().isMapEntryExpression() && mapping.isCollectionMapping()) {
                    Object rowKey = null;
                    rowKey = mapping.getContainerPolicy().isMapPolicy() && !mapping.getContainerPolicy().isMappedKeyMapPolicy() ? ((MapContainerPolicy)mapping.getContainerPolicy()).keyFrom(value, query.getSession()) : mapping.getContainerPolicy().buildKey(subRow, query, query.getSession());
                    value = ((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry() ? new Association(rowKey, value) : rowKey;
                }
                if (this.key != null) {
                    Vector list = descriptor.getObjectBuilder().extractPrimaryKeyFromRow(subRow, query.getSession());
                    if (list != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            this.key.append(iterator.next());
                            this.key.append("-");
                        }
                    }
                    this.key.append("_");
                }
            } else {
                value = row.getValues().get(itemIndex);
                if (this.key != null) {
                    this.key.append(value);
                }
            }
        }
        return value;
    }

    public void clear() {
        this.names = new Vector();
        this.results = new Vector();
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.getNames().contains(key);
    }

    public boolean containsValue(Object value) {
        return this.getResults().contains(value);
    }

    public Enumeration elements() {
        return this.getResults().elements();
    }

    public Set entrySet() {
        int size = this.size();
        HashMap tempMap = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            tempMap.put(this.getNames().elementAt(i), this.getResults().elementAt(i));
        }
        return tempMap.entrySet();
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof ReportQueryResult) {
            return this.equals((ReportQueryResult)anObject);
        }
        return false;
    }

    public boolean equals(ReportQueryResult result) {
        if (this == result) {
            return true;
        }
        if (!Helper.compareOrderedVectors(this.getResults(), result.getResults())) {
            return false;
        }
        if (this.getPrimaryKeyValues() != null) {
            if (result.getPrimaryKeyValues() == null) {
                return false;
            }
            return Helper.compareOrderedVectors(this.getPrimaryKeyValues(), result.getPrimaryKeyValues());
        }
        return true;
    }

    public Object get(Object name) {
        if (name instanceof String) {
            return this.get((String)name);
        }
        return null;
    }

    public Object get(String name) {
        int index = this.getNames().indexOf(name);
        if (index == -1) {
            return null;
        }
        return this.getResults().elementAt(index);
    }

    public Object getByIndex(int index) {
        return this.getResults().elementAt(index);
    }

    public String getResultKey() {
        if (this.key != null) {
            return this.key.toString();
        }
        return null;
    }

    public Vector getNames() {
        return this.names;
    }

    public Vector getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public Vector getResults() {
        return this.results;
    }

    public boolean isEmpty() {
        return this.getNames().isEmpty();
    }

    public Enumeration keys() {
        return this.getNames().elements();
    }

    public Set keySet() {
        return new HashSet(this.getNames());
    }

    public Object put(Object name, Object value) {
        int index = this.getNames().indexOf(name);
        if (index == -1) {
            this.getNames().addElement(name);
            this.getResults().addElement(value);
            return null;
        }
        Object oldValue = this.getResults().elementAt(index);
        this.getResults().setElementAt(value, index);
        return oldValue;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object readObject(Class javaClass, Session session) {
        if (this.getPrimaryKeyValues() == null) {
            throw QueryException.reportQueryResultWithoutPKs(this);
        }
        ReadObjectQuery query = new ReadObjectQuery(javaClass);
        query.setSelectionKey(this.getPrimaryKeyValues());
        return session.executeQuery(query);
    }

    public Object remove(Object name) {
        int index = this.getNames().indexOf(name);
        if (index >= 0) {
            this.getNames().removeElementAt(index);
            Object value = this.getResults().elementAt(index);
            this.getResults().removeElementAt(index);
            return value;
        }
        return null;
    }

    protected void setNames(Vector names) {
        this.names = names;
    }

    protected void setPrimaryKeyValues(Vector primaryKeyValues) {
        this.primaryKeyValues = primaryKeyValues;
    }

    public void setResults(Vector results) {
        this.results = results;
    }

    public int size() {
        return this.getNames().size();
    }

    public Object[] toArray() {
        Vector list = this.getResults();
        return list == null ? null : list.toArray();
    }

    public List toList() {
        return this.getResults();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("ReportQueryResult(");
        for (int index = 0; index < this.getResults().size(); ++index) {
            writer.write(String.valueOf(this.getResults().elementAt(index)));
            if (index >= this.getResults().size() - 1) continue;
            writer.write(", ");
        }
        writer.write(")");
        return writer.toString();
    }

    public Collection values() {
        return this.getResults();
    }
}

