/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.SystemPropertyConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class InstanceHandler {
    private static final String PROPERTY_VALUE = "Value";

    public static void getInstanceGeneralAttributes(HandlerContext handlerCtx) {
        String debugEnabled;
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        if (GuiUtil.isEmpty((String)instanceName)) {
            System.out.println("instanceName is not provided, set to \"server\"");
            instanceName = "server";
        }
        AMXRoot amxRoot = AMXRoot.getInstance();
        String configName = amxRoot.getConfigName(instanceName);
        ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        String hostName = request.getServerName();
        handlerCtx.setOutputValue("hostName", (Object)hostName);
        handlerCtx.setOutputValue("httpPorts", (Object)V3AMX.getHttpPortNumber((String)hostName, (String)configName));
        IIOPServiceConfig iiopService = amxRoot.getConfig(configName).getIIOPServiceConfig();
        Map iiopListeners = iiopService.getIIOPListenerConfigMap();
        StringBuffer iports = new StringBuffer();
        for (String key : iiopListeners.keySet()) {
            String iport = ((IIOPListenerConfig)iiopListeners.get(key)).getPort();
            if (iport.startsWith("$")) {
                iport = InstanceHandler.resolveToken(iport.substring(2, iport.length() - 1), instanceName);
            }
            iports.append("," + iport);
        }
        iports.deleteCharAt(0);
        handlerCtx.setOutputValue("iiopPorts", (Object)iports.toString());
        String configDir = amxRoot.getDomainRoot().getConfigDir();
        String version = amxRoot.getDomainRoot().getApplicationServerFullVersion();
        String debugPort = "";
        String debugOption = amxRoot.getConfig(configName).getJavaConfig().getDebugOptions();
        StringTokenizer tokens = new StringTokenizer(debugOption, ",");
        String doption = "";
        while (tokens.hasMoreTokens()) {
            int pos;
            doption = tokens.nextToken().trim();
            if (!doption.startsWith("address") || (pos = doption.indexOf("=")) < 0) continue;
            debugPort = doption.substring(pos + 1).trim();
            break;
        }
        String msg = "true".equals(debugEnabled = amxRoot.getConfig(configName).getJavaConfig().getDebugEnabled()) ? GuiUtil.getMessage((String)"inst.debugEnabled") + debugPort : GuiUtil.getMessage((String)"inst.notEnabled");
        handlerCtx.setOutputValue("debugPort", (Object)msg);
        handlerCtx.setOutputValue("configDir", (Object)configDir);
        handlerCtx.setOutputValue("version", (Object)version);
    }

    private static String resolveToken(String pn, String serverName) {
        StandaloneServerConfig ss = (StandaloneServerConfig)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(serverName);
        if (ss != null && ss.getSystemPropertyConfigMap().containsKey(pn)) {
            return ((SystemPropertyConfig)ss.getSystemPropertyConfigMap().get(pn)).getValue();
        }
        ClusteredServerConfig cs = (ClusteredServerConfig)AMXRoot.getInstance().getServersConfig().getClusteredServerConfigMap().get(serverName);
        if (cs != null && cs.getSystemPropertyConfigMap().containsKey(pn)) {
            return ((SystemPropertyConfig)cs.getSystemPropertyConfigMap().get(pn)).getValue();
        }
        return "";
    }

    public static void getProfilerAttrs(HandlerContext handlerCtx) {
        ObjectName objName = null;
        Boolean edit = false;
        try {
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName("v3:pp=/domain/configs/config[server-config],type=java-config"));
            objName = (ObjectName)amx.attributesMap().get("Profiler");
            if (objName != null) {
                edit = true;
            }
            handlerCtx.setOutputValue("edit", (Object)edit);
            handlerCtx.setOutputValue("objectName", (Object)objName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("edit", (Object)false);
        }
    }

    public static void getJvmOptionsValues(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            Object[] options = (String[])amx.attributesMap().get("JvmOptions");
            handlerCtx.setOutputValue("result", (Object)GuiUtil.convertArrayToListOfMap((Object[])options, (String)PROPERTY_VALUE));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("result", new HashMap());
        }
    }

    public static void saveJvmOptionValues(HandlerContext handlerCtx) {
        ArrayList<String> newList = new ArrayList<String>();
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            ObjectName objectName = new ObjectName(objectNameStr);
            List options = (List)handlerCtx.getInputValue("options");
            AttributeList attrList = new AttributeList();
            for (Map oneRow : options) {
                String value = (String)oneRow.get(PROPERTY_VALUE);
                if (GuiUtil.isEmpty((String)value)) continue;
                newList.add(value);
            }
            V3AMX.setAttribute((ObjectName)objectName, (Attribute)new Attribute("JvmOptions", newList.toArray(new String[0])));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void stopDAS(HandlerContext handlerCtx) {
        AMXRoot.getInstance().getDomainRoot().executeREST("stop-domain");
    }
}

