/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TriggerEvent;

abstract class GenericTriggerExecutor {
    final InternalTriggerExecutionContext tec;
    final TriggerDescriptor triggerd;
    final Activation activation;
    final LanguageConnectionContext lcc;
    private ExecPreparedStatement ps;
    private Activation spsActivation;

    GenericTriggerExecutor(InternalTriggerExecutionContext internalTriggerExecutionContext, TriggerDescriptor triggerDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext) {
        this.tec = internalTriggerExecutionContext;
        this.triggerd = triggerDescriptor;
        this.activation = activation;
        this.lcc = languageConnectionContext;
    }

    abstract void fireTrigger(TriggerEvent var1, CursorResultSet var2, CursorResultSet var3) throws StandardException;

    protected SPSDescriptor getWhenClause() throws StandardException {
        return this.triggerd.getWhenClauseSPS();
    }

    protected SPSDescriptor getAction() throws StandardException {
        return this.triggerd.getActionSPS(this.lcc);
    }

    protected void executeSPS(SPSDescriptor sPSDescriptor) throws StandardException {
        boolean bl = false;
        while (true) {
            if (this.ps == null || bl) {
                this.ps = sPSDescriptor.getPreparedStatement();
                this.ps = this.ps.getClone();
                this.ps.setValid();
                this.spsActivation = this.ps.getActivation(this.lcc, false);
                this.ps.setSource(sPSDescriptor.getText());
                this.ps.setSPSAction();
            }
            StatementContext statementContext = this.lcc.getStatementContext();
            try {
                ResultSet resultSet = this.ps.execute(this.spsActivation, false, 0L);
                if (resultSet.returnsRows()) {
                    while (resultSet.getNextRow() != null) {
                    }
                }
                resultSet.close();
            }
            catch (StandardException standardException) {
                StatementContext statementContext2 = this.lcc.getStatementContext();
                if (statementContext != statementContext2) {
                    statementContext2.cleanupOnError(standardException);
                }
                if (standardException.getMessageId().equals("XCL32.S")) {
                    bl = true;
                    sPSDescriptor.revalidate(this.lcc);
                    continue;
                }
                this.spsActivation.close();
                throw standardException;
            }
            break;
        }
    }

    protected void clearSPS() throws StandardException {
        if (this.spsActivation != null) {
            this.spsActivation.close();
        }
        this.ps = null;
        this.spsActivation = null;
    }
}

