/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerWrapper;
import com.sun.enterprise.container.common.impl.FactoryForEntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.MailNamingObjectFactory;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ComponentEnvManagerImpl
implements ComponentEnvManager {
    private static final String JAVA_COLON = "java:";
    private static final String JAVA_COMP_ENV_STRING = "java:comp/env/";
    private static final String JAVA_COMP_PREFIX = "java:comp/";
    private static final String JAVA_MODULE_PREFIX = "java:module/";
    private static final String JAVA_APP_PREFIX = "java:app/";
    private static final String JAVA_GLOBAL_PREFIX = "java:global/";
    private static final String EIS_STRING = "/eis/";
    @Inject
    private Habitat habitat;
    @Inject
    private Logger _logger;
    @Inject
    GlassfishNamingManager namingManager;
    @Inject
    private NamingUtils namingUtils;
    @Inject
    private InvocationManager invMgr;
    private Map<String, JndiNameEnvironment> compId2Env = new ConcurrentHashMap<String, JndiNameEnvironment>();
    private static final String ID_SEPARATOR = "_";

    public void register(String componentId, JndiNameEnvironment env) {
        this.compId2Env.put(componentId, env);
    }

    public void unregister(String componentId) {
        this.compId2Env.remove(componentId);
    }

    @Override
    public JndiNameEnvironment getJndiNameEnvironment(String componentId) {
        return this.compId2Env.get(componentId);
    }

    @Override
    public JndiNameEnvironment getCurrentJndiNameEnvironment() {
        JndiNameEnvironment desc = null;
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null && inv.componentId != null) {
            desc = this.compId2Env.get(inv.componentId);
        }
        return desc;
    }

    @Override
    public String bindToComponentNamespace(JndiNameEnvironment env) throws NamingException {
        String compEnvId = this.getComponentEnvId(env);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.COMPONENT, bindings);
        for (JndiNameEnvironment moduleEnv : this.getJndiNameEnvironmentsForModule(env)) {
            this.addJNDIBindings(moduleEnv, ScopeType.MODULE, bindings);
        }
        for (JndiNameEnvironment appEnv : this.getJndiNameEnvironmentsForApp(env)) {
            this.addJNDIBindings(appEnv, ScopeType.APP, bindings);
        }
        this.namingManager.bindToComponentNamespace(this.getApplicationName(env), compEnvId, bindings);
        ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.GLOBAL, globalBindings);
        for (JNDIBinding next : globalBindings) {
            this.namingManager.publishObject(next.getName(), next.getValue(), true);
        }
        this.register(compEnvId, env);
        return compEnvId;
    }

    @Override
    public void unbindFromComponentNamespace(JndiNameEnvironment env) throws NamingException {
        String compEnvId = this.getComponentEnvId(env);
        this.namingManager.unbindObjects(compEnvId);
        ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.GLOBAL, globalBindings);
        for (JNDIBinding next : globalBindings) {
            this.namingManager.unpublishObject(next.getName());
        }
        this.unregister(compEnvId);
    }

    private void addJNDIBindings(JndiNameEnvironment env, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        Object value;
        String name;
        for (EnvironmentProperty next : env.getEnvironmentProperties()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope) || !next.hasAValue()) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = next.getValueObject();
            jndiBindings.add(new CompEnvBinding(name, this.namingUtils.createSimpleNamingObjectFactory(name, value)));
        }
        for (EnvironmentProperty next : env.getJmsDestinationReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            jndiBindings.add(this.getCompEnvBinding((JmsDestinationReferenceDescriptor)next));
        }
        for (EnvironmentProperty next : env.getEjbReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            EjbReferenceProxy proxy = new EjbReferenceProxy((EjbReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, proxy));
        }
        for (EnvironmentProperty next : env.getMessageDestinationReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            jndiBindings.add(this.getCompEnvBinding((MessageDestinationReferenceDescriptor)next));
        }
        for (ResourceReferenceDescriptor resourceRef : env.getResourceReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)resourceRef, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)resourceRef);
            value = null;
            String physicalJndiName = resourceRef.getJndiName();
            if (resourceRef.isMailResource()) {
                value = new MailNamingObjectFactory(name, physicalJndiName, this.namingUtils);
            } else if (resourceRef.isURLResource()) {
                URL obj = null;
                try {
                    obj = new URL(physicalJndiName);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                NamingObjectFactory factory = this.namingUtils.createSimpleNamingObjectFactory(name, (Object)obj);
                value = this.namingUtils.createCloningNamingObjectFactory(name, factory);
            } else if (resourceRef.isORB()) {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            } else if (resourceRef.isWebServiceContext()) {
                WebServiceReferenceManager wsRefMgr = (WebServiceReferenceManager)this.habitat.getByContract(WebServiceReferenceManager.class);
                if (wsRefMgr != null) {
                    value = wsRefMgr.getWSContextObject();
                } else {
                    this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @Resource WebServiceContext" + wsRefMgr + "Please confirm if webservices module is installed ");
                }
            } else {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true);
            }
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (EnvironmentProperty next : env.getEntityManagerFactoryReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new FactoryForEntityManagerFactoryWrapper(next.getUnitName(), this.invMgr, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (EnvironmentProperty next : env.getServiceReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new WebServiceRefProxy((ServiceReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (EnvironmentProperty next : env.getEntityManagerReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new FactoryForEntityManagerWrapper((EntityManagerReferenceDescriptor)next, this.habitat);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private CompEnvBinding getCompEnvBinding(final JmsDestinationReferenceDescriptor next) {
        final String name = this.descriptorToLogicalJndiName((Descriptor)next);
        Object value = null;
        value = next.isEJBContext() ? new EjbContextProxy(next.getRefType()) : new NamingObjectFactory(){
            NamingObjectFactory delegate;
            {
                this.delegate = ComponentEnvManagerImpl.this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), true);
            }

            public boolean isCreateResultCacheable() {
                return true;
            }

            public Object create(Context ic) throws NamingException {
                try {
                    return this.delegate.create(ic);
                }
                catch (NamingException e) {
                    Object ref = ComponentEnvManagerImpl.this.habitat.getComponent(next.getRefType(), next.getMappedName());
                    if (ref != null) {
                        return ref;
                    }
                    throw e;
                }
            }
        };
        return new CompEnvBinding(name, value);
    }

    private CompEnvBinding getCompEnvBinding(MessageDestinationReferenceDescriptor next) {
        String name = this.descriptorToLogicalJndiName((Descriptor)next);
        String physicalJndiName = null;
        physicalJndiName = next.isLinkedToMessageDestination() ? next.getMessageDestination().getJndiName() : next.getJndiName();
        NamingObjectFactory value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true);
        return new CompEnvBinding(name, value);
    }

    private boolean dependencyAppliesToScope(Descriptor descriptor, ScopeType scope) {
        boolean appliesToScope = false;
        String name = descriptor.getName();
        switch (scope) {
            case COMPONENT: {
                appliesToScope = name.startsWith(JAVA_COMP_PREFIX) || !name.startsWith(JAVA_COLON);
                break;
            }
            case MODULE: {
                appliesToScope = name.startsWith(JAVA_MODULE_PREFIX);
                break;
            }
            case APP: {
                appliesToScope = name.startsWith(JAVA_APP_PREFIX);
                break;
            }
            case GLOBAL: {
                appliesToScope = name.startsWith(JAVA_GLOBAL_PREFIX);
            }
        }
        return appliesToScope;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        String rawName = descriptor.getName();
        return rawName.startsWith(JAVA_COLON) ? rawName : JAVA_COMP_ENV_STRING + rawName;
    }

    private String getComponentEnvId(JndiNameEnvironment env) {
        String id = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            id = ejbEnv.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleDescriptor().getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName + ejbEnv.getUniqueId();
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            id = webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this.getApplicationName(env) + "Component Id: " + id);
        }
        return id;
    }

    private String getApplicationName(JndiNameEnvironment env) {
        String appName = "";
        String moduleName = "";
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            appName = "ejb [" + ejbEnv.getApplication().getRegistrationName();
            moduleName = ejbEnv.getName();
            appName = moduleName == null || moduleName.equals("") ? appName + "]" : appName + ":" + ejbEnv.getName() + "]";
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            appName = "web module [" + webEnv.getApplication().getRegistrationName();
            moduleName = webEnv.getContextRoot();
            appName = moduleName == null || moduleName.equals("") ? appName + "]" : appName + ":" + webEnv.getContextRoot() + "]";
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            appName = "client [" + appEnv.getName() + ":" + appEnv.getMainClassName() + "]";
        }
        return appName;
    }

    private Collection<JndiNameEnvironment> getJndiNameEnvironmentsForApp(JndiNameEnvironment env) {
        WebBundleDescriptor webBundle;
        ModuleDescriptor moduleDesc;
        ArrayList<JndiNameEnvironment> envsForApp = new ArrayList();
        Application appDesc = null;
        if (env instanceof EjbDescriptor) {
            EjbBundleDescriptor ejbBundle = ((EjbDescriptor)env).getEjbBundleDescriptor();
            ModuleDescriptor moduleDesc2 = ejbBundle.getModuleDescriptor();
            if (!moduleDesc2.isStandalone()) {
                appDesc = ejbBundle.getApplication();
            }
        } else if (env instanceof WebBundleDescriptor && !(moduleDesc = (webBundle = (WebBundleDescriptor)env).getModuleDescriptor()).isStandalone()) {
            appDesc = webBundle.getApplication();
        }
        if (appDesc == null) {
            envsForApp = this.getJndiNameEnvironmentsForModule(env);
        } else {
            envsForApp.addAll(appDesc.getJndiNameEnvironments());
        }
        return envsForApp;
    }

    private Collection<JndiNameEnvironment> getJndiNameEnvironmentsForModule(JndiNameEnvironment env) {
        ArrayList<JndiNameEnvironment> envsForModule = new ArrayList<JndiNameEnvironment>();
        if (env instanceof EjbDescriptor) {
            EjbBundleDescriptor ejbBundle = ((EjbDescriptor)env).getEjbBundleDescriptor();
            for (EjbDescriptor ejbDescriptor : ejbBundle.getEjbs()) {
                envsForModule.add((JndiNameEnvironment)ejbDescriptor);
            }
            ModuleDescriptor moduleDesc = ejbBundle.getModuleDescriptor();
            if (moduleDesc.getModuleType() == XModuleType.WAR) {
                WebBundleDescriptor webBundle = (WebBundleDescriptor)moduleDesc.getDescriptor();
                envsForModule.add((JndiNameEnvironment)webBundle);
            }
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webBundle = (WebBundleDescriptor)env;
            envsForModule.add((JndiNameEnvironment)webBundle);
            ModuleDescriptor moduleDesc = webBundle.getModuleDescriptor();
            Collection ejbBundles = moduleDesc.getDescriptor().getExtensionsDescriptors(EjbBundleDescriptor.class);
            if (!ejbBundles.isEmpty()) {
                EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
                for (EjbDescriptor ejb : ejbBundle.getEjbs()) {
                    envsForModule.add((JndiNameEnvironment)ejb);
                }
            }
        }
        return envsForModule;
    }

    private static boolean isConnector(String logicalJndiName) {
        return logicalJndiName.indexOf(EIS_STRING) != -1;
    }

    private static class CompEnvBinding
    implements JNDIBinding {
        private String name;
        private Object value;

        CompEnvBinding(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class EjbContextProxy
    implements NamingObjectProxy {
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private String contextType;

        EjbContextProxy(String contextType) {
            this.contextType = contextType;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(EjbNamingReferenceManager.class);
            }
            if (this.ejbRefMgr != null) {
                result = this.ejbRefMgr.getEJBContextObject(this.contextType);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve EJB context of type " + this.contextType);
            }
            return result;
        }
    }

    private class EjbReferenceProxy
    implements NamingObjectProxy {
        private EjbReferenceDescriptor ejbRef;

        EjbReferenceProxy(EjbReferenceDescriptor ejbRef) {
            this.ejbRef = ejbRef;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            EjbNamingReferenceManager ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(EjbNamingReferenceManager.class);
            if (ejbRefMgr != null) {
                result = ejbRefMgr.resolveEjbReference(this.ejbRef, ctx);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve ejb reference " + this.ejbRef.getName() + " : " + this.ejbRef);
            }
            return result;
        }
    }

    private class FactoryForEntityManagerWrapper
    implements NamingObjectProxy {
        private EntityManagerReferenceDescriptor refDesc;
        private Habitat habitat;

        FactoryForEntityManagerWrapper(EntityManagerReferenceDescriptor refDesc, Habitat habitat) {
            this.refDesc = refDesc;
            this.habitat = habitat;
        }

        public Object create(Context ctx) {
            EntityManagerWrapper emWrapper = (EntityManagerWrapper)this.habitat.getComponent(EntityManagerWrapper.class);
            emWrapper.initializeEMWrapper(this.refDesc.getUnitName(), this.refDesc.getPersistenceContextType(), this.refDesc.getProperties());
            return emWrapper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScopeType {
        COMPONENT,
        MODULE,
        APP,
        GLOBAL;

    }

    private class WebServiceRefProxy
    implements NamingObjectProxy {
        private WebServiceReferenceManager wsRefMgr;
        private ServiceReferenceDescriptor serviceRef;

        WebServiceRefProxy(ServiceReferenceDescriptor servRef) {
            this.serviceRef = servRef;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            this.wsRefMgr = (WebServiceReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(WebServiceReferenceManager.class);
            if (this.wsRefMgr != null) {
                result = this.wsRefMgr.resolveWSReference(this.serviceRef, ctx);
            } else {
                ComponentEnvManagerImpl.this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @WebServiceRef" + this.wsRefMgr + "Please confirm if webservices module is installed ");
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve webservice context of type " + this.serviceRef.getName());
            }
            return result;
        }
    }
}

