/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalRemoteCommand
extends AbstractCommand {
    private String port;
    private String host;
    private String user;
    private String passwordFile;
    static final LocalStringsImpl strings = new LocalStringsImpl(LocalRemoteCommand.class);
    static final CLILogger logger = CLILogger.getInstance();

    CLIRemoteCommand runRemoteCommand(String commandName, String ... args) throws CommandException {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            CLIRemoteCommand rc = new CLIRemoteCommand(this.prepareRemoteCommand(commandName, args));
            rc.runCommand();
            CLIRemoteCommand cLIRemoteCommand = rc;
            return cLIRemoteCommand;
        }
        catch (Exception e) {
            throw new CommandException(strings.get("LocalRemoteCommand.errorRemote", new Object[]{e.getMessage()}));
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private String[] prepareRemoteCommand(String commandName, String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(commandName);
        this.addMetaArgs(list);
        for (String arg : args) {
            list.add(arg);
        }
        return list.toArray(new String[list.size()]);
    }

    private void addMetaArgs(List<String> list) {
        this.port = this.getOption("port");
        this.host = this.getOption("host");
        this.user = this.getOption("user");
        this.passwordFile = this.getOption("passwordfile");
        if (LocalRemoteCommand.ok(this.port)) {
            list.add("--port");
            list.add(this.port);
        }
        if (LocalRemoteCommand.ok(this.host)) {
            list.add("--host");
            list.add(this.host);
        }
        if (LocalRemoteCommand.ok(this.user)) {
            list.add("--user");
            list.add(this.user);
        }
        if (LocalRemoteCommand.ok(this.passwordFile)) {
            list.add("--passwordfile");
            list.add(this.passwordFile);
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }
}

