/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.amx;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.amx.AMXUtil;
import org.glassfish.api.amx.MBeanListener;

public final class AMXBooter {
    private AMXBooter() {
    }

    public static ObjectName bootAMX(MBeanServerConnection conn) {
        ObjectName domainRootObjectName = AMXUtil.findDomainRoot(conn);
        if (domainRootObjectName == null) {
            BootAMXCallback callback = new BootAMXCallback(conn);
            MBeanListener.listenForBootAMX(conn, callback);
            callback.await();
            AMXUtil.invokeBootAMX(conn);
            domainRootObjectName = AMXUtil.invokeWaitAMXReady(conn);
        } else {
            AMXUtil.invokeWaitAMXReady(conn);
        }
        return domainRootObjectName;
    }

    public static class BootAMXCallback
    extends MBeanListener.CallbackImpl {
        private final MBeanServerConnection mConn;

        public BootAMXCallback(MBeanServerConnection conn) {
            this.mConn = conn;
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
            this.mLatch.countDown();
        }
    }
}

