/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.folb.CSIv2SSLTaggedComponentHandler;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.internal.api.Globals;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSIv2SSLTaggedComponentHandlerImpl
extends LocalObject
implements CSIv2SSLTaggedComponentHandler,
ORBConfigurator {
    private static Logger _logger = null;
    private final String baseMsg = CSIv2SSLTaggedComponentHandlerImpl.class.getName();
    private ORB orb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggedComponent insert(IORInfo iorInfo, List<ClusterInstanceInfo> clusterInstanceInfo) {
        Object result = null;
        try {
            TaggedComponent taggedComponent;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".insert->:");
            }
            ArrayList<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
            for (ClusterInstanceInfo clInstInfo : clusterInstanceInfo) {
                for (int endPIndex = 0; endPIndex < clInstInfo.endpoints.length; ++endPIndex) {
                    SocketInfo socketInfo = clInstInfo.endpoints[endPIndex];
                    if (!socketInfo.type.equals("SSL") && !socketInfo.type.equals("SSL_MUTUALAUTH")) continue;
                    socketInfos.add(socketInfo);
                }
            }
            IIOPSSLUtil sslUtil = null;
            if (Globals.getDefaultHabitat() != null) {
                sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getComponent(IIOPSSLUtil.class);
                taggedComponent = sslUtil.createSSLTaggedComponent(iorInfo, socketInfos);
                return taggedComponent;
            }
            taggedComponent = null;
            return taggedComponent;
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".insert<-: " + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<com.sun.corba.ee.spi.transport.SocketInfo> extract(IOR ior) {
        List socketInfo = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract->:");
            }
            IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            IIOPSSLUtil sslUtil = null;
            if (Globals.getDefaultHabitat() != null) {
                sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getComponent(IIOPSSLUtil.class);
                socketInfo = (List)sslUtil.getSSLPortsAsSocketInfo((Object)ior);
            }
            if (socketInfo == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.baseMsg + ".extract: did not find SSL SocketInfo");
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract: found SSL socketInfo");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract: Connection Context");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract<-: " + socketInfo);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Exception getting SocketInfo", ex);
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract<-: " + socketInfo);
            }
        }
        return socketInfo;
    }

    @Override
    public void configure(DataCollector collector, ORB orb) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ".configure->:");
        }
        this.orb = orb;
        try {
            orb.register_initial_reference("CSIv2SSLTaggedComponentHandler", this);
        }
        catch (InvalidName e) {
            _logger.log(Level.WARNING, ".configure: ", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ".configure<-:");
        }
    }

    static {
        _logger = LogDomains.getLogger(CSIv2SSLTaggedComponentHandlerImpl.class, (String)"javax.enterprise.resource.corba");
    }
}

